/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.File;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.openspcoop2.core.config.rs.server.model.ApiDescrizione;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegato;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGenerali;
import org.openspcoop2.core.config.rs.server.model.ApiImplInformazioniGeneraliView;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazione;
import org.openspcoop2.core.config.rs.server.model.ApiImplUrlInvocazioneView;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApi;
import org.openspcoop2.core.config.rs.server.model.ApiImplVersioneApiView;
import org.openspcoop2.core.config.rs.server.model.ConnettoreFruizione;
import org.openspcoop2.core.config.rs.server.model.Fruizione;
import org.openspcoop2.core.config.rs.server.model.FruizioneModI;
import org.openspcoop2.core.config.rs.server.model.FruizioneViewItem;
import org.openspcoop2.core.config.rs.server.model.ListaApiImplAllegati;
import org.openspcoop2.core.config.rs.server.model.ListaFruizioni;
import org.openspcoop2.core.config.rs.server.model.Problem;
import org.openspcoop2.core.config.rs.server.model.TipoApiEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;

@Path(value="/")
public interface FruizioniApi {
    @POST
    @Path(value="/fruizioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di una fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void createFruizione(@Valid Fruizione var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @POST
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Creazione di un allegato nella fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Resource created"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="409", description="Conflict (L'entit\u00e0 che si vuole creare risulta gi\u00e0 esistente)", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void createFruizioneAllegato(@Valid ApiImplAllegato var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina una fruizione di api", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Fruizione di API eliminata con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @DELETE
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati/{nome_allegato}")
    @Produces(value={"application/problem+json"})
    @Operation(summary="Elimina un allegato dalla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Allegato eliminato con successo"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void deleteFruizioneAllegato(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_allegato") String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati/{nome_allegato}/download")
    @Produces(value={"application/_*", "text/_*", "application/problem+json"})
    @Operation(summary="Restituisce l'allegato di una fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Allegato della fruizione restituito con successo", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] downloadFruizioneAllegato(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_allegato") String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Elenco allegati di una fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(schema=@Schema(implementation=ListaApiImplAllegati.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaApiImplAllegati findAllFruizioneAllegati(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="q") String var7, @QueryParam(value="limit") Integer var8, @QueryParam(value="offset") @DefaultValue(value="0") Integer var9);

    @GET
    @Path(value="/fruizioni")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ricerca fruizioni di api", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Ricerca eseguita correttamente", content={@Content(schema=@Schema(implementation=ListaFruizioni.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaFruizioni findAllFruizioni(@QueryParam(value="profilo") ProfiloEnum var1, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="q") String var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="offset") @DefaultValue(value="0") Integer var5, @QueryParam(value="tipo_api") TipoApiEnum var6, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var8, @QueryParam(value="profilo_qualsiasi") @DefaultValue(value="false") Boolean var9, @QueryParam(value="soggetto_qualsiasi") @DefaultValue(value="false") Boolean var10);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce i dettagli di una fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dettagli di una fruizione di API restituiti con successo", content={@Content(schema=@Schema(implementation=FruizioneViewItem.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public FruizioneViewItem getFruizione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/api")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni sull'API implementata dalla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sull'API restituite con successo", content={@Content(schema=@Schema(implementation=ApiImplVersioneApiView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiImplVersioneApiView getFruizioneAPI(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati/{nome_allegato}")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce il dettaglio di un allegato della fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati dell'allegato restituiti con successo", content={@Content(schema=@Schema(implementation=ApiImplAllegato.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiImplAllegato getFruizioneAllegato(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @PathParam(value="nome_allegato") String var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/connettore")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni su connettore associato alla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sul connettore restituite con successo", content={@Content(schema=@Schema(implementation=ConnettoreFruizione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ConnettoreFruizione getFruizioneConnettore(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var7);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/descrizione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce la descrizione di una fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Dati della descrizione restituiti con successo", content={@Content(schema=@Schema(implementation=ApiDescrizione.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiDescrizione getFruizioneDescrizione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/informazioni")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni generali di una fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni generali restituite con successo", content={@Content(schema=@Schema(implementation=ApiImplInformazioniGeneraliView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiImplInformazioniGeneraliView getFruizioneInformazioniGenerali(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/modi")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni ModI associate alla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni ModI restituite con successo", content={@Content(schema=@Schema(implementation=FruizioneModI.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public FruizioneModI getFruizioneModI(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @GET
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/url-invocazione")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Restituisce le informazioni sull'url di invocazione necessaria ad invocare la fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sull'url di invocazione restituite con successo", content={@Content(schema=@Schema(implementation=ApiImplUrlInvocazioneView.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ApiImplUrlInvocazioneView getFruizioneUrlInvocazione(@PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var1, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var3, @QueryParam(value="profilo") ProfiloEnum var4, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/api")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la versione dell'API implementata dalla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Fruizione di API aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneAPI(@Valid ApiImplVersioneApi var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/allegati/{nome_allegato}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Modifica i dati di un allegato della fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="L'allegato \u00e8 stato aggiornato correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneAllegato(@Valid ApiImplAllegato var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @PathParam(value="nome_allegato") String var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/connettore")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione del connettore associato alla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione della fruizione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneConnettore(@Valid ConnettoreFruizione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7, @QueryParam(value="gruppo") @Size(max=255) @Size(max=255) String var8);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/descrizione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la descrizione di una fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="La descrizione \u00e8 stato aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneDescrizione(@Valid ApiDescrizione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/informazioni")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare le informazioni generali di una fruizione di API", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Fruizione di API aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneInformazioniGenerali(@Valid ApiImplInformazioniGenerali var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/modi")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare le informazioni ModI associate alla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Fruizione di API aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneModI(@Valid FruizioneModI var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);

    @PUT
    @Path(value="/fruizioni/{erogatore}/{nome}/{versione}/url-invocazione")
    @Consumes(value={"application/json"})
    @Produces(value={"application/problem+json"})
    @Operation(summary="Consente di modificare la configurazione utilizzata per identificare l'azione invocata dell'API implementata dalla fruizione", tags={"fruizioni"})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Configurazione della fruizione aggiornata correttamente"), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public void updateFruizioneUrlInvocazione(@Valid ApiImplUrlInvocazione var1, @PathParam(value="erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2, @PathParam(value="nome") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var3, @PathParam(value="versione") @Min(value=1L) @Min(value=1L) Integer var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var7);
}

