/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.erogazioni;

import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaLivelloServizio;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSemiformale;
import org.openspcoop2.core.config.rs.server.model.ApiImplAllegatoSpecificaSicurezza;
import org.openspcoop2.core.config.rs.server.model.ConnettoreConfigurazioneHttpsClient;
import org.openspcoop2.core.config.rs.server.model.GruppoNuovaConfigurazione;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaLivelloServizioEnum;
import org.openspcoop2.core.config.rs.server.model.TipoSpecificaSicurezzaEnum;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;

public class ErogazioniCheckNotNull {
    public static String getHttpskeystore(ConnettoreConfigurazioneHttpsClient httpsClient) {
        String httpskeystore = null;
        if (httpsClient != null) {
            httpskeystore = httpsClient.getKeystorePath() != null || httpsClient.getKeystoreTipo() != null ? "ridefinisci" : "default";
        }
        return httpskeystore;
    }

    public static void checkAutenticazione(GruppoNuovaConfigurazione conf) {
        if (conf.getAutenticazione() == null) {
            throw FaultCode.RICHIESTA_NON_VALIDA.toException(GruppoNuovaConfigurazione.class.getName() + ": Indicare il campo obbligatorio 'autenticazione'");
        }
    }

    public static boolean isNotNullTipoSpecifica(ApiImplAllegatoSpecificaSemiformale allegatoSS, Documento documento) {
        if (allegatoSS.getTipoSpecifica() == null) {
            documento.setTipo(TipiDocumentoSemiformale.LINGUAGGIO_NATURALE.toString());
            return false;
        }
        return true;
    }

    public static boolean isNotNullTipoSpecifica(ApiImplAllegatoSpecificaLivelloServizio allegatoLS, Documento documento) {
        if (allegatoLS.getTipoSpecifica() == null) {
            documento.setTipo(TipiDocumentoLivelloServizio.WSLA.toString());
            return false;
        }
        return true;
    }

    public static boolean isNotNullTipoSpecifica(ApiImplAllegatoSpecificaSicurezza allegatoLS, Documento documento) {
        if (allegatoLS.getTipoSpecifica() == null) {
            documento.setTipo(TipiDocumentoSicurezza.LINGUAGGIO_NATURALE.toString());
            return false;
        }
        return true;
    }

    public static void documentoToImplAllegato(ApiImplAllegatoSpecificaLivelloServizio allegatoSL, TipiDocumentoLivelloServizio tipo) {
        if (allegatoSL.getTipoSpecifica() == null && TipiDocumentoLivelloServizio.WSAGREEMENT.equals((Object)tipo)) {
            allegatoSL.setTipoSpecifica(TipoSpecificaLivelloServizioEnum.WS_AGREEMENT);
        }
    }

    public static void documentoToImplAllegato(ApiImplAllegatoSpecificaSicurezza allegatoSSec, TipiDocumentoSicurezza tipo) {
        if (allegatoSSec.getTipoSpecifica() == null) {
            if (TipiDocumentoSicurezza.WSPOLICY.equals((Object)tipo)) {
                allegatoSSec.setTipoSpecifica(TipoSpecificaSicurezzaEnum.WS_POLICY);
            } else if (TipiDocumentoSicurezza.XACML_POLICY.equals((Object)tipo)) {
                allegatoSSec.setTipoSpecifica(TipoSpecificaSicurezzaEnum.XACML_POLICY);
            }
        }
    }
}

