/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.api.impl.soggetti;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.rs.server.api.impl.ProtocolPropertiesHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiApiHelper;
import org.openspcoop2.core.config.rs.server.api.impl.soggetti.SoggettiEnv;
import org.openspcoop2.core.config.rs.server.model.DominioEnum;
import org.openspcoop2.core.config.rs.server.model.ModISoggetto;
import org.openspcoop2.core.config.rs.server.model.ModISoggettoPDND;
import org.openspcoop2.core.config.rs.server.model.TracciamentoPDNDSoggettoEnum;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.utils.UtilsException;

public class ModiSoggettiApiHelper {
    private ModiSoggettiApiHelper() {
    }

    public static ProtocolProperties getProtocolProperties(org.openspcoop2.core.config.rs.server.model.Soggetto body) throws ProtocolException {
        ProtocolProperties p = new ProtocolProperties();
        if (body.getModi() != null && body.getModi().getPdnd() != null) {
            TracciamentoPDNDSoggettoEnum tracciamentoPdnd;
            if (body.getModi().getPdnd().getIdEnte() != null && StringUtils.isNotEmpty((String)body.getModi().getPdnd().getIdEnte())) {
                p.addProperty("modipaSoggettoIDEnte", body.getModi().getPdnd().getIdEnte());
            }
            if ((tracciamentoPdnd = body.getModi().getPdnd().getTracciamentoPdnd()) != null) {
                if (DominioEnum.INTERNO.equals((Object)body.getDominio())) {
                    p.addProperty("modipaSoggettoPdndTracingEnabled", ModiSoggettiApiHelper.toTracciamentoPDNDSoggettoId(tracciamentoPdnd));
                } else {
                    throw new ProtocolException("Il campo tracing_pdnd \u00e8 valido solo per soggetti con dominio interno");
                }
            }
        }
        return p;
    }

    public static void initializePdnd(org.openspcoop2.core.config.rs.server.model.Soggetto ret) {
        if (ret.getModi() == null) {
            ret.setModi(new ModISoggetto());
        }
        if (ret.getModi().getPdnd() == null) {
            ret.getModi().setPdnd(new ModISoggettoPDND());
        }
    }

    public static void populateProtocolInfo(Soggetto soggetto, SoggettiEnv env, org.openspcoop2.core.config.rs.server.model.Soggetto ret) throws CoreException, UtilsException, ProtocolException, DriverConfigurazioneException {
        String tracciamentoPdnd;
        Map<String, AbstractProperty<?>> p = SoggettiApiHelper.getProtocolPropertiesMap(soggetto, env);
        String idEnte = ProtocolPropertiesHelper.getStringProperty(p, "modipaSoggettoIDEnte", false);
        if (idEnte != null && StringUtils.isNotEmpty((String)idEnte)) {
            ModiSoggettiApiHelper.initializePdnd(ret);
            ret.getModi().getPdnd().setIdEnte(idEnte);
        }
        if ((tracciamentoPdnd = ProtocolPropertiesHelper.getStringProperty(p, "modipaSoggettoPdndTracingEnabled", false)) != null && DominioEnum.INTERNO.equals((Object)ret.getDominio())) {
            ModiSoggettiApiHelper.initializePdnd(ret);
            ret.getModi().getPdnd().setTracciamentoPdnd(ModiSoggettiApiHelper.toTracciamentoPDNDSoggettoEnum(tracciamentoPdnd));
        }
    }

    private static TracciamentoPDNDSoggettoEnum toTracciamentoPDNDSoggettoEnum(String idValue) {
        if ("0".equals(idValue)) {
            return TracciamentoPDNDSoggettoEnum.DISABILITATO;
        }
        if ("1".equals(idValue)) {
            return TracciamentoPDNDSoggettoEnum.ABILITATO;
        }
        return TracciamentoPDNDSoggettoEnum.DEFAULT;
    }

    private static String toTracciamentoPDNDSoggettoId(TracciamentoPDNDSoggettoEnum enumValue) {
        if (enumValue == null) {
            return "-1";
        }
        switch (enumValue) {
            case ABILITATO: {
                return "1";
            }
            case DEFAULT: {
                return "-1";
            }
            case DISABILITATO: {
                return "0";
            }
        }
        return "-1";
    }
}

