/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.rs.server.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaRest;
import org.openspcoop2.core.config.rs.server.model.ApiInterfacciaSoap;
import org.openspcoop2.core.config.rs.server.model.OneOfApiBaseTipoInterfaccia;

public class ApiBase {
    @Schema(description="")
    private String referente = null;
    @Schema(required=true, description="")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="protocollo", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ApiInterfacciaRest.class, name="rest"), @JsonSubTypes.Type(value=ApiInterfacciaSoap.class, name="soap")})
    private OneOfApiBaseTipoInterfaccia tipoInterfaccia = null;
    @Schema(required=true, description="")
    private String nome = null;
    @Schema(example="descrizione API", description="")
    private String descrizione = null;
    @Schema(required=true, description="")
    private Integer versione = null;
    @Schema(example="[\"PagamentiTelematici\",\"Anagrafica\"]", description="")
    private List<String> tags = null;

    @JsonProperty(value="referente")
    @Valid
    @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$")
    @Size(max=255)
    public @Valid @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String getReferente() {
        return this.referente;
    }

    public void setReferente(String referente) {
        this.referente = referente;
    }

    public ApiBase referente(String referente) {
        this.referente = referente;
        return this;
    }

    @JsonProperty(value="tipo_interfaccia")
    @NotNull
    @Valid
    public OneOfApiBaseTipoInterfaccia getTipoInterfaccia() {
        return this.tipoInterfaccia;
    }

    public void setTipoInterfaccia(OneOfApiBaseTipoInterfaccia tipoInterfaccia) {
        this.tipoInterfaccia = tipoInterfaccia;
    }

    public ApiBase tipoInterfaccia(OneOfApiBaseTipoInterfaccia tipoInterfaccia) {
        this.tipoInterfaccia = tipoInterfaccia;
        return this;
    }

    @JsonProperty(value="nome")
    @NotNull
    @Valid
    @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$")
    @Size(max=255)
    public @NotNull @Valid @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public ApiBase nome(String nome) {
        this.nome = nome;
        return this;
    }

    @JsonProperty(value="descrizione")
    @Valid
    @Size(max=4000)
    public @Valid @Size(max=4000) String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public ApiBase descrizione(String descrizione) {
        this.descrizione = descrizione;
        return this;
    }

    @JsonProperty(value="versione")
    @NotNull
    @Valid
    public Integer getVersione() {
        return this.versione;
    }

    public void setVersione(Integer versione) {
        this.versione = versione;
    }

    public ApiBase versione(Integer versione) {
        this.versione = versione;
        return this;
    }

    @JsonProperty(value="tags")
    @Valid
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ApiBase tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ApiBase addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiBase {\n");
        sb.append("    referente: ").append(ApiBase.toIndentedString(this.referente)).append("\n");
        sb.append("    tipoInterfaccia: ").append(ApiBase.toIndentedString(this.tipoInterfaccia)).append("\n");
        sb.append("    nome: ").append(ApiBase.toIndentedString(this.nome)).append("\n");
        sb.append("    descrizione: ").append(ApiBase.toIndentedString(this.descrizione)).append("\n");
        sb.append("    versione: ").append(ApiBase.toIndentedString(this.versione)).append("\n");
        sb.append("    tags: ").append(ApiBase.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

