/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.trasparente;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.protocol.basic.BasicEmptyRawContent;
import org.openspcoop2.protocol.basic.BasicEmptyRawContentFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.trasparente.builder.TrasparenteBustaBuilder;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProperties;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProtocolConfiguration;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProtocolManager;
import org.openspcoop2.protocol.trasparente.config.TrasparenteProtocolVersionManager;
import org.openspcoop2.protocol.trasparente.properties.TrasparenteTestsuiteDynamicConfiguration;
import org.openspcoop2.protocol.trasparente.validator.TrasparenteValidazioneSintattica;
import org.slf4j.Logger;

public class TrasparenteFactory
extends BasicEmptyRawContentFactory {
    private static final long serialVersionUID = -4246311511752079753L;
    private static IProtocolManager staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;
    private static IProtocolConfiguration staticInstanceProtocolConfiguration = null;

    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        super.init(log, protocol, configPdD, manifest);
        TrasparenteProperties.initialize(configPdD.getConfigurationDir(), log);
        TrasparenteProperties properties = TrasparenteProperties.getInstance();
        properties.validaConfigurazione(configPdD.getLoader());
        BasicStaticInstanceConfig staticInstanceConfig = properties.getStaticInstanceConfig();
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null && staticInstanceConfig.isStaticConfig()) {
            staticInstanceProtocolManager = new TrasparenteProtocolManager((IProtocolFactory<?>)this);
            staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
            staticInstanceProtocolConfiguration = new TrasparenteProtocolConfiguration((IProtocolFactory<?>)this);
        }
    }

    public TrasparenteBustaBuilder createBustaBuilder(IState state) throws ProtocolException {
        return new TrasparenteBustaBuilder((IProtocolFactory<?>)this, state);
    }

    public TrasparenteValidazioneSintattica createValidazioneSintattica(IState state) throws ProtocolException {
        return new TrasparenteValidazioneSintattica((IProtocolFactory<BasicEmptyRawContent>)this, state);
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        return staticInstanceProtocolManager != null ? staticInstanceProtocolManager : new TrasparenteProtocolManager((IProtocolFactory<?>)this);
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(version)) {
                this.initProtocolVersionManager(version);
            }
            return staticInstanceProtocolVersionManager.get(version);
        }
        return new TrasparenteProtocolVersionManager((IProtocolFactory<?>)this, version);
    }

    private synchronized void initProtocolVersionManager(String version) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(version)) {
            staticInstanceProtocolVersionManager.put(version, new TrasparenteProtocolVersionManager((IProtocolFactory<?>)this, version));
        }
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return staticInstanceProtocolConfiguration != null ? staticInstanceProtocolConfiguration : new TrasparenteProtocolConfiguration((IProtocolFactory<?>)this);
    }

    public IConsoleDynamicConfiguration createDynamicConfigurationConsole() throws ProtocolException {
        if (TrasparenteProperties.getInstance().isUtilizzaTestSuiteProtocolProperties().booleanValue()) {
            return new TrasparenteTestsuiteDynamicConfiguration((IProtocolFactory<?>)this);
        }
        return super.createDynamicConfigurationConsole();
    }
}

