/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.File;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.openspcoop2.core.monitor.rs.server.model.DetailsTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.DimensioniReportCustomEnum;
import org.openspcoop2.core.monitor.rs.server.model.DimensioniReportEnum;
import org.openspcoop2.core.monitor.rs.server.model.EsitoTransazioneSimpleSearchEnum;
import org.openspcoop2.core.monitor.rs.server.model.FiltroRicercaRuoloTransazioneEnum;
import org.openspcoop2.core.monitor.rs.server.model.ForcePublishBodyTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.FormatoReportConfigEnum;
import org.openspcoop2.core.monitor.rs.server.model.FormatoReportEnum;
import org.openspcoop2.core.monitor.rs.server.model.InfoImplementazioneApi;
import org.openspcoop2.core.monitor.rs.server.model.ListaRiepilogoApi;
import org.openspcoop2.core.monitor.rs.server.model.ListaTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.OperationStatus;
import org.openspcoop2.core.monitor.rs.server.model.Problem;
import org.openspcoop2.core.monitor.rs.server.model.RicercaConfigurazioneApi;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaAndamentoTemporale;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneApi;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneApplicativo;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneApplicativoRegistrato;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneAzione;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneErrori;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneEsiti;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneSoggettoLocale;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneSoggettoRemoto;
import org.openspcoop2.core.monitor.rs.server.model.RicercaStatisticaDistribuzioneTokenInfo;
import org.openspcoop2.core.monitor.rs.server.model.Riepilogo;
import org.openspcoop2.core.monitor.rs.server.model.StatoTracing;
import org.openspcoop2.core.monitor.rs.server.model.StatoTracingPDND;
import org.openspcoop2.core.monitor.rs.server.model.TipoIdentificazioneApplicativoEnum;
import org.openspcoop2.core.monitor.rs.server.model.TipoInformazioneReportEnum;
import org.openspcoop2.core.monitor.rs.server.model.TipoReportEnum;
import org.openspcoop2.core.monitor.rs.server.model.TokenClaimDistribuzioneStatisticaEnum;
import org.openspcoop2.core.monitor.rs.server.model.UnitaTempoReportEnum;
import org.openspcoop2.utils.service.beans.ProfiloEnum;
import org.openspcoop2.utils.service.beans.TransazioneRuoloEnum;

@Path(value="/")
public interface ReportisticaApi {
    @POST
    @Path(value="/reportistica/configurazione-api/esporta")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/vnd.ms-excel", "application/problem+json"})
    @Operation(summary="Recupera la configurazione di un servizio", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report delle configurazioni generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] exportConfigurazioneApiByFullSearch(@Valid RicercaConfigurazioneApi var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/configurazione-api/esporta")
    @Produces(value={"text/csv", "application/vnd.ms-excel", "application/problem+json"})
    @Operation(summary="Recupera la configurazione di un servizio", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report delle configurazioni generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] exportConfigurazioneApiBySimpleSearch(@QueryParam(value="tipo") @NotNull TransazioneRuoloEnum var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var7, @QueryParam(value="formato_report") FormatoReportConfigEnum var8);

    @GET
    @Path(value="/reportistica/tracing-pdnd/{id}/esporta")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="esporta il csv inerente al tracciato", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] exportTracingPdnd(@PathParam(value="id") Long var1);

    @GET
    @Path(value="/reportistica/configurazione-api")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Consente di recuperare l'elenco delle erogazioni o fruizioni che coinvolgono il soggetto scelto", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Riepilogo ottenuto con successo", content={@Content(schema=@Schema(implementation=ListaRiepilogoApi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaRiepilogoApi getConfigurazioneApi(@QueryParam(value="tipo") @NotNull TransazioneRuoloEnum var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="offset") @DefaultValue(value="0") Integer var4, @QueryParam(value="limit") Integer var5);

    @GET
    @Path(value="/reportistica/tracing-pdnd/{id}/dettagli")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="mostra i dettagli di un tracciamento", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="valore del tracciato", content={@Content(schema=@Schema(implementation=DetailsTracingPDND.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public DetailsTracingPDND getDetailsTracingPdnd(@PathParam(value="id") Long var1);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-api")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera per mezzo di una ricerca articolata, un report statistico raggruppato per servizi", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneApiByFullSearch(@Valid RicercaStatisticaDistribuzioneApi var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-api")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per API utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneApiBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="distingui_api_implementata") @DefaultValue(value="true") Boolean var10, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var11, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var12, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var13, @QueryParam(value="tipo_report") TipoReportEnum var14, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var15, @QueryParam(value="dimensioni_report") DimensioniReportEnum var16, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var17);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-applicativo")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per applicativo utilizzando una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneApplicativoByFullSearch(@Valid RicercaStatisticaDistribuzioneApplicativoRegistrato var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-applicativo")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per Applicativi utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneApplicativoBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="soggetto_mittente") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var12, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var13, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var14, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var15, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var16, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var17, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var18, @QueryParam(value="tipo_identificazione") TipoIdentificazioneApplicativoEnum var19, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var20, @QueryParam(value="tipo_report") TipoReportEnum var21, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var22, @QueryParam(value="dimensioni_report") DimensioniReportEnum var23, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var24);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-azione")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico distribuito per azione utilizzando una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneAzioneByFullSearch(@Valid RicercaStatisticaDistribuzioneAzione var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-azione")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per Azioni utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneAzioneBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var15, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var16, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var17, @QueryParam(value="tipo_report") TipoReportEnum var18, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var19, @QueryParam(value="dimensioni_report") DimensioniReportEnum var20, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var21);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-errori")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico distribuito per esiti di errore utilizzando una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneErroriByFullSearch(@Valid RicercaStatisticaDistribuzioneErrori var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-errori")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per esiti di errore utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneErroriBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var16, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var17, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var18, @QueryParam(value="tipo_report") TipoReportEnum var19, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var20, @QueryParam(value="dimensioni_report") DimensioniReportEnum var21, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var22);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-esiti")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per andamento esiti per mezzo di una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneEsitiByFullSearch(@Valid RicercaStatisticaDistribuzioneEsiti var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-esiti")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per andamento esiti per mezzo di una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneEsitiBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var16, @QueryParam(value="tipo_report") TipoReportEnum var17, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var18);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-id-autenticato")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per identificativo autenticato utilizzando una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneIdAutenticatoByFullSearch(@Valid RicercaStatisticaDistribuzioneApplicativo var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-id-autenticato")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per Identificativo Autenticato utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneIdAutenticatoBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var16, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var17, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var18, @QueryParam(value="tipo_report") TipoReportEnum var19, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var20, @QueryParam(value="dimensioni_report") DimensioniReportEnum var21, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var22);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-indirizzo-ip")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per Indirizzi IP", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneIndirizzoIPByFullSearch(@Valid RicercaStatisticaDistribuzioneApplicativo var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-indirizzo-ip")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato organizzato per Indirizzo IP utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneIndirizzoIPBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var16, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var17, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var18, @QueryParam(value="tipo_report") TipoReportEnum var19, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var20, @QueryParam(value="dimensioni_report") DimensioniReportEnum var21, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var22);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-soggetto-locale")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico raggruppato per soggetto locale per mezzo di una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneSoggettoLocaleByFullSearch(@Valid RicercaStatisticaDistribuzioneSoggettoLocale var1, @QueryParam(value="profilo") ProfiloEnum var2);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-soggetto-locale")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per soggetto locale per mezzo di una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneSoggettoLocaleBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="id_cluster") String var6, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var10, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var12, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var13, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var14, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var15, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var16, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var17, @QueryParam(value="tipo_report") TipoReportEnum var18, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var19, @QueryParam(value="dimensioni_report") DimensioniReportEnum var20, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var21);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-soggetto-remoto")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico raggruppato per soggetto remoto per mezzo di una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneSoggettoRemotoByFullSearch(@Valid RicercaStatisticaDistribuzioneSoggettoRemoto var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-soggetto-remoto")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per soggetto remoto per mezzo di una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneSoggettoRemotoBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var10, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var12, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var13, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var14, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var15, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var16, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var17, @QueryParam(value="tipo_report") TipoReportEnum var18, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var19, @QueryParam(value="dimensioni_report") DimensioniReportEnum var20, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var21);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-temporale")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per andamento temporale per mezzo di una ricerca articolata", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneTemporaleByFullSearch(@Valid RicercaStatisticaAndamentoTemporale var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-temporale")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico per andamento temporale per mezzo di una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneTemporaleBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="profilo") ProfiloEnum var5, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var6, @QueryParam(value="id_cluster") String var7, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var8, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var11, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var12, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var13, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var14, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var15, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var16, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var17, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var18, @QueryParam(value="tipo_report") TipoReportEnum var19, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var20);

    @POST
    @Path(value="/reportistica/analisi-statistica/distribuzione-token-info")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato per Token Info", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneTokenInfoByFullSearch(@Valid RicercaStatisticaDistribuzioneTokenInfo var1, @QueryParam(value="profilo") ProfiloEnum var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3);

    @GET
    @Path(value="/reportistica/analisi-statistica/distribuzione-token-info")
    @Produces(value={"text/csv", "application/pdf", "application/vnd.ms-excel", "text/xml", "application/json", "application/problem+json"})
    @Operation(summary="Genera un report statistico organizzato organizzato per Token Info utilizzando una ricerca semplice", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report statistico generato correttamente", content={@Content(schema=@Schema(implementation=File.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public byte[] getReportDistribuzioneTokenInfoBySimpleSearch(@QueryParam(value="data_inizio") @NotNull DateTime var1, @QueryParam(value="data_fine") @NotNull DateTime var2, @QueryParam(value="tipo") @NotNull FiltroRicercaRuoloTransazioneEnum var3, @QueryParam(value="formato_report") @NotNull FormatoReportEnum var4, @QueryParam(value="claim") @NotNull TokenClaimDistribuzioneStatisticaEnum var5, @QueryParam(value="profilo") ProfiloEnum var6, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var7, @QueryParam(value="id_cluster") String var8, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var9, @QueryParam(value="soggetto_erogatore") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var10, @QueryParam(value="tag") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var11, @QueryParam(value="uri_api_implementata") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") @Pattern(regexp="^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$|^[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$") String var12, @QueryParam(value="nome_servizio") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var13, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var14, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var15, @QueryParam(value="azione") @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var16, @QueryParam(value="esito") EsitoTransazioneSimpleSearchEnum var17, @QueryParam(value="escludi_scartate") @DefaultValue(value="false") Boolean var18, @QueryParam(value="unita_tempo") UnitaTempoReportEnum var19, @QueryParam(value="tipo_report") TipoReportEnum var20, @QueryParam(value="tipo_informazione_report") TipoInformazioneReportEnum var21, @QueryParam(value="dimensioni_report") DimensioniReportEnum var22, @QueryParam(value="dimensioni_report_custom_info") DimensioniReportCustomEnum var23);

    @GET
    @Path(value="/reportistica/configurazione-api/riepilogo/api")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ottieni le informazioni generali sulle implementazioni di un Api", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Informazioni sulla API ottenute con successo", content={@Content(schema=@Schema(implementation=InfoImplementazioneApi.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public InfoImplementazioneApi getRiepilogoApi(@QueryParam(value="tipo") @NotNull TransazioneRuoloEnum var1, @QueryParam(value="nome_servizio") @NotNull @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) @NotNull @Pattern(regexp="^[_A-Za-z][\\-\\._A-Za-z0-9]*$") @Size(max=255) String var2, @QueryParam(value="profilo") ProfiloEnum var3, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var4, @QueryParam(value="soggetto_remoto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var5, @QueryParam(value="tipo_servizio") @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) @Pattern(regexp="^[a-z]{2,20}$") @Size(max=20) String var6, @QueryParam(value="versione_servizio") @Min(value=1L) @DefaultValue(value="1") @Min(value=1L) Integer var7);

    @GET
    @Path(value="/reportistica/configurazione-api/riepilogo")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Ottieni le informazioni generali sulle api e servizi di un soggetto", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Riepilogo ottenuto con successo", content={@Content(schema=@Schema(implementation=Riepilogo.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public Riepilogo getRiepologoConfigurazioni(@QueryParam(value="profilo") ProfiloEnum var1, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var2);

    @GET
    @Path(value="/reportistica/tracing-pdnd")
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="Recupera la lista di tracciati della pdnd", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="lista dei tracing attivi che rispettano i filtri di ricerca", content={@Content(schema=@Schema(implementation=ListaTracingPDND.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public ListaTracingPDND getTracingPdndList(@QueryParam(value="data_inizio") @NotNull LocalDate var1, @QueryParam(value="data_fine") @NotNull LocalDate var2, @QueryParam(value="soggetto") @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) @Pattern(regexp="^[0-9A-Za-z][\\-A-Za-z0-9]*$") @Size(max=255) String var3, @QueryParam(value="offset") @DefaultValue(value="0") Integer var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="tentativi_pubblicazione") Integer var6, @QueryParam(value="stato") StatoTracing var7, @QueryParam(value="stato_pdnd") StatoTracingPDND var8, @QueryParam(value="tracing_id") UUID var9);

    @PUT
    @Path(value="/reportistica/tracing-pdnd/{id}/force-publish")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/problem+json"})
    @Operation(summary="forza un nuovo invio del tracciato indipendentemente dal numero di tentativi", tags={"Reportistica"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="empty", content={@Content(schema=@Schema(implementation=OperationStatus.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="401", description="Non sono state fornite le credenziali necessarie", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="403", description="Autorizzazione non concessa per l'operazione richiesta", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="404", description="Not Found", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="429", description="Too many requests", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="503", description="Service Unavailable", content={@Content(schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Unexpected error", content={@Content(schema=@Schema(implementation=Problem.class))})})
    public OperationStatus tracingPdndForcePubblish(@PathParam(value="id") Long var1, @Valid ForcePublishBodyTracingPDND var2);
}

