/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.monitor.rs.server.config;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.driver.ExtendedInfoManager;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.monitor.rs.server.config.DBManager;
import org.openspcoop2.core.monitor.rs.server.config.DatasourceProperties;
import org.openspcoop2.core.monitor.rs.server.config.InitRuntimeConfigReader;
import org.openspcoop2.core.monitor.rs.server.config.LoggerProperties;
import org.openspcoop2.core.monitor.rs.server.config.ServerProperties;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.transazioni.utils.DumpUtils;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntime;
import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeProperties;
import org.openspcoop2.pdd.core.byok.BYOKMapProperties;
import org.openspcoop2.pdd.core.dynamic.DynamicInfo;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.services.ServicesUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.openspcoop2.utils.certificate.hsm.HSMUtils;
import org.openspcoop2.utils.properties.MapProperties;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.security.ProviderUtils;
import org.openspcoop2.web.lib.mvc.login.FailedAttempts;
import org.openspcoop2.web.monitor.core.bean.LoginBean;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.slf4j.Logger;

public class Startup
implements ServletContextListener {
    private static Logger log = null;
    private static InitRuntimeConfigReader initRuntimeConfigReader;
    private static boolean initializedLog;
    private static boolean initializedResources;

    public static Logger getLog() {
        return log;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log != null) {
            log.info("Undeploy webService in corso...");
        }
        if (initRuntimeConfigReader != null) {
            initRuntimeConfigReader.setStop(true);
        }
        if (log != null) {
            log.info("Undeploy webService effettuato.");
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        Startup.initLog();
        Startup.initResources();
    }

    public static boolean isInitializedLog() {
        return initializedLog;
    }

    public static synchronized String initLog() {
        String confDir = null;
        try {
            InputStream is = Startup.class.getResourceAsStream("/rs-api-monitor.properties");
            try {
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    confDir = p.getProperty("confDirectory");
                    if (confDir != null) {
                        confDir = confDir.trim();
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception is) {
            // empty catch block
        }
        if (!initializedLog) {
            try {
                log = LoggerWrapperFactory.getLogger(Startup.class);
                LoggerProperties.initialize(log, confDir, null);
                initializedLog = true;
                log = LoggerProperties.getLoggerCore();
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return confDir;
    }

    public static synchronized void initResources() {
        if (!initializedResources) {
            String confDir = Startup.initLog();
            log.info("Inizializzazione rs api monitor in corso...");
            if (!ServerProperties.initialize(confDir, log)) {
                return;
            }
            ServerProperties serverProperties = null;
            try {
                serverProperties = ServerProperties.getInstance();
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del serverProperties", e);
            }
            try {
                Logger logR = log;
                ServicesUtils.initCheckConnectionDB((Logger)logR, (boolean)serverProperties.isJdbcCloseConnectionCheckIsClosed(), (boolean)serverProperties.isJdbcCloseConnectionCheckAutocommit());
                DBManager.setCheckLogger(logR);
                DBManager.setCheckIsClosed(serverProperties.isJdbcCloseConnectionCheckIsClosed());
                DBManager.setCheckAutocommit(serverProperties.isJdbcCloseConnectionCheckAutocommit());
            }
            catch (Exception e) {
                Startup.doError("Inizializzazione controlli connessione non riuscita", e);
            }
            try {
                String mapConfig = serverProperties.getEnvMapConfig();
                if (StringUtils.isNotEmpty((String)mapConfig)) {
                    log.info("Inizializzazione environment in corso...");
                    MapProperties.initialize((Logger)log, (String)mapConfig, (boolean)serverProperties.isEnvMapConfigRequired());
                    MapProperties mapProperties = MapProperties.getInstance();
                    mapProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con le variabili definite nel file '" + mapConfig + "'\n\tJavaProperties: " + mapProperties.getJavaMap().keys() + "\n\tEnvProperties: " + mapProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + mapProperties.getObfuscateModeDescription() + "\n\tObfuscatedJavaKeys: " + mapProperties.getObfuscatedJavaKeys() + "\n\tObfuscatedEnvKeys: " + mapProperties.getObfuscatedEnvKeys();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente", e);
            }
            log.info("Inizializzazione security provider...");
            try {
                if (serverProperties.isSecurityLoadBouncyCastleProvider()) {
                    ProviderUtils.addBouncyCastleAfterSun((boolean)true);
                    log.info("Aggiunto Security Provider org.bouncycastle.jce.provider.BouncyCastleProvider");
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dei security provider", e);
            }
            log.info("Inizializzazione security provider effettuata con successo");
            try {
                String hsmConfig = serverProperties.getHSMConfigurazione();
                if (StringUtils.isNotEmpty((String)hsmConfig)) {
                    log.info("Inizializzazione HSM in corso...");
                    File f = new File(hsmConfig);
                    HSMManager.init((File)f, (boolean)serverProperties.isHSMRequired(), (Logger)log, (boolean)false);
                    HSMUtils.setHsmConfigurableKeyPassword((boolean)serverProperties.isHSMKeyPasswordConfigurable());
                    log.info("Inizializzazione HSM effettuata con successo");
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del manager HSM", e);
            }
            BYOKManager byokManager = null;
            try {
                String byokConfig = serverProperties.getBYOKConfigurazione();
                if (StringUtils.isNotEmpty((String)byokConfig)) {
                    log.info("Inizializzazione BYOK in corso...");
                    File f = new File(byokConfig);
                    BYOKManager.init((File)f, (boolean)serverProperties.isBYOKRequired(), (Logger)log);
                    byokManager = BYOKManager.getInstance();
                    String msgInit = "Gestore BYOK inizializzato;\n\tHSM registrati: " + byokManager.getKeystoreTypes() + "\n\tSecurityEngine registrati: " + byokManager.getSecurityEngineTypes() + "\n\tGovWaySecurityEngine: " + byokManager.getSecurityEngineGovWayDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del manager BYOK", e);
            }
            boolean reInitSecretMaps = false;
            try {
                String secretsConfig = serverProperties.getBYOKEnvSecretsConfig();
                if (byokManager != null && StringUtils.isNotEmpty((String)secretsConfig)) {
                    log.info("Inizializzazione secrets in corso...");
                    boolean useSecurityEngine = true;
                    HashMap dynamicMap = new HashMap();
                    DynamicInfo dynamicInfo = new DynamicInfo();
                    DynamicUtils.fillDynamicMap((Logger)log, dynamicMap, (DynamicInfo)dynamicInfo);
                    if (byokManager.isBYOKRemoteGovWayNodeUnwrapConfig()) {
                        reInitSecretMaps = true;
                        useSecurityEngine = false;
                    }
                    BYOKMapProperties.initialize((Logger)log, (String)secretsConfig, (boolean)serverProperties.isBYOKEnvSecretsConfigRequired(), (boolean)useSecurityEngine, dynamicMap, (boolean)true);
                    BYOKMapProperties secretsProperties = BYOKMapProperties.getInstance();
                    secretsProperties.initEnvironment();
                    String msgInit = "Environment inizializzato con i secrets definiti nel file '" + secretsConfig + "'\n\tJavaProperties: " + secretsProperties.getJavaMap().keys() + "\n\tEnvProperties: " + secretsProperties.getEnvMap().keys() + "\n\tObfuscateMode: " + secretsProperties.getObfuscateModeDescription();
                    log.info(msgInit);
                }
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione dell'ambiente (secrets)", e);
            }
            if (!DatasourceProperties.initialize(confDir, log)) {
                return;
            }
            log.info("Inizializzazione DBManager in corso...");
            try {
                DatasourceProperties dbProperties = DatasourceProperties.getInstance();
                DBManager.initialize(dbProperties.getConfigDataSource(), dbProperties.getConfigDataSourceContext(), dbProperties.getConfigTipoDatabase(), dbProperties.getTracceDataSource(), dbProperties.getTracceDataSourceContext(), dbProperties.getTracceTipoDatabase(), dbProperties.getStatisticheDataSource(), dbProperties.getStatisticheDataSourceContext(), dbProperties.getStatisticheTipoDatabase(), dbProperties.isShowSql());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione DBManager effettuata con successo");
            log.info("Inizializzazione ExtendedInfoManager in corso...");
            try {
                ExtendedInfoManager.initialize((Loader)new Loader(), null, null, null);
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione ExtendedInfoManager effettuata con successo");
            log.info("Inizializzazione NodiRuntime in corso...");
            try {
                boolean configFileRequired = false;
                ConfigurazioneNodiRuntime.initialize((String)serverProperties.getConfigurazioneNodiRuntime(), (boolean)configFileRequired, (ConfigurazioneNodiRuntimeProperties[])new ConfigurazioneNodiRuntimeProperties[0]);
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del gestore dei nodi run", e);
            }
            log.info("Inizializzazione NodiRuntime effettuata con successo");
            log.info("Inizializzazione ProtocolFactoryManager in corso...");
            ServerProperties properties = null;
            try {
                properties = ServerProperties.getInstance();
                ConfigurazionePdD configPdD = new ConfigurazionePdD();
                configPdD.setAttesaAttivaJDBC(-1L);
                configPdD.setCheckIntervalJDBC(-1);
                configPdD.setLoader(new Loader(Startup.class.getClassLoader()));
                configPdD.setLog(log);
                ProtocolFactoryManager.initialize((Logger)log, (ConfigurazionePdD)configPdD, (String)properties.getProtocolloDefault());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("ProtocolFactoryManager DBManager effettuata con successo");
            log.info("Inizializzazione Risorse Statiche Console in corso...");
            try {
                Startup.initResourceConsole();
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione Risorse Statiche Console effettuata con successo");
            log.info("Inizializzazione Soglia per Dimensione Messaggi in corso...");
            try {
                DumpUtils.setThreshold_readInMemory((int)properties.getTransazioniDettaglioVisualizzazioneMessaggiThreshold());
            }
            catch (Exception e) {
                throw new UtilsRuntimeException(e.getMessage(), (Throwable)e);
            }
            log.info("Inizializzazione Soglia per Dimensione Messaggi effettuata con successo");
            if (reInitSecretMaps) {
                try {
                    initRuntimeConfigReader = new InitRuntimeConfigReader(serverProperties, ConfigurazioneNodiRuntime.getConfigurazioneNodiRuntime(), reInitSecretMaps);
                    initRuntimeConfigReader.start();
                    log.info("RuntimeConfigReader avviato con successo.");
                }
                catch (Exception e) {
                    log.error("Errore durante l'inizializzazione del RuntimeConfigReader: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                FailedAttempts.createInstance((String)serverProperties.getLoginRetryDelays());
            }
            catch (Exception e) {
                Startup.doError("Errore durante l'inizializzazione del FailedAttempts", e);
            }
            initializedResources = true;
            log.info("Inizializzazione rs api monitor effettuata con successo.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initResourceConsole() throws UtilsException, DriverRegistroServiziException, DriverRegistroServiziNotFound {
        DBManager dbManager = DBManager.getInstance();
        Connection connection = null;
        try {
            connection = dbManager.getConnectionConfig();
            ServiceManagerProperties smp = dbManager.getServiceManagerPropertiesConfig();
            Logger logSql = LoggerProperties.getLoggerDAO();
            LoginBean lb = new LoginBean(connection, true, smp, logSql);
            Utility.setStaticConfigurazioneGenerale((Configurazione)lb.getConfigurazioneGenerale());
            boolean multitenantAbilitato = Utility.isMultitenantAbilitato();
            Utility.setStaticFiltroDominioAbilitato((boolean)multitenantAbilitato);
            DriverRegistroServiziDB driverDB = new DriverRegistroServiziDB(connection, logSql, DatasourceProperties.getInstance().getConfigTipoDatabase());
            FiltroRicerca filtroRicercaPdd = new FiltroRicerca();
            filtroRicercaPdd.setTipo(PddTipologia.OPERATIVO.toString());
            List idsPdd = null;
            try {
                idsPdd = driverDB.getAllIdPorteDominio(filtroRicercaPdd);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            Startup.initPdd(idsPdd, driverDB);
        }
        finally {
            dbManager.releaseConnectionConfig(connection);
        }
    }

    private static void initPdd(List<String> idsPdd, DriverRegistroServiziDB driverDB) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idsPdd != null && !idsPdd.isEmpty()) {
            for (String idPdd : idsPdd) {
                FiltroRicercaSoggetti filtroSoggetti = new FiltroRicercaSoggetti();
                filtroSoggetti.setNomePdd(idPdd);
                List idsSoggetti = null;
                try {
                    idsSoggetti = driverDB.getAllIdSoggetti(filtroSoggetti);
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (idsSoggetti == null || idsSoggetti.isEmpty()) continue;
                for (IDSoggetto idSoggetto : idsSoggetti) {
                    Utility.putIdentificativoPorta((String)idSoggetto.getTipo(), (String)idSoggetto.getNome(), (String)driverDB.getSoggetto(idSoggetto).getIdentificativoPorta());
                }
            }
        }
    }

    private static void doError(String msg, Exception e) {
        String msgErrore = msg + ": " + e.getMessage();
        log.error(msgErrore, (Throwable)e);
        throw new UtilsRuntimeException(msgErrore, (Throwable)e);
    }

    static {
        initializedLog = false;
        initializedResources = false;
    }
}

