/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.EntityClientHelper;
import org.restlet.engine.local.FileEntity;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

public class FileClientHelper
extends EntityClientHelper {
    public FileClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.FILE);
    }

    protected boolean checkExtensionsConsistency(File file) {
        boolean knownExtension = true;
        Collection<String> set = Entity.getExtensions(file.getName(), this.getMetadataService());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && knownExtension) {
            knownExtension = this.getMetadataService().getMetadata(iterator.next()) != null;
        }
        return knownExtension;
    }

    private boolean checkMetadataConsistency(String fileName, Representation representation) {
        if (representation != null) {
            Variant var = new Variant();
            Entity.updateMetadata(fileName, var, false, this.getMetadataService());
            if (!(var.getLanguages().isEmpty() || representation.getLanguages().isEmpty() || var.getLanguages().containsAll(representation.getLanguages()))) {
                return false;
            }
            if (var.getMediaType() != null && representation.getMediaType() != null && !var.getMediaType().includes(representation.getMediaType())) {
                return false;
            }
            if (!(var.getEncodings().isEmpty() || representation.getEncodings().isEmpty() || var.getEncodings().containsAll(representation.getEncodings()))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Entity getEntity(String decodedPath) {
        return new FileEntity(new File(LocalReference.localizePath(decodedPath)), this.getMetadataService());
    }

    public String getTemporaryExtension() {
        return this.getHelpedParameters().getFirstValue("temporaryExtension", "tmp");
    }

    @Override
    protected void handleLocal(Request request, Response response, String decodedPath) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.FILE.getSchemeName().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException(String.format("Protocol \"%s\" not supported by the connector. Only FILE is supported.", scheme));
        }
        this.handleFile(request, response, decodedPath);
    }

    protected void handleFile(Request request, Response response, String decodedPath) {
        if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
            this.handleEntityGet(request, response, this.getEntity(decodedPath));
        } else if (Method.PUT.equals(request.getMethod())) {
            this.handleFilePut(request, response, decodedPath, new File(decodedPath));
        } else if (Method.DELETE.equals(request.getMethod())) {
            this.handleFileDelete(response, new File(decodedPath));
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
            response.getAllowedMethods().add(Method.PUT);
            response.getAllowedMethods().add(Method.DELETE);
        }
    }

    protected void handleFileDelete(Response response, File file) {
        if (file.isDirectory()) {
            if (file.listFiles().length == 0) {
                if (IoUtils.delete(file)) {
                    response.setStatus(Status.SUCCESS_NO_CONTENT);
                } else {
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the directory");
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, "Couldn't delete the non-empty directory");
            }
        } else if (IoUtils.delete(file)) {
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the file");
        }
    }

    protected void handleFilePut(Request request, Response response, String path, File file) {
        response.setStatus(this.doHandleFilePut(request, path, file));
    }

    private Status doHandleFilePut(Request request, String path, File file) {
        Range range;
        if (file.exists()) {
            if (file.isDirectory()) {
                return new Status(Status.CLIENT_ERROR_FORBIDDEN, "Can't put a new representation of a directory");
            }
        } else if (path.endsWith("/")) {
            if (file.mkdirs()) {
                return Status.SUCCESS_NO_CONTENT;
            }
            this.getLogger().warning("Unable to create the new directory");
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new directory");
        }
        if (!this.checkMetadataConsistency(file.getName(), request.getEntity())) {
            return new Status(Status.CLIENT_ERROR_BAD_REQUEST, "The metadata are not consistent with the URI");
        }
        final String baseName = Entity.getBaseName(file.getName(), this.getMetadataService());
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && baseName.equals(Entity.getBaseName(file.getName(), FileClientHelper.this.getMetadataService()));
            }
        };
        File[] files = file.getParentFile().listFiles(filter);
        File uniqueVariant = null;
        ArrayList<File> variantsList = new ArrayList<File>();
        if (files != null && files.length > 0) {
            Variant variant = new Variant();
            Entity.updateMetadata(file.getName(), variant, false, this.getMetadataService());
            Iterator<Encoding> extensions = Entity.getExtensions(variant, this.getMetadataService());
            for (File entry : files) {
                Collection<String> entryExtensions = Entity.getExtensions(entry.getName(), this.getMetadataService());
                if (!entryExtensions.containsAll((Collection<?>)((Object)extensions))) continue;
                variantsList.add(entry);
                if (!extensions.containsAll(entryExtensions)) continue;
                uniqueVariant = entry;
            }
        }
        if (uniqueVariant != null) {
            file = uniqueVariant;
        } else {
            if (!variantsList.isEmpty()) {
                return new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely.");
            }
            Entity.updateMetadata(file.getName(), request.getEntity(), true, this.getMetadataService());
            StringBuilder fileName = new StringBuilder(baseName);
            for (Language language : request.getEntity().getLanguages()) {
                this.updateFileExtension(fileName, language);
            }
            for (Encoding encoding : request.getEntity().getEncodings()) {
                this.updateFileExtension(fileName, encoding);
            }
            this.updateFileExtension(fileName, request.getEntity().getMediaType());
            file = new File(file.getParentFile(), fileName.toString());
        }
        if (!this.checkExtensionsConsistency(file)) {
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to process properly the URI. At least one extension is not known by the server.");
        }
        Range range2 = range = !request.getRanges().isEmpty() && Range.isBytesRange(request.getRanges().get(0)) ? request.getRanges().get(0) : null;
        if (file.exists()) {
            if (range != null) {
                return this.updateFileWithPartialContent(request, file, range);
            }
            return this.replaceFile(request, file);
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            String message = "Unable to create the parent directory";
            this.getLogger().warning(message);
            return new Status(Status.SERVER_ERROR_INTERNAL, message);
        }
        if (range != null) {
            return this.createFileWithPartialContent(request, file, range);
        }
        return this.createFile(request, file);
    }

    private Status updateFileWithPartialContent(Request request, File file, Range range) {
        File tmp = null;
        try {
            tmp = new File(file.getCanonicalPath() + "." + this.getTemporaryExtension());
            this.cleanTemporaryFileIfUploadNotResumed(tmp);
            if (!tmp.exists()) {
                Files.copy(file.toPath(), tmp.toPath(), new CopyOption[0]);
            }
            try (RandomAccessFile raf = new RandomAccessFile(tmp, "rwd");){
                if (range.getIndex() == -1L) {
                    if (raf.length() <= range.getSize()) {
                        raf.seek(range.getSize());
                    } else {
                        raf.seek(raf.length() - range.getSize());
                    }
                } else {
                    raf.seek(range.getIndex());
                }
                if (request.isEntityAvailable()) {
                    IoUtils.copy(request.getEntity().getStream(), raf);
                }
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe);
                this.cleanTemporaryFileIfUploadNotResumed(tmp);
                return new Status(Status.SERVER_ERROR_INTERNAL, (Throwable)ioe);
            }
            return this.replaceFileByTemporaryFile(request, file, tmp);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
            this.cleanTemporaryFileIfUploadNotResumed(tmp);
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file");
        }
    }

    private Status replaceFile(Request request, File file) {
        File tmp = null;
        try {
            tmp = File.createTempFile("restlet-upload", "bin");
            if (request.isEntityAvailable()) {
                Files.copy(request.getEntity().getStream(), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
            this.cleanTemporaryFileIfUploadNotResumed(tmp);
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file");
        }
        return this.replaceFileByTemporaryFile(request, file, tmp);
    }

    private Status replaceFileByTemporaryFile(Request request, File file, File tmp) {
        if (!tmp.exists()) {
            return new Status(Status.SERVER_ERROR_INTERNAL, "Can't replace the existing file without new content.");
        }
        if (!IoUtils.delete(file)) {
            this.cleanTemporaryFileIfUploadNotResumed(tmp);
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to delete the existing file");
        }
        if (tmp.renameTo(file)) {
            if (request.isEntityAvailable()) {
                return Status.SUCCESS_NO_CONTENT;
            }
            return Status.SUCCESS_OK;
        }
        if (!tmp.exists()) {
            return new Status(Status.SERVER_ERROR_INTERNAL, "Unable to move the temporary file to replace the existing file");
        }
        try {
            Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return new Status(Status.SERVER_ERROR_INTERNAL, (Throwable)e, "Unable to move the temporary file to replace the existing file");
        }
        return Status.SUCCESS_OK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status createFileWithPartialContent(Request request, File file, Range range) {
        try (RandomAccessFile raf = new RandomAccessFile(file, "rwd");){
            if (range.getIndex() == -1L) {
                if (raf.length() <= range.getSize()) {
                    raf.seek(range.getSize());
                } else {
                    raf.seek(raf.length() - range.getSize());
                }
            } else {
                raf.seek(range.getIndex());
            }
            if (request.isEntityAvailable()) {
                IoUtils.copy(request.getEntity().getStream(), raf);
                Status status2 = Status.SUCCESS_CREATED;
                return status2;
            }
            Status status = Status.SUCCESS_NO_CONTENT;
            return status;
        }
        catch (FileNotFoundException fnfe) {
            this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
            return new Status(Status.SERVER_ERROR_INTERNAL, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
            return new Status(Status.SERVER_ERROR_INTERNAL, (Throwable)ioe);
        }
    }

    private Status createFile(Request request, File file) {
        try {
            if (request.isEntityAvailable()) {
                Files.copy(request.getEntity().getStream(), file.toPath(), new CopyOption[0]);
                return Status.SUCCESS_CREATED;
            }
            if (file.createNewFile()) {
                return Status.SUCCESS_NO_CONTENT;
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
            return new Status(Status.SERVER_ERROR_INTERNAL, (Throwable)ioe);
        }
        String message = "Unable to create the new file";
        this.getLogger().warning(message);
        return new Status(Status.SERVER_ERROR_INTERNAL, message);
    }

    private void cleanTemporaryFileIfUploadNotResumed(File tmp) {
        if (tmp.exists() && !this.isResumeUpload()) {
            IoUtils.delete(tmp);
        }
    }

    public boolean isResumeUpload() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("resumeUpload", "false"));
    }

    private void updateFileExtension(StringBuilder fileName, Metadata metadata) {
        boolean defaultMetadata = true;
        if (this.getMetadataService() != null) {
            if (metadata instanceof Language) {
                Language language = (Language)metadata;
                defaultMetadata = language.equals(this.getMetadataService().getDefaultLanguage());
            } else if (metadata instanceof MediaType) {
                MediaType mediaType = (MediaType)metadata;
                defaultMetadata = mediaType.equals(this.getMetadataService().getDefaultMediaType());
            } else if (metadata instanceof CharacterSet) {
                CharacterSet characterSet = (CharacterSet)metadata;
                defaultMetadata = characterSet.equals(this.getMetadataService().getDefaultCharacterSet());
            } else if (metadata instanceof Encoding) {
                Encoding encoding = (Encoding)metadata;
                defaultMetadata = encoding.equals(this.getMetadataService().getDefaultEncoding());
            }
        }
        if (!defaultMetadata) {
            String extension = this.getMetadataService().getExtension(metadata);
            if (extension != null) {
                fileName.append("." + extension);
            } else if (metadata.getParent() != null) {
                this.updateFileExtension(fileName, metadata.getParent());
            }
        }
    }
}

