/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.util.Objects;
import org.restlet.data.MediaType;
import org.restlet.engine.resource.MethodAnnotationInfo;
import org.restlet.engine.util.SystemUtils;
import org.restlet.representation.Variant;

public class VariantInfo
extends Variant {
    private final MethodAnnotationInfo annotationInfo;
    private float inputScore;

    public VariantInfo(MediaType mediaType) {
        this(mediaType, (MethodAnnotationInfo)null);
    }

    public VariantInfo(MediaType mediaType, MethodAnnotationInfo annotationInfo) {
        super(mediaType);
        this.annotationInfo = annotationInfo;
        this.inputScore = 1.0f;
    }

    public VariantInfo(Variant variant, MethodAnnotationInfo annotationInfo) {
        this(variant.getMediaType(), annotationInfo);
        this.setCharacterSet(variant.getCharacterSet());
        this.setEncodings(variant.getEncodings());
        this.setLanguages(variant.getLanguages());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof VariantInfo)) {
            return false;
        }
        VariantInfo that = (VariantInfo)other;
        return super.equals(that) && Objects.equals(this.getAnnotationInfo(), that.getAnnotationInfo());
    }

    public MethodAnnotationInfo getAnnotationInfo() {
        return this.annotationInfo;
    }

    public float getInputScore() {
        return this.inputScore;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(super.hashCode(), this.annotationInfo);
    }

    public void setInputScore(float inputScore) {
        this.inputScore = inputScore;
    }
}

