/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigInstanceProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.exceptions.EngineException;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class AlarmConfigProperties {
    private static AlarmConfigProperties alarmConfigProperties = null;
    private static AlarmEngineConfig alarmEngineConfig = null;
    private AlarmConfigInstanceProperties reader;

    public static AlarmEngineConfig getAlarmConfiguration(Logger log, String filePath, String confDir) throws Exception {
        return AlarmConfigProperties.getAlarmConfiguration(log, filePath, confDir, true);
    }

    public static AlarmEngineConfig getAlarmConfiguration(Logger log, String filePath, String confDir, boolean useDefaultIfNotFound) throws Exception {
        if (alarmConfigProperties == null) {
            return AlarmConfigProperties._getAlarmConfiguration(log, filePath, confDir, useDefaultIfNotFound);
        }
        return alarmEngineConfig;
    }

    private static synchronized AlarmEngineConfig _getAlarmConfiguration(Logger log, String filePath, String confDir, boolean useDefaultIfNotFound) throws Exception {
        if (alarmConfigProperties == null) {
            alarmConfigProperties = new AlarmConfigProperties(log, filePath, confDir, useDefaultIfNotFound);
            alarmEngineConfig = AlarmEngineConfig.readAlarmEngineConfig(log, alarmConfigProperties);
        }
        return alarmEngineConfig;
    }

    public AlarmConfigProperties(Logger log, String filePat, String confDir, boolean useDefaultIfNotFound) throws EngineException {
        Properties p = new Properties();
        InputStream properties = null;
        try {
            File f = new File(filePat);
            if (f.exists()) {
                properties = new FileInputStream(f);
            } else {
                properties = AlarmConfigProperties.class.getResourceAsStream(filePat);
                if (properties == null && !filePat.startsWith("/")) {
                    properties = AlarmConfigProperties.class.getResourceAsStream("/" + filePat);
                }
            }
            if (properties == null) {
                properties = AlarmConfigProperties.class.getResourceAsStream("/org/openspcoop2/monitor/engine/alarm/allarmi_configurazione.properties");
            }
            if (properties == null) {
                throw new Exception("Properties " + filePat + " not found");
            }
            p.load(properties);
            properties.close();
        }
        catch (Exception e) {
            log.error("Riscontrato errore durante la lettura del file '" + filePat + "': " + e.getMessage(), (Throwable)e);
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new EngineException(e.getMessage(), e);
        }
        try {
            this.reader = new AlarmConfigInstanceProperties(p, log, confDir);
        }
        catch (Exception e) {
            throw new EngineException(e.getMessage(), e);
        }
    }

    public String getProperty(String name, String defaultValue, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null) {
            return defaultValue;
        }
        return tmp.trim();
    }

    public String getProperty(String name, boolean required, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new UtilsException("Property [" + name + "] not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }
}

