/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.alarm;

import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.openspcoop2.monitor.sdk.alarm.IAlarmLogger;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.slf4j.Logger;

public class AlarmLogger
implements IAlarmLogger {
    private CircularFifoQueue<String> logHistory = new CircularFifoQueue(20);
    private static final int NUMERO_EVENTI = 20;
    private String threadName;
    private String nome;
    private String id;
    private Logger _log;
    private Logger _logSql;

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public AlarmLogger(String nome, String id, String threadName, Logger log, Logger logSql) {
        this.nome = nome;
        this.id = id;
        this.threadName = threadName;
        this._log = log;
        this._logSql = logSql;
    }

    public Logger getInternalLogger() {
        return this._log;
    }

    public Logger getInternalSqlLogger() {
        return this._logSql;
    }

    public void debug(String messaggio) {
        this._log(messaggio, true, false, false, false, null);
    }

    public void debug(String messaggio, Throwable t) {
        this._log(messaggio, true, false, false, false, t);
    }

    public void info(String messaggio) {
        this._log(messaggio, false, true, false, false, null);
    }

    public void info(String messaggio, Throwable t) {
        this._log(messaggio, false, true, false, false, t);
    }

    public void warn(String messaggio) {
        this._log(messaggio, false, false, true, false, null);
    }

    public void warn(String messaggio, Throwable t) {
        this._log(messaggio, false, false, true, false, t);
    }

    public void error(String messaggio) {
        this._log(messaggio, false, false, false, true, null);
    }

    public void error(String messaggio, Throwable t) {
        this._log(messaggio, false, false, false, true, t);
    }

    private void _log(String messaggio, boolean debug, boolean info, boolean warning, boolean error, Throwable e) {
        String prefix = AlarmLogger.buildPrefix(this.threadName, this.nome, this.id);
        String logMsg = prefix + messaggio;
        if (debug) {
            if (e != null) {
                this._log.debug(logMsg, e);
            } else {
                this._log.debug(logMsg);
            }
        } else if (info) {
            if (e != null) {
                this._log.info(logMsg, e);
            } else {
                this._log.info(logMsg);
            }
        } else if (warning) {
            if (e != null) {
                this._log.warn(logMsg, e);
            } else {
                this._log.warn(logMsg);
            }
        } else if (error) {
            if (e != null) {
                this._log.error(logMsg, e);
            } else {
                this._log.error(logMsg);
            }
        }
        String data = " <" + DateUtils.getSimpleDateFormatMs().format(DateManager.getDate()) + "> ";
        this.logHistory.add((Object)("\n" + data + messaggio));
    }

    public static String buildPrefix(String threadName, String aliasAllarme, String idAllarme) {
        Object prefix = "";
        if (threadName != null) {
            prefix = "[" + threadName + "] ";
        }
        prefix = (String)prefix + "Allarme '" + aliasAllarme + "' (" + idAllarme + ") ";
        return prefix;
    }

    public String getStatoAllarme() {
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append("================================================================\n");
        sb.append("Dati Identificativi\n");
        sb.append("- Nome: ").append(this.nome).append("\n");
        sb.append("- IdAllarme: ").append(this.id).append("\n");
        sb.append("- IdThread: ").append(this.threadName).append("\n");
        sb.append("\nUltimi 20 eventi:");
        if (this.logHistory.isFull()) {
            sb.append("\n...");
        }
        if ((s = this.logHistory.toString()).startsWith("[") && s.length() > 1) {
            s = s.substring(1);
        }
        if (s.endsWith("]") && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        sb.append(s);
        sb.append("\n");
        sb.append("================================================================\n");
        return sb.toString();
    }
}

