/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.condition;

import java.util.Collection;
import java.util.List;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.monitor.sdk.transaction.FaseTracciamento;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.slf4j.Logger;

public class EsitoUtils {
    public static final String ALL_LABEL = "[Qualsiasi]";
    public static final String ALL_ERROR_LABEL = "Fallite";
    public static final String ALL_OK_LABEL = "Completate con successo";
    public static final String ALL_FAULT_APPLICATIVO_LABEL = "Fault Applicativo";
    public static final String ALL_PERSONALIZZATO_LABEL = "Personalizzato";
    public static final String ALL_ERROR_FAULT_APPLICATIVO_LABEL = "Fallite - Fault Applicativo";
    public static final String ALL_ERROR_CONSEGNA_LABEL = "Errori di Consegna";
    public static final String ALL_ERROR_RICHIESTE_SCARTATE_LABEL = "Richieste Scartate";
    public static final String ALL_VALUE_AS_STRING = "-";
    public static final Integer ALL_VALUE = -1;
    public static final Integer ALL_ERROR_VALUE = -2;
    public static final Integer ALL_OK_VALUE = -3;
    public static final Integer ALL_FAULT_APPLICATIVO_VALUE = -4;
    public static final Integer ALL_PERSONALIZZATO_VALUE = -5;
    public static final Integer ALL_ERROR_FAULT_APPLICATIVO_VALUE = -6;
    public static final Integer ALL_ERROR_CONSEGNA_VALUE = -7;
    public static final Integer ALL_ERROR_RICHIESTE_SCARTATE_VALUE = -8;
    public static final boolean DEFAULT_VALUE_ESCLUDI_RICHIESTE_SCARTATE = true;
    public static final String LABEL_ESITO_CONSEGNA_MULTIPLA_SENZA_STATI = "Consegna Multipla";
    private Logger logger;
    private EsitiProperties esitiProperties;
    private static final String SUFFIX_IN_REQUEST = "_irq";
    private static final String SUFFIX_OUT_REQUEST = "_orq";
    private static final String SUFFIX_OUT_RESPONSE = "_ors";

    public EsitoUtils(Logger logger, String protocollo) throws ProtocolException {
        this.logger = logger;
        this.esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.logger, (String)protocollo);
    }

    public void setExpression(IExpression expr, Integer esitoGruppo, Integer esitoDettaglio, Integer[] esitoDettaglioPersonalizzato, String contesto, boolean escludiRichiesteScartate, IField fieldEsito, IField fieldContesto, IExpression newExpression) throws ProtocolException, ExpressionException, ExpressionNotImplementedException, ServiceException, NotImplementedException {
        this.setExpression(expr, esitoGruppo, esitoDettaglio, esitoDettaglioPersonalizzato, escludiRichiesteScartate, fieldEsito, newExpression);
        this.setExpressionContesto(expr, fieldContesto, contesto);
    }

    public void setExpression(IExpression expr, Integer esitoGruppo, Integer esitoDettaglio, Integer[] esitoDettaglioPersonalizzato, boolean escludiRichiesteScartate, IField fieldEsito, IExpression newExpression) throws ProtocolException, ExpressionException, ExpressionNotImplementedException, ServiceException, NotImplementedException {
        boolean soloRichiesteScartate;
        boolean senzaFiltro = esitoGruppo != null && ALL_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean soloOk = esitoGruppo != null && ALL_OK_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean faultApplicativo = esitoGruppo != null && ALL_FAULT_APPLICATIVO_VALUE.intValue() == esitoGruppo.intValue();
        boolean soloErrori = esitoGruppo != null && ALL_ERROR_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean personalizzato = esitoGruppo != null && ALL_PERSONALIZZATO_VALUE.intValue() == esitoGruppo.intValue();
        boolean soloErroriPiuFaultApplicativi = esitoGruppo != null && ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean soloErroriConsegna = esitoGruppo != null && ALL_ERROR_CONSEGNA_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        boolean bl = soloRichiesteScartate = esitoGruppo != null && ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() == esitoGruppo.intValue() && esitoDettaglio != null && ALL_VALUE.intValue() == esitoDettaglio.intValue();
        if (senzaFiltro && escludiRichiesteScartate) {
            senzaFiltro = false;
        }
        if (!senzaFiltro) {
            if (personalizzato) {
                if (esitoDettaglioPersonalizzato == null || esitoDettaglioPersonalizzato.length <= 0) {
                    throw new ServiceException("Esito Personalizzato richiede la selezione di almeno un dettaglio");
                }
                expr.and().in(fieldEsito, (Object[])esitoDettaglioPersonalizzato);
            } else if (soloOk) {
                List esitiOk = this.esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                expr.and().in(fieldEsito, (Collection)esitiOk);
            } else if (faultApplicativo) {
                int codeFaultApplicativo = this.esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
                expr.and().equals(fieldEsito, (Object)codeFaultApplicativo);
            } else if (soloErrori || soloErroriPiuFaultApplicativi) {
                IExpression exprOk = newExpression;
                List esitiOk = null;
                esitiOk = soloErrori ? this.esitiProperties.getEsitiCodeOk() : this.esitiProperties.getEsitiCodeOk_senzaFaultApplicativo();
                exprOk.and().in(fieldEsito, (Collection)esitiOk);
                expr.and().not(exprOk);
                if (escludiRichiesteScartate) {
                    List esitiRichiesteMalformate = this.esitiProperties.getEsitiCodeRichiestaScartate();
                    IExpression exprRichiesteMalformate = newExpression;
                    exprRichiesteMalformate.and().in(fieldEsito, (Collection)esitiRichiesteMalformate);
                    expr.and().not(exprRichiesteMalformate);
                }
            } else if (soloErroriConsegna) {
                List esitiErroriConsegna = this.esitiProperties.getEsitiCodeErroriConsegna();
                expr.and().in(fieldEsito, (Collection)esitiErroriConsegna);
            } else if (soloRichiesteScartate) {
                List esitiRichiesteMalformate = this.esitiProperties.getEsitiCodeRichiestaScartate();
                expr.and().in(fieldEsito, (Collection)esitiRichiesteMalformate);
            } else if (esitoDettaglio != null && esitoDettaglio.intValue() == ALL_FAULT_APPLICATIVO_VALUE.intValue()) {
                int codeFaultApplicativo = this.esitiProperties.convertNameToCode(EsitoTransazioneName.ERRORE_APPLICATIVO.name());
                expr.and().equals(fieldEsito, (Object)codeFaultApplicativo);
            } else if (esitoDettaglio != null && esitoDettaglio >= 0) {
                expr.and().equals(fieldEsito, (Object)esitoDettaglio);
            } else if (escludiRichiesteScartate) {
                List esitiRichiesteMalformate = this.esitiProperties.getEsitiCodeRichiestaScartate();
                IExpression exprRichiesteMalformate = newExpression;
                exprRichiesteMalformate.and().in(fieldEsito, (Collection)esitiRichiesteMalformate);
                expr.and().not(exprRichiesteMalformate);
            }
        }
    }

    public void setExpressionContesto(IExpression expr, IField fieldContesto, String contesto) throws ExpressionNotImplementedException, ExpressionException {
        if (!ALL_VALUE_AS_STRING.equals(contesto)) {
            expr.and().equals(fieldContesto, (Object)contesto);
        }
    }

    public Integer getEsitoValueFromLabel(String label) {
        if (ALL_LABEL.equals(label)) {
            return ALL_VALUE;
        }
        if (ALL_ERROR_LABEL.equals(label)) {
            return ALL_ERROR_VALUE;
        }
        if (ALL_OK_LABEL.equals(label)) {
            return ALL_OK_VALUE;
        }
        if (ALL_FAULT_APPLICATIVO_LABEL.equals(label)) {
            return ALL_FAULT_APPLICATIVO_VALUE;
        }
        if (ALL_PERSONALIZZATO_LABEL.equals(label)) {
            return ALL_PERSONALIZZATO_VALUE;
        }
        if (ALL_ERROR_FAULT_APPLICATIVO_LABEL.equals(label)) {
            return ALL_ERROR_FAULT_APPLICATIVO_VALUE;
        }
        if (ALL_ERROR_CONSEGNA_LABEL.equals(label)) {
            return ALL_ERROR_CONSEGNA_VALUE;
        }
        if (ALL_ERROR_RICHIESTE_SCARTATE_LABEL.equals(label)) {
            return ALL_ERROR_RICHIESTE_SCARTATE_VALUE;
        }
        if (LABEL_ESITO_CONSEGNA_MULTIPLA_SENZA_STATI.equals(label)) {
            try {
                return this.esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
            }
            catch (Exception e) {
                this.logger.error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try {
            return this.esitiProperties.convertLabelToCode(label);
        }
        catch (Exception e) {
            this.logger.error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getEsitoLabelFromValue(Object value, boolean consegnaMultiplaSenzaVariStati) {
        if (value != null && value instanceof Integer) {
            if (ALL_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_LABEL;
            }
            if (ALL_ERROR_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_ERROR_LABEL;
            }
            if (ALL_OK_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_OK_LABEL;
            }
            if (ALL_FAULT_APPLICATIVO_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_FAULT_APPLICATIVO_LABEL;
            }
            if (ALL_PERSONALIZZATO_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_PERSONALIZZATO_LABEL;
            }
            if (ALL_ERROR_FAULT_APPLICATIVO_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_ERROR_FAULT_APPLICATIVO_LABEL;
            }
            if (ALL_ERROR_CONSEGNA_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_ERROR_CONSEGNA_LABEL;
            }
            if (ALL_ERROR_RICHIESTE_SCARTATE_VALUE.intValue() == ((Integer)value).intValue()) {
                return ALL_ERROR_RICHIESTE_SCARTATE_LABEL;
            }
            try {
                int consegnaMultipla;
                int valueInt = (Integer)value;
                if (consegnaMultiplaSenzaVariStati && (consegnaMultipla = this.esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA).intValue()) == valueInt) {
                    return LABEL_ESITO_CONSEGNA_MULTIPLA_SENZA_STATI;
                }
                return this.esitiProperties.getEsitoLabel(Integer.valueOf(valueInt));
            }
            catch (Exception e) {
                this.logger.error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
                return "Conversione non riuscita";
            }
        }
        this.logger.error("Conversione non riuscita: tipo [" + (value != null ? value.getClass().getName() : "value is null") + "] non supportato");
        return "Conversione non riuscita";
    }

    public String getEsitoContestoValueFromLabel(String label) {
        if (ALL_LABEL.equals(label)) {
            return ALL_VALUE_AS_STRING;
        }
        try {
            return this.esitiProperties.convertLabelToContextTypeCode(label);
        }
        catch (Exception e) {
            this.logger.error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getEsitoContestoLabelFromValue(Object value) {
        if (value instanceof String) {
            if (ALL_VALUE_AS_STRING.equals(value)) {
                return ALL_LABEL;
            }
            try {
                boolean moreContext = this.esitiProperties.getEsitiTransactionContextCode().size() > 1;
                String code = (String)value;
                Object label = null;
                label = EsitoUtils.isFaseRequestIn(code) ? (String)(moreContext ? this.esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext(code)) + " - " : "") + "Richiesta ricevuta" : (EsitoUtils.isFaseRequestOut(code) ? (String)(moreContext ? this.esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext(code)) + " - " : "") + "Richiesta in consegna" : (EsitoUtils.isFaseResponseOut(code) ? (String)(moreContext ? this.esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext(code)) + " - " : "") + "Risposta in consegna" : this.esitiProperties.getEsitoTransactionContextLabel(code)));
                return label;
            }
            catch (Exception e) {
                this.logger.error("Conversione non riuscita: " + e.getMessage(), (Throwable)e);
                return "Conversione non riuscita";
            }
        }
        this.logger.error("Conversione non riuscita: tipo [" + value.getClass().getName() + "] non supportato");
        return "Conversione non riuscita";
    }

    public static String buildEsitoContext(String esitoContext, FaseTracciamento fase) {
        if (esitoContext == null) {
            esitoContext = "standard";
        }
        switch (fase) {
            case IN_REQUEST: {
                return esitoContext + SUFFIX_IN_REQUEST;
            }
            case OUT_REQUEST: {
                return esitoContext + SUFFIX_OUT_REQUEST;
            }
            case OUT_RESPONSE: {
                return esitoContext + SUFFIX_OUT_RESPONSE;
            }
        }
        return esitoContext;
    }

    public static boolean isFaseIntermedia(String esito) {
        return EsitoUtils.isFaseRequestIn(esito) || EsitoUtils.isFaseRequestOut(esito) || EsitoUtils.isFaseResponseOut(esito);
    }

    public static String getRawEsitoContext(String esito) {
        if (EsitoUtils.isFaseIntermedia(esito) && esito.length() > SUFFIX_IN_REQUEST.length()) {
            return esito.substring(0, esito.length() - SUFFIX_IN_REQUEST.length());
        }
        return esito;
    }

    public static boolean isFaseRequestIn(String esito) {
        return esito != null && esito.endsWith(SUFFIX_IN_REQUEST);
    }

    public static boolean isFaseRequestOut(String esito) {
        return esito != null && esito.endsWith(SUFFIX_OUT_REQUEST);
    }

    public static boolean isFaseResponseOut(String esito) {
        return esito != null && esito.endsWith(SUFFIX_OUT_RESPONSE);
    }
}

