/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.sql.Connection;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.dao.DAOFactoryException;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdAccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.IdSoggetto;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.ConfigurazioneServizio;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.IdConfigurazioneServizio;
import org.openspcoop2.core.plugins.IdConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioServiceSearch;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.slf4j.Logger;

public class BasicServiceLibraryReader {
    private Connection connection;
    private DAOFactory daoFactory = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesPlugins = null;
    private ServiceManagerProperties daoFactoryServiceManagerPropertiesUtils = null;
    private Logger daoFactoryLogger = null;
    private IServiceManager serviceManagerPluginsBase;
    private org.openspcoop2.core.commons.search.dao.IServiceManager serviceManagerUtils;
    private boolean debug;

    public BasicServiceLibraryReader(Connection connection, DAOFactory daoFactory, ServiceManagerProperties daoFactoryServiceManagerPropertiesPlugins, ServiceManagerProperties daoFactoryServiceManagerPropertiesUtils, Logger daoFactoryLogger, boolean debug) {
        this.connection = connection;
        this.daoFactory = daoFactory;
        this.daoFactoryServiceManagerPropertiesPlugins = daoFactoryServiceManagerPropertiesPlugins;
        this.daoFactoryServiceManagerPropertiesUtils = daoFactoryServiceManagerPropertiesUtils;
        this.daoFactoryLogger = daoFactoryLogger;
        this.debug = debug;
    }

    public BasicServiceLibraryReader(IServiceManager jdbcServiceManagerPluginsBase, org.openspcoop2.core.commons.search.dao.IServiceManager jdbcServiceManagerUtils, boolean debug) {
        this.serviceManagerPluginsBase = jdbcServiceManagerPluginsBase;
        this.serviceManagerUtils = jdbcServiceManagerUtils;
        this.debug = debug;
    }

    public BasicServiceLibrary read(IDServizio idServizio, Logger log) throws Exception {
        String azione = idServizio.getAzione();
        AccordoServizioParteSpecifica s = null;
        try {
            s = this.getAccordoServizioParteSpecifica(idServizio);
            if (s == null) {
                throw new NotFoundException("Null instance return");
            }
        }
        catch (NotFoundException notFound) {
            if (this.debug) {
                log.debug("Non \u00e8 stata trovata una parte specifica con id [" + idServizio.toString() + "]: " + notFound.getMessage(), (Throwable)notFound);
            }
            return null;
        }
        String portType = null;
        portType = s.getPortType() != null && !"".equals(s.getPortType()) ? s.getPortType() : idServizio.getNome();
        if (s.getIdAccordoServizioParteComune().getIdSoggetto() == null) {
            log.warn("Il servizio indicato [" + idServizio + "] implementa un accordo che non contiene un soggetto referente. Opzione non supportata");
            return null;
        }
        IDSoggetto soggettoReferente = new IDSoggetto(s.getIdAccordoServizioParteComune().getIdSoggetto().getTipo(), s.getIdAccordoServizioParteComune().getIdSoggetto().getNome());
        IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(s.getIdAccordoServizioParteComune().getNome(), soggettoReferente, s.getIdAccordoServizioParteComune().getVersione());
        BasicServiceLibrary basicServiceLibrary = this.read(idAccordo, portType, azione, log);
        if (basicServiceLibrary != null) {
            basicServiceLibrary.setIdServizio(idServizio);
            basicServiceLibrary.setAccordoServizioParteSpecifica(s);
        }
        return basicServiceLibrary;
    }

    public boolean existsAlmostOneBasicServiceLibrary(Logger log) throws Exception {
        return this._existsAlmostOneBasicServiceLibrary();
    }

    public BasicServiceLibrary read(IDAccordo idAccordo, String portType, String azione, Logger log) throws Exception {
        ConfigurazioneServizioAzione serviceActionLibrary;
        ConfigurazioneServizio serviceLibrary;
        BasicServiceLibrary basicServiceLibrary;
        block11: {
            basicServiceLibrary = new BasicServiceLibrary();
            basicServiceLibrary.setIdAccordoServizioParteComune(idAccordo);
            basicServiceLibrary.setPortType(portType);
            basicServiceLibrary.setAzione(azione);
            serviceLibrary = null;
            try {
                serviceLibrary = this.getServiceLibrary(idAccordo, portType);
                if (serviceLibrary == null) {
                    throw new NotFoundException("Null instance return");
                }
            }
            catch (NotFoundException notFound) {
                if (this.debug) {
                    log.debug("NON e' stata configurata una libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]");
                }
                return null;
            }
            basicServiceLibrary.setServiceLibrary(serviceLibrary);
            serviceActionLibrary = null;
            if (azione != null) {
                try {
                    serviceActionLibrary = this.getServiceActionLibrary(serviceLibrary, azione);
                    if (serviceActionLibrary == null) {
                        throw new NotFoundException("Null instance return");
                    }
                }
                catch (NotFoundException notFound) {
                    if (!this.debug) break block11;
                    log.debug("Non risulta configurata configurata l'azione specifica [" + azione + "] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]", (Throwable)notFound);
                }
            }
        }
        basicServiceLibrary.setServiceActionLibrary(serviceActionLibrary);
        ConfigurazioneServizioAzione serviceActionAllLibrary = null;
        try {
            serviceActionAllLibrary = this.getServiceActionLibrary(serviceLibrary, "*");
            if (serviceActionAllLibrary == null) {
                throw new NotFoundException("Null instance return");
            }
        }
        catch (NotFoundException notFound) {
            String errorMsg = "Non risulta configurata configurata l'azione specifica [*] per la libreria di servizio [" + portType + "] dell'accordo [" + idAccordo.toString() + "]";
            log.error(errorMsg, (Throwable)notFound);
            throw new NotFoundException(errorMsg, (Throwable)notFound);
        }
        basicServiceLibrary.setServiceActionAllLibrary(serviceActionAllLibrary);
        return basicServiceLibrary;
    }

    private AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        boolean autoCommit = true;
        org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager = this.serviceManagerUtils;
        if (serviceManager == null && (serviceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesUtils, this.daoFactoryLogger)) instanceof org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager) {
            ((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IAccordoServizioParteSpecificaServiceSearch search = serviceManager.getAccordoServizioParteSpecificaServiceSearch();
        IdAccordoServizioParteSpecifica idAS = new IdAccordoServizioParteSpecifica();
        IdSoggetto idErogatore = new IdSoggetto();
        idErogatore.setTipo(idServizio.getSoggettoErogatore().getTipo());
        idErogatore.setNome(idServizio.getSoggettoErogatore().getNome());
        idAS.setIdErogatore(idErogatore);
        idAS.setTipo(idServizio.getTipo());
        idAS.setNome(idServizio.getNome());
        idAS.setVersione(idServizio.getVersione());
        return (AccordoServizioParteSpecifica)search.get((Object)idAS);
    }

    private boolean _existsAlmostOneBasicServiceLibrary() throws DAOFactoryException, ServiceException, NotImplementedException {
        IConfigurazioneServizioServiceSearch search;
        NonNegativeNumber nn;
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsBase;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPlugins, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        return (nn = (search = serviceManager.getConfigurazioneServizioServiceSearch()).count(search.newExpression())) != null && nn.longValue() > 0L;
    }

    private ConfigurazioneServizio getServiceLibrary(IDAccordo idAccordo, String portType) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsBase;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPlugins, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IConfigurazioneServizioServiceSearch search = serviceManager.getConfigurazioneServizioServiceSearch();
        IdConfigurazioneServizio idConfigurazioneServizio = new IdConfigurazioneServizio();
        idConfigurazioneServizio.setAccordo(idAccordo.getNome());
        if (idAccordo.getSoggettoReferente() != null) {
            idConfigurazioneServizio.setTipoSoggettoReferente(idAccordo.getSoggettoReferente().getTipo());
            idConfigurazioneServizio.setNomeSoggettoReferente(idAccordo.getSoggettoReferente().getNome());
        }
        idConfigurazioneServizio.setServizio(portType);
        if (idAccordo.getVersione() != null) {
            idConfigurazioneServizio.setVersione(idAccordo.getVersione());
        }
        return (ConfigurazioneServizio)search.get((Object)idConfigurazioneServizio);
    }

    private ConfigurazioneServizioAzione getServiceActionLibrary(ConfigurazioneServizio serviceLibrary, String azione) throws DAOFactoryException, ServiceException, NotImplementedException, NotFoundException, MultipleResultException {
        boolean autoCommit = true;
        IServiceManager serviceManager = this.serviceManagerPluginsBase;
        if (serviceManager == null && (serviceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.connection, autoCommit, this.daoFactoryServiceManagerPropertiesPlugins, this.daoFactoryLogger)) instanceof JDBCServiceManager) {
            ((JDBCServiceManager)serviceManager).getJdbcProperties().setShowSql(this.debug);
        }
        IConfigurazioneServizioServiceSearch serviceSearch = serviceManager.getConfigurazioneServizioServiceSearch();
        IdConfigurazioneServizio idConfigurazioneServizio = (IdConfigurazioneServizio)serviceSearch.convertToId((Object)serviceLibrary);
        IConfigurazioneServizioAzioneServiceSearch search = serviceManager.getConfigurazioneServizioAzioneServiceSearch();
        IdConfigurazioneServizioAzione idConfigurazioneServizioAzione = new IdConfigurazioneServizioAzione();
        idConfigurazioneServizioAzione.setIdConfigurazioneServizio(idConfigurazioneServizio);
        idConfigurazioneServizioAzione.setAzione(azione);
        return (ConfigurazioneServizioAzione)search.get((Object)idConfigurazioneServizioAzione);
    }
}

