/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.ricerche.ConfigurazioneRicerca;

public class SearchServiceLibrary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BasicServiceLibrary basicServiceLibrary;
    private List<ConfigurazioneRicerca> searchActionLibrary;
    private List<ConfigurazioneRicerca> searchActionAllLibrary;

    public BasicServiceLibrary getBasicServiceLibrary() {
        return this.basicServiceLibrary;
    }

    public void setBasicServiceLibrary(BasicServiceLibrary basicServiceLibrary) {
        this.basicServiceLibrary = basicServiceLibrary;
    }

    public List<ConfigurazioneRicerca> getSearchActionLibrary() {
        return this.searchActionLibrary;
    }

    public void setSearchActionLibrary(List<ConfigurazioneRicerca> searchActionLibrary) {
        this.searchActionLibrary = searchActionLibrary;
    }

    public List<ConfigurazioneRicerca> getSearchActionAllLibrary() {
        return this.searchActionAllLibrary;
    }

    public void setSearchActionAllLibrary(List<ConfigurazioneRicerca> searchActionAllLibrary) {
        this.searchActionAllLibrary = searchActionAllLibrary;
    }

    public String toString() {
        int i;
        StringBuilder bf = new StringBuilder();
        if (this.basicServiceLibrary == null) {
            bf.append("BasicServiceLibrary: notDefined");
            bf.append("\n");
        } else {
            bf.append(this.basicServiceLibrary.toString());
        }
        if (this.getSearchActionLibrary() != null) {
            for (i = 0; i < this.getSearchActionLibrary().size(); ++i) {
                bf.append("SearchActionLibrary[" + i + "]: ");
                bf.append("id[").append(this.getSearchActionLibrary().get(i).getIdConfigurazioneRicerca()).append("] plugin.className[").append(this.getSearchActionLibrary().get(i).getPlugin().getClassName()).append("] plugin.description[").append(this.getSearchActionLibrary().get(i).getPlugin().getDescrizione()).append("] plugin.label[").append(this.getSearchActionLibrary().get(i).getPlugin().getLabel()).append("] label[").append(this.getSearchActionLibrary().get(i).getLabel()).append("] enabled[").append(this.getSearchActionLibrary().get(i).isEnabled()).append("]");
                bf.append("\n");
            }
        } else {
            bf.append("SearchActionLibrary: ");
            bf.append("-");
        }
        bf.append("\n");
        if (this.getSearchActionAllLibrary() != null) {
            for (i = 0; i < this.getSearchActionAllLibrary().size(); ++i) {
                bf.append("SearchActionAllLibrary[" + i + "]: ");
                bf.append("id[").append(this.getSearchActionAllLibrary().get(i).getIdConfigurazioneRicerca()).append("] plugin.className[").append(this.getSearchActionAllLibrary().get(i).getPlugin().getClassName()).append("] plugin.description[").append(this.getSearchActionAllLibrary().get(i).getPlugin().getDescrizione()).append("] plugin.label[").append(this.getSearchActionAllLibrary().get(i).getPlugin().getLabel()).append("] label[").append(this.getSearchActionAllLibrary().get(i).getLabel()).append("] enabled[").append(this.getSearchActionAllLibrary().get(i).isEnabled()).append("]");
                bf.append("\n");
            }
        } else {
            bf.append("SearchActionAllLibrary: ");
            bf.append("-");
        }
        bf.append("\n");
        return bf.toString();
    }

    public List<ConfigurazioneRicerca> mergeServiceActionSearchLibrary(boolean onlyEnabled, boolean orderByLabel) throws Exception {
        HashMap<String, ConfigurazioneRicerca> plugins = new HashMap<String, ConfigurazioneRicerca>();
        if (this.searchActionLibrary != null && this.searchActionLibrary.size() > 0) {
            for (ConfigurazioneRicerca configurazioneRicerca : this.searchActionLibrary) {
                if (onlyEnabled && !configurazioneRicerca.isEnabled()) continue;
                plugins.put(configurazioneRicerca.getPlugin().getClassName(), configurazioneRicerca);
            }
        }
        if (this.searchActionAllLibrary != null && this.searchActionAllLibrary.size() > 0) {
            for (ConfigurazioneRicerca configurazioneRicerca : this.searchActionAllLibrary) {
                String idRisorsa = configurazioneRicerca.getPlugin().getClassName();
                if (plugins.containsKey(idRisorsa) || onlyEnabled && !configurazioneRicerca.isEnabled()) continue;
                plugins.put(configurazioneRicerca.getPlugin().getClassName(), configurazioneRicerca);
            }
        }
        ArrayList<ConfigurazioneRicerca> list = new ArrayList<ConfigurazioneRicerca>();
        if (orderByLabel) {
            ArrayList<CallSite> sortedKey = new ArrayList<CallSite>();
            HashMap<CallSite, ConfigurazioneRicerca> mapLabelToCorrelazioneRicerca = new HashMap<CallSite, ConfigurazioneRicerca>();
            int count = 0;
            for (String string : plugins.keySet()) {
                ConfigurazioneRicerca cr = (ConfigurazioneRicerca)plugins.get(string);
                String labelKey = cr.getLabel() + count;
                sortedKey.add((CallSite)((Object)labelKey));
                mapLabelToCorrelazioneRicerca.put((CallSite)((Object)labelKey), cr);
                ++count;
            }
            Collections.sort(sortedKey);
            for (String string : sortedKey) {
                list.add((ConfigurazioneRicerca)mapLabelToCorrelazioneRicerca.get(string));
            }
        } else {
            list.addAll(plugins.values());
        }
        return list;
    }
}

