/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.config;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.config.statistiche.InfoPlugin;
import org.openspcoop2.monitor.engine.statistic.StatisticByResource;
import org.openspcoop2.monitor.engine.statistic.StatisticByState;

public class StatisticsServiceLibrary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BasicServiceLibrary basicServiceLibrary;
    private List<ConfigurazioneStatistica> statisticsActionLibrary;
    private List<ConfigurazioneStatistica> statisticsActionAllLibrary;
    private boolean pluginStatiTransazioniEnabled = false;
    private List<String> pluginRisorseTransazioni = new ArrayList<String>();

    public BasicServiceLibrary getBasicServiceLibrary() {
        return this.basicServiceLibrary;
    }

    public void setBasicServiceLibrary(BasicServiceLibrary basicServiceLibrary) {
        this.basicServiceLibrary = basicServiceLibrary;
    }

    public List<ConfigurazioneStatistica> getStatisticsActionLibrary() {
        return this.statisticsActionLibrary;
    }

    public void setStatisticsActionLibrary(List<ConfigurazioneStatistica> searchActionLibrary) {
        this.statisticsActionLibrary = searchActionLibrary;
    }

    public List<ConfigurazioneStatistica> getStatisticsActionAllLibrary() {
        return this.statisticsActionAllLibrary;
    }

    public void setStatisticsActionAllLibrary(List<ConfigurazioneStatistica> searchActionAllLibrary) {
        this.statisticsActionAllLibrary = searchActionAllLibrary;
    }

    public boolean isPluginStatiTransazioniEnabled() {
        return this.pluginStatiTransazioniEnabled;
    }

    public void setPluginStatiTransazioniEnabled(boolean pluginStatiTransazioniEnabled) {
        this.pluginStatiTransazioniEnabled = pluginStatiTransazioniEnabled;
    }

    public List<String> getPluginRisorseTransazioni() {
        return this.pluginRisorseTransazioni;
    }

    public void setPluginRisorseTransazioni(List<String> pluginRisorseTransazioni) {
        this.pluginRisorseTransazioni = pluginRisorseTransazioni;
    }

    public String toString() {
        int i;
        StringBuilder bf = new StringBuilder();
        if (this.basicServiceLibrary == null) {
            bf.append("BasicServiceLibrary: notDefined");
            bf.append("\n");
        } else {
            bf.append(this.basicServiceLibrary.toString());
        }
        if (this.getStatisticsActionLibrary() != null) {
            for (i = 0; i < this.getStatisticsActionLibrary().size(); ++i) {
                bf.append("StatisticsActionLibrary[" + i + "]: ");
                bf.append("id[").append(this.getStatisticsActionLibrary().get(i).getIdConfigurazioneStatistica()).append("] plugin.className[").append(this.getStatisticsActionLibrary().get(i).getPlugin().getClassName()).append("] plugin.description[").append(this.getStatisticsActionLibrary().get(i).getPlugin().getDescrizione()).append("] plugin.label[").append(this.getStatisticsActionLibrary().get(i).getPlugin().getLabel()).append("] label[").append(this.getStatisticsActionLibrary().get(i).getLabel()).append("] enabled[").append(this.getStatisticsActionLibrary().get(i).isEnabled()).append("]");
                bf.append("\n");
            }
        } else {
            bf.append("StatisticsActionLibrary: ");
            bf.append("-");
        }
        bf.append("\n");
        if (this.getStatisticsActionAllLibrary() != null) {
            for (i = 0; i < this.getStatisticsActionAllLibrary().size(); ++i) {
                bf.append("StatisticsActionAllLibrary[" + i + "]: ");
                bf.append("id[").append(this.getStatisticsActionAllLibrary().get(i).getIdConfigurazioneStatistica()).append("] plugin.className[").append(this.getStatisticsActionAllLibrary().get(i).getPlugin().getClassName()).append("] plugin.description[").append(this.getStatisticsActionAllLibrary().get(i).getPlugin().getDescrizione()).append("] plugin.label[").append(this.getStatisticsActionAllLibrary().get(i).getPlugin().getLabel()).append("] label[").append(this.getStatisticsActionAllLibrary().get(i).getLabel()).append("] enabled[").append(this.getStatisticsActionAllLibrary().get(i).isEnabled()).append("]");
                bf.append("\n");
            }
        } else {
            bf.append("StatisticsActionAllLibrary: ");
            bf.append("-");
        }
        bf.append("\n");
        return bf.toString();
    }

    public List<ConfigurazioneStatistica> mergeServiceActionSearchLibrary(boolean onlyEnabled, boolean orderByLabel) throws Exception {
        Iterator<ConfigurazioneStatistica> conf;
        HashMap<String, Object> plugins = new HashMap<String, Object>();
        if (this.pluginStatiTransazioniEnabled) {
            conf = this.buildNewConfigurazioneStatistica("__StatisticByState__", "Stati", "Informazione Statistica sugli Stati associati alle Transazioni", StatisticByState.class);
            plugins.put(((ConfigurazioneStatistica)((Object)conf)).getPlugin().getClassName(), conf);
        }
        if (this.pluginRisorseTransazioni != null && this.pluginRisorseTransazioni.size() > 0) {
            conf = this.buildNewConfigurazioneStatistica("__StatisticByResource__", "Risorse", "Informazioni Statistiche sulle Risorse associate alle Transazioni", StatisticByResource.class);
            plugins.put(((ConfigurazioneStatistica)((Object)conf)).getPlugin().getClassName(), conf);
        }
        if (this.statisticsActionLibrary != null && this.statisticsActionLibrary.size() > 0) {
            for (ConfigurazioneStatistica configurazioneStatistica : this.statisticsActionLibrary) {
                if (onlyEnabled && !configurazioneStatistica.isEnabled()) continue;
                plugins.put(configurazioneStatistica.getPlugin().getClassName(), configurazioneStatistica);
            }
        }
        if (this.statisticsActionAllLibrary != null && this.statisticsActionAllLibrary.size() > 0) {
            for (ConfigurazioneStatistica configurazioneStatistica : this.statisticsActionAllLibrary) {
                String idRisorsa = configurazioneStatistica.getPlugin().getClassName();
                if (plugins.containsKey(idRisorsa) || onlyEnabled && !configurazioneStatistica.isEnabled()) continue;
                plugins.put(configurazioneStatistica.getPlugin().getClassName(), configurazioneStatistica);
            }
        }
        ArrayList<ConfigurazioneStatistica> list = new ArrayList<ConfigurazioneStatistica>();
        if (orderByLabel) {
            ArrayList<CallSite> sortedKey = new ArrayList<CallSite>();
            HashMap<CallSite, ConfigurazioneStatistica> mapLabelToCorrelazioneStatistica = new HashMap<CallSite, ConfigurazioneStatistica>();
            int count = 0;
            for (String string : plugins.keySet()) {
                ConfigurazioneStatistica cs = (ConfigurazioneStatistica)plugins.get(string);
                String labelKey = cs.getLabel() + count;
                sortedKey.add((CallSite)((Object)labelKey));
                mapLabelToCorrelazioneStatistica.put((CallSite)((Object)labelKey), cs);
                ++count;
            }
            Collections.sort(sortedKey);
            for (String string : sortedKey) {
                list.add((ConfigurazioneStatistica)mapLabelToCorrelazioneStatistica.get(string));
            }
        } else {
            list.addAll(plugins.values());
        }
        return list;
    }

    private ConfigurazioneStatistica buildNewConfigurazioneStatistica(String id, String label, String descrizione, Class<?> classPlugin) {
        ConfigurazioneStatistica conf = new ConfigurazioneStatistica();
        conf.setEnabled(true);
        conf.setIdConfigurazioneStatistica(id);
        conf.setLabel(label);
        InfoPlugin infoPlugin = new InfoPlugin();
        infoPlugin.setClassName(classPlugin.getName());
        infoPlugin.setDescrizione(descrizione);
        infoPlugin.setLabel(label);
        infoPlugin.setTipo(TipoPlugin.STATISTICA.getValue());
        conf.setPlugin(infoPlugin);
        return conf;
    }
}

