/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import java.util.Map;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.engine.dynamic.IDynamicValidator;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.exceptions.ValidationException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.ISearchArguments;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;

public class BasicValidator
implements IDynamicValidator {
    private static Logger log = LoggerWrapperFactory.getLogger(BasicValidator.class);
    private String tipoPlugin;
    private String tipo;
    private String className;

    protected BasicValidator(String tipoPlugin, String tipo, String className) {
        this.tipoPlugin = tipoPlugin;
        this.tipo = tipo;
        this.className = className;
    }

    @Override
    public void validate(Context context) throws ValidationException {
        try {
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(this.tipoPlugin, this.tipo, this.className, log);
            Object obj = bl.newInstance();
            if (!(obj instanceof ISearchArguments)) {
                String iface = ISearchArguments.class.getName();
                throw new Exception("La classe [" + this.className + "] non implementa l'interfaccia [" + iface + "]");
            }
            ((ISearchArguments)obj).validate(context);
            Map mapParams = context.getParameters();
            if (mapParams != null && mapParams.size() > 0) {
                for (String idParameter : mapParams.keySet()) {
                    Object o;
                    Parameter p = (Parameter)mapParams.get(idParameter);
                    if (!p.getRendering().isRequired() || (o = p.getValue()) != null) continue;
                    throw new ValidationException("Non \u00e8 stato fornito un valore per il parametro '" + idParameter + "'");
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Impossibile caricare il plugin. La classe indicata [" + this.className + "] non esiste.", (Throwable)cnfe);
            throw new ValidationException("Impossibile caricare il plugin. La classe indicata [" + this.className + "] non esiste.");
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ValidationException(e.getMessage());
        }
    }
}

