/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.dynamic;

import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.monitor.engine.dynamic.BasicFilter;
import org.openspcoop2.monitor.engine.dynamic.BasicLoader;
import org.openspcoop2.monitor.engine.dynamic.BasicValidator;
import org.openspcoop2.monitor.engine.dynamic.IDynamicFilter;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.engine.dynamic.IDynamicValidator;
import org.openspcoop2.monitor.engine.dynamic.PluginLoader;
import org.openspcoop2.monitor.sdk.exceptions.SearchException;
import org.slf4j.Logger;

public class DynamicFactory {
    private static DynamicFactory basicLoaderFactory;
    private PluginLoader pluginLoader = PluginLoader.getInstance();

    private static synchronized void initialize() {
        if (basicLoaderFactory == null) {
            basicLoaderFactory = new DynamicFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicFactory getInstance() {
        if (basicLoaderFactory != null) return basicLoaderFactory;
        Class<DynamicFactory> clazz = DynamicFactory.class;
        synchronized (DynamicFactory.class) {
            DynamicFactory.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return basicLoaderFactory;
        }
    }

    private DynamicFactory() {
    }

    public IDynamicLoader newDynamicLoader(TipoPlugin tipoPlugin, String tipo, String className, Logger log) throws SearchException {
        return this.newDynamicLoader(tipoPlugin.getValue(), tipo, className, log);
    }

    public IDynamicLoader newDynamicLoader(String tipoPlugin, String tipo, String className, Logger log) throws SearchException {
        try {
            return new BasicLoader(tipoPlugin, tipo, className, this.pluginLoader.getDynamicClass(className, tipoPlugin, tipo), log);
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage(), (Throwable)e);
        }
    }

    public IDynamicFilter newDynamicFilter(TipoPlugin tipoPlugin, String tipo, String className, Logger log) {
        return this.newDynamicFilter(tipoPlugin.getValue(), tipo, className, log);
    }

    public IDynamicFilter newDynamicFilter(String tipoPlugin, String tipo, String className, Logger log) {
        if (log != null) {
            // empty if block
        }
        return new BasicFilter(tipoPlugin, tipo, className);
    }

    public IDynamicValidator newDynamicValidator(TipoPlugin tipoPlugin, String tipo, String className, Logger log) {
        return this.newDynamicValidator(tipoPlugin.getValue(), tipo, className, log);
    }

    public IDynamicValidator newDynamicValidator(String tipoPlugin, String tipo, String className, Logger log) {
        if (log != null) {
            // empty if block
        }
        return new BasicValidator(tipoPlugin, tipo, className);
    }
}

