/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.fs_recovery;

import java.io.File;
import java.sql.Connection;
import org.openspcoop2.monitor.engine.fs_recovery.FSRecoveryFileUtils;
import org.openspcoop2.monitor.engine.fs_recovery.LastModifiedFileFilter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public abstract class AbstractFSRecovery {
    protected Logger log;
    protected boolean debug;
    protected File directory;
    protected File directoryDLQ;
    protected int tentativi;
    protected long msAttesaProcessingFile;
    protected long maxFileProcessed;

    protected AbstractFSRecovery(Logger log, boolean debug, File directory, File directoryDLQ, int tentativi, long msAttesaProcessingFile, long maxFileProcessed) {
        this.log = log;
        this.debug = debug;
        this.directory = directory;
        this.directoryDLQ = directoryDLQ;
        this.tentativi = tentativi;
        this.msAttesaProcessingFile = msAttesaProcessingFile;
        this.maxFileProcessed = maxFileProcessed;
    }

    public abstract void insertObject(File var1, Connection var2) throws UtilsException, UtilsMultiException;

    protected void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    protected void logInfo(String msg) {
        if (this.log != null) {
            this.log.info(msg);
        }
    }

    protected void logWarn(String msg) {
        if (this.log != null) {
            this.log.warn(msg);
        }
    }

    protected void logWarn(String msg, Exception e) {
        if (this.log != null) {
            this.log.warn(msg, (Throwable)e);
        }
    }

    protected void logError(String msg, Exception e) {
        if (this.log != null) {
            this.log.error(msg, (Throwable)e);
        }
    }

    public long process(Connection connection) {
        long count = 0L;
        try {
            File[] filesToProcess = this.directory.listFiles(new LastModifiedFileFilter(this.msAttesaProcessingFile));
            if (filesToProcess != null && filesToProcess.length > 0) {
                this.logInfo("Processamento di [" + filesToProcess.length + "] file");
                int countProcessatiCorrettamente = 0;
                int countProcessatiConErrore = 0;
                for (File file : filesToProcess) {
                    if (this.process(connection, file)) {
                        ++countProcessatiCorrettamente;
                    } else {
                        ++countProcessatiConErrore;
                    }
                    if (this.maxFileProcessed <= 0L || ++count < this.maxFileProcessed) continue;
                    this.logInfo("Processamento di [" + filesToProcess.length + "] file terminato; raggiunto max numero di file processabili: " + this.maxFileProcessed + ". [" + countProcessatiCorrettamente + "] file processati correttamente, [" + countProcessatiConErrore + "] con errore");
                    return count;
                }
                this.logInfo("Processamento di [" + filesToProcess.length + "] file completato. [" + countProcessatiCorrettamente + "] file processati correttamente, [" + countProcessatiConErrore + "] con errore");
            } else {
                this.logInfo("Nessun file da processare");
            }
            return count;
        }
        catch (Exception e) {
            this.logError("Errore durante Il Recovery: " + e.getMessage(), e);
            return -1L;
        }
    }

    private boolean process(Connection connection, File file) throws UtilsException {
        try {
            if (this.debug) {
                this.logInfo("Inserimento del file [" + file.getName() + "] ...");
            }
            this.insertObject(file, connection);
            FileSystemUtilities.deleteFile((File)file);
            if (this.debug) {
                this.logInfo("Inserimento del file [" + file.getName() + "] completato con successo");
            }
            return true;
        }
        catch (Exception e) {
            this.error(file, e);
            return false;
        }
    }

    private void error(File file, Exception e) throws UtilsException {
        int tentativiPerFile;
        if (this.debug) {
            this.logWarn("Errore durante l'inserimento del file [" + file.getName() + "] rinomino il file:" + e.getMessage(), e);
        }
        if ((tentativiPerFile = FSRecoveryFileUtils.getTentativiFromFilename(file.getName())) < this.tentativi) {
            File newFile = new File(this.directory, FSRecoveryFileUtils.getNewFileNameFromFilename(file.getName()));
            if (!file.renameTo(newFile)) {
                // empty if block
            }
            if (this.debug) {
                this.logWarn("File [" + file.getName() + "] rinominato in [" + newFile.getName() + "]");
            }
        } else {
            String newFileName = FSRecoveryFileUtils.renameToDLQ(this.directoryDLQ, file, e, this.log);
            if (this.debug) {
                this.logWarn("File [" + file.getName() + "] rinominato in [" + newFileName + "]");
            }
        }
    }
}

