/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.dao.DAOFactoryProperties;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.statistiche.Statistica;
import org.openspcoop2.core.statistiche.StatisticaContenuti;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.statistiche.constants.TipoPorta;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoService;
import org.openspcoop2.core.statistiche.dao.IStatisticaInfoServiceSearch;
import org.openspcoop2.core.statistiche.model.StatisticaModel;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.dao.ITransazioneServiceSearch;
import org.openspcoop2.generic_project.beans.ConstantField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.IServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.IServiceWithoutId;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.engine.condition.FilterImpl;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.BasicServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.StatisticsServiceLibrary;
import org.openspcoop2.monitor.engine.config.StatisticsServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IConfigurazioneStatisticaService;
import org.openspcoop2.monitor.engine.constants.Costanti;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.engine.statistic.AliasFilter;
import org.openspcoop2.monitor.engine.statistic.IStatisticsEngine;
import org.openspcoop2.monitor.engine.statistic.RisorsaAggregata;
import org.openspcoop2.monitor.engine.statistic.RisorsaSemplice;
import org.openspcoop2.monitor.engine.statistic.StatisticBean;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsEngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsForceIndexConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsGroupByConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsInfoUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsUtils;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.monitor.sdk.exceptions.StatisticException;
import org.openspcoop2.monitor.sdk.plugins.IStatisticProcessing;
import org.openspcoop2.monitor.sdk.statistic.StatisticResourceFilter;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.sql.Case;
import org.openspcoop2.utils.sql.CastColumnType;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public abstract class AbstractStatistiche
implements IStatisticsEngine {
    private static final String PREFIX_GENERAZIONE_STATISTICA = "Generazione statistiche [";
    private static final String PREFIX_INVOCAZIONE = "---- Invocazione [";
    private static final String PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA = "Valori query (ms) tr.data_ingresso_richiesta>[";
    private static final String LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA = "] AND tr.data_ingresso_richiesta<=[";
    private static final String LOG_INTERVALLO_DATE = "] Intervallo date: [";
    private static final String LOG_SUFFIX_IN_CORSO = ") ...";
    private static final String LOG_SUFFIX_TERMINATA = ") terminata";
    private static final String LOG_RECORD = "\nRecord: ";
    private static final String LOG_SEPARATORE = ") e (";
    protected Logger logger = LoggerWrapperFactory.getLogger(AbstractStatistiche.class);
    protected boolean debug = false;
    protected boolean useUnionForLatency = true;
    protected boolean generazioneStatisticheCustom = false;
    protected boolean analisiTransazioniCustom = false;
    protected long waitMsBeforeNextInterval = 0L;
    protected boolean waitStatiInConsegna = false;
    protected boolean gestioneUltimoIntervallo = false;
    protected org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM = null;
    protected IServiceWithoutId<?> statisticaServiceDAO = null;
    protected IServiceSearchWithoutId<?> statisticaServiceSearchDAO = null;
    protected StatisticaModel model = null;
    private IStatisticaInfoServiceSearch statisticaInfoSearchDAO = null;
    private IStatisticaInfoService statisticaInfoDAO = null;
    private ITransazioneServiceSearch transazioneSearchDAO = null;
    private org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM = null;
    private IServiceManager pluginsBaseSM = null;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM = null;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM;
    private IConfigurazioneStatisticaService confStatisticaDAO = null;
    private TipiDatabase databaseType;
    private StatisticsForceIndexConfig forceIndexConfig;
    private StatisticsGroupByConfig groupByConfig;
    private static final String SUFFIX_NON_INIZIALIZZATO = "] non inizializzato";
    private boolean initialized = false;

    private void logDebug(String msg) {
        if (this.logger != null) {
            this.logger.debug(msg);
        }
    }

    private void logDebug(String msg, Throwable e) {
        if (this.logger != null) {
            this.logger.debug(msg, e);
        }
    }

    private void logError(String msg, Throwable e) {
        if (this.logger != null) {
            this.logger.error(msg, e);
        }
    }

    AbstractStatistiche() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        if (config.getLogCore() != null) {
            this.logger = config.getLogCore();
        }
        this.debug = config.isDebug();
        this.useUnionForLatency = config.isUseUnionForLatency();
        this.generazioneStatisticheCustom = config.isGenerazioneStatisticheCustom();
        this.analisiTransazioniCustom = config.isAnalisiTransazioniCustom();
        this.waitMsBeforeNextInterval = config.getWaitMsBeforeNextInterval();
        this.waitStatiInConsegna = config.isWaitStatiInConsegna();
        this.gestioneUltimoIntervallo = this.isGestioneUltimoIntervallo(config);
        try {
            if (statisticheSM == null) {
                throw new ServiceException("StatisticheServiceManager [" + org.openspcoop2.core.statistiche.dao.IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
            }
            if (transazioniSM == null) {
                throw new ServiceException("TransazioniServiceManager [" + org.openspcoop2.core.transazioni.dao.IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
            }
            this.statisticheSM = statisticheSM;
            this.statisticaInfoSearchDAO = this.statisticheSM.getStatisticaInfoServiceSearch();
            this.statisticaInfoDAO = this.statisticheSM.getStatisticaInfoService();
            this.databaseType = DAOFactoryProperties.getInstance((Logger)this.logger).getTipoDatabaseEnum((IProjectInfo)ProjectInfo.getInstance());
            this.transazioneSearchDAO = transazioniSM.getTransazioneServiceSearch();
            if (this.generazioneStatisticheCustom) {
                if (pluginsStatisticheSM == null) {
                    throw new ServiceException("PluginStatisticheServiceManager [" + org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
                }
                this.pluginsStatisticheSM = pluginsStatisticheSM;
                this.confStatisticaDAO = this.pluginsStatisticheSM.getConfigurazioneStatisticaService();
                if (utilsSM == null) {
                    throw new ServiceException("UtilsServiceManager [" + org.openspcoop2.core.commons.search.dao.IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
                }
                this.utilsSM = utilsSM;
                if (pluginsBaseSM == null) {
                    throw new ServiceException("PluginBaseServiceManager [" + IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
                }
                this.pluginsBaseSM = pluginsBaseSM;
                if (this.analisiTransazioniCustom) {
                    if (pluginsTransazioniSM == null) {
                        throw new ServiceException("PluginTransazioniServiceManager [" + org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager.class.getName() + SUFFIX_NON_INIZIALIZZATO);
                    }
                    this.pluginsTransazioniSM = pluginsTransazioniSM;
                }
            }
            this.forceIndexConfig = config.getForceIndexConfig();
            this.groupByConfig = config.getGroupByConfig();
            this.initialized = true;
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected TipiDatabase getDatabaseType() {
        return this.databaseType;
    }

    public void printDate(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        this.printCalendar(c);
    }

    public void printCalendar(Calendar c) {
        StringBuilder bf = new StringBuilder();
        bf.append("DATA [" + c.getTime().toString() + "]");
        bf.append(" DATA in millisecondi: " + c.getTime().getTime());
        bf.append(" YEAR:" + c.get(1));
        bf.append(" MONTH:" + (c.get(2) + 1));
        bf.append(" DAY_OF_MONTH:" + c.get(5));
        bf.append(" HOUR_OF_DAY:" + c.get(11));
        bf.append(" MINUTE:" + c.get(12));
        bf.append(" SECOND:" + c.get(13));
        bf.append(" MILLISECOND:" + c.get(14));
        this.logDebug(bf.toString());
    }

    public abstract Date truncDate(Date var1, boolean var2);

    public abstract Date incrementDate(Date var1, boolean var2);

    public abstract Date decrementDate(Date var1, boolean var2);

    protected abstract boolean isGestioneUltimoIntervallo(StatisticsConfig var1);

    public Date decrementDate1Millisecond(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.add(14, -1);
        return cTmp.getTime();
    }

    public abstract String getIntervalloStatistica(Date var1, boolean var2);

    private String getIntervalloStatistica(Date date) {
        Date d = this.incrementDate(date, false);
        return this.getIntervalloStatistica(d, false);
    }

    public abstract TipoIntervalloStatistico getTipoStatistiche();

    public abstract void callStatisticPluginMethod(IStatisticProcessing var1, StatisticBean var2) throws StatisticException;

    public abstract String getStatisticPluginMethodName() throws StatisticException;

    @Override
    public void generate() throws StatisticsEngineException {
        if (!this.initialized) {
            throw new StatisticsEngineException("Inizializzazione fallita (verificare errori precedenti)");
        }
        try {
            if (this.debug) {
                this.logDebug("********************************************* " + this.getTipoStatistiche() + " *******************************************************");
            }
            Date dataUltimaGenerazioneStatistiche = StatisticsInfoUtils.readDataUltimaGenerazioneStatistiche(this.statisticaInfoSearchDAO, this.getTipoStatistiche(), this.logger);
            dataUltimaGenerazioneStatistiche = this.truncDate(dataUltimaGenerazioneStatistiche, false);
            dataUltimaGenerazioneStatistiche = this.decrementDate1Millisecond(dataUltimaGenerazioneStatistiche);
            Date dataAvvioBatch = DateManager.getDate();
            Date now = new Date();
            now = this.truncDate(now, false);
            now = this.decrementDate1Millisecond(now);
            Date nowMenoUno = this.decrementDate(now, false);
            boolean saveDataStatistica = true;
            while (dataUltimaGenerazioneStatistiche.compareTo(nowMenoUno) <= 0) {
                boolean generazioneCompletataConSuccesso = this.generaStatistica(dataUltimaGenerazioneStatistiche, dataAvvioBatch, this.waitMsBeforeNextInterval, this.waitStatiInConsegna);
                if (!generazioneCompletataConSuccesso) {
                    saveDataStatistica = false;
                }
                dataUltimaGenerazioneStatistiche = this.incrementDate(dataUltimaGenerazioneStatistiche, false);
                if (this.debug) {
                    this.logDebug("-----------------------");
                }
                if (!saveDataStatistica) continue;
                Date next = this.truncDate(this.incrementDate(dataUltimaGenerazioneStatistiche, false), false);
                if (this.debug) {
                    this.logDebug("Save data ultima generazione statistiche: " + next.toString());
                }
                StatisticsInfoUtils.updateDataUltimaGenerazioneStatistiche(this.statisticaInfoSearchDAO, this.statisticaInfoDAO, this.getTipoStatistiche(), this.logger, next);
            }
            if (this.gestioneUltimoIntervallo) {
                Date dataUltimoIntervallo = dataUltimaGenerazioneStatistiche;
                this.generaStatistica(dataUltimoIntervallo, dataAvvioBatch, -1L, false);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
            throw new StatisticsEngineException(e);
        }
    }

    private boolean generaStatistica(Date dataUltimaGenerazioneStatistiche, Date dataAvvioBatch, long waitMsBeforeNextInterval, boolean waitStatiInConsegna) {
        boolean unicaPromozione;
        int statoFinale;
        boolean esito;
        Date now = new Date();
        Date nowTruncated = this.truncDate(now, false);
        if (this.debug) {
            this.logDebug("----------- conversione Fase0 (stato 3->1 per intervalli passati) ------------");
        }
        if (!(esito = this.convertStatoIntervalloCorrenteInPassato(nowTruncated))) {
            return false;
        }
        if (this.debug) {
            this.logDebug("------------ conversione Fase0 (stato 3->1 per intervalli passati) -----------");
        }
        if (this.debug) {
            this.logDebug("----------- pulizia Fase1 (DataUguale) ------------");
        }
        if (!(esito = this.deleteFisicoStatistiche(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, 1, false))) {
            return false;
        }
        if (this.debug) {
            this.logDebug("------------ pulizia Fase1 (DataUguale) -----------");
        }
        if (!(esito = this.deleteFisicoStatistiche(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, 1, false))) {
            return false;
        }
        if (this.debug) {
            this.logDebug("----------- aggiornamento Fase2 (DataUguale) ------------");
        }
        if (!(esito = this.updateStatoRecordStatistiche(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, 2))) {
            return false;
        }
        if (this.debug) {
            this.logDebug("------------ aggiornamento Fase2 (DataUguale) -----------");
        }
        if (!(esito = this.updateStatoRecordStatistiche(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, 2))) {
            return false;
        }
        BooleanNullable delegataStatiInCorso = BooleanNullable.NULL();
        if (this.debug) {
            this.logDebug("----------- generazione Fase3 (DataUguale) ------------");
        }
        if (!(esito = this.useUnionForLatency ? this.generaStatisticheUnion(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, 0, delegataStatiInCorso) : this.generaStatistiche(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, 0, delegataStatiInCorso))) {
            return false;
        }
        BooleanNullable applicativaStatiInCorso = BooleanNullable.NULL();
        if (this.debug) {
            this.logDebug("------------ generazione Fase3 (DataUguale) -----------");
        }
        if (!(esito = this.useUnionForLatency ? this.generaStatisticheUnion(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, 0, applicativaStatiInCorso) : this.generaStatistiche(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, 0, applicativaStatiInCorso))) {
            return false;
        }
        Date intervalloInAggiornamento = this.truncDate(this.incrementDate(dataUltimaGenerazioneStatistiche, false), false);
        boolean isIntervalloCorrente = intervalloInAggiornamento.equals(nowTruncated);
        int n = statoFinale = isIntervalloCorrente ? 3 : 1;
        if (this.debug) {
            this.logDebug("Intervallo in aggiornamento: " + intervalloInAggiornamento + ", Now truncated: " + nowTruncated + ", isIntervalloCorrente: " + isIntervalloCorrente + ", stato finale: " + statoFinale);
        }
        if (unicaPromozione = true) {
            if (this.debug) {
                this.logDebug("----------- promozione Fase4 (DataUguale) ------------");
            }
            if (!(esito = this.updateStatoRecordStatistiche(null, dataUltimaGenerazioneStatistiche, 2, -2, 0, statoFinale))) {
                return false;
            }
        } else {
            if (this.debug) {
                this.logDebug("----------- promozione Fase4 (DataUguale) ------------");
            }
            if (!(esito = this.updateStatoRecordStatistiche(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, 2, -2, 0, statoFinale))) {
                return false;
            }
            if (this.debug) {
                this.logDebug("------------ promozione Fase4 (DataUguale) -----------");
            }
            if (!(esito = this.updateStatoRecordStatistiche(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, 2, -2, 0, statoFinale))) {
                return false;
            }
        }
        boolean pulituraOk = true;
        if (this.debug) {
            this.logDebug("----------- eliminazione Fase5 (DataUguale) ------------");
        }
        if (!(esito = this.deleteFisicoStatistiche(TipoPdD.DELEGATA, dataUltimaGenerazioneStatistiche, -2, true))) {
            pulituraOk = false;
        }
        if (this.debug) {
            this.logDebug("------------ eliminazione Fase5 (DataUguale) -----------");
        }
        if (!(esito = this.deleteFisicoStatistiche(TipoPdD.APPLICATIVA, dataUltimaGenerazioneStatistiche, -2, true))) {
            pulituraOk = false;
        }
        if (waitMsBeforeNextInterval > 0L) {
            Date valid;
            boolean block;
            Date dateNext = this.incrementDate(dataUltimaGenerazioneStatistiche, false);
            boolean bl = block = !dateNext.before(valid = new Date(dataAvvioBatch.getTime() - waitMsBeforeNextInterval));
            if (block) {
                if (this.debug) {
                    this.logDebug("Tradeoff '" + waitMsBeforeNextInterval + "'; next interval update disabled");
                }
                return false;
            }
        }
        if (waitStatiInConsegna) {
            if (delegataStatiInCorso != null && delegataStatiInCorso.getValue() != null && delegataStatiInCorso.getValue().booleanValue()) {
                if (this.debug) {
                    this.logDebug("Trovate transazioni di fruizioni ancora in consegna; next interval update disabled");
                }
                return false;
            }
            if (applicativaStatiInCorso != null && applicativaStatiInCorso.getValue() != null && applicativaStatiInCorso.getValue().booleanValue()) {
                if (this.debug) {
                    this.logDebug("Trovate transazioni di erogazioni ancora in consegna; next interval update disabled");
                }
                return false;
            }
        }
        return pulituraOk;
    }

    private boolean generaStatisticheUnion(TipoPdD tipoPdD, Date data, int statoRecord, BooleanNullable statiInCorso) {
        boolean generazioneOk = true;
        if (this.debug) {
            this.logDebug("Generazione statistiche (union) [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_IN_CORSO);
        }
        try {
            List<Index> listForceIndexes;
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.transazioneSearchDAO).getFieldConverter();
            ArrayList<FunctionField> selectList = new ArrayList<FunctionField>();
            StatisticsUtils.addSelectFieldCountTransaction(selectList);
            StatisticsUtils.addSelectFieldSizeTransaction(tipoPdD, selectList);
            ArrayList<FunctionField> selectListConTutteLatenze = new ArrayList<FunctionField>();
            selectListConTutteLatenze.addAll(selectList);
            StatisticsUtils.addSelectFunctionFieldLatencyTransaction(tipoPdD, fieldConverter, selectListConTutteLatenze, true, true, true);
            ArrayList<FunctionField> selectListConSoloLatenzaTotale = new ArrayList<FunctionField>();
            selectListConSoloLatenzaTotale.addAll(selectList);
            StatisticsUtils.addSelectFunctionFieldLatencyTransaction(tipoPdD, fieldConverter, selectListConSoloLatenzaTotale, true, false, false);
            ArrayList<ConstantField> selectListCostantiLatenzaServizioPorta = new ArrayList<ConstantField>();
            StatisticsUtils.addSelectConstantFieldLatencyTransaction(tipoPdD, fieldConverter, selectListCostantiLatenzaServizioPorta, false, true, true);
            ArrayList<FunctionField> selectListSenzaLatenze = new ArrayList<FunctionField>();
            selectListSenzaLatenze.addAll(selectList);
            ArrayList<ConstantField> selectListCostantiTutteLatenze = new ArrayList<ConstantField>();
            StatisticsUtils.addSelectConstantFieldLatencyTransaction(tipoPdD, fieldConverter, selectListCostantiTutteLatenze, true, true, true);
            Date dateNext = this.incrementDate(data, false);
            IExpression exprConTutteLatenze = this.transazioneSearchDAO.newExpression();
            StatisticsUtils.setExpressionAllDatesNotNull(this.transazioneSearchDAO, exprConTutteLatenze, data, dateNext, tipoPdD, null, fieldConverter, this.groupByConfig);
            IExpression exprConSoloLatenzaTotale = this.transazioneSearchDAO.newExpression();
            StatisticsUtils.setExpressionOnlyTotalLatencyDates(this.transazioneSearchDAO, exprConSoloLatenzaTotale, data, dateNext, tipoPdD, null, fieldConverter, this.groupByConfig);
            IExpression exprSenzaLatenze = this.transazioneSearchDAO.newExpression();
            StatisticsUtils.setExpressionNullDate(this.transazioneSearchDAO, exprSenzaLatenze, data, dateNext, tipoPdD, null, fieldConverter, this.groupByConfig);
            if (this.debug) {
                this.logDebug("Genero statistiche [" + this.getTipoStatistiche() + LOG_INTERVALLO_DATE + data.toString() + " - " + dateNext.toString() + "]");
                this.logDebug(PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + data.getTime() + LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateNext.getTime() + "]");
            }
            if (this.forceIndexConfig != null && this.forceIndexConfig.getTransazioniForceIndexGroupByNumeroDimensione() != null && !(listForceIndexes = this.forceIndexConfig.getTransazioniForceIndexGroupByNumeroDimensione()).isEmpty()) {
                for (Index index : listForceIndexes) {
                    exprConTutteLatenze.addForceIndex(index);
                    exprConSoloLatenzaTotale.addForceIndex(index);
                    exprSenzaLatenze.addForceIndex(index);
                }
            }
            UnionExpression tutteLatenzeUnionExpr = new UnionExpression(exprConTutteLatenze);
            for (FunctionField functionField : selectListConTutteLatenze) {
                tutteLatenzeUnionExpr.addSelectFunctionField(functionField);
            }
            StatisticsUtils.addSelectUnionField(tutteLatenzeUnionExpr, fieldConverter, this.groupByConfig);
            UnionExpression soloLatenzaTotaleUnionExpr = new UnionExpression(exprConSoloLatenzaTotale);
            for (FunctionField functionField : selectListConSoloLatenzaTotale) {
                soloLatenzaTotaleUnionExpr.addSelectFunctionField(functionField);
            }
            for (ConstantField constantField : selectListCostantiLatenzaServizioPorta) {
                soloLatenzaTotaleUnionExpr.addSelectField((IField)constantField, constantField.getAlias());
            }
            StatisticsUtils.addSelectUnionField(soloLatenzaTotaleUnionExpr, fieldConverter, this.groupByConfig);
            UnionExpression unionExpression = new UnionExpression(exprSenzaLatenze);
            for (FunctionField functionField : selectListSenzaLatenze) {
                unionExpression.addSelectFunctionField(functionField);
            }
            for (ConstantField constantField : selectListCostantiTutteLatenze) {
                unionExpression.addSelectField((IField)constantField, constantField.getAlias());
            }
            StatisticsUtils.addSelectUnionField(unionExpression, fieldConverter, this.groupByConfig);
            Union union = new Union();
            union.setUnionAll(true);
            for (String alias : tutteLatenzeUnionExpr.getReturnFieldAliases()) {
                union.addField(alias);
            }
            List list = this.transazioneSearchDAO.union(union, new UnionExpression[]{tutteLatenzeUnionExpr, soloLatenzaTotaleUnionExpr, unionExpression});
            for (Map row : list) {
                StatisticBean stat = null;
                try {
                    stat = this.readStatisticBean(data, row, fieldConverter, true);
                    StatisticsUtils.updateStatisticBeanCountTransactionInfo(stat, row);
                    StatisticsUtils.updateStatisticBeanSizeTransactionInfo(stat, row);
                    StatisticsUtils.updateStatisticsBeanLatencyTransactionInfo(stat, row);
                    if (EsitoUtils.isFaseIntermedia(stat.getEsitoContesto())) {
                        statiInCorso.setValue(Boolean.valueOf(true));
                    }
                    this.insertStatistica(stat, statoRecord);
                    if (!this.generazioneStatisticheCustom) continue;
                    this.createCustomStatistic(stat);
                }
                catch (Throwable eSingoloRecord) {
                    Object r = "";
                    if (stat != null) {
                        try {
                            r = LOG_RECORD + stat.toString();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.logError("Rilevato errore durante la registrazione del singolo record di informazione statistica: " + eSingoloRecord.getMessage() + (String)r, eSingoloRecord);
                    generazioneOk = false;
                }
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
            this.logError(e.getMessage(), e);
            generazioneOk = false;
        }
        catch (NotFoundException e) {
            if (this.debug) {
                this.logDebug(e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            generazioneOk = false;
        }
        if (this.debug) {
            this.logDebug(PREFIX_GENERAZIONE_STATISTICA + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_TERMINATA);
        }
        return generazioneOk;
    }

    private boolean generaStatistiche(TipoPdD tipoPdD, Date data, int statoRecord, BooleanNullable statiInCorso) {
        boolean generazioneOk = true;
        if (this.debug) {
            this.logDebug(PREFIX_GENERAZIONE_STATISTICA + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_IN_CORSO);
        }
        try {
            List<Index> listForceIndexes;
            IExpression expr = this.transazioneSearchDAO.newExpression();
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.transazioneSearchDAO).getFieldConverter();
            ArrayList<FunctionField> selectList = new ArrayList<FunctionField>();
            StatisticsUtils.addSelectFieldCountTransaction(selectList);
            StatisticsUtils.addSelectFieldSizeTransaction(tipoPdD, selectList);
            Date dateNext = this.incrementDate(data, false);
            StatisticsUtils.setExpression(this.transazioneSearchDAO, expr, data, dateNext, tipoPdD, false, null, fieldConverter, this.groupByConfig);
            if (this.debug) {
                this.logDebug("Genero statistiche [" + this.getTipoStatistiche() + LOG_INTERVALLO_DATE + data.toString() + " - " + dateNext.toString() + "]");
                this.logDebug(PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + data.getTime() + LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateNext.getTime() + "]");
            }
            if (this.forceIndexConfig != null && this.forceIndexConfig.getTransazioniForceIndexGroupByNumeroDimensione() != null && !(listForceIndexes = this.forceIndexConfig.getTransazioniForceIndexGroupByNumeroDimensione()).isEmpty()) {
                for (Index index : listForceIndexes) {
                    expr.addForceIndex(index);
                }
            }
            List list = this.transazioneSearchDAO.groupBy(expr, selectList.toArray(new FunctionField[1]));
            for (Map row : list) {
                StatisticBean stat = null;
                try {
                    stat = this.readStatisticBean(data, row, null, false);
                    StatisticsUtils.updateStatisticBeanCountTransactionInfo(stat, row);
                    StatisticsUtils.updateStatisticBeanSizeTransactionInfo(stat, row);
                    try {
                        this.addLatenze(data, dateNext, tipoPdD, stat, fieldConverter);
                    }
                    catch (Throwable eSingoloRecordAddLatenze) {
                        this.logError("Rilevato errore durante la lettura delle latenze di un singolo record di informazione statistica: " + eSingoloRecordAddLatenze.getMessage() + LOG_RECORD + stat.toString(), eSingoloRecordAddLatenze);
                        generazioneOk = false;
                    }
                    if (EsitoUtils.isFaseIntermedia(stat.getEsitoContesto())) {
                        statiInCorso.setValue(Boolean.valueOf(true));
                    }
                    this.insertStatistica(stat, statoRecord);
                    if (!this.generazioneStatisticheCustom) continue;
                    this.createCustomStatistic(stat);
                }
                catch (Throwable eSingoloRecord) {
                    Object r = "";
                    if (stat != null) {
                        try {
                            r = LOG_RECORD + stat.toString();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.logError("Rilevato errore durante la registrazione del singolo record di informazione statistica: " + eSingoloRecord.getMessage() + (String)r, eSingoloRecord);
                    generazioneOk = false;
                }
            }
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
            this.logError(e.getMessage(), e);
            generazioneOk = false;
        }
        catch (NotFoundException e) {
            if (this.debug) {
                this.logDebug(e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            generazioneOk = false;
        }
        if (this.debug) {
            this.logDebug(PREFIX_GENERAZIONE_STATISTICA + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_TERMINATA);
        }
        return generazioneOk;
    }

    private StatisticBean readStatisticBean(Date data, Map<String, Object> row, ISQLFieldConverter fieldConverter, boolean useFieldConverter) throws ExpressionException {
        StatisticBean stat = new StatisticBean();
        stat.setDateIntervalLeft(data);
        stat.setDateIntervalRight(this.incrementDate(data, false));
        Date next = this.truncDate(this.incrementDate(data, false), false);
        stat.setData(next);
        if (this.debug) {
            this.logDebug("Salvo statistica con data [" + next + "]");
        }
        return StatisticsUtils.readStatisticBean(stat, row, fieldConverter, useFieldConverter, this.groupByConfig);
    }

    private void addLatenze(Date data, Date dateNext, TipoPdD tipoPdD, StatisticBean stat, ISQLFieldConverter fieldConverter) throws Exception {
        IExpression exprDateNotNull = this.transazioneSearchDAO.newExpression();
        StatisticsUtils.setExpression(this.transazioneSearchDAO, exprDateNotNull, data, dateNext, tipoPdD, true, stat, fieldConverter, this.groupByConfig);
        ArrayList<FunctionField> selectListDateNotNull = new ArrayList<FunctionField>();
        StatisticsUtils.addSelectFunctionFieldLatencyTransaction(tipoPdD, fieldConverter, selectListDateNotNull);
        if (this.debug) {
            this.logDebug("Leggo ulteriormente statistiche con campi data not null [" + this.getTipoStatistiche() + LOG_INTERVALLO_DATE + data.toString() + " - " + dateNext.toString() + "]");
            this.logDebug(PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + data.getTime() + LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateNext.getTime() + "]");
        }
        try {
            List listDateNotNull;
            List<Index> listForceIndexes;
            if (this.forceIndexConfig != null && this.forceIndexConfig.getTransazioniForceIndexGroupByLatenze() != null && !(listForceIndexes = this.forceIndexConfig.getTransazioniForceIndexGroupByLatenze()).isEmpty()) {
                for (Index index : listForceIndexes) {
                    exprDateNotNull.addForceIndex(index);
                }
            }
            if ((listDateNotNull = this.transazioneSearchDAO.groupBy(exprDateNotNull, selectListDateNotNull.toArray(new FunctionField[1]))).size() > 1) {
                throw new MultipleResultException("Attesa un solo gruppo, ritornati " + listDateNotNull.size() + " gruppi");
            }
            Map row = (Map)listDateNotNull.get(0);
            StatisticsUtils.updateStatisticsBeanLatencyTransactionInfo(stat, row);
        }
        catch (NotFoundException notFound) {
            if (this.debug) {
                this.logDebug(notFound.getMessage(), notFound);
            }
            stat.setLatenzaPorta(Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue());
            stat.setLatenzaServizio(Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue());
            stat.setLatenzaTotale(Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue());
        }
    }

    private void createCustomStatistic(StatisticBean stat) {
        try {
            if (stat.getDestinatario() == null || stat.getDestinatario().getTipo() == null || stat.getDestinatario().getNome() == null) {
                if (this.debug) {
                    this.logDebug("Statistiche personalizzate non ricercate: destinatario non presente");
                }
                return;
            }
            if (stat.getTipoServizio() == null || stat.getServizio() == null) {
                if (this.debug) {
                    this.logDebug("Statistiche personalizzate non ricercate: servizio non presente");
                }
                return;
            }
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(stat.getTipoServizio(), stat.getServizio(), stat.getDestinatario(), stat.getVersioneServizio().intValue());
            if (!"*".equals(stat.getAzione())) {
                idServizio.setAzione(stat.getAzione());
            }
            BasicServiceLibraryReader reader = new BasicServiceLibraryReader(this.pluginsBaseSM, this.utilsSM, this.debug);
            BasicServiceLibrary basicLibrary = null;
            try {
                basicLibrary = reader.read(idServizio, this.logger);
                if (basicLibrary == null) {
                    throw new NotFoundException("Null instance return");
                }
            }
            catch (NotFoundException notFound) {
                if (this.debug) {
                    this.logDebug("Statistiche personalizzate non ricercate: nessuna configurazione base presente per l'IDServizio: " + idServizio, notFound);
                }
                return;
            }
            TransactionServiceLibrary transactionLibrary = null;
            if (this.analisiTransazioniCustom) {
                TransactionServiceLibraryReader transactionReader = new TransactionServiceLibraryReader(this.pluginsTransazioniSM, this.debug);
                transactionLibrary = transactionReader.readConfigurazioneTransazione(basicLibrary, this.logger);
            }
            StatisticsServiceLibraryReader statReader = new StatisticsServiceLibraryReader(this.pluginsStatisticheSM, this.debug);
            StatisticsServiceLibrary statLibrary = null;
            try {
                statLibrary = statReader.readConfigurazioneStatistiche(basicLibrary, transactionLibrary, this.logger);
                if (statLibrary == null) {
                    throw new NotFoundException("Null instance return");
                }
            }
            catch (NotFoundException notFound) {
                if (this.debug) {
                    this.logDebug("Statistiche personalizzate non ricercate: nessuna configurazione specifica per le statistiche presente per l'IDServizio: " + idServizio, notFound);
                }
                return;
            }
            List<ConfigurazioneStatistica> list = statLibrary.mergeServiceActionSearchLibrary(false, true);
            for (ConfigurazioneStatistica confStat : list) {
                String classNameStatisticaPersonalizzata = confStat.getPlugin().getClassName();
                String labelStatisticaPersonalizzata = confStat.getLabel();
                if (this.debug) {
                    this.logDebug("*** Inizio Gestione Statistica personalizzata (" + classNameStatisticaPersonalizzata + " [" + labelStatisticaPersonalizzata + "]) ****");
                }
                stat.setIdStatistica(confStat.getIdConfigurazioneStatistica());
                stat.setPluginClassname(classNameStatisticaPersonalizzata);
                IDynamicLoader cStatPersonalizzata = DynamicFactory.getInstance().newDynamicLoader(confStat.getPlugin().getTipoPlugin(), confStat.getPlugin().getTipo(), classNameStatisticaPersonalizzata, this.logger);
                IStatisticProcessing statProcessing = (IStatisticProcessing)cStatPersonalizzata.newInstance();
                if (this.isEnabledStatisticTypeCustom(statProcessing)) {
                    if (this.debug) {
                        this.logDebug(PREFIX_INVOCAZIONE + cStatPersonalizzata.getClassName() + "." + this.getStatisticPluginMethodName() + "()] ...");
                    }
                    try {
                        this.callStatisticPluginMethod(statProcessing, stat);
                        if (this.debug) {
                            this.logDebug(PREFIX_INVOCAZIONE + cStatPersonalizzata.getClassName() + "." + this.getStatisticPluginMethodName() + "()] terminata");
                        }
                    }
                    catch (Exception e) {
                        this.logError(PREFIX_INVOCAZIONE + cStatPersonalizzata.getClassName() + "." + this.getStatisticPluginMethodName() + "()] terminata con errori: " + e.getMessage(), e);
                    }
                } else if (this.debug) {
                    this.logDebug("Tipo di statistica [" + this.getTipoStatistiche() + "] non abilitata nel plugin");
                }
                if (!this.debug) continue;
                this.logDebug("*** Fine Gestione Statistica personalizzata (" + classNameStatisticaPersonalizzata + " [" + labelStatisticaPersonalizzata + "]) ****");
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
        }
    }

    private boolean isEnabledStatisticTypeCustom(IStatisticProcessing statProcessing) {
        List listEnabled = statProcessing.getEnabledStatisticType();
        switch (this.getTipoStatistiche()) {
            case STATISTICHE_ORARIE: {
                for (StatisticType statisticType : listEnabled) {
                    if (!StatisticType.ORARIA.equals((Object)statisticType)) continue;
                    return true;
                }
                break;
            }
            case STATISTICHE_GIORNALIERE: {
                for (StatisticType statisticType : listEnabled) {
                    if (!StatisticType.GIORNALIERA.equals((Object)statisticType)) continue;
                    return true;
                }
                break;
            }
            case STATISTICHE_SETTIMANALI: {
                for (StatisticType statisticType : listEnabled) {
                    if (!StatisticType.SETTIMANALE.equals((Object)statisticType)) continue;
                    return true;
                }
                break;
            }
            case STATISTICHE_MENSILI: {
                for (StatisticType statisticType : listEnabled) {
                    if (!StatisticType.MENSILE.equals((Object)statisticType)) continue;
                    return true;
                }
                break;
            }
            case PDND_GENERAZIONE_TRACCIAMENTO: 
            case PDND_PUBBLICAZIONE_TRACCIAMENTO: {
                return false;
            }
        }
        return false;
    }

    protected void generaStatisticaPersonalizzataByStato(StatisticBean stat) {
        this.generaStatisticaPersonalizzata(stat, true, null, null);
    }

    protected void generaStatisticaPersonalizzata(StatisticBean stat, RisorsaSemplice risorsaSemplice) {
        this.generaStatisticaPersonalizzata(stat, false, risorsaSemplice, null);
    }

    protected void generaStatisticaPersonalizzata(StatisticBean stat, RisorsaAggregata risorsaAggregata) {
        this.generaStatisticaPersonalizzata(stat, false, null, risorsaAggregata);
    }

    private void generaStatisticaPersonalizzata(StatisticBean stat, boolean gropuByStato, RisorsaSemplice risorsaSemplice, RisorsaAggregata risorsaAggregata) {
        TipoPdD tipoPdD = null;
        String idStatisticaPersonalizzata = null;
        Date dateStatistics = null;
        try {
            HashMap<String, StatisticaContenuti> statisticheContenuti;
            block37: {
                StatisticaContenuti statisticaContenuti;
                List<Index> listForceIndexes;
                tipoPdD = stat.getTipoPorta();
                Date dateLeft = stat.getDateIntervalLeft();
                Date dateRight = stat.getDateIntervalRight();
                dateStatistics = stat.getData();
                idStatisticaPersonalizzata = stat.getIdStatistica();
                if (this.debug) {
                    this.logDebug("Generazione statistica personalizzata [" + idStatisticaPersonalizzata + "] [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(dateStatistics, false) + LOG_SUFFIX_IN_CORSO);
                }
                ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.transazioneSearchDAO).getFieldConverter();
                statisticheContenuti = new HashMap<String, StatisticaContenuti>();
                String idRisorsa = null;
                StatisticResourceFilter[] risorseFiltri = null;
                if (risorsaSemplice != null) {
                    idRisorsa = risorsaSemplice.getIdRisorsa();
                    if (risorsaSemplice.getFiltri() != null && !risorsaSemplice.getFiltri().isEmpty()) {
                        risorseFiltri = risorsaSemplice.getFiltri().toArray(new StatisticResourceFilter[1]);
                    }
                }
                IExpression expr = this.transazioneSearchDAO.newExpression();
                ArrayList<Object> selectList = new ArrayList<FunctionField>();
                StatisticsUtils.addSelectFieldCountTransaction(selectList);
                StatisticsUtils.addSelectFieldSizeTransaction(tipoPdD, selectList);
                ArrayList<AliasFilter> aliases = new ArrayList<AliasFilter>();
                if (gropuByStato) {
                    StatisticsUtils.setExpressionByStato(this.transazioneSearchDAO, expr, dateLeft, dateRight, tipoPdD, false, stat, fieldConverter, this.groupByConfig);
                } else {
                    StatisticsUtils.setExpressionStatsPersonalizzate(this.transazioneSearchDAO, expr, dateLeft, dateRight, tipoPdD, false, stat, fieldConverter, aliases, idRisorsa, this.groupByConfig, risorseFiltri);
                }
                if (risorsaAggregata != null && risorsaAggregata.getFiltro() instanceof FilterImpl) {
                    FilterImpl f = (FilterImpl)risorsaAggregata.getFiltro();
                    expr.and(new IExpression[]{f.getExpression()});
                }
                if (this.debug) {
                    this.logDebug("Analizzo dati di base statistica personalizzata [" + idStatisticaPersonalizzata + "]  [" + this.getTipoStatistiche() + LOG_INTERVALLO_DATE + dateLeft.toString() + " - " + dateRight.toString() + "]");
                    this.logDebug(PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateLeft.getTime() + LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateRight.getTime() + "]");
                    this.logDebug("Expr: " + expr.toString());
                }
                if (this.forceIndexConfig != null && this.forceIndexConfig.getTransazioniForceIndexGroupByCustomNumeroDimensione() != null && !(listForceIndexes = this.forceIndexConfig.getTransazioniForceIndexGroupByCustomNumeroDimensione()).isEmpty()) {
                    for (Index index : listForceIndexes) {
                        expr.addForceIndex(index);
                    }
                }
                List list = this.transazioneSearchDAO.groupBy(expr, selectList.toArray(new FunctionField[1]));
                for (Object row : list) {
                    if (list.size() > 1 && risorsaAggregata != null) {
                        throw new ServiceException("Localizzata pi\u00f9 di una entry?? Comportamento non atteso per una risorsa aggregata");
                    }
                    statisticaContenuti = new StatisticaContenuti();
                    if (gropuByStato) {
                        StatisticsUtils.fillStatisticsContenutiByStato(idStatisticaPersonalizzata, statisticaContenuti, (Map<String, Object>)row);
                    } else if (risorsaSemplice != null) {
                        StatisticsUtils.fillStatisticsContenuti(idStatisticaPersonalizzata, statisticaContenuti, (Map<String, Object>)row, aliases, risorsaSemplice);
                    } else {
                        StatisticsUtils.fillStatisticsContenuti(idStatisticaPersonalizzata, statisticaContenuti, risorsaAggregata);
                    }
                    StatisticBean tmp = new StatisticBean();
                    tmp.setTipoPorta(stat.getTipoPorta());
                    StatisticsUtils.updateStatisticBeanCountTransactionInfo(tmp, (Map<String, Object>)row);
                    StatisticsUtils.updateStatisticBeanSizeTransactionInfo(tmp, (Map<String, Object>)row);
                    statisticaContenuti.setNumeroTransazioni(Integer.valueOf((int)tmp.getRichieste()));
                    statisticaContenuti.setDimensioniBytesBandaComplessiva(Long.valueOf(tmp.getBytesBandaTotale()));
                    statisticaContenuti.setDimensioniBytesBandaInterna(Long.valueOf(tmp.getBytesBandaInterna()));
                    statisticaContenuti.setDimensioniBytesBandaEsterna(Long.valueOf(tmp.getBytesBandaEsterna()));
                    String key = StatisticsUtils.buildKey(statisticaContenuti);
                    statisticheContenuti.put(key, statisticaContenuti);
                }
                try {
                    Object listForceIndexes2;
                    expr = this.transazioneSearchDAO.newExpression();
                    selectList = new ArrayList();
                    StatisticsUtils.addSelectFunctionFieldLatencyTransaction(tipoPdD, fieldConverter, selectList);
                    aliases = new ArrayList();
                    if (gropuByStato) {
                        StatisticsUtils.setExpressionByStato(this.transazioneSearchDAO, expr, dateLeft, dateRight, tipoPdD, false, stat, fieldConverter, this.groupByConfig);
                    } else {
                        StatisticsUtils.setExpressionStatsPersonalizzate(this.transazioneSearchDAO, expr, dateLeft, dateRight, tipoPdD, true, stat, fieldConverter, aliases, idRisorsa, this.groupByConfig, risorseFiltri);
                    }
                    if (risorsaAggregata != null && risorsaAggregata.getFiltro() instanceof FilterImpl) {
                        FilterImpl f = (FilterImpl)risorsaAggregata.getFiltro();
                        expr.and(new IExpression[]{f.getExpression()});
                    }
                    if (this.debug) {
                        this.logDebug("Analizzo dati sulla latenza per la statistica personalizzata [" + idStatisticaPersonalizzata + "]  [" + this.getTipoStatistiche() + LOG_INTERVALLO_DATE + dateLeft.toString() + " - " + dateRight.toString() + "]");
                        this.logDebug(PREFIX_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateLeft.getTime() + LOG_AND_VALORI_QUERY_DATA_INGRESSO_RICHIESTA + dateRight.getTime() + "]");
                    }
                    if (this.forceIndexConfig != null && this.forceIndexConfig.getTransazioniForceIndexGroupByCustomLatenze() != null && !(listForceIndexes2 = this.forceIndexConfig.getTransazioniForceIndexGroupByCustomLatenze()).isEmpty()) {
                        Object row;
                        row = listForceIndexes2.iterator();
                        while (row.hasNext()) {
                            Index index = (Index)row.next();
                            expr.addForceIndex(index);
                        }
                    }
                    list = this.transazioneSearchDAO.groupBy(expr, selectList.toArray(new FunctionField[1]));
                    for (Object row : list) {
                        if (list.size() > 1 && risorsaAggregata != null) {
                            throw new ServiceException("Localizzata pi\u00f9 di una entry?? Comportamento non atteso per una risorsa aggregata");
                        }
                        statisticaContenuti = new StatisticaContenuti();
                        if (gropuByStato) {
                            StatisticsUtils.fillStatisticsContenutiByStato(idStatisticaPersonalizzata, statisticaContenuti, (Map<String, Object>)row);
                        } else if (risorsaSemplice != null) {
                            StatisticsUtils.fillStatisticsContenuti(idStatisticaPersonalizzata, statisticaContenuti, (Map<String, Object>)row, aliases, risorsaSemplice);
                        } else {
                            StatisticsUtils.fillStatisticsContenuti(idStatisticaPersonalizzata, statisticaContenuti, risorsaAggregata);
                        }
                        String key = StatisticsUtils.buildKey(statisticaContenuti);
                        statisticaContenuti = (StatisticaContenuti)statisticheContenuti.get(key);
                        if (statisticaContenuti == null) {
                            throw new ServiceException("Statistica [" + key + "] non presente in cache??");
                        }
                        StatisticBean tmp = new StatisticBean();
                        StatisticsUtils.updateStatisticsBeanLatencyTransactionInfo(tmp, (Map<String, Object>)row);
                        statisticaContenuti.setLatenzaPorta(Long.valueOf(tmp.getLatenzaPorta()));
                        statisticaContenuti.setLatenzaServizio(Long.valueOf(tmp.getLatenzaServizio()));
                        statisticaContenuti.setLatenzaTotale(Long.valueOf(tmp.getLatenzaTotale()));
                    }
                }
                catch (NotFoundException e) {
                    if (!this.debug) break block37;
                    this.logDebug(e.getMessage(), e);
                }
            }
            if (this.debug) {
                this.logDebug("Aggiorno [" + statisticheContenuti.size() + "] risultati statistiche personalizzate");
            }
            if (statisticheContenuti.size() > 0) {
                this.updateStatistica(stat.getId(), statisticheContenuti.values().toArray(new StatisticaContenuti[1]));
            }
        }
        catch (NotFoundException e) {
            if (this.debug) {
                this.logDebug(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            this.logError(e.getMessage(), e);
        }
        if (this.debug) {
            this.logDebug("Generazione statistica personalizzata [" + idStatisticaPersonalizzata + "] [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(dateStatistics, false) + LOG_SUFFIX_TERMINATA);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStatoRecordStatistiche(TipoPdD tipoPdD, Date data, int stato) {
        if (this.debug) {
            this.logDebug("Update record statistiche allo stato '" + stato + "' [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_IN_CORSO);
        }
        try {
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.statisticaServiceDAO).getFieldConverter();
            TipiDatabase tipoDB = fieldConverter.getDatabaseType();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDB);
            sqlQueryObject.addUpdateTable(fieldConverter.toTable((IModel)this.model));
            sqlQueryObject.addUpdateField(fieldConverter.toColumn(this.model.STATO_RECORD, false), "?");
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.DATA, false) + "=?");
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.TIPO_PORTA, false) + "=?");
            sqlQueryObject.setANDLogicOperator(true);
            Date next = this.truncDate(this.incrementDate(data, false), false);
            if (this.debug) {
                this.logDebug("Aggiorno statistiche [" + this.getTipoStatistiche() + "]");
                this.logDebug("Valori update stato record = (" + stato + ") tr.data_ingresso_richiesta=[" + next.getTime() + "]");
            }
            int righeModificate = this.statisticaServiceDAO.nativeUpdate(sqlQueryObject.createSQLUpdate(), new Object[]{stato, next, TipoPdD.DELEGATA.equals((Object)tipoPdD) ? PddRuolo.DELEGATA.getValue() : PddRuolo.APPLICATIVA.getValue()});
            if (this.debug) {
                this.logDebug("Modificate [" + righeModificate + "] entry");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.debug) {
                this.logDebug("Update record statistiche allo stato '" + stato + "' [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_TERMINATA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateStatoRecordStatistiche(TipoPdD tipoPdD, Date data, int case1WhenStato, int case1ThenStato, int case2WhenStato, int case2ThenStato) {
        if (this.debug) {
            this.logDebug("Update record statistiche negli stati con CASE (" + case1WhenStato + "->" + case1ThenStato + LOG_SEPARATORE + case2WhenStato + "->" + case2ThenStato + ")  [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_IN_CORSO);
        }
        try {
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.statisticaServiceDAO).getFieldConverter();
            TipiDatabase tipoDB = fieldConverter.getDatabaseType();
            String nomeColonna = fieldConverter.toColumn(this.model.STATO_RECORD, false);
            Case caseSql = new Case(CastColumnType.INT);
            caseSql.addCase(nomeColonna + "=?", "?");
            caseSql.addCase(nomeColonna + "=?", "?");
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDB);
            sqlQueryObject.addUpdateTable(fieldConverter.toTable((IModel)this.model));
            sqlQueryObject.addUpdateField(nomeColonna, caseSql);
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.DATA, false) + "=?");
            if (tipoPdD != null) {
                sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.TIPO_PORTA, false) + "=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            Date next = this.truncDate(this.incrementDate(data, false), false);
            if (this.debug) {
                this.logDebug("Aggiorno statistiche [" + this.getTipoStatistiche() + "]");
                this.logDebug("Valori update stato record CASE (" + case1WhenStato + "->" + case1ThenStato + LOG_SEPARATORE + case2WhenStato + "->" + case2ThenStato + ") tr.data_ingresso_richiesta=[" + next.getTime() + "]");
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(case1WhenStato);
            l.add(case1ThenStato);
            l.add(case2WhenStato);
            l.add(case2ThenStato);
            l.add(next);
            if (tipoPdD != null) {
                l.add(TipoPdD.DELEGATA.equals((Object)tipoPdD) ? PddRuolo.DELEGATA.getValue() : PddRuolo.APPLICATIVA.getValue());
            }
            int righeModificate = this.statisticaServiceDAO.nativeUpdate(sqlQueryObject.createSQLUpdate(), l.toArray(new Object[1]));
            if (this.debug) {
                this.logDebug("Modificate [" + righeModificate + "] entry");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.debug) {
                this.logDebug("Update record statistiche negli stati con CASE (" + case1WhenStato + "->" + case1ThenStato + LOG_SEPARATORE + case2WhenStato + "->" + case2ThenStato + ") [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_TERMINATA);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertStatoIntervalloCorrenteInPassato(Date nowTruncated) {
        if (this.debug) {
            this.logDebug("Conversione record con stato 3 (intervallo corrente) in stato 1 (intervalli precedenti) per date < [" + nowTruncated + "] ...");
        }
        try {
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.statisticaServiceDAO).getFieldConverter();
            TipiDatabase tipoDB = fieldConverter.getDatabaseType();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDB);
            sqlQueryObject.addUpdateTable(fieldConverter.toTable((IModel)this.model));
            sqlQueryObject.addUpdateField(fieldConverter.toColumn(this.model.STATO_RECORD, false), "?");
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.STATO_RECORD, false) + "=?");
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.DATA, false) + "<?");
            sqlQueryObject.setANDLogicOperator(true);
            if (this.debug) {
                this.logDebug("Converto record con stato_record=3 e data<[" + nowTruncated.getTime() + "] in stato_record=1");
            }
            int righeModificate = this.statisticaServiceDAO.nativeUpdate(sqlQueryObject.createSQLUpdate(), new Object[]{1, 3, nowTruncated});
            if (this.debug) {
                this.logDebug("Convertite [" + righeModificate + "] entry da stato 3 a stato 1");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.debug) {
                this.logDebug("Conversione record con stato 3 in stato 1 per date < [" + nowTruncated + "] terminata");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteFisicoStatistiche(TipoPdD tipoPdD, Date data, int statoRecord, boolean equalsStatoRecord) {
        if (this.debug) {
            this.logDebug("Eliminazione statistiche con stato record '" + statoRecord + "' equals_stato_record:" + equalsStatoRecord + " [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_IN_CORSO);
        }
        try {
            ISQLFieldConverter fieldConverter = ((IDBServiceUtilities)this.statisticaServiceDAO).getFieldConverter();
            TipiDatabase tipoDB = fieldConverter.getDatabaseType();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((TipiDatabase)tipoDB);
            sqlQueryObject.addDeleteTable(fieldConverter.toTable((IModel)this.model));
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.DATA, false) + "=?");
            if (equalsStatoRecord) {
                sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.STATO_RECORD, false) + "=?");
            } else {
                sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.STATO_RECORD, false) + "<?");
            }
            sqlQueryObject.addWhereCondition(fieldConverter.toColumn(this.model.TIPO_PORTA, false) + "=?");
            sqlQueryObject.setANDLogicOperator(true);
            Date next = this.truncDate(this.incrementDate(data, false), false);
            if (this.debug) {
                this.logDebug("Elimino statistiche [" + this.getTipoStatistiche() + "]");
                this.logDebug("Valori eliminazione (ms) tr.data_ingresso_richiesta=[" + next.getTime() + "]");
            }
            int righeEliminate = this.statisticaServiceDAO.nativeUpdate(sqlQueryObject.createSQLDelete(), new Object[]{next, statoRecord, TipoPdD.DELEGATA.equals((Object)tipoPdD) ? PddRuolo.DELEGATA.getValue() : PddRuolo.APPLICATIVA.getValue()});
            if (this.debug) {
                this.logDebug("Eliminate [" + righeEliminate + "] entry");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            this.logError(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.debug) {
                this.logDebug("Eliminazione statistiche con stato record '" + statoRecord + "' equals_stato_record:" + equalsStatoRecord + " [" + this.getTipoStatistiche() + "] [" + tipoPdD + "](" + this.getIntervalloStatistica(data) + LOG_SUFFIX_TERMINATA);
            }
        }
    }

    protected abstract Long insertStatistica(Statistica var1) throws StatisticException;

    protected abstract void updateStatistica(long var1, StatisticaContenuti ... var3) throws StatisticException;

    private void insertStatistica(StatisticBean stat, int statoRecord) throws StatisticException {
        Long id;
        if (this.debug) {
            this.logDebug("Inserimento statistica [" + stat.toString() + "] in corso ...");
        }
        Statistica statisticaBase = new Statistica();
        statisticaBase.setData(stat.getData());
        statisticaBase.setStatoRecord(statoRecord);
        statisticaBase.setTipoPorta(TipoPorta.toEnumConstant((String)stat.getTipoPorta().getTipo()));
        statisticaBase.setIdPorta(stat.getIdPorta());
        statisticaBase.setTipoMittente(stat.getMittente().getTipo());
        statisticaBase.setMittente(stat.getMittente().getNome());
        statisticaBase.setTipoDestinatario(stat.getDestinatario().getTipo());
        statisticaBase.setDestinatario(stat.getDestinatario().getNome());
        statisticaBase.setTipoServizio(stat.getTipoServizio());
        statisticaBase.setServizio(stat.getServizio());
        statisticaBase.setVersioneServizio(stat.getVersioneServizio().intValue());
        statisticaBase.setAzione(stat.getAzione());
        statisticaBase.setServizioApplicativo(stat.getServizioApplicativo());
        statisticaBase.setTrasportoMittente(stat.getTrasportoMittente());
        statisticaBase.setTokenIssuer(stat.getTokenIssuer());
        statisticaBase.setTokenClientId(stat.getTokenClientId());
        statisticaBase.setTokenSubject(stat.getTokenSubject());
        statisticaBase.setTokenUsername(stat.getTokenUsername());
        statisticaBase.setTokenMail(stat.getTokenMail());
        statisticaBase.setClientAddress(stat.getClientAddress());
        statisticaBase.setGruppi(stat.getGruppo());
        statisticaBase.setUriApi(stat.getApi());
        statisticaBase.setClusterId(stat.getClusterId());
        if (stat.getDestinatario() != null && stat.getDestinatario().getTipo() != null) {
            EsitiProperties esitiProperties = null;
            int esitoConsegnaMultipla = -1;
            int esitoConsegnaMultiplaInCorso = -1;
            int esitoConsegnaMultiplaFallita = -1;
            int esitoConsegnaMultiplaCompletata = -1;
            try {
                String protocollo = null;
                protocollo = stat.getDestinatario() != null && stat.getDestinatario().getTipo() != null && !"".equals(stat.getDestinatario().getTipo()) && !"-".equals(stat.getDestinatario().getTipo()) ? ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(stat.getDestinatario().getTipo()) : (stat.getMittente() != null && stat.getMittente().getTipo() != null && !"".equals(stat.getMittente().getTipo()) && !"-".equals(stat.getMittente().getTipo()) ? ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(stat.getMittente().getTipo()) : ProtocolFactoryManager.getInstance().getDefaultProtocolFactory().getProtocol());
                esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.logger, (String)protocollo);
                esitoConsegnaMultipla = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA);
                esitoConsegnaMultiplaInCorso = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_IN_CORSO);
                esitoConsegnaMultiplaFallita = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_FALLITA);
                esitoConsegnaMultiplaCompletata = esitiProperties.convertoToCode(EsitoTransazioneName.CONSEGNA_MULTIPLA_COMPLETATA);
                if (stat.getEsito() == esitoConsegnaMultiplaInCorso || stat.getEsito() == esitoConsegnaMultiplaFallita || stat.getEsito() == esitoConsegnaMultiplaCompletata) {
                    statisticaBase.setEsito(Integer.valueOf(esitoConsegnaMultipla));
                }
                statisticaBase.setEsito(stat.getEsito());
            }
            catch (Exception er) {
                throw new StatisticException(er.getMessage(), (Throwable)er);
            }
        } else {
            statisticaBase.setEsito(stat.getEsito());
        }
        statisticaBase.setEsitoContesto(stat.getEsitoContesto());
        statisticaBase.setNumeroTransazioni(Integer.valueOf((int)stat.getRichieste()));
        statisticaBase.setDimensioniBytesBandaComplessiva(Long.valueOf(stat.getBytesBandaTotale()));
        statisticaBase.setDimensioniBytesBandaInterna(Long.valueOf(stat.getBytesBandaInterna()));
        statisticaBase.setDimensioniBytesBandaEsterna(Long.valueOf(stat.getBytesBandaEsterna()));
        if (stat.getLatenzaServizio() != (long)Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue()) {
            statisticaBase.setLatenzaServizio(Long.valueOf(stat.getLatenzaServizio()));
        }
        if (stat.getLatenzaPorta() != (long)Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue()) {
            statisticaBase.setLatenzaPorta(Long.valueOf(stat.getLatenzaPorta()));
        }
        if (stat.getLatenzaTotale() != (long)Costanti.INFORMAZIONE_LATENZA_NON_DISPONIBILE.intValue()) {
            statisticaBase.setLatenzaTotale(Long.valueOf(stat.getLatenzaTotale()));
        }
        if ((id = this.insertStatistica(statisticaBase)) != null && id > 0L) {
            stat.setId(id);
        }
        if (this.debug) {
            this.logDebug("Inserimento statistica effettuato con successo");
        }
    }
}

