/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.statistic;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.statistiche.StatistichePdndTracing;
import org.openspcoop2.core.statistiche.constants.PdndMethods;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiPdnd;
import org.openspcoop2.core.statistiche.constants.TipoIntervalloStatistico;
import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.Transazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.dao.jdbc.JDBCCredenzialeMittenteServiceSearch;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenzialeList;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.monitor.engine.statistic.IStatisticsEngine;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoInfo;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoSoggetto;
import org.openspcoop2.monitor.engine.statistic.PdndTracciamentoUtils;
import org.openspcoop2.monitor.engine.statistic.StatisticsConfig;
import org.openspcoop2.monitor.engine.statistic.StatisticsEngineException;
import org.openspcoop2.monitor.engine.statistic.StatisticsInfoUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class PdndGenerazioneTracciamento
implements IStatisticsEngine {
    private static final String PDND_DATE_FORMAT = "yyyy-MM-dd";
    private static final String REQUESTS_COUNT_ID = "request_count";
    private StatisticsConfig config;
    private org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM;
    private org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM;
    private Map<String, Integer> eventsToCode;
    private PdndTracciamentoInfo internalPddCodes;
    private Logger logger;
    private static final String[] CSV_HEADERS = new String[]{"date", "purpose_id", "status", "token_id", "requests_count"};

    PdndGenerazioneTracciamento() {
    }

    @Override
    public void init(StatisticsConfig config, org.openspcoop2.core.statistiche.dao.IServiceManager statisticheSM, org.openspcoop2.core.transazioni.dao.IServiceManager transazioniSM, org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager pluginsStatisticheSM, IServiceManager pluginsBaseSM, org.openspcoop2.core.commons.search.dao.IServiceManager utilsSM, org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager pluginsTransazioniSM) {
        this.config = config;
        this.statisticheSM = statisticheSM;
        this.transazioniSM = transazioniSM;
        this.logger = config.getLogCore();
        this.eventsToCode = new HashMap<String, Integer>();
        try {
            this.internalPddCodes = PdndTracciamentoUtils.getEnabledPddCodes(utilsSM, config);
            PdndTracciamentoUtils.logDebugSoggettiAbilitati(this.internalPddCodes, this.logger);
        }
        catch (Throwable e) {
            this.logger.error("Impossibile inizializzare la classe PdndGenerazioneTracciamento", e);
        }
    }

    private Date truncDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(11, 0);
        cTmp.set(12, 0);
        cTmp.set(13, 0);
        cTmp.set(14, 0);
        return cTmp.getTime();
    }

    private Date incrementDate(Date date) {
        Calendar cTmp = Calendar.getInstance();
        cTmp.setTime(date);
        cTmp.set(6, cTmp.get(6) + 1);
        return cTmp.getTime();
    }

    private Integer convertEventToInteger(Object o) throws UtilsException {
        try {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            String event = o.toString();
            Integer cached = this.eventsToCode.get(event);
            if (cached != null) {
                return cached;
            }
            CredenzialeMittente credenzialeMittente = ((JDBCCredenzialeMittenteServiceSearch)this.transazioniSM.getCredenzialeMittenteService()).get(Long.valueOf(event).longValue());
            String cred = AbstractCredenzialeList.normalize((String)credenzialeMittente.getCredenziale());
            String rawCode = RegularExpressionEngine.getStringFindPattern((String)cred, (String)"Out=(\\d+)");
            Integer code = Integer.valueOf(rawCode);
            this.eventsToCode.put(event, code);
            return code;
        }
        catch (Exception e) {
            throw new UtilsException("Errore nella risoluzione del campo eventi_gestione della transazione, id={" + o + "}: " + e.getMessage(), (Throwable)e);
        }
    }

    public byte[] generateCsv(Date tracingDate, List<Map<String, Object>> data) throws UtilsException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(CSV_HEADERS).build();
        Format format = new Format();
        format.setSkipEmptyRecord(false);
        format.setCsvFormat(csvFormat);
        Printer printer = new Printer(format, (OutputStream)os);
        for (Map<String, Object> row : data) {
            String purposeId = row.get(Transazione.model().TOKEN_PURPOSE_ID.getFieldName()).toString();
            String tokenId = row.get(Transazione.model().TOKEN_ID.getFieldName()).toString();
            Integer status = this.convertEventToInteger(row.get(Transazione.model().EVENTI_GESTIONE.getFieldName()));
            String requestsCount = row.get(REQUESTS_COUNT_ID).toString();
            printer.printRecord(new Object[]{this.dataTracciamentoFormat(tracingDate), purposeId, status, tokenId, requestsCount});
            printer.printComment("commento");
        }
        printer.close();
        return os.toByteArray();
    }

    private boolean createRecord(Date tracingDate, PdndTracciamentoSoggetto soggettoEntry, List<Map<String, Object>> dataNonAggregati) {
        List<Map<String, Object>> data = null;
        try {
            data = this.aggregateData(dataNonAggregati);
        }
        catch (UtilsException e) {
            String dataTracciamento = this.dataTracciamentoFormat(tracingDate);
            this.logger.error("Errore nell'aggregare il csv per il soggetto {} (idPorta: {}), data tracciamento: {}", new Object[]{soggettoEntry.getIdSoggetto().getNome(), soggettoEntry.getIdSoggetto().getCodicePorta(), dataTracciamento, e});
            return false;
        }
        byte[] csv = null;
        try {
            csv = this.generateCsv(tracingDate, data);
        }
        catch (UtilsException e) {
            String dataTracciamento = this.dataTracciamentoFormat(tracingDate);
            this.logger.error("Errore nel generare il csv per il soggetto {} (idPorta: {}), data tracciamento: {}", new Object[]{soggettoEntry.getIdSoggetto().getNome(), soggettoEntry.getIdSoggetto().getCodicePorta(), dataTracciamento, e});
            return false;
        }
        Date endTraceDate = this.truncDate(this.incrementDate(tracingDate));
        StatistichePdndTracing entry = new StatistichePdndTracing();
        Date now = DateManager.getDate();
        entry.setDataRegistrazione(now);
        entry.setDataTracciamento(tracingDate);
        entry.setCsv(csv);
        entry.setPddCodice(soggettoEntry.getIdSoggetto().getCodicePorta());
        entry.setHistory(0);
        entry.setMethod(endTraceDate.before(this.truncDate(now)) ? PdndMethods.RECOVER : PdndMethods.SUBMIT);
        entry.setStatoPdnd(PossibiliStatiPdnd.WAITING);
        try {
            this.statisticheSM.getStatistichePdndTracingService().create((Object)entry);
        }
        catch (NotImplementedException | ServiceException e) {
            String dataTracciamento = this.dataTracciamentoFormat(tracingDate);
            this.logger.error("Errore nel inserire il csv sul database per il soggetto {} (idPorta: {}), data tracciamento: {}", new Object[]{soggettoEntry.getIdSoggetto().getNome(), soggettoEntry.getIdSoggetto().getCodicePorta(), dataTracciamento, e});
            return false;
        }
        return true;
    }

    public List<Map<String, Object>> aggregateData(List<Map<String, Object>> data) throws UtilsException {
        String PURPOSE_ID = Transazione.model().TOKEN_PURPOSE_ID.getFieldName();
        String TOKEN_ID = Transazione.model().TOKEN_ID.getFieldName();
        String STATUS_ID = Transazione.model().EVENTI_GESTIONE.getFieldName();
        LinkedHashMap<GroupKey, Long> acc = new LinkedHashMap<GroupKey, Long>();
        for (Map<String, Object> row : data) {
            String purposeId = row.get(PURPOSE_ID).toString();
            String tokenId = row.get(TOKEN_ID).toString();
            Integer status = this.convertEventToInteger(row.get(STATUS_ID));
            long requestsCount = PdndGenerazioneTracciamento.asLong(row.get(REQUESTS_COUNT_ID));
            GroupKey key = new GroupKey(purposeId, tokenId, status);
            acc.merge(key, requestsCount, Long::sum);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(acc.size());
        for (Map.Entry e : acc.entrySet()) {
            GroupKey k = (GroupKey)e.getKey();
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            m.put(PURPOSE_ID, k.purposeId);
            m.put(TOKEN_ID, k.tokenId);
            m.put(STATUS_ID, k.status);
            m.put(REQUESTS_COUNT_ID, e.getValue());
            result.add(m);
        }
        return result;
    }

    private static long asLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        String s = String.valueOf(o).trim();
        if (s.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            try {
                return new BigDecimal(s).longValue();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Valore non numerico per request_count: " + o);
            }
        }
    }

    private List<Map<String, Object>> aggregateTransactions(Date start, Date end, String ... pddCode) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IExpression expr = this.transazioniSM.getTransazioneService().newExpression();
        expr.addGroupBy(Transazione.model().PDD_CODICE).addGroupBy(Transazione.model().TOKEN_PURPOSE_ID).addGroupBy(Transazione.model().TOKEN_ID).addGroupBy(Transazione.model().EVENTI_GESTIONE).and().between(Transazione.model().DATA_INGRESSO_RICHIESTA, (Object)start, (Object)end).isNotNull(Transazione.model().PDD_CODICE).isNotNull(Transazione.model().TOKEN_PURPOSE_ID).isNotNull(Transazione.model().TOKEN_ID).isNotNull(Transazione.model().EVENTI_GESTIONE).equals(Transazione.model().PROTOCOLLO, (Object)"modipa");
        if (!this.config.isPdndTracciamentoFruizioniEnabled()) {
            expr.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.DELEGATA);
        }
        if (!this.config.isPdndTracciamentoErogazioniEnabled()) {
            expr.notEquals(Transazione.model().PDD_RUOLO, (Object)PddRuolo.APPLICATIVA);
        }
        if (pddCode != null && pddCode.length > 0) {
            if (pddCode.length == 1) {
                expr.equals(Transazione.model().PDD_CODICE, (Object)pddCode[0]);
            } else {
                expr.in(Transazione.model().PDD_CODICE, Arrays.asList(pddCode));
            }
        }
        FunctionField countFunction = new FunctionField(Transazione.model().ID_TRANSAZIONE, Function.COUNT, REQUESTS_COUNT_ID);
        try {
            return this.transazioniSM.getTransazioneService().groupBy(expr, new FunctionField[]{countFunction});
        }
        catch (NotFoundException e) {
            return List.of();
        }
    }

    private boolean createRecords(Date start, Date end, Set<String> ignorePdd) throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        List<Map<String, Object>> groups = this.aggregateTransactions(start, end, new String[0]);
        String dataTracciamento = this.dataTracciamentoFormat(start);
        boolean errors = false;
        Map<String, List<Map<String, Object>>> recordRaggruppatiPerPddCodice = groups.stream().collect(Collectors.groupingBy(row -> (String)row.get(Transazione.model().PDD_CODICE.getFieldName())));
        for (PdndTracciamentoSoggetto soggettoEntry : this.internalPddCodes.getSoggetti()) {
            String pddCode = soggettoEntry.getIdSoggetto().getCodicePorta();
            String nomeSoggetto = soggettoEntry.getIdSoggetto().getNome();
            List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
            if (ignorePdd.contains(pddCode)) {
                this.logger.info("Tracciato [{}] gi\u00e0 presente per il soggetto: {} aggregati: {}, non genero", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
                continue;
            }
            ArrayList<String> pddCodici = new ArrayList<String>();
            pddCodici.add(pddCode);
            pddCodici.addAll(soggettiAggregati);
            List<Map<String, Object>> rowsAggregati = this.aggregaRecordPddCodiceDifferenti(pddCodici, recordRaggruppatiPerPddCodice);
            if (this.createRecord(start, soggettoEntry, rowsAggregati)) {
                this.logger.info("Tracciato [{}] generato correttamente per il soggetto: {} aggregati: {}", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
                continue;
            }
            this.logger.info("Tracciato [{}] non generato per il soggetto: {} aggregati: {}", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            errors = true;
        }
        return !errors;
    }

    private List<Map<String, Object>> aggregaRecordPddCodiceDifferenti(List<String> pddCodici, Map<String, List<Map<String, Object>>> recordRaggruppatiPerPddCodice) {
        ArrayList<Map<String, Object>> rowsAggregati = new ArrayList<Map<String, Object>>();
        for (String pddCodiceScan : pddCodici) {
            List rows = Objects.requireNonNullElse(recordRaggruppatiPerPddCodice.get(pddCodiceScan), List.of());
            if (rows.isEmpty()) continue;
            rowsAggregati.addAll(rows);
        }
        return rowsAggregati;
    }

    public void scanNull() throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IPaginatedExpression expr = this.statisticheSM.getStatistichePdndTracingService().newPaginatedExpression();
        expr.isNull(StatistichePdndTracing.model().CSV);
        this.logger.info("Cerco tracciati vuoti ...");
        List stats = null;
        try {
            stats = this.statisticheSM.getStatistichePdndTracingService().findAll(expr);
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotFoundException || e instanceof NotFoundException) {
                this.logger.info("Non sono stati trovati tracciati vuoti");
                return;
            }
            throw new ServiceException("Non sono stati trovati tracciati vuoti per via di un'anomalia: " + e.getMessage(), (Throwable)e);
        }
        this.logger.info("Sono stati trovati {} tracciati vuoti, procedo a valorizzarli", (Object)stats.size());
        for (StatistichePdndTracing stat : stats) {
            PdndTracciamentoSoggetto soggettoEntry = this.internalPddCodes.getInfoByIdentificativoPorta(stat.getPddCodice(), true, false);
            List<String> soggettiAggregati = PdndTracciamentoUtils.getNomiSoggettiAggregati(soggettoEntry);
            ArrayList<String> pddCodici = new ArrayList<String>();
            pddCodici.add(soggettoEntry.getIdSoggetto().getCodicePorta());
            pddCodici.addAll(soggettiAggregati);
            String nomeSoggetto = soggettoEntry.getIdSoggetto().getNome();
            String dataTracciamento = this.dataTracciamentoFormat(stat.getDataTracciamento());
            Date startTracing = stat.getDataTracciamento();
            Date endTracing = this.truncDate(this.incrementDate(startTracing));
            this.logger.info("Tracciato [{}] vuoto del soggetto: {} aggregati: {}, valorizzazione in corso ...", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            try {
                List<Map<String, Object>> data = this.aggregateTransactions(startTracing, endTracing, pddCodici.toArray(new String[1]));
                stat.setCsv(this.generateCsv(startTracing, data));
                this.statisticheSM.getStatistichePdndTracingService().update((Object)stat);
                this.logger.info("Tracciato [{}] del soggetto: {} aggregati: {} valorizzato correttamente", new Object[]{dataTracciamento, nomeSoggetto, soggettiAggregati});
            }
            catch (Exception e) {
                this.logger.error("Errore nell'update della statistica con csv null, tracingDate: {}, codice pdd: {}", new Object[]{this.dataTracciamentoFormat(startTracing), stat.getPddCodice(), e});
            }
        }
    }

    private Map<Date, Set<String>> getAlreadyExistsPddRecords(Date lastDate) throws NotImplementedException, ServiceException {
        Map<Date, Set<String>> ignorePddCodes = null;
        try {
            IPaginatedExpression expr = this.statisticheSM.getStatistichePdndTracingService().newPaginatedExpression();
            expr.greaterEquals(StatistichePdndTracing.model().DATA_TRACCIAMENTO, (Object)lastDate);
            expr.equals(StatistichePdndTracing.model().HISTORY, (Object)0);
            List stats = this.statisticheSM.getStatistichePdndTracingService().findAll(expr);
            ignorePddCodes = stats.stream().collect(Collectors.toMap(StatistichePdndTracing::getDataTracciamento, o -> {
                HashSet<String> baseSet = new HashSet<String>();
                baseSet.add(o.getPddCodice());
                return baseSet;
            }, (o1, o2) -> {
                o1.addAll(o2);
                return o1;
            }));
        }
        catch (Exception e) {
            if (e.getCause() instanceof NotFoundException || e instanceof NotFoundException) {
                ignorePddCodes = Map.of();
            }
            throw new ServiceException("Impossibile ottenere record tracciati PDND gi\u00e0 presenti", (Throwable)e);
        }
        if (!ignorePddCodes.isEmpty()) {
            this.logger.warn("Attenzione alcuni tracciati sono gia presenti nel db per questo intervallo temporale, non li rigenero: {}", ignorePddCodes);
        }
        return ignorePddCodes;
    }

    private Date getLastTracingDate(Date currDate) throws ServiceException {
        Date lastDate = null;
        try {
            lastDate = StatisticsInfoUtils.readDataUltimaGenerazioneStatistiche(this.statisticheSM.getStatisticaInfoServiceSearch(), TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, this.config.getLogSql());
        }
        catch (NotFoundException e) {
            lastDate = new Date(0L);
        }
        catch (NotImplementedException | ServiceException e) {
            throw new ServiceException(e);
        }
        if (lastDate.equals(new Date(0L))) {
            lastDate = this.incrementDate(currDate);
        }
        return this.truncDate(lastDate);
    }

    public void scanDates() throws NotImplementedException, ServiceException {
        Date nextDate = null;
        Date lastNoErrorDate = null;
        int delayMinutes = this.config.getPdndTracciamentoGenerazioneDelayMinutes();
        Date now = DateManager.getDate();
        if (delayMinutes > 0) {
            now = new Date(now.getTime() - (long)(delayMinutes * 60 * 1000));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Attivo offset delay '{}', nuova 'now date' {}", (Object)delayMinutes, (Object)DateUtils.getSimpleDateFormatMs().format(now));
            }
        }
        Date currDate = this.truncDate(now);
        Date lastDate = this.getLastTracingDate(currDate);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Verifico esistenza csv gi\u00e0 generati per la data {}", (Object)this.dataTracciamentoFormat(lastDate));
        }
        Map<Date, Set<String>> ignorePddCodes = this.getAlreadyExistsPddRecords(lastDate);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Intervallo di generazione PDND tracciamento {} -> {}", (Object)this.dataTracciamentoFormat(lastDate), (Object)this.dataTracciamentoFormat(currDate));
        }
        while (lastDate.before(currDate)) {
            block8: {
                nextDate = this.truncDate(this.incrementDate(lastDate));
                try {
                    if (!this.createRecords(lastDate, nextDate, ignorePddCodes.getOrDefault(lastDate, Set.of())) && lastNoErrorDate == null) {
                        lastNoErrorDate = lastDate;
                    }
                }
                catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
                    this.logger.error("Errore nella generazione dei tracciamenti PDND per il range [{},{}(", new Object[]{this.dataTracciamentoFormat(lastDate), this.dataTracciamentoFormat(nextDate), e});
                    if (lastNoErrorDate != null) break block8;
                    lastNoErrorDate = lastDate;
                }
            }
            lastDate = nextDate;
        }
        this.scanDatesUpdateDataUltimaGenerazione(lastNoErrorDate, currDate);
    }

    private void scanDatesUpdateDataUltimaGenerazione(Date lastNoErrorDate, Date currDate) throws NotImplementedException, ServiceException {
        if (lastNoErrorDate == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiornamento data ultima generazione alla data corrente: {}", (Object)this.dataTracciamentoFormat(currDate));
            }
            lastNoErrorDate = currDate;
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("A causa di errori per la generazione di data: {}, la data di ultima generazione sar\u00e0 impostata a tale data", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
        }
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiorno data ultima generazione statistiche {} ...", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
            }
            StatisticsInfoUtils.updateDataUltimaGenerazioneStatistiche(this.statisticheSM.getStatisticaInfoServiceSearch(), this.statisticheSM.getStatisticaInfoService(), TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, this.config.getLogSql(), lastNoErrorDate);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Aggiorno daa ultima generazione statistiche {} completato", (Object)this.dataTracciamentoFormat(lastNoErrorDate));
            }
        }
        catch (Exception e) {
            this.logger.error("Errore nell'aggiornamento della data ultima statistica {}", (Object)TipoIntervalloStatistico.PDND_GENERAZIONE_TRACCIAMENTO, (Object)e);
        }
    }

    @Override
    public void generate() throws StatisticsEngineException {
        this.logger.info("********************* INIZIO GENERAZIONE TRACCIATO PDND *********************");
        try {
            this.scanDates();
        }
        catch (NotImplementedException | ServiceException e) {
            throw new StatisticsEngineException(e);
        }
        try {
            this.scanNull();
        }
        catch (ExpressionException | ExpressionNotImplementedException | NotImplementedException | ServiceException e) {
            throw new StatisticsEngineException(e);
        }
        this.logger.info("********************* FINE GENERAZIONE TRACCIATO PDND *********************");
    }

    @Override
    public boolean isEnabled(StatisticsConfig config) {
        return config.isPdndTracciamentoGenerazione();
    }

    private String dataTracciamentoFormat(Date date) {
        return new SimpleDateFormat(PDND_DATE_FORMAT).format(date);
    }

    private static final class GroupKey {
        final String purposeId;
        final String tokenId;
        final Integer status;

        GroupKey(String purposeId, String tokenId, Integer status) {
            this.purposeId = purposeId;
            this.tokenId = tokenId;
            this.status = status;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof GroupKey)) {
                return false;
            }
            GroupKey other = (GroupKey)obj;
            return Objects.equals(this.purposeId, other.purposeId) && Objects.equals(this.tokenId, other.tokenId) && Objects.equals(this.status, other.status);
        }

        public int hashCode() {
            return Objects.hash(this.purposeId, this.tokenId, this.status);
        }
    }
}

