/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.engine.transaction;

import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.monitor.engine.config.BasicServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibraryReader;
import org.openspcoop2.monitor.engine.transaction.TransactionLibrary;
import org.openspcoop2.monitor.engine.transaction.TransactionManager;
import org.openspcoop2.monitor.sdk.plugins.ITransactionProcessing;
import org.openspcoop2.monitor.sdk.transaction.Transaction;
import org.slf4j.Logger;

public class TransactionProcessorThread
implements Runnable {
    private List<String> idTransazioni;
    private Logger log;
    private BasicServiceLibraryReader basicServiceLibraryReader;
    private TransactionServiceLibraryReader transactionServiceLibraryReader;
    private DAOFactory daoFactory;
    private int threadNumber;
    private boolean finished = false;
    private boolean debug;
    private Date lastDateTransaction;
    private String error;

    public TransactionProcessorThread(List<String> idTransazioni, Logger log, BasicServiceLibraryReader basicServiceLibraryReader, TransactionServiceLibraryReader transactionServiceLibraryReader, DAOFactory daoFactory, int threadNumber, boolean debug) {
        this.idTransazioni = idTransazioni;
        this.log = log;
        this.basicServiceLibraryReader = basicServiceLibraryReader;
        this.transactionServiceLibraryReader = transactionServiceLibraryReader;
        this.daoFactory = daoFactory;
        this.threadNumber = threadNumber;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String identificativo = null;
        try {
            for (int i = 0; i < this.idTransazioni.size(); ++i) {
                String idTransazione = this.idTransazioni.get(i);
                Transaction transaction = TransactionManager.getTransaction(this.daoFactory, this.log, idTransazione, this.debug);
                identificativo = idTransazione + "-(#T-" + this.threadNumber + " #M-" + (i + 1) + ")";
                if (this.debug) {
                    this.log.debug("[" + identificativo + "] Check Transazione [" + i + "]=[" + idTransazione + "] ...");
                }
                IDServizio idServizio = null;
                if (transaction.getTransaction().getTipoSoggettoErogatore() != null && transaction.getTransaction().getNomeSoggettoErogatore() != null && transaction.getTransaction().getTipoServizio() != null && transaction.getTransaction().getNomeServizio() != null) {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(transaction.getTransaction().getTipoServizio(), transaction.getTransaction().getNomeServizio(), transaction.getTransaction().getTipoSoggettoErogatore(), transaction.getTransaction().getNomeSoggettoErogatore(), transaction.getTransaction().getVersioneServizio());
                    idServizio.setAzione(transaction.getTransaction().getAzione());
                }
                if (idServizio != null) {
                    TransactionServiceLibrary transactionServiceLibrary;
                    block16: {
                        if (this.debug) {
                            this.log.debug("[" + identificativo + "] Search and Apply plugins SDK for idService[" + idServizio.toString() + "] ...");
                        }
                        transactionServiceLibrary = null;
                        try {
                            transactionServiceLibrary = TransactionLibrary.getTransactionServiceLibrary(idServizio, this.basicServiceLibraryReader, this.transactionServiceLibraryReader, this.log);
                        }
                        catch (NotFoundException notFound) {
                            if (!this.debug) break block16;
                            this.log.debug("[" + identificativo + "] Library not found: " + notFound.getMessage(), (Throwable)notFound);
                        }
                    }
                    if (transactionServiceLibrary != null) {
                        List<ITransactionProcessing> listPlugins = transactionServiceLibrary.mergeServiceActionTransactionLibrary_sdkPlugins(this.log);
                        if (listPlugins != null && listPlugins.size() > 0) {
                            for (ITransactionProcessing iTransactionProcessing : listPlugins) {
                                if (this.debug) {
                                    this.log.debug("[" + identificativo + "] Applico plugin [" + iTransactionProcessing.getClass().getName() + "] per la transazione " + transaction.getIdTransazione() + " ...");
                                }
                                iTransactionProcessing.postProcessTransaction(transaction);
                                if (!this.debug) continue;
                                this.log.info("[" + identificativo + "] Applicato plugin [" + iTransactionProcessing.getClass().getName() + "] per la transazione " + transaction.getIdTransazione());
                            }
                        }
                        TransactionManager.updateContentResources(transaction);
                    }
                }
                this.lastDateTransaction = transaction.getTransaction().getDataIngressoRichiesta();
                if (!this.debug) continue;
                this.log.debug("[" + identificativo + "] Check Transazione [" + i + "]=[" + idTransazione + "] ...");
            }
            this.log.info("Thread #" + this.threadNumber + " finished");
        }
        catch (Exception e) {
            String msg = "Thread #" + this.threadNumber + " finished with error (id in corso di gestione: " + identificativo + "): " + e.getMessage();
            this.log.error(msg, (Throwable)e);
            this.error = msg;
        }
        finally {
            this.finished = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Date getLastDateTransaction() {
        return this.lastDateTransaction;
    }

    public String getError() {
        return this.error;
    }
}

