/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.security.SecurityException;

public class CRLCertstore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private org.openspcoop2.utils.certificate.CRLCertstore crl = null;

    public CRLCertstore(String crlPaths) throws SecurityException {
        this(crlPaths, null);
    }

    public CRLCertstore(String crlPaths, Map<String, byte[]> localResources) throws SecurityException {
        ArrayList<String> crlPathsList = null;
        if (localResources != null && localResources.containsKey(crlPaths)) {
            crlPathsList = new ArrayList<String>();
            crlPathsList.add(crlPaths);
        } else {
            crlPathsList = org.openspcoop2.utils.certificate.CRLCertstore.readCrlPaths((String)crlPaths);
        }
        try {
            this.initEngine(crlPathsList, localResources);
        }
        catch (Exception t) {
            throw new SecurityException(t.getMessage(), t);
        }
    }

    public CRLCertstore(List<String> crlPaths) throws SecurityException {
        this(crlPaths, null);
    }

    public CRLCertstore(List<String> crlPaths, Map<String, byte[]> localResources) throws SecurityException {
        try {
            this.initEngine(crlPaths, localResources);
        }
        catch (Exception t) {
            throw new SecurityException(t.getMessage(), t);
        }
    }

    private void initEngine(List<String> crlPaths, Map<String, byte[]> localResources) throws SecurityException {
        try {
            this.crl = new org.openspcoop2.utils.certificate.CRLCertstore(crlPaths, localResources);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public CertificateFactory getCertFactory() throws SecurityException {
        try {
            return this.crl.getCertFactory();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public List<X509CRL> getCaCrls() throws SecurityException {
        try {
            return this.crl.getCaCrls();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public CertStore getCertStore() throws SecurityException {
        try {
            return this.crl.getCertStore();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public org.openspcoop2.utils.certificate.CRLCertstore getWrappedCRLCertStore() {
        return this.crl;
    }
}

