/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.FixTrustAnchorsNotEmpty;
import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.hsm.HSMManager;

public class MerlinTruststore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient org.openspcoop2.utils.certificate.KeyStore ks = null;
    private byte[] ksBytes;
    private String tipoStore = null;
    private String pathStore = null;
    private String passwordStore = null;
    private boolean hsm;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("TrustStore (").append(this.tipoStore).append(") ").append(this.pathStore);
        return bf.toString();
    }

    public MerlinTruststore(String propertyFilePath) throws SecurityException {
        Properties propStore = StoreUtils.readProperties("PropertyFilePath", propertyFilePath);
        this.initMerlinTruststoreEngine(propStore);
    }

    public MerlinTruststore(Properties propStore) throws SecurityException {
        this.initMerlinTruststoreEngine(propStore);
    }

    private void initMerlinTruststoreEngine(Properties propStore) throws SecurityException {
        try {
            if (propStore == null) {
                throw new SecurityException("Properties per lo Store non indicato");
            }
            this.tipoStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            this.tipoStore = this.tipoStore != null ? this.tipoStore.trim() : KeyStore.getDefaultType();
            this.pathStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.file");
            this.passwordStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            this.init();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public MerlinTruststore(String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        this.pathStore = pathStore;
        this.tipoStore = tipoStore;
        this.passwordStore = passwordStore;
        this.init();
    }

    public MerlinTruststore(byte[] bytesKeystore, String tipoStore, String passwordStore) throws SecurityException {
        this.ksBytes = bytesKeystore;
        this.tipoStore = tipoStore;
        this.passwordStore = passwordStore;
        this.init();
    }

    private void init() throws SecurityException {
        try {
            HSMManager hsmManager;
            if (this.tipoStore == null) {
                throw new SecurityException("Tipo dello Store non indicato");
            }
            if (this.passwordStore == null) {
                boolean required = true;
                if (KeystoreType.JKS.isType(this.tipoStore)) {
                    required = DBUtils.isTruststoreJksPasswordRequired();
                } else if (KeystoreType.PKCS12.isType(this.tipoStore)) {
                    required = DBUtils.isTruststorePkcs12PasswordRequired();
                }
                if (required) {
                    throw new SecurityException("Password dello Store non indicata");
                }
            }
            if ((hsmManager = HSMManager.getInstance()) != null) {
                this.hsm = hsmManager.existsKeystoreType(this.tipoStore);
            }
            if (!this.hsm) {
                if (this.ksBytes == null && this.pathStore == null) {
                    throw new SecurityException("Path per lo Store non indicato");
                }
                if (this.ksBytes == null) {
                    this.ksBytes = StoreUtils.readContent("Path", this.pathStore);
                }
            }
            this.initKS();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public boolean isHsm() {
        return this.hsm;
    }

    private void checkInit() throws SecurityException {
        if (this.ks == null) {
            this.initKS();
        }
    }

    private synchronized void initKS() throws SecurityException {
        if (this.ks == null) {
            try {
                if (this.hsm) {
                    this.ks = HSMManager.getInstance().getKeystore(this.tipoStore);
                } else {
                    this.ks = new org.openspcoop2.utils.certificate.KeyStore(this.ksBytes, this.tipoStore, this.passwordStore);
                    FixTrustAnchorsNotEmpty.addCertificate(this.ks.getKeystore());
                }
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public Certificate getCertificate(String alias) throws SecurityException {
        if (alias == null) {
            throw new SecurityException("Alias non fornito");
        }
        this.checkInit();
        try {
            return this.ks.getCertificate(alias);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public org.openspcoop2.utils.certificate.KeyStore getTrustStore() throws SecurityException {
        this.checkInit();
        try {
            return this.ks;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public String getTipoStore() {
        return this.tipoStore;
    }

    public String getPathStore() {
        return this.pathStore;
    }

    public String getPasswordStore() {
        return this.passwordStore;
    }
}

