/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import javax.crypto.SecretKey;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.SecretPasswordKeyDerivationConfig;
import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.certificate.SymmetricKeyUtils;
import org.openspcoop2.utils.certificate.byok.BYOKCostanti;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.EncryptOpenSSLPassPBKDF2;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class SecretKeyStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String secretKeyPath;
    private byte[] secretKeyContent;
    private transient SecretKey secretKey;
    private String algorithm;
    private byte[] iv;
    private byte[] salt;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("SecretKeyStore (public:").append(this.secretKeyPath).append(")");
        return bf.toString();
    }

    public SecretKeyStore(String secretKeyPath, String algorithm) throws SecurityException {
        this(secretKeyPath, algorithm, null);
    }

    public SecretKeyStore(String secretKeyPath, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        this.secretKeyPath = secretKeyPath;
        this.algorithm = algorithm == null ? "AES" : algorithm;
        this.secretKeyContent = StoreUtils.readContent("SecretKey", this.secretKeyPath);
        this.secretKeyContent = StoreUtils.unwrapBYOK(this.secretKeyContent, requestParams);
    }

    public SecretKeyStore(byte[] secretKey, String algorithm) throws SecurityException {
        this(secretKey, algorithm, null);
    }

    public SecretKeyStore(byte[] secretKey, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        try {
            if (secretKey == null) {
                throw new SecurityException("Store publicKey undefined");
            }
            this.secretKeyContent = secretKey;
            this.secretKeyContent = StoreUtils.unwrapBYOK(this.secretKeyContent, requestParams);
            this.algorithm = algorithm == null ? "AES" : algorithm;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public SecretKeyStore(SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig) throws SecurityException {
        this(passwordKeyDerivationConfig, null);
    }

    public SecretKeyStore(SecretPasswordKeyDerivationConfig passwordKeyDerivationConfig, BYOKRequestParams requestParams) throws SecurityException {
        try {
            if (passwordKeyDerivationConfig == null) {
                throw new SecurityException("Password Key Derivation config undefined");
            }
            if (passwordKeyDerivationConfig.getPasswordEncryptionMode() == null) {
                throw new SecurityException("Password Key Derivation mode undefined");
            }
            if (passwordKeyDerivationConfig.getPassword() == null) {
                throw new SecurityException("Password Key Derivation undefined");
            }
            String pwd = null;
            pwd = requestParams != null ? new String(StoreUtils.unwrapBYOK(passwordKeyDerivationConfig.getPassword().getBytes(), requestParams)) : passwordKeyDerivationConfig.getPassword();
            if (!BYOKCostanti.isOpenSSLPasswordDerivationKeyMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode())) {
                throw new SecurityException("Password Key Derivation mode '" + passwordKeyDerivationConfig.getPasswordEncryptionMode() + "' unsupported");
            }
            CipherInfo cipherInfo = null;
            cipherInfo = BYOKCostanti.isOpenSSLPBKDF2PasswordDerivationKeyMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()) ? EncryptOpenSSLPassPBKDF2.buildCipherInfo((String)pwd, (Integer)passwordKeyDerivationConfig.getPasswordIterator(), (OpenSSLEncryptionMode)OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode())) : EncryptOpenSSLPass.buildCipherInfo((String)pwd, null, (OpenSSLEncryptionMode)OpenSSLEncryptionMode.toMode((String)passwordKeyDerivationConfig.getPasswordEncryptionMode()));
            this.secretKeyContent = cipherInfo.getEncodedKey();
            this.secretKey = (SecretKey)cipherInfo.getKey();
            this.algorithm = "AES";
            this.iv = cipherInfo.getIv();
            this.salt = cipherInfo.getSalt();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public SecretKey getSecretKey() throws SecurityException {
        if (this.secretKey == null) {
            this.initializeSecretKey();
        }
        return this.secretKey;
    }

    private synchronized void initializeSecretKey() throws SecurityException {
        if (this.secretKey == null) {
            try {
                this.secretKey = SymmetricKeyUtils.getInstance((String)this.algorithm).getSecretKey(this.secretKeyContent);
            }
            catch (Exception e) {
                throw new SecurityException("Load public key failed: " + e.getMessage(), e);
            }
        }
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getSalt() {
        return this.salt;
    }
}

