/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class JWKSetStoreCache
extends AbstractKeystoreCache<JWKSetStore> {
    @Override
    public JWKSetStore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        String path = key;
        if (params.length == 0) {
            return new JWKSetStore(path);
        }
        if (params.length == 1) {
            if (!(params[0] instanceof byte[]) && !(params[0] instanceof BYOKRequestParams)) {
                throw new SecurityException("Param[0] must be byte[] (store) or BYOKRequestParams");
            }
            if (params[0] instanceof byte[]) {
                byte[] store = (byte[])params[0];
                return new JWKSetStore(store);
            }
            BYOKRequestParams requestParams = (BYOKRequestParams)params[0];
            return new JWKSetStore(path, requestParams);
        }
        if (params.length == 2) {
            if (!(params[0] instanceof byte[])) {
                throw new SecurityException("Param[0] must be byte[] (store)");
            }
            if (!(params[1] instanceof BYOKRequestParams)) {
                throw new SecurityException("Param[1] must be BYOKRequestParams");
            }
            byte[] store = (byte[])params[0];
            BYOKRequestParams requestParams = (BYOKRequestParams)params[1];
            return new JWKSetStore(store, requestParams);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "JWKSet ";
    }
}

