/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class KeyPairStoreCache
extends AbstractKeystoreCache<KeyPairStore> {
    @Override
    public KeyPairStore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 3) {
            return this.createFromPath(key, params);
        }
        if (params.length == 4) {
            if (params[0] instanceof String) {
                return this.createFromPath(key, params);
            }
            return this.createFromByteArray(params);
        }
        if (params.length == 5) {
            return this.createFromByteArray(params);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    private KeyPairStore createFromPath(String key, Object ... params) throws SecurityException {
        if (params[0] instanceof String) {
            if (params[1] != null && !(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (privateKeyPassword) or null");
            }
            if (!(params[2] instanceof String)) {
                throw new SecurityException("Param[2] must be String (algorithm)");
            }
            String pathPrivateKey = key;
            String pathPublicKey = (String)params[0];
            String privateKeyPassword = (String)params[1];
            String algorithm = (String)params[2];
            if (params.length == 4) {
                if (!(params[3] instanceof BYOKRequestParams)) {
                    throw new SecurityException("Param[3] must be BYOKRequestParams");
                }
                BYOKRequestParams requestParams = (BYOKRequestParams)params[3];
                return new KeyPairStore(pathPrivateKey, pathPublicKey, privateKeyPassword, algorithm, requestParams);
            }
            return new KeyPairStore(pathPrivateKey, pathPublicKey, privateKeyPassword, algorithm);
        }
        throw new SecurityException("Param[0] must be String (pathPublicKey)");
    }

    private KeyPairStore createFromByteArray(Object ... params) throws SecurityException {
        if (params[0] instanceof byte[]) {
            if (!(params[1] instanceof byte[])) {
                throw new SecurityException("Param[1] must be byte[] (publicKey)");
            }
            if (params[2] != null && !(params[2] instanceof String)) {
                throw new SecurityException("Param[2] must be String (privateKeyPassword) or null");
            }
            if (!(params[3] instanceof String)) {
                throw new SecurityException("Param[3] must be String (algorithm)");
            }
            byte[] privateKey = (byte[])params[0];
            byte[] publicKey = (byte[])params[1];
            String privateKeyPassword = (String)params[2];
            String algorithm = (String)params[3];
            if (params.length == 5) {
                if (!(params[4] instanceof BYOKRequestParams)) {
                    throw new SecurityException("Param[4] must be BYOKRequestParams");
                }
                BYOKRequestParams requestParams = (BYOKRequestParams)params[3];
                return new KeyPairStore(privateKey, publicKey, privateKeyPassword, algorithm, requestParams);
            }
            return new KeyPairStore(privateKey, publicKey, privateKeyPassword, algorithm);
        }
        throw new SecurityException("Param[0] must be byte[] (privateKey)");
    }

    @Override
    public String getPrefixKey() {
        return "KeyPair ";
    }
}

