/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.RemoteStoreClientInfo;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;

public class RemoteStoreClientInfoCache
extends AbstractKeystoreCache<RemoteStoreClientInfo> {
    private static int clientDetailsMaxLifeMinutes = -1;
    private static int clientDetailsCacheFallbackMaxLifeMinutes = -1;
    public static final String RESTORE_STORE_CLIENT_INFO_PREFIX = "RemoteStoreClientInfo ";

    public static int getClientDetailsMaxLifeMinutes() {
        return clientDetailsMaxLifeMinutes;
    }

    public static void setClientDetailsMaxLifeMinutes(int clientDetailsMaxLifeMinutes) {
        RemoteStoreClientInfoCache.clientDetailsMaxLifeMinutes = clientDetailsMaxLifeMinutes;
    }

    public static int getClientDetailsCacheFallbackMaxLifeMinutes() {
        return clientDetailsCacheFallbackMaxLifeMinutes;
    }

    public static void setClientDetailsCacheFallbackMaxLifeMinutes(int clientDetailsCacheFallbackMaxLifeMinutes) {
        RemoteStoreClientInfoCache.clientDetailsCacheFallbackMaxLifeMinutes = clientDetailsCacheFallbackMaxLifeMinutes;
    }

    @Override
    public RemoteStoreClientInfo createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 5) {
            if (!(params[0] instanceof String)) {
                throw new SecurityException("Param[0] must be String");
            }
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String");
            }
            if (!(params[2] instanceof RemoteStoreConfig)) {
                throw new SecurityException("Param[2] must be RemoteStoreConfig");
            }
            if (!(params[3] instanceof IRemoteStoreProvider)) {
                throw new SecurityException("Param[3] must be IRemoteStoreProvider");
            }
            if (!(params[4] instanceof Map)) {
                throw new SecurityException("Param[4] must be org.openspcoop2.utils.Map");
            }
            String keyId = (String)params[0];
            String clientId = (String)params[1];
            RemoteStoreConfig remoteStoreConfig = (RemoteStoreConfig)params[2];
            IRemoteStoreProvider provider = (IRemoteStoreProvider)params[3];
            Map<Object> context = this.readMapUtils(params);
            RemoteStoreClientInfo rsci = new RemoteStoreClientInfo(keyId, clientId, remoteStoreConfig, provider, context);
            this.setCacheLifeSecond(rsci);
            return rsci;
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    private void setCacheLifeSecond(RemoteStoreClientInfo rsci) {
        if (rsci.getClientInfo() != null) {
            if (rsci.getClientInfo().isInfoComplete()) {
                if (clientDetailsMaxLifeMinutes > 0) {
                    this.updateCacheLifeSecond(clientDetailsMaxLifeMinutes * 60);
                }
            } else if (clientDetailsCacheFallbackMaxLifeMinutes > 0) {
                this.updateCacheLifeSecond(clientDetailsCacheFallbackMaxLifeMinutes * 60);
            }
        }
    }

    private Map<Object> readMapUtils(Object ... params) {
        return (Map)params[4];
    }

    @Override
    public String getPrefixKey() {
        return RESTORE_STORE_CLIENT_INFO_PREFIX;
    }

    public static String getPrefixKeyCache(RemoteStoreConfig remoteStoreConfig) throws SecurityException {
        if (remoteStoreConfig == null) {
            throw new SecurityException("RemoteStoreConfig undefined");
        }
        String remoteStoreName = remoteStoreConfig.getStoreName();
        if (remoteStoreName == null) {
            throw new SecurityException("RemoteStoreConfig name undefined");
        }
        return remoteStoreName + "_";
    }

    public static String getKeyCache(RemoteStoreConfig remoteStoreConfig, String keyId) throws SecurityException {
        if (keyId == null) {
            throw new SecurityException("KeyId undefined");
        }
        return RemoteStoreClientInfoCache.getPrefixKeyCache(remoteStoreConfig) + keyId;
    }
}

