/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message;

import java.util.Map;
import org.openspcoop2.security.message.constants.SecurityConstants;

public class MessageSecurityUtilities {
    private MessageSecurityUtilities() {
    }

    public static boolean processSOAPFault(Map<String, Object> messageSecurityProperties) {
        String propertySAMLToken;
        String propertyUsernameToken;
        String propertySignature;
        boolean processEncryptSOAPFault = false;
        boolean processSignatureSOAPFault = false;
        boolean processUsernameTokenFault = false;
        boolean processSAMLTokenFault = false;
        String propertyEncrypt = (String)messageSecurityProperties.get("encryptionSOAPFault");
        if (propertyEncrypt != null && "true".equalsIgnoreCase(propertyEncrypt)) {
            processEncryptSOAPFault = true;
        }
        if ((propertySignature = (String)messageSecurityProperties.get("signatureSOAPFault")) != null && "true".equalsIgnoreCase(propertySignature)) {
            processSignatureSOAPFault = true;
        }
        if ((propertyUsernameToken = (String)messageSecurityProperties.get("UsernameTokenSOAPFault")) != null && "true".equalsIgnoreCase(propertyUsernameToken)) {
            processUsernameTokenFault = true;
        }
        if ((propertySAMLToken = (String)messageSecurityProperties.get("SAMLTokenSOAPFault")) != null && "true".equalsIgnoreCase(propertySAMLToken)) {
            processSAMLTokenFault = true;
        }
        return MessageSecurityUtilities.processFaultEngine(messageSecurityProperties, processEncryptSOAPFault, processSignatureSOAPFault, processUsernameTokenFault, processSAMLTokenFault);
    }

    public static boolean processProblemDetails(Map<String, Object> messageSecurityProperties) {
        String propertySAMLToken;
        String propertyUsernameToken;
        String propertySignature;
        boolean processEncryptProblemDetails = false;
        boolean processSignatureProblemDetails = false;
        boolean processUsernameTokenProblemDetails = false;
        boolean processSAMLTokenProblemDetails = false;
        String propertyEncrypt = (String)messageSecurityProperties.get("encryptionProblemDetails");
        if (propertyEncrypt != null && "true".equalsIgnoreCase(propertyEncrypt)) {
            processEncryptProblemDetails = true;
        }
        if ((propertySignature = (String)messageSecurityProperties.get("signatureProblemDetails")) != null && "true".equalsIgnoreCase(propertySignature)) {
            processSignatureProblemDetails = true;
        }
        if ((propertyUsernameToken = (String)messageSecurityProperties.get("UsernameTokenProblemDetails")) != null && "true".equalsIgnoreCase(propertyUsernameToken)) {
            processUsernameTokenProblemDetails = true;
        }
        if ((propertySAMLToken = (String)messageSecurityProperties.get("SAMLTokenProblemDetails")) != null && "true".equalsIgnoreCase(propertySAMLToken)) {
            processSAMLTokenProblemDetails = true;
        }
        return MessageSecurityUtilities.processFaultEngine(messageSecurityProperties, processEncryptProblemDetails, processSignatureProblemDetails, processUsernameTokenProblemDetails, processSAMLTokenProblemDetails);
    }

    private static boolean processFaultEngine(Map<String, Object> messageSecurityProperties, boolean processEncryptFault, boolean processSignatureFault, boolean processUsernameTokenFault, boolean processSAMLTokenFault) {
        String action = (String)messageSecurityProperties.remove("action");
        String[] splitActions = action.split(" ");
        StringBuilder bfNewActions = new StringBuilder();
        for (int i = 0; i < splitActions.length; ++i) {
            String a = splitActions[i].trim();
            if (SecurityConstants.isActionEncryption(a) || SecurityConstants.isActionDecryption(a)) {
                if (!processEncryptFault) continue;
                if (bfNewActions.length() > 0) {
                    bfNewActions.append(" ");
                }
                bfNewActions.append(a);
                continue;
            }
            if ("Signature".equals(a)) {
                if (!processSignatureFault) continue;
                if (bfNewActions.length() > 0) {
                    bfNewActions.append(" ");
                }
                bfNewActions.append(a);
                continue;
            }
            if (SecurityConstants.isActionUsernameToken(a)) {
                if (!processUsernameTokenFault) continue;
                if (bfNewActions.length() > 0) {
                    bfNewActions.append(" ");
                }
                bfNewActions.append(a);
                continue;
            }
            if (SecurityConstants.isActionSAMLToken(a)) {
                if (!processSAMLTokenFault) continue;
                if (bfNewActions.length() > 0) {
                    bfNewActions.append(" ");
                }
                bfNewActions.append(a);
                continue;
            }
            if (bfNewActions.length() > 0) {
                bfNewActions.append(" ");
            }
            bfNewActions.append(a);
        }
        if (bfNewActions.length() > 0) {
            String newActions = bfNewActions.toString();
            if ("Timestamp".equals(newActions)) {
                return false;
            }
            messageSecurityProperties.put("action", newActions);
            return true;
        }
        return false;
    }
}

