/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message;

import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.RandomBasedGenerator;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.xml.security.stax.impl.util.IDGenerator;

public class WsuIdAllocator
implements org.apache.wss4j.dom.WsuIdAllocator {
    private static String secureRandomAlgorithm = null;
    private static ThreadLocal<RandomBasedGenerator> randomBasedGeneratorThreadLocal = new ThreadLocal();
    private String prefixComponent;

    public static String getSecureRandomAlgorithm() {
        return secureRandomAlgorithm;
    }

    public static void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        WsuIdAllocator.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public static RandomBasedGenerator getRandomBasedGenerator() {
        if (secureRandomAlgorithm == null) {
            return null;
        }
        RandomBasedGenerator randomGenerator = randomBasedGeneratorThreadLocal.get();
        if (randomGenerator == null) {
            try {
                randomGenerator = Generators.randomBasedGenerator((Random)SecureRandom.getInstance(secureRandomAlgorithm));
                randomBasedGeneratorThreadLocal.set(randomGenerator);
            }
            catch (Throwable t) {
                System.out.println("Inizializzazione RandomBasedGenerator fallita: " + t.getMessage());
                t.printStackTrace(System.out);
            }
        }
        return randomGenerator;
    }

    public static void removeRandomBasedGenerator() {
        if (randomBasedGeneratorThreadLocal != null) {
            randomBasedGeneratorThreadLocal.remove();
        }
    }

    public WsuIdAllocator(String prefix) {
        this.prefixComponent = prefix;
    }

    public String createId(String prefix, Object o) {
        RandomBasedGenerator generator = null;
        if (secureRandomAlgorithm != null) {
            generator = WsuIdAllocator.getRandomBasedGenerator();
        }
        if (generator != null) {
            return WsuIdAllocator._generateID(generator, prefix);
        }
        if (prefix == null) {
            return IDGenerator.generateID((String)this.prefixComponent);
        }
        return IDGenerator.generateID((String)(this.prefixComponent + prefix));
    }

    public String createSecureId(String prefix, Object o) {
        RandomBasedGenerator generator = null;
        if (secureRandomAlgorithm != null) {
            generator = WsuIdAllocator.getRandomBasedGenerator();
        }
        if (generator != null) {
            return WsuIdAllocator._generateID(generator, prefix);
        }
        if (prefix == null) {
            return IDGenerator.generateID((String)this.prefixComponent);
        }
        return IDGenerator.generateID((String)(this.prefixComponent + prefix));
    }

    private static String _generateID(RandomBasedGenerator generator, String prefix) {
        String id = generator.generate().toString();
        if (prefix != null) {
            return prefix + id;
        }
        return "G" + id;
    }
}

