/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.constants;

import org.openspcoop2.generic_project.exception.NotFoundException;

public enum EncryptionKeyTransportAlgorithm {
    RSA_OAEP("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"),
    RSA_OAEP_11("http://www.w3.org/2009/xmlenc11#rsa-oaep"),
    RSA_v1dot5("http://www.w3.org/2001/04/xmlenc#rsa-1_5"),
    DIFFIE_HELLMAN("http://www.w3.org/2001/04/xmlenc#dh");

    private String uri;

    private EncryptionKeyTransportAlgorithm(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static EncryptionKeyTransportAlgorithm toEnumConstant(String uri) {
        try {
            return EncryptionKeyTransportAlgorithm.toEnumConstant(uri, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static EncryptionKeyTransportAlgorithm toEnumConstant(String uri, boolean throwNotFoundException) throws NotFoundException {
        EncryptionKeyTransportAlgorithm res = null;
        for (EncryptionKeyTransportAlgorithm tmp : EncryptionKeyTransportAlgorithm.values()) {
            if (!tmp.getUri().equals(uri)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with uri [" + uri + "] not found");
        }
        return res;
    }
}

