/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.engine.MessageSecurityReceiver;
import org.openspcoop2.security.message.engine.MessageSecurityReceiver_impl;
import org.openspcoop2.security.message.engine.MessageSecuritySender;
import org.openspcoop2.security.message.engine.MessageSecuritySender_impl;
import org.openspcoop2.utils.Map;

public class MessageSecurityContext_impl
extends MessageSecurityContext {
    private MessageSecurityReceiver receiver;
    private MessageSecuritySender sender;

    public MessageSecurityContext_impl(MessageSecurityContextParameters messageSecurityContextParameters) {
        super(messageSecurityContextParameters);
    }

    @Override
    public boolean processIncoming(OpenSPCoop2Message message, Busta busta, Map<Object> ctx) {
        this.receiver = new MessageSecurityReceiver_impl(this);
        boolean result = this.receiver.process(message, busta, ctx);
        if (!result) {
            if (ctx != null) {
                if (MessageRole.REQUEST.equals((Object)message.getMessageRole())) {
                    ctx.put(Costanti.ERRORE_SICUREZZA_MESSAGGIO_RICHIESTA, (Object)"true");
                } else {
                    ctx.put(Costanti.ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA, (Object)"true");
                }
            }
            this.codiceErrore = this.receiver.getCodiceErrore();
            this.msgErrore = this.receiver.getMsgErrore();
            this.listaSubCodiceErrore = this.receiver.getListaSubCodiceErrore();
        }
        return result;
    }

    @Override
    public boolean processOutgoing(OpenSPCoop2Message message, Map<Object> ctx) {
        this.sender = new MessageSecuritySender_impl(this);
        boolean result = this.sender.process(message, ctx);
        if (!result) {
            if (ctx != null) {
                if (MessageRole.REQUEST.equals((Object)message.getMessageRole())) {
                    ctx.put(Costanti.ERRORE_SICUREZZA_MESSAGGIO_RICHIESTA, (Object)"true");
                } else {
                    ctx.put(Costanti.ERRORE_SICUREZZA_MESSAGGIO_RISPOSTA, (Object)"true");
                }
            }
            this.codiceErrore = this.sender.getCodiceErrore();
            this.msgErrore = this.sender.getMsgErrore();
        }
        return result;
    }

    @Override
    public String getSubject() {
        if (this.receiver != null) {
            return this.receiver.getSubject();
        }
        return null;
    }
}

