/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityUtilities;
import org.openspcoop2.security.message.engine.MessageSecuritySender;
import org.openspcoop2.utils.Map;

public class MessageSecuritySender_impl
extends MessageSecuritySender {
    protected MessageSecuritySender_impl(MessageSecurityContext messageSecurityContext) {
        super(messageSecurityContext);
    }

    @Override
    protected boolean process(OpenSPCoop2Message message, Map<Object> ctx) {
        try {
            IMessageSecuritySender senderInterface = this.messageSecurityContext.getMessageSecuritySender();
            if (ServiceBinding.SOAP.equals((Object)message.getServiceBinding()) ? (message.isFault() || message.castAsSoap().getSOAPBody().hasFault()) && !MessageSecurityUtilities.processSOAPFault(this.messageSecurityContext.getOutgoingProperties()) : ServiceBinding.REST.equals((Object)message.getServiceBinding()) && (message.isFault() || message.castAsRest().isProblemDetailsForHttpApis_RFC7807()) && !MessageSecurityUtilities.processProblemDetails(this.messageSecurityContext.getOutgoingProperties())) {
                return true;
            }
            String action = (String)this.messageSecurityContext.getOutgoingProperties().get("action");
            if (action == null || "".equals(action.trim())) {
                return true;
            }
            senderInterface.process(this.messageSecurityContext, message, ctx);
        }
        catch (Exception e) {
            String prefix = "Generatosi errore durante il processamento Message-Security(Sender): ";
            this.messageSecurityContext.getLog().error(prefix + e.getMessage(), (Throwable)e);
            this.msgErrore = prefix + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA;
            if (e instanceof SecurityException) {
                SecurityException securityException = (SecurityException)e;
                if (securityException.getMsgErrore() != null) {
                    this.msgErrore = prefix + securityException.getMsgErrore();
                }
                if (securityException.getCodiceErrore() != null) {
                    this.codiceErrore = securityException.getCodiceErrore();
                }
            }
            return false;
        }
        return true;
    }
}

