/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reference.AttachmentReference;
import org.openspcoop2.message.soap.reference.ElementReference;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageUtilities {
    public static void checkEncryptionPartElements(Map<QName, QName> notResolved, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> listaErroriInElementi) throws SecurityException {
        try {
            if (notResolved != null && !notResolved.isEmpty()) {
                for (QName expected : notResolved.keySet()) {
                    QName actualQName = notResolved.get(expected);
                    boolean found = false;
                    NodeList it = message.getSOAPPart().getElementsByTagNameNS(actualQName.getNamespaceURI(), actualQName.getLocalPart());
                    for (int j = 0; j < it.getLength() && !found; ++j) {
                        Node elementFather = it.item(j);
                        List encryptedElements = SoapUtils.getNotEmptyChildNodes((OpenSPCoop2MessageFactory)message.getFactory(), (Node)elementFather, (boolean)false);
                        for (int i = 0; i < encryptedElements.size() && !found; ++i) {
                            Node actual = (Node)encryptedElements.get(i);
                            String actualNamespaceURI = actual.getNamespaceURI();
                            String actualLocalName = actual.getLocalName();
                            String expectedNamespaceURI = expected.getNamespaceURI();
                            String expectedLocalName = expected.getLocalPart();
                            if ((actualNamespaceURI != null || expectedNamespaceURI != null) && (actualNamespaceURI == null || !actualNamespaceURI.equals(expectedNamespaceURI)) || !actualLocalName.equals(expectedLocalName)) continue;
                            found = true;
                        }
                    }
                    if (found) continue;
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(true);
                    subCodice.setMsgErrore("Expected encryption part(" + expected + ") not found");
                    subCodice.setTipo("Content");
                    subCodice.setNamespace(expected.getNamespaceURI());
                    subCodice.setName(expected.getLocalPart());
                    listaErroriInElementi.add(subCodice);
                }
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static Map<QName, QName> checkEncryptSignatureParts(MessageSecurityContext messageSecurityContext, List<Reference> elementsToClean, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> codiciErrore, QName qnameSecurity) throws SecurityException {
        Map<String, Object> properties = messageSecurityContext.getIncomingProperties();
        boolean addAttachmentIdBrackets = properties.containsKey("addAttachmentIdBrackets") ? properties.get("addAttachmentIdBrackets").equals("true") : SecurityConstants.ADD_ATTACHMENT_ID_BRACKETS_DEFAULT;
        try {
            String nome;
            String namespace;
            String tipo;
            int numAttachmentsInMsg = message.countAttachments();
            ArrayList<String> cidAttachments = new ArrayList<String>();
            if (numAttachmentsInMsg > 0) {
                Iterator itAttach = message.getAttachments();
                while (itAttach.hasNext()) {
                    AttachmentPart ap = (AttachmentPart)itAttach.next();
                    String cid = ap.getContentId();
                    if (!addAttachmentIdBrackets) {
                        cid = cid.replaceAll("(^<)|(>$)", "");
                    }
                    cidAttachments.add(cid);
                }
            }
            HashMap<QName, QName> notResolvedMap = new HashMap<QName, QName>();
            Object encryptionPartsVerify = messageSecurityContext.getIncomingProperties().get("encryptionPartsVerify");
            Object encryptionParts = messageSecurityContext.getIncomingProperties().get("encryptionParts");
            if (encryptionPartsVerify != null && "true".equalsIgnoreCase(((String)encryptionPartsVerify).trim()) && encryptionParts == null) {
                throw new SecurityException("encryptionParts non indicate");
            }
            if ((encryptionPartsVerify == null || "true".equalsIgnoreCase(((String)encryptionPartsVerify).trim())) && encryptionParts != null) {
                String[] split;
                HashMap<String, Boolean> encryptionPartsMap = new HashMap<String, Boolean>();
                HashMap<Reference, Boolean> encryptionReferenceMap = new HashMap<Reference, Boolean>();
                boolean isAllAttachmentEncrypted = false;
                int numAttachmentsEncrypted = 0;
                if (encryptionParts != null) {
                    split = ((String)encryptionParts).split(";");
                    int numElementsEncrypted = 0;
                    block7: for (int i = 0; i < split.length; ++i) {
                        boolean checked = false;
                        String[] split2 = split[i].trim().split("}");
                        tipo = split2[0].trim().substring(1);
                        if ("".equals(tipo)) {
                            tipo = "Content";
                        }
                        namespace = null;
                        nome = null;
                        boolean attach = false;
                        if (split2.length == 3) {
                            namespace = split2[1].trim().substring(1);
                            nome = split2[2].trim();
                            attach = "Attach".equals(namespace);
                        } else if ("cid:Attachments".equalsIgnoreCase(split2[1].trim())) {
                            namespace = "Attach";
                            nome = "*";
                            attach = true;
                        } else {
                            throw new Exception("Part [" + split[i] + "] with wrong format");
                        }
                        if ("Element".equals(tipo) && !attach) {
                            ++numElementsEncrypted;
                        }
                        if (nome.startsWith("{")) {
                            nome = nome.substring(1);
                        }
                        ArrayList<String> cidAttachmentsEncrypt = new ArrayList<String>();
                        if (cidAttachments != null && cidAttachments.size() > 0) {
                            cidAttachmentsEncrypt.addAll(cidAttachments);
                        }
                        for (Reference reference : elementsToClean) {
                            if (reference instanceof AttachmentReference) {
                                if (4 != reference.getType() || !"Attach".equals(namespace)) continue;
                                ++numAttachmentsEncrypted;
                                if (nome.equals("*")) {
                                    checked = true;
                                    isAllAttachmentEncrypted = true;
                                    encryptionReferenceMap.put(reference, true);
                                    encryptionPartsMap.put(split[i], checked);
                                    continue;
                                }
                                int position = -1;
                                try {
                                    position = Integer.parseInt(nome);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (position > 0) {
                                    int refPosition = -1;
                                    for (int j = 0; j < cidAttachments.size(); ++j) {
                                        if (!((String)cidAttachments.get(j)).equals(reference.getReference())) continue;
                                        refPosition = j + 1;
                                        break;
                                    }
                                    if (refPosition <= 0) continue;
                                    cidAttachmentsEncrypt.remove(refPosition - 1);
                                    checked = true;
                                    encryptionReferenceMap.put(reference, true);
                                    encryptionPartsMap.put(split[i], checked);
                                    continue block7;
                                }
                                if (!nome.equals(reference.getReference())) continue;
                                checked = true;
                                encryptionReferenceMap.put(reference, true);
                                encryptionPartsMap.put(split[i], checked);
                                continue block7;
                            }
                            ElementReference elementReference = (ElementReference)reference;
                            String localName = elementReference.getElement().getLocalName();
                            String namespaceURI = elementReference.getElement().getNamespaceURI();
                            if (1 == reference.getType()) {
                                if (!nome.equals(localName) || !namespace.equals(namespaceURI)) continue;
                                checked = "Content".equals(tipo);
                                encryptionReferenceMap.put(reference, checked);
                                encryptionPartsMap.put(split[i], checked);
                                if (!checked) continue;
                                continue block7;
                            }
                            if (2 != reference.getType() || !"Element".equals(tipo)) continue;
                            checked = true;
                            encryptionPartsMap.put(split[i], checked);
                            QName actual = new QName(namespaceURI, localName);
                            QName expected = new QName(namespace, nome);
                            boolean localPartSec = localName.equals(qnameSecurity.getLocalPart());
                            boolean namespaceURISec = namespaceURI.equals(qnameSecurity.getNamespaceURI());
                            if (localPartSec && namespaceURISec || notResolvedMap.containsKey(expected)) continue;
                            notResolvedMap.put(expected, actual);
                        }
                    }
                    int numElementsExpectedToBeEncrypted = 0;
                    for (Reference reference : elementsToClean) {
                        if (reference.getType() != 2) continue;
                        ++numElementsExpectedToBeEncrypted;
                    }
                    if (numElementsExpectedToBeEncrypted != numElementsEncrypted) {
                        SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                        subCodice.setEncrypt(true);
                        subCodice.setMsgErrore("Expected encryption {Element} " + numElementsExpectedToBeEncrypted + ", found " + notResolvedMap.size());
                        codiciErrore.add(subCodice);
                    }
                }
                if (encryptionParts != null) {
                    split = ((String)encryptionParts).split(";");
                    for (int i = 0; i < split.length; ++i) {
                        String[] split2 = split[i].trim().split("}");
                        String tipo2 = split2[0].trim().substring(1);
                        if ("".equals(tipo2)) {
                            tipo2 = "Content";
                        }
                        String namespace2 = null;
                        String nome2 = null;
                        if (split2.length == 3) {
                            namespace2 = split2[1].trim().substring(1);
                            nome2 = split2[2].trim();
                        } else if ("cid:Attachments".equalsIgnoreCase(split2[1].trim())) {
                            namespace2 = "Attach";
                            nome2 = "*";
                        } else {
                            throw new Exception("Part [" + split[i] + "] with wrong format");
                        }
                        if (nome2.startsWith("{")) {
                            nome2 = nome2.substring(1);
                        }
                        if (!"Content".equals(tipo2) || encryptionPartsMap.containsKey(split[i]) && ((Boolean)encryptionPartsMap.get(split[i])).booleanValue()) continue;
                        SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                        subCodice.setEncrypt(true);
                        subCodice.setMsgErrore("Expected encryption part(" + split[i] + ") not found");
                        subCodice.setTipo(tipo2);
                        subCodice.setNamespace(namespace2);
                        subCodice.setName(nome2);
                        codiciErrore.add(subCodice);
                    }
                }
                if (isAllAttachmentEncrypted && numAttachmentsEncrypted != numAttachmentsInMsg) {
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(true);
                    subCodice.setMsgErrore("All attachments in message (found:" + numAttachmentsInMsg + ") must be encrypted, but only " + numAttachmentsEncrypted + " appear to be encrypted");
                    subCodice.setTipo("Content");
                    subCodice.setNamespace("Attach");
                    subCodice.setName("*");
                    codiciErrore.add(subCodice);
                }
                for (Reference reference : elementsToClean) {
                    if (reference.getType() != 1 && reference.getType() != 4 || encryptionReferenceMap.containsKey(reference) && ((Boolean)encryptionReferenceMap.get(reference)).booleanValue()) continue;
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(true);
                    subCodice.setMsgErrore("Found encryption part(" + reference + ") not expected");
                    if (reference.getType() == 1) {
                        ElementReference elReference = (ElementReference)reference;
                        subCodice.setTipo("Content");
                        subCodice.setNamespace(elReference.getElement().getNamespaceURI());
                        subCodice.setName(elReference.getElement().getLocalName());
                    } else {
                        subCodice.setTipo("Content");
                        subCodice.setNamespace("Attach");
                        subCodice.setName(reference.getReference());
                    }
                    codiciErrore.add(subCodice);
                }
            }
            Object signaturePartsVerify = messageSecurityContext.getIncomingProperties().get("signaturePartsVerify");
            Object signatureParts = messageSecurityContext.getIncomingProperties().get("signatureParts");
            if (signaturePartsVerify != null && "true".equalsIgnoreCase(((String)signaturePartsVerify).trim()) && signatureParts == null) {
                throw new SecurityException("signatureParts non indicate");
            }
            if ((signaturePartsVerify == null || "true".equalsIgnoreCase(((String)signaturePartsVerify).trim())) && signatureParts != null) {
                boolean isAllAttachmentSigned = false;
                int numAttachmentsSigned = 0;
                HashMap<String, Boolean> signaturePartsMap = new HashMap<String, Boolean>();
                HashMap<Reference, Boolean> referenceMap = new HashMap<Reference, Boolean>();
                if (signatureParts != null) {
                    String[] split = ((String)signatureParts).split(";");
                    for (int i = 0; i < split.length; ++i) {
                        boolean checked = false;
                        String[] split2 = split[i].trim().split("}");
                        String tipo3 = split2[0].trim().substring(1);
                        if ("".equals(tipo3)) {
                            tipo3 = "Content";
                        }
                        String namespace3 = null;
                        String nome3 = null;
                        if (split2.length == 3) {
                            namespace3 = split2[1].trim().substring(1);
                            nome3 = split2[2].trim();
                        } else if ("cid:Attachments".equalsIgnoreCase(split2[1].trim())) {
                            namespace3 = "Attach";
                            nome3 = "*";
                        } else {
                            throw new Exception("Part [" + split[i] + "] with wrong format");
                        }
                        if (nome3.startsWith("{")) {
                            nome3 = nome3.substring(1);
                        }
                        ArrayList<String> cidAttachmentsSignature = new ArrayList<String>();
                        if (cidAttachments != null && cidAttachments.size() > 0) {
                            cidAttachmentsSignature.addAll(cidAttachments);
                        }
                        for (Reference reference : elementsToClean) {
                            if (reference instanceof AttachmentReference) {
                                if (5 != reference.getType() || !"Attach".equals(namespace3)) continue;
                                ++numAttachmentsSigned;
                                if (nome3.equals("*")) {
                                    checked = true;
                                    isAllAttachmentSigned = true;
                                    referenceMap.put(reference, true);
                                    continue;
                                }
                                int position = -1;
                                try {
                                    position = Integer.parseInt(nome3);
                                }
                                catch (Exception localName) {
                                    // empty catch block
                                }
                                if (position > 0) {
                                    int refPosition = -1;
                                    for (int j = 0; j < cidAttachments.size(); ++j) {
                                        if (!((String)cidAttachments.get(j)).equals(reference.getReference())) continue;
                                        refPosition = j + 1;
                                        break;
                                    }
                                    if (refPosition <= 0) continue;
                                    cidAttachmentsSignature.remove(refPosition - 1);
                                    checked = true;
                                    referenceMap.put(reference, true);
                                    break;
                                }
                                if (!nome3.equals(reference.getReference())) continue;
                                checked = true;
                                referenceMap.put(reference, true);
                                break;
                            }
                            ElementReference elementReference = (ElementReference)reference;
                            String localName = elementReference.getElement().getLocalName();
                            String namespaceURI = elementReference.getElement().getNamespaceURI();
                            if (3 != reference.getType() || !nome3.equals(localName) || !namespace3.equals(namespaceURI)) continue;
                            checked = "Complete".equals(tipo3) || "Content".equals(tipo3) || "Element".equals(tipo3);
                            referenceMap.put(reference, checked);
                            if (!checked) continue;
                            break;
                        }
                        signaturePartsMap.put(split[i], checked);
                    }
                }
                for (String part : signaturePartsMap.keySet()) {
                    if (((Boolean)signaturePartsMap.get(part)).booleanValue()) continue;
                    String[] split2 = part.trim().split("}");
                    tipo = split2[0].trim().substring(1);
                    if ("".equals(tipo)) {
                        tipo = "Content";
                    }
                    namespace = null;
                    nome = null;
                    if (split2.length == 3) {
                        namespace = split2[1].trim().substring(1);
                        nome = split2[2].trim();
                    } else if ("cid:Attachments".equalsIgnoreCase(split2[1].trim())) {
                        namespace = "Attach";
                        nome = "*";
                    } else {
                        throw new Exception("Part [" + part + "] with wrong format");
                    }
                    if (nome.startsWith("{")) {
                        nome = nome.substring(1);
                    }
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(false);
                    subCodice.setMsgErrore("Expected signature part(" + part + ") not found");
                    subCodice.setTipo(tipo);
                    subCodice.setNamespace(namespace);
                    subCodice.setName(nome);
                    codiciErrore.add(subCodice);
                }
                if (isAllAttachmentSigned && numAttachmentsSigned != numAttachmentsInMsg) {
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(false);
                    subCodice.setMsgErrore("All attachments in message (found:" + numAttachmentsInMsg + ") must be signed, but only " + numAttachmentsSigned + " appear to be signed");
                    subCodice.setTipo("Content");
                    subCodice.setNamespace("Attach");
                    subCodice.setName("*");
                    codiciErrore.add(subCodice);
                }
                for (Reference reference : elementsToClean) {
                    if (reference.getType() != 3 && reference.getType() != 5 || referenceMap.containsKey(reference) && ((Boolean)referenceMap.get(reference)).booleanValue()) continue;
                    SubErrorCodeSecurity subCodice = new SubErrorCodeSecurity();
                    subCodice.setEncrypt(false);
                    subCodice.setMsgErrore("Found signature part(" + reference + ") not expected");
                    if (reference.getType() == 3) {
                        ElementReference elReference = (ElementReference)reference;
                        subCodice.setTipo("Signature");
                        subCodice.setNamespace(elReference.getElement().getNamespaceURI());
                        subCodice.setName(elReference.getElement().getLocalName());
                    } else {
                        subCodice.setTipo("Content");
                        subCodice.setNamespace("Attach");
                        subCodice.setName(reference.getReference());
                    }
                    codiciErrore.add(subCodice);
                }
            }
            return notResolvedMap;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

