/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.mvc.properties.utils.MultiPropertiesUtilities;
import org.openspcoop2.security.message.jose.TrustStoreSecurityProvider;

public class SignatureReceiverProvider
extends TrustStoreSecurityProvider {
    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        String file;
        super.validate(mapProperties);
        Properties defaultP = MultiPropertiesUtilities.getDefaultProperties(mapProperties);
        Properties p = mapProperties.get("signaturePropRefId");
        if (p != null && p.size() > 0 && !p.containsKey("rs.security.keystore") && !p.containsKey("rs.security.keystore.jwkset") && (file = p.getProperty("rs.security.keystore.file")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Verifier Signature - TrustStore - File");
        }
        if ((file = defaultP.getProperty("rs.security.keystore.file.ssl")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Configurazione HTTPS (jku/x5u) - TrustStore - File");
        }
        if ((file = defaultP.getProperty("rs.security.keystore.ssl.crl")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Configurazione HTTPS (jku/x5u) - TrustStore - CRL File(s)");
        }
        if ((file = defaultP.getProperty("joseUseHeaders.truststore.file")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Validazione Certificati X.509 (x5c/x5u) - TrustStore - File");
        }
        if ((file = defaultP.getProperty("signatureCRL")) != null && StringUtils.isNotEmpty((String)file)) {
            InputValidationUtils.validateTextAreaInput((String)file, (String)"Validazione Certificati X.509 (x5c/x5u) - TrustStore - CRL File(s)");
        }
    }
}

