/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResourceBase;
import org.ajax4jsf.resource.ResourceComponent2;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.SerializableResource;

public class UserResource
extends InternetResourceBase {
    private String contentType;

    public UserResource(boolean cacheable, boolean session, String mime) {
        this.setCacheable(cacheable);
        this.setSessionAware(session);
        this.setContentType(mime);
    }

    public String getContentType(ResourceContext resourceContext) {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Object getDataToStore(FacesContext context, Object data) {
        UriData dataToStore = null;
        if (data instanceof ResourceComponent2) {
            ResourceComponent2 resource = (ResourceComponent2)data;
            dataToStore = new UriData();
            dataToStore.value = resource.getValue();
            dataToStore.createContent = UIComponentBase.saveAttachedState((FacesContext)context, (Object)resource.getCreateContentExpression());
            if (data instanceof UIComponent) {
                ValueExpression lastModified;
                UIComponent component = (UIComponent)data;
                ValueExpression expires = component.getValueExpression("expires");
                if (null != expires) {
                    dataToStore.expires = UIComponentBase.saveAttachedState((FacesContext)context, (Object)expires);
                }
                if (null != (lastModified = component.getValueExpression("lastModified"))) {
                    dataToStore.modified = UIComponentBase.saveAttachedState((FacesContext)context, (Object)lastModified);
                }
            }
        }
        return dataToStore;
    }

    public void send(ResourceContext context) throws IOException {
        UriData data = (UriData)this.restoreData(context);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != data && null != facesContext) {
            ELContext elContext = facesContext.getELContext();
            OutputStream out = context.getOutputStream();
            MethodExpression send = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.createContent);
            send.invoke(elContext, new Object[]{out, data.value});
            try {
                out.flush();
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Date getLastModified(ResourceContext resourceContext) {
        UriData data = (UriData)this.restoreData(resourceContext);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != data && null != facesContext) {
            ValueExpression binding;
            Date modified;
            ELContext elContext = facesContext.getELContext();
            if (data.modified != null && null != (modified = (Date)(binding = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.modified)).getValue(elContext))) {
                return modified;
            }
        }
        return super.getLastModified(resourceContext);
    }

    public long getExpired(ResourceContext resourceContext) {
        UriData data = (UriData)this.restoreData(resourceContext);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != data && null != facesContext) {
            ValueExpression binding;
            Date expires;
            ELContext elContext = facesContext.getELContext();
            if (data.expires != null && null != (expires = (Date)(binding = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)facesContext, (Object)data.expires)).getValue(elContext))) {
                return expires.getTime() - System.currentTimeMillis();
            }
        }
        return super.getExpired(resourceContext);
    }

    public boolean requireFacesContext() {
        return true;
    }

    public static class UriData
    implements SerializableResource {
        private static final long serialVersionUID = 1258987L;
        private Object value;
        private Object createContent;
        private Object expires;
        private Object modified;
    }
}

