/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp.tidy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.ajax4jsf.Messages;
import org.ajax4jsf.io.parser.FastHtmlParser;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.webapp.BaseXMLFilter;
import org.ajax4jsf.webapp.HtmlParser;
import org.ajax4jsf.webapp.tidy.TidyParser;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TidyXMLFilter
extends BaseXMLFilter {
    static final Log log = LogFactory.getLog(TidyXMLFilter.class);
    private Properties _tidyProperties;
    private static final int STACK_SIZE = 100;
    private ArrayStack _parsersPool = new ArrayStack(100);

    protected void reuseParser(HtmlParser parser) {
    }

    protected HtmlParser getParser(String mime, boolean isAjax, String viewId) {
        if (isAjax || mime.startsWith("text/html") || mime.startsWith("application/xhtml+xml")) {
            if (isAjax || this.isForcexml()) {
                TidyParser parser = new TidyParser(this.getTidyProperties());
                parser.setMoveElements(this.isForcexml());
                if (parser.setMime(mime)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)Messages.getMessage((String)"CREATE_JTIDY_INFO"));
                    }
                    return parser;
                }
            } else {
                return new FastHtmlParser();
            }
        }
        return null;
    }

    private Properties getTidyProperties() {
        if (null == this._tidyProperties) {
            this._tidyProperties = new Properties();
            InputStream props = null;
            try {
                props = URLToStreamHelper.urlToStreamSafe((URL)TidyXMLFilter.class.getResource("tidy.properties"));
                if (null != props) {
                    this._tidyProperties.load(props);
                }
                if (null != (props = URLToStreamHelper.urlToStreamSafe((URL)Thread.currentThread().getContextClassLoader().getResource("tidy.properties")))) {
                    this._tidyProperties.load(props);
                }
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage((String)"READING_TIDY_PROPERTIES_ERROR"), (Throwable)e);
            }
            finally {
                if (null != props) {
                    try {
                        props.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this._tidyProperties;
    }
}

