/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.TipologiaServizio;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.utils.XMLDataConverter;
import org.openspcoop2.core.registry.wsdl.RegistroOpenSPCoopUtilities;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.AbstractArchiveEngine;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.AbstractArchiveGenericProperties;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoCooperazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioComposto;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteComune;
import org.openspcoop2.protocol.sdk.archive.ArchiveAccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.archive.ArchiveActivePolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveAllarme;
import org.openspcoop2.protocol.sdk.archive.ArchiveAttributeAuthority;
import org.openspcoop2.protocol.sdk.archive.ArchiveConfigurationPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImport;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetail;
import org.openspcoop2.protocol.sdk.archive.ArchiveEsitoImportDetailConfigurazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveFruitore;
import org.openspcoop2.protocol.sdk.archive.ArchiveGruppo;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingErogazione;
import org.openspcoop2.protocol.sdk.archive.ArchiveMappingFruizione;
import org.openspcoop2.protocol.sdk.archive.ArchivePdd;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginArchivio;
import org.openspcoop2.protocol.sdk.archive.ArchivePluginClasse;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaApplicativa;
import org.openspcoop2.protocol.sdk.archive.ArchivePortaDelegata;
import org.openspcoop2.protocol.sdk.archive.ArchiveRuolo;
import org.openspcoop2.protocol.sdk.archive.ArchiveScope;
import org.openspcoop2.protocol.sdk.archive.ArchiveServizioApplicativo;
import org.openspcoop2.protocol.sdk.archive.ArchiveSoggetto;
import org.openspcoop2.protocol.sdk.archive.ArchiveSortedMap;
import org.openspcoop2.protocol.sdk.archive.ArchiveTokenPolicy;
import org.openspcoop2.protocol.sdk.archive.ArchiveUrlInvocazioneRegola;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;
import org.openspcoop2.protocol.sdk.archive.IPositionArchiveObject;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.constants.ArchiveStatoImport;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.security.keystore.MerlinProvider;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;

public class ImporterArchiveUtils {
    private AbstractArchiveEngine importerEngine;
    private Logger log;
    private String userLogin;
    private boolean gestioneWorkflowStatiAccordi;
    private boolean updateAbilitato;
    private boolean importPolicyConfigurazione;
    private boolean importPluginConfigurazione;
    private boolean checkExistsPluginConfigurazione;
    private boolean importConfigurazione;
    private String nomePddOperativa;
    private String tipoPddDefault;
    private ProtocolFactoryManager protocolFactoryManager;
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory;
    private IDAccordoFactory idAccordoFactory;

    public ImporterArchiveUtils(AbstractArchiveEngine importerEngine, Logger log, String userLogin, String nomePddOperativa, String tipoPddDefault, boolean gestioneWorkflowStatiAccordi, boolean updateAbilitato, boolean importPolicyConfigurazione, boolean importPluginConfigurazione, boolean checkExistsPluginConfigurazione, boolean importConfigurazione) throws Exception {
        this.importerEngine = importerEngine;
        this.log = log;
        this.userLogin = userLogin;
        this.gestioneWorkflowStatiAccordi = gestioneWorkflowStatiAccordi;
        this.updateAbilitato = updateAbilitato;
        this.importPolicyConfigurazione = importPolicyConfigurazione;
        this.importPluginConfigurazione = importPluginConfigurazione;
        this.checkExistsPluginConfigurazione = checkExistsPluginConfigurazione;
        this.importConfigurazione = importConfigurazione;
        if (nomePddOperativa != null) {
            this.nomePddOperativa = nomePddOperativa;
        } else {
            FiltroRicerca filtroRicerca = new FiltroRicerca();
            filtroRicerca.setTipo(PddTipologia.OPERATIVO.toString());
            List<String> pdd = this.importerEngine.getAllIdPorteDominio(filtroRicerca);
            if (pdd.size() <= 0) {
                throw new Exception("Pdd operative non trovate nel registro");
            }
            if (pdd.size() > 1) {
                throw new Exception("Riscontrate piu' di una porta di dominio operativa");
            }
            this.nomePddOperativa = pdd.get(0);
        }
        this.tipoPddDefault = tipoPddDefault;
        if (this.tipoPddDefault == null) {
            this.tipoPddDefault = PddTipologia.ESTERNO.toString();
        }
        this.protocolFactoryManager = ProtocolFactoryManager.getInstance();
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
    }

    public ArchiveEsitoImport importArchive(Archive archive, String userLogin, boolean utilizzoAzioniDiretteInAccordoAbilitato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, boolean isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiSslPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials) throws Exception, ImportInformationMissingException {
        ArchiveEsitoImportDetail detail;
        ConfigurazioneUrlInvocazione configurazione;
        ArchiveEsitoImportDetail detail2;
        ArchiveEsitoImportDetail detail3;
        MappingErogazionePortaApplicativa mapping;
        ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica;
        int i;
        ArchiveTokenPolicy archiveTokenPolicy;
        ArchiveEsitoImportDetail detail4;
        int i2;
        ArchiveEsitoImportDetail detail5;
        ArchiveEsitoImport esito = new ArchiveEsitoImport();
        HashMap<String, IDSoggetto> mapIdSoggettoDefault = new HashMap<String, IDSoggetto>();
        HashMap<String, org.openspcoop2.core.registry.Soggetto> mapSoggettoDefault = new HashMap<String, org.openspcoop2.core.registry.Soggetto>();
        HashMap<String, Boolean> mapAPIconReferente = new HashMap<String, Boolean>();
        if (this.protocolFactoryManager == null) {
            throw new Exception("ProtocolFactoryManager not initialized");
        }
        Enumeration pEnum = this.protocolFactoryManager.getProtocolFactories().keys();
        if (pEnum != null) {
            while (pEnum.hasMoreElements()) {
                String protocollo = (String)pEnum.nextElement();
                IDSoggetto soggettoDefaultProtocollo = this.importerEngine.getSoggettoDefault(protocollo);
                if (soggettoDefaultProtocollo == null) {
                    throw new Exception("IDSoggetto di default non trovato per il protocollo '" + protocollo + "'");
                }
                mapIdSoggettoDefault.put(protocollo, soggettoDefaultProtocollo);
                org.openspcoop2.core.registry.Soggetto soggettoDefault = null;
                try {
                    soggettoDefault = this.importerEngine.getSoggettoRegistro(soggettoDefaultProtocollo);
                    if (soggettoDefault != null) {
                        mapSoggettoDefault.put(protocollo, soggettoDefault);
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                if (soggettoDefault == null) {
                    throw new Exception("Soggetto di default non trovato per il protocollo '" + protocollo + "'");
                }
                IProtocolFactory<?> pf = this.protocolFactoryManager.getProtocolFactoryByName(protocollo);
                boolean supportoReferente = false;
                if (pf != null) {
                    supportoReferente = pf.createProtocolConfiguration().isSupportoSoggettoReferenteAccordiParteComune();
                }
                mapAPIconReferente.put(protocollo, supportoReferente);
            }
        }
        for (int i3 = 0; i3 < archive.getPdd().size(); ++i3) {
            ArchivePdd archivePdd = (ArchivePdd)archive.getPdd().get(i3);
            ArchiveEsitoImportDetail detail6 = new ArchiveEsitoImportDetail((IArchiveObject)archivePdd);
            try {
                this.importPdd(archivePdd, detail6);
            }
            catch (Exception e) {
                detail6.setState(ArchiveStatoImport.ERROR);
                detail6.setException((Throwable)e);
            }
            esito.getPdd().add((Object)detail6);
        }
        SortedMap map_plugin_archivi = this.reorderByPosition(archive.getPlugin_archivi());
        if (!map_plugin_archivi.isEmpty()) {
            for (String position : map_plugin_archivi.keys()) {
                List archivePluginList = (List)map_plugin_archivi.get(position);
                if (archivePluginList.isEmpty()) continue;
                for (ArchivePluginArchivio archivePluginArchivio : archivePluginList) {
                    detail5 = new ArchiveEsitoImportDetail((IArchiveObject)archivePluginArchivio);
                    try {
                        this.importPluginArchivio(archivePluginArchivio, detail5);
                    }
                    catch (Exception e) {
                        detail5.setState(ArchiveStatoImport.ERROR);
                        detail5.setException((Throwable)e);
                    }
                    esito.getPlugin_archivi().add((Object)detail5);
                }
            }
        }
        for (i2 = 0; i2 < archive.getPlugin_classi().size(); ++i2) {
            ArchivePluginClasse archivePluginClasse = (ArchivePluginClasse)archive.getPlugin_classi().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archivePluginClasse);
            try {
                this.importPluginClasse(archivePluginClasse, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getPlugin_classi().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getToken_validation_policies().size(); ++i2) {
            archiveTokenPolicy = (ArchiveTokenPolicy)archive.getToken_validation_policies().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveTokenPolicy);
            try {
                this.importTokenPolicy(archiveTokenPolicy, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getToken_validation_policies().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getToken_retrieve_policies().size(); ++i2) {
            archiveTokenPolicy = (ArchiveTokenPolicy)archive.getToken_retrieve_policies().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveTokenPolicy);
            try {
                this.importTokenPolicy(archiveTokenPolicy, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getToken_retrieve_policies().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getAttributeAuthorities().size(); ++i2) {
            ArchiveAttributeAuthority archiveAttributeAuthority = (ArchiveAttributeAuthority)archive.getAttributeAuthorities().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAttributeAuthority);
            try {
                this.importAttributeAuthority(archiveAttributeAuthority, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getAttributeAuthorities().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getGruppi().size(); ++i2) {
            ArchiveGruppo archiveGruppo = (ArchiveGruppo)archive.getGruppi().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveGruppo);
            try {
                this.importGruppo(archiveGruppo, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getGruppi().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getRuoli().size(); ++i2) {
            ArchiveRuolo archiveRuolo = (ArchiveRuolo)archive.getRuoli().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveRuolo);
            try {
                this.importRuolo(archiveRuolo, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getRuoli().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getScope().size(); ++i2) {
            ArchiveScope archiveScope = (ArchiveScope)archive.getScope().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveScope);
            try {
                this.importScope(archiveScope, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getScope().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getSoggetti().size(); ++i2) {
            ArchiveSoggetto archiveSoggetto = (ArchiveSoggetto)archive.getSoggetti().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveSoggetto);
            try {
                this.importSoggetto(archiveSoggetto, detail4, isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, isSoggettiApplicativiCredenzialiSslPermitSameCredentials, isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials, mapIdSoggettoDefault, mapSoggettoDefault);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getSoggetti().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getServiziApplicativi().size(); ++i2) {
            ArchiveServizioApplicativo archiveServizioApplicativo = (ArchiveServizioApplicativo)archive.getServiziApplicativi().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveServizioApplicativo);
            try {
                archiveServizioApplicativo.update();
                this.importServizioApplicativo(archiveServizioApplicativo, detail4, isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, isSoggettiApplicativiCredenzialiSslPermitSameCredentials, isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getServiziApplicativi().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getAccordiCooperazione().size(); ++i2) {
            ArchiveAccordoCooperazione archiveAccordoCooperazione = (ArchiveAccordoCooperazione)archive.getAccordiCooperazione().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoCooperazione);
            try {
                archiveAccordoCooperazione.update();
                this.importAccordoCooperazione(archiveAccordoCooperazione, detail4);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getAccordiCooperazione().add((Object)detail4);
        }
        for (i2 = 0; i2 < archive.getAccordiServizioParteComune().size(); ++i2) {
            ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune = (ArchiveAccordoServizioParteComune)archive.getAccordiServizioParteComune().get(i2);
            detail4 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteComune);
            try {
                archiveAccordoServizioParteComune.update();
                this.importAccordoServizioParteComune(archiveAccordoServizioParteComune, utilizzoAzioniDiretteInAccordoAbilitato, detail4, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail4.setState(ArchiveStatoImport.ERROR);
                detail4.setException((Throwable)e);
            }
            esito.getAccordiServizioParteComune().add((Object)detail4);
        }
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        ArrayList<ArchiveAccordoServizioParteSpecifica> listAccordiServizioParteSpecifica_serviziComposti = new ArrayList<ArchiveAccordoServizioParteSpecifica>();
        for (int i4 = 0; i4 < archive.getAccordiServizioParteSpecifica().size(); ++i4) {
            ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica2 = (ArchiveAccordoServizioParteSpecifica)archive.getAccordiServizioParteSpecifica().get(i4);
            archiveAccordoServizioParteSpecifica2.update();
            IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteSpecifica2.getIdAccordoServizioParteComune();
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idAccordoServizioParteComune.getSoggettoReferente().getTipo());
            boolean APIconReferente = (Boolean)mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = (IDSoggetto)mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idAccordoServizioParteComune.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                    idAccordoServizioParteComune.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioParteComune.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    archiveAccordoServizioParteSpecifica2.getAccordoServizioParteSpecifica().setAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizioParteComune));
                }
            }
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                AccordoServizioParteComune aspc = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                if (aspc.getServizioComposto() != null) {
                    listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica2);
                    continue;
                }
                listAccordiServizioParteSpecifica.add(archiveAccordoServizioParteSpecifica2);
                continue;
            }
            listAccordiServizioParteSpecifica_serviziComposti.add(archiveAccordoServizioParteSpecifica2);
        }
        ArrayList<MappingErogazionePortaApplicativa> listMappingErogazionePA = new ArrayList<MappingErogazionePortaApplicativa>();
        ArrayList<MappingFruizionePortaDelegata> listMappingFruizionePD = new ArrayList<MappingFruizionePortaDelegata>();
        for (i = 0; i < listAccordiServizioParteSpecifica.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica.get(i);
            ArchiveEsitoImportDetail detail7 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.importAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, false, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, detail7, listMappingErogazionePA, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail7.setState(ArchiveStatoImport.ERROR);
                detail7.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecifica().add((Object)detail7);
        }
        for (i = 0; i < archive.getAccordiServizioComposto().size(); ++i) {
            ArchiveAccordoServizioComposto archiveAccordoServizioComposto = (ArchiveAccordoServizioComposto)archive.getAccordiServizioComposto().get(i);
            ArchiveEsitoImportDetail detail8 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioComposto);
            try {
                archiveAccordoServizioComposto.update();
                this.importAccordoServizioComposto(archiveAccordoServizioComposto, utilizzoAzioniDiretteInAccordoAbilitato, detail8, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail8.setState(ArchiveStatoImport.ERROR);
                detail8.setException((Throwable)e);
            }
            esito.getAccordiServizioComposto().add((Object)detail8);
        }
        for (i = 0; i < listAccordiServizioParteSpecifica_serviziComposti.size(); ++i) {
            archiveAccordoServizioParteSpecifica = (ArchiveAccordoServizioParteSpecifica)listAccordiServizioParteSpecifica_serviziComposti.get(i);
            ArchiveEsitoImportDetail detail9 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAccordoServizioParteSpecifica);
            try {
                this.importAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica, true, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, detail9, listMappingErogazionePA, mapIdSoggettoDefault, mapAPIconReferente);
            }
            catch (Exception e) {
                detail9.setState(ArchiveStatoImport.ERROR);
                detail9.setException((Throwable)e);
            }
            esito.getAccordiServizioParteSpecificaServiziComposti().add((Object)detail9);
        }
        for (i = 0; i < archive.getAccordiFruitori().size(); ++i) {
            ArchiveFruitore archiveFruitore = (ArchiveFruitore)archive.getAccordiFruitori().get(i);
            ArchiveEsitoImportDetail detail10 = new ArchiveEsitoImportDetail((IArchiveObject)archiveFruitore);
            try {
                archiveFruitore.update();
                this.importFruitore(archiveFruitore, detail10, listMappingFruizionePD);
            }
            catch (Exception e) {
                detail10.setState(ArchiveStatoImport.ERROR);
                detail10.setException((Throwable)e);
            }
            esito.getAccordiFruitori().add((Object)detail10);
        }
        for (i = 0; i < archive.getPorteDelegate().size(); ++i) {
            ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i);
            ArchiveEsitoImportDetail detail11 = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaDelegata);
            try {
                archivePortaDelegata.update();
                this.importPortaDelegata(archivePortaDelegata, detail11);
            }
            catch (Exception e) {
                detail11.setState(ArchiveStatoImport.ERROR);
                detail11.setException((Throwable)e);
            }
            esito.getPorteDelegate().add((Object)detail11);
        }
        for (i = 0; i < archive.getPorteApplicative().size(); ++i) {
            ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i);
            ArchiveEsitoImportDetail detail12 = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaApplicativa);
            try {
                archivePortaApplicativa.update();
                this.importPortaApplicativa(archivePortaApplicativa, detail12);
            }
            catch (Exception e) {
                detail12.setState(ArchiveStatoImport.ERROR);
                detail12.setException((Throwable)e);
            }
            esito.getPorteApplicative().add((Object)detail12);
        }
        if (listMappingErogazionePA.size() > 0) {
            for (i = 0; i < listMappingErogazionePA.size(); ++i) {
                mapping = (MappingErogazionePortaApplicativa)listMappingErogazionePA.get(i);
                ArchiveMappingErogazione archiveMappingErogazione = new ArchiveMappingErogazione(mapping);
                detail3 = new ArchiveEsitoImportDetail((IArchiveObject)archiveMappingErogazione);
                try {
                    if (this.importerEngine.existsMappingErogazione(mapping.getIdServizio(), mapping.getIdPortaApplicativa())) {
                        detail3.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    } else {
                        this.importerEngine.createMappingErogazione(mapping.getNome(), mapping.getDescrizione(), mapping.isDefault(), mapping.getIdServizio(), mapping.getIdPortaApplicativa());
                        detail3.setState(ArchiveStatoImport.CREATED);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante la creazione del mapping di erogazione nome [" + mapping.getNome() + "] deafult [" + mapping.isDefault() + "] del servizio [" + mapping.getIdServizio() + "] verso la porta applicativa [" + mapping.getIdPortaApplicativa().getNome() + "]: " + e.getMessage(), (Throwable)e);
                    detail3.setState(ArchiveStatoImport.ERROR);
                    detail3.setException((Throwable)e);
                }
                esito.getMappingErogazioni().add((Object)detail3);
            }
        }
        if (listMappingFruizionePD.size() > 0) {
            for (i = 0; i < listMappingFruizionePD.size(); ++i) {
                mapping = (MappingFruizionePortaDelegata)listMappingFruizionePD.get(i);
                ArchiveMappingFruizione archiveMappingFruizione = new ArchiveMappingFruizione((MappingFruizionePortaDelegata)mapping);
                detail3 = new ArchiveEsitoImportDetail((IArchiveObject)archiveMappingFruizione);
                try {
                    if (this.importerEngine.existsMappingFruizione(mapping.getIdServizio(), mapping.getIdFruitore(), mapping.getIdPortaDelegata())) {
                        detail3.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    } else {
                        this.importerEngine.createMappingFruizione(mapping.getNome(), mapping.getDescrizione(), mapping.isDefault(), mapping.getIdServizio(), mapping.getIdFruitore(), mapping.getIdPortaDelegata());
                        detail3.setState(ArchiveStatoImport.CREATED);
                    }
                }
                catch (Exception e) {
                    this.log.error("Errore durante la creazione del mapping di fruizione nome [" + mapping.getNome() + "] deafult [" + mapping.isDefault() + "] del servizio [" + mapping.getIdServizio() + "] verso la porta delegata [" + mapping.getIdPortaDelegata().getNome() + "] da parte del soggetto [" + mapping.getIdFruitore() + "]: " + e.getMessage(), (Throwable)e);
                    detail3.setState(ArchiveStatoImport.ERROR);
                    detail3.setException((Throwable)e);
                }
                esito.getMappingFruizioni().add((Object)detail3);
            }
        }
        if (archive.getControlloTraffico_configurazione() != null) {
            ConfigurazioneGenerale configurazione2 = archive.getControlloTraffico_configurazione();
            detail5 = new ArchiveEsitoImportDetailConfigurazione((Object)configurazione2);
            try {
                this.importControlloTraffico_configurazione(configurazione2, (ArchiveEsitoImportDetailConfigurazione<ConfigurazioneGenerale>)detail5);
            }
            catch (Exception e) {
                detail5.setState(ArchiveStatoImport.ERROR);
                detail5.setException((Throwable)e);
            }
            esito.setControlloTraffico_configurazione((ArchiveEsitoImportDetailConfigurazione)detail5);
        }
        for (int i5 = 0; i5 < archive.getControlloTraffico_configurationPolicies().size(); ++i5) {
            ArchiveConfigurationPolicy archiveCCPolicy = (ArchiveConfigurationPolicy)archive.getControlloTraffico_configurationPolicies().get(i5);
            ArchiveEsitoImportDetail detail13 = new ArchiveEsitoImportDetail((IArchiveObject)archiveCCPolicy);
            try {
                this.importControlloTraffico_configurationPolicy(archiveCCPolicy, detail13);
            }
            catch (Exception e) {
                detail13.setState(ArchiveStatoImport.ERROR);
                detail13.setException((Throwable)e);
            }
            esito.getControlloTraffico_configurationPolicies().add((Object)detail13);
        }
        HashMap<String, String> instanceSerialIdsForPolicy = new HashMap<String, String>();
        SortedMap map_controllo_traffico_activePolicy = this.reorderByPosition(archive.getControlloTraffico_activePolicies());
        if (!map_controllo_traffico_activePolicy.isEmpty()) {
            for (String position : map_controllo_traffico_activePolicy.keys()) {
                List archiveActivePolicyList = (List)map_controllo_traffico_activePolicy.get(position);
                if (archiveActivePolicyList.isEmpty()) continue;
                for (ArchiveActivePolicy archiveCCPolicy : archiveActivePolicyList) {
                    ArchiveEsitoImportDetail detail14 = new ArchiveEsitoImportDetail((IArchiveObject)archiveCCPolicy);
                    try {
                        this.importControlloTraffico_activePolicy(archiveCCPolicy, detail14, instanceSerialIdsForPolicy);
                    }
                    catch (Exception e) {
                        detail14.setState(ArchiveStatoImport.ERROR);
                        detail14.setException((Throwable)e);
                    }
                    esito.getControlloTraffico_activePolicies().add((Object)detail14);
                }
            }
        }
        HashMap<String, String> instanceSerialIdsForAlarm = new HashMap<String, String>();
        for (int i6 = 0; i6 < archive.getAllarmi().size(); ++i6) {
            ArchiveAllarme archiveAllarme = (ArchiveAllarme)archive.getAllarmi().get(i6);
            detail2 = new ArchiveEsitoImportDetail((IArchiveObject)archiveAllarme);
            try {
                this.importAllarme(archiveAllarme, detail2, instanceSerialIdsForAlarm);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.getAllarmi().add((Object)detail2);
        }
        SortedMap map_urlInvocazione_regole = this.reorderByPosition(archive.getConfigurazionePdD_urlInvocazione_regole());
        if (!map_urlInvocazione_regole.isEmpty()) {
            for (String position : map_urlInvocazione_regole.keys()) {
                List archiveRegolaList = (List)map_urlInvocazione_regole.get(position);
                if (archiveRegolaList.isEmpty()) continue;
                for (ArchiveUrlInvocazioneRegola archiveRegola : archiveRegolaList) {
                    ArchiveEsitoImportDetail detail15 = new ArchiveEsitoImportDetail((IArchiveObject)archiveRegola);
                    try {
                        this.importConfigurazione_UrlInvocazioneRegola(archiveRegola, detail15);
                    }
                    catch (Exception e) {
                        detail15.setState(ArchiveStatoImport.ERROR);
                        detail15.setException((Throwable)e);
                    }
                    esito.getConfigurazionePdD_urlInvocazione_regole().add((Object)detail15);
                }
            }
        }
        if (archive.getConfigurazionePdD_urlInvocazione() != null) {
            configurazione = archive.getConfigurazionePdD_urlInvocazione();
            detail2 = new ArchiveEsitoImportDetailConfigurazione((Object)configurazione);
            try {
                this.importConfigurazione_UrlInvocazione(configurazione, (ArchiveEsitoImportDetailConfigurazione<ConfigurazioneUrlInvocazione>)detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.setConfigurazionePdD_urlInvocazione((ArchiveEsitoImportDetailConfigurazione)detail2);
        }
        if (archive.getConfigurazionePdD() != null) {
            configurazione = archive.getConfigurazionePdD();
            detail2 = new ArchiveEsitoImportDetailConfigurazione((Object)configurazione);
            try {
                this.importConfigurazione((Configurazione)configurazione, (ArchiveEsitoImportDetailConfigurazione<Configurazione>)detail2);
            }
            catch (Exception e) {
                detail2.setState(ArchiveStatoImport.ERROR);
                detail2.setException((Throwable)e);
            }
            esito.setConfigurazionePdD((ArchiveEsitoImportDetailConfigurazione)detail2);
        }
        if (archive.getPorteApplicative().size() > 0) {
            for (int i7 = 0; i7 < archive.getPorteApplicative().size(); ++i7) {
                ArchiveEsitoImportDetail detailEsitoPortaApplicativaPrecedente = null;
                if (esito.getPorteApplicative().size() > i7) {
                    detailEsitoPortaApplicativaPrecedente = (ArchiveEsitoImportDetail)esito.getPorteApplicative().get(i7);
                }
                boolean init = true;
                if (detailEsitoPortaApplicativaPrecedente != null && ArchiveStatoImport.ERROR.equals((Object)detailEsitoPortaApplicativaPrecedente.getState())) {
                    init = false;
                }
                ArchivePortaApplicativa archivePortaApplicativa = (ArchivePortaApplicativa)archive.getPorteApplicative().get(i7);
                detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaApplicativa);
                try {
                    if (init) {
                        ArrayList<PortaApplicativa> listPA = new ArrayList<PortaApplicativa>();
                        listPA.add(((ArchivePortaApplicativa)archive.getPorteApplicative().get(i7)).getPortaApplicativa());
                        this.importerEngine.initMappingErogazione(this.log, listPA);
                    }
                    detail.setState(ArchiveStatoImport.UPDATED);
                }
                catch (Exception e) {
                    detail.setState(ArchiveStatoImport.ERROR);
                    detail.setException((Throwable)e);
                }
                esito.getPorteApplicative_initMapping().add((Object)detail);
            }
        }
        if (archive.getPorteDelegate().size() > 0) {
            for (int i8 = 0; i8 < archive.getPorteDelegate().size(); ++i8) {
                ArchiveEsitoImportDetail detailEsitoPortaDelegataPrecedente = null;
                if (esito.getPorteApplicative().size() > i8) {
                    detailEsitoPortaDelegataPrecedente = (ArchiveEsitoImportDetail)esito.getPorteDelegate().get(i8);
                }
                boolean init = true;
                if (detailEsitoPortaDelegataPrecedente != null && ArchiveStatoImport.ERROR.equals((Object)detailEsitoPortaDelegataPrecedente.getState())) {
                    init = false;
                }
                ArchivePortaDelegata archivePortaDelegata = (ArchivePortaDelegata)archive.getPorteDelegate().get(i8);
                detail = new ArchiveEsitoImportDetail((IArchiveObject)archivePortaDelegata);
                try {
                    if (init) {
                        ArrayList<PortaDelegata> listPD = new ArrayList<PortaDelegata>();
                        listPD.add(((ArchivePortaDelegata)archive.getPorteDelegate().get(i8)).getPortaDelegata());
                        this.importerEngine.initMappingFruizione(this.log, listPD);
                    }
                    detail.setState(ArchiveStatoImport.UPDATED);
                }
                catch (Exception e) {
                    detail.setState(ArchiveStatoImport.ERROR);
                    detail.setException((Throwable)e);
                }
                esito.getPorteDelegate_initMapping().add((Object)detail);
            }
        }
        this.importerEngine.finalizeImport(archive);
        return esito;
    }

    private <T extends IPositionArchiveObject> SortedMap<List<T>> reorderByPosition(ArchiveSortedMap<T> map) throws ProtocolException, UtilsException {
        SortedMap map_reordered = new SortedMap();
        if (map.size() > 0) {
            HashMap map_for_reorder = new HashMap();
            for (int i = 0; i < map.size(); ++i) {
                IPositionArchiveObject archive = (IPositionArchiveObject)map.get(i);
                int posizione = archive.position();
                String posizionePadding = StringUtils.leftPad((String)("" + posizione), (int)20, (String)"0");
                List<IPositionArchiveObject> l = null;
                if (map_for_reorder.containsKey(posizionePadding)) {
                    l = (List)map_for_reorder.get(posizionePadding);
                } else {
                    l = new ArrayList();
                    map_for_reorder.put(posizionePadding, l);
                }
                l.add(archive);
            }
            ArrayList keys = new ArrayList();
            keys.addAll(map_for_reorder.keySet());
            Collections.sort(keys);
            for (String position : keys) {
                map_reordered.add(position, (Object)((List)map_for_reorder.remove(position)));
            }
        }
        return map_reordered;
    }

    public void importPdd(ArchivePdd archivePdd, ArchiveEsitoImportDetail detail) {
        String nomePdd = archivePdd.getNomePdd();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsPortaDominio(nomePdd)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            archivePdd.getPortaDominio().setSuperUser(this.userLogin);
            XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio((PortaDominio)archivePdd.getPortaDominio());
            archivePdd.getPortaDominio().setOraRegistrazione(DateManager.getDate());
            boolean create = false;
            if (this.importerEngine.existsPortaDominio(nomePdd)) {
                PortaDominio old = this.importerEngine.getPortaDominio(nomePdd);
                archivePdd.getPortaDominio().setId(old.getId());
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("La porta di dominio non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updatePortaDominio(archivePdd.getPortaDominio());
                create = false;
            } else {
                this.importerEngine.createPortaDominio(archivePdd.getPortaDominio());
                create = true;
            }
            XMLDataConverter.impostaInformazioniRegistroDB_PortaDominio_update((PortaDominio)archivePdd.getPortaDominio(), (String)this.nomePddOperativa, (Logger)this.log, (DriverRegistroServiziDB)this.importerEngine.getDriverRegistroServizi(), (String)this.tipoPddDefault);
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della porta di dominio [" + nomePdd + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importGruppo(ArchiveGruppo archiveGruppo, ArchiveEsitoImportDetail detail) {
        IDGruppo idGruppo = archiveGruppo.getIdGruppo();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsGruppo(idGruppo)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            archiveGruppo.getGruppo().setSuperUser(this.userLogin);
            XMLDataConverter.impostaInformazioniRegistroDB_Gruppo((Gruppo)archiveGruppo.getGruppo());
            archiveGruppo.getGruppo().setOraRegistrazione(DateManager.getDate());
            boolean create = false;
            if (this.importerEngine.existsGruppo(idGruppo)) {
                Gruppo old = this.importerEngine.getGruppo(idGruppo);
                archiveGruppo.getGruppo().setId(old.getId());
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Il gruppo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateGruppo(archiveGruppo.getGruppo());
                create = false;
            } else {
                this.importerEngine.createGruppo(archiveGruppo.getGruppo());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del gruppo [" + idGruppo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importRuolo(ArchiveRuolo archiveRuolo, ArchiveEsitoImportDetail detail) {
        IDRuolo idRuolo = archiveRuolo.getIdRuolo();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsRuolo(idRuolo)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            archiveRuolo.getRuolo().setSuperUser(this.userLogin);
            XMLDataConverter.impostaInformazioniRegistroDB_Ruolo((Ruolo)archiveRuolo.getRuolo());
            archiveRuolo.getRuolo().setOraRegistrazione(DateManager.getDate());
            boolean create = false;
            if (this.importerEngine.existsRuolo(idRuolo)) {
                Ruolo old = this.importerEngine.getRuolo(idRuolo);
                archiveRuolo.getRuolo().setId(old.getId());
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Il ruolo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateRuolo(archiveRuolo.getRuolo());
                create = false;
            } else {
                this.importerEngine.createRuolo(archiveRuolo.getRuolo());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del ruolo [" + idRuolo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importScope(ArchiveScope archiveScope, ArchiveEsitoImportDetail detail) {
        IDScope idScope = archiveScope.getIdScope();
        try {
            if (!this.updateAbilitato && this.importerEngine.existsScope(idScope)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            archiveScope.getScope().setSuperUser(this.userLogin);
            XMLDataConverter.impostaInformazioniRegistroDB_Scope((Scope)archiveScope.getScope());
            archiveScope.getScope().setOraRegistrazione(DateManager.getDate());
            boolean create = false;
            if (this.importerEngine.existsScope(idScope)) {
                Scope old = this.importerEngine.getScope(idScope);
                archiveScope.getScope().setId(old.getId());
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("Lo scope non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateScope(archiveScope.getScope());
                create = false;
            } else {
                this.importerEngine.createScope(archiveScope.getScope());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dello scope [" + idScope + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importSoggetto(ArchiveSoggetto archiveSoggetto, ArchiveEsitoImportDetail detail, boolean isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiSslPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, org.openspcoop2.core.registry.Soggetto> mapSoggettoDefault) {
        IDSoggetto idSoggetto = archiveSoggetto.getIdSoggetto();
        IProtocolFactory<?> protocolFactory = null;
        try {
            boolean create = false;
            if (archiveSoggetto.getSoggettoRegistro() != null) {
                if (!this.updateAbilitato && this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    return;
                }
                protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idSoggetto.getTipo());
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (archiveSoggetto.getSoggettoConfigurazione().isDominioDefault() && soggettoDefaultProtocollo != null && !soggettoDefaultProtocollo.equals((Object)idSoggetto)) {
                    archiveSoggetto.getSoggettoConfigurazione().setDominioDefault(false);
                }
                if (soggettoDefaultProtocollo != null && soggettoDefaultProtocollo.equals((Object)idSoggetto)) {
                    archiveSoggetto.getSoggettoConfigurazione().setDominioDefault(true);
                    org.openspcoop2.core.registry.Soggetto soggettoDefault = mapSoggettoDefault.get(protocolFactory.getProtocol());
                    if (soggettoDefault != null && soggettoDefault.getPortaDominio() != null && !soggettoDefault.getPortaDominio().equals(archiveSoggetto.getSoggettoRegistro().getPortaDominio())) {
                        archiveSoggetto.getSoggettoRegistro().setPortaDominio(soggettoDefault.getPortaDominio());
                    }
                }
                if (archiveSoggetto.getSoggettoRegistro().getPortaDominio() != null && !this.importerEngine.existsPortaDominio(archiveSoggetto.getSoggettoRegistro().getPortaDominio())) {
                    throw new Exception("Porta di dominio [" + archiveSoggetto.getSoggettoRegistro().getPortaDominio() + "] associata non esiste");
                }
                if (archiveSoggetto.getSoggettoRegistro().getRuoli() != null && archiveSoggetto.getSoggettoRegistro().getRuoli().sizeRuoloList() > 0) {
                    for (int i = 0; i < archiveSoggetto.getSoggettoRegistro().getRuoli().sizeRuoloList(); ++i) {
                        IDRuolo idRuolo = new IDRuolo(archiveSoggetto.getSoggettoRegistro().getRuoli().getRuolo(i).getNome());
                        if (this.importerEngine.existsRuolo(idRuolo)) continue;
                        throw new Exception("Ruolo [" + idRuolo.getNome() + "] associato non esiste");
                    }
                }
                if (archiveSoggetto.getSoggettoRegistro().getCredenzialiList() != null && !archiveSoggetto.getSoggettoRegistro().getCredenzialiList().isEmpty()) {
                    for (CredenzialiSoggetto credenziali : archiveSoggetto.getSoggettoRegistro().getCredenzialiList()) {
                        IDSoggetto idSoggettoFound;
                        boolean equalsForUpdate;
                        CredenzialeTipo tipo = credenziali.getTipo();
                        if (tipo == null) continue;
                        org.openspcoop2.core.registry.Soggetto soggettoFound = null;
                        ServizioApplicativo saFound = null;
                        String c = null;
                        switch (tipo) {
                            case BASIC: {
                                soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiBasic(credenziali.getUser());
                                c = credenziali.getUser();
                                if (isSoggettiApplicativiCredenzialiBasicPermitSameCredentials) break;
                                saFound = this.importerEngine.getServizioApplicativoCredenzialiBasic(credenziali.getUser());
                                break;
                            }
                            case APIKEY: {
                                soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiApiKey(credenziali.getUser(), credenziali.isAppId());
                                c = credenziali.getUser();
                                break;
                            }
                            case SSL: {
                                boolean dominioEsternoModI = false;
                                if ("modipa".equals(archiveSoggetto.getSoggettoRegistro().getTipo())) {
                                    org.openspcoop2.core.registry.Soggetto s = archiveSoggetto.getSoggettoRegistro();
                                    List<String> listPdDoperative = null;
                                    if (s.getPortaDominio() != null && !s.getPortaDominio().equals("") && !s.getPortaDominio().equals("-")) {
                                        FiltroRicerca filtroPdDoperative = new FiltroRicerca();
                                        filtroPdDoperative.setTipo(PddTipologia.OPERATIVO.toString());
                                        try {
                                            listPdDoperative = this.importerEngine.getAllIdPorteDominio(filtroPdDoperative);
                                        }
                                        catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                            // empty catch block
                                        }
                                        if (listPdDoperative == null) {
                                            listPdDoperative = new ArrayList<String>();
                                        }
                                    }
                                    boolean pddEsterna = false;
                                    if (listPdDoperative == null || !listPdDoperative.contains(s.getPortaDominio())) {
                                        pddEsterna = true;
                                    }
                                    dominioEsternoModI = pddEsterna;
                                }
                                if (credenziali.getCertificate() != null && credenziali.getCertificate().length > 0) {
                                    soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiSsl(credenziali.getCertificate(), credenziali.isCertificateStrictVerification());
                                    c = "X.509";
                                    if (isSoggettiApplicativiCredenzialiSslPermitSameCredentials) break;
                                    saFound = this.importerEngine.getServizioApplicativoCredenzialiSsl(credenziali.getCertificate(), credenziali.isCertificateStrictVerification(), dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                                    break;
                                }
                                soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiSsl(credenziali.getSubject(), credenziali.getIssuer());
                                c = credenziali.getSubject();
                                if (isSoggettiApplicativiCredenzialiSslPermitSameCredentials) break;
                                saFound = this.importerEngine.getServizioApplicativoCredenzialiSsl(credenziali.getSubject(), credenziali.getIssuer(), dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                                break;
                            }
                            case PRINCIPAL: {
                                soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiPrincipal(credenziali.getUser());
                                c = credenziali.getUser();
                                if (isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials) break;
                                saFound = this.importerEngine.getServizioApplicativoCredenzialiPrincipal(credenziali.getUser());
                            }
                        }
                        if (soggettoFound != null && !(equalsForUpdate = (idSoggettoFound = new IDSoggetto(soggettoFound.getTipo(), soggettoFound.getNome())).equals((Object)idSoggetto))) {
                            throw new Exception("Le credenziali '" + tipo + "' (" + c + ") risultano gi\u00e0 associate al soggetto '" + idSoggettoFound + "'");
                        }
                        if (saFound == null) continue;
                        IDSoggetto idSoggettoSaFound = new IDSoggetto(saFound.getTipoSoggettoProprietario(), saFound.getNomeSoggettoProprietario());
                        throw new Exception("Le credenziali '" + tipo + "' (" + c + ") risultano gi\u00e0 associate all'applicativo '" + saFound.getNome() + "' appartenente al soggetto '" + idSoggettoSaFound + "'");
                    }
                }
                String server = this.nomePddOperativa;
                if (PddTipologia.ESTERNO.equals(this.tipoPddDefault)) {
                    server = null;
                }
                XMLDataConverter.impostaInformazioniRegistroDB_Soggetto((org.openspcoop2.core.registry.Soggetto)archiveSoggetto.getSoggettoRegistro(), (String)server);
                archiveSoggetto.getSoggettoRegistro().setSuperUser(this.userLogin);
                if (archiveSoggetto.getSoggettoRegistro().getCodiceIpa() == null || archiveSoggetto.getSoggettoRegistro().getIdentificativoPorta() == null) {
                    ITraduttore traduttore = protocolFactory.createTraduttore();
                    if (archiveSoggetto.getSoggettoRegistro().getCodiceIpa() == null) {
                        archiveSoggetto.getSoggettoRegistro().setCodiceIpa(traduttore.getIdentificativoCodiceIPADefault(idSoggetto, false));
                    }
                    if (archiveSoggetto.getSoggettoRegistro().getIdentificativoPorta() == null) {
                        archiveSoggetto.getSoggettoRegistro().setIdentificativoPorta(traduttore.getIdentificativoPortaDefault(idSoggetto));
                    }
                }
                archiveSoggetto.getSoggettoRegistro().setOraRegistrazione(DateManager.getDate());
                if (this.importerEngine.existsSoggettoRegistro(idSoggetto)) {
                    org.openspcoop2.core.registry.Soggetto old = this.importerEngine.getSoggettoRegistro(idSoggetto);
                    archiveSoggetto.getSoggettoRegistro().setId(old.getId());
                    IDSoggetto oldIDSoggettoForUpdate = new IDSoggetto(old.getTipo(), old.getNome());
                    archiveSoggetto.getSoggettoRegistro().setOldIDSoggettoForUpdate(oldIDSoggettoForUpdate);
                    XMLDataConverter.impostaInformazioniRegistroDB_Soggetto_update((org.openspcoop2.core.registry.Soggetto)archiveSoggetto.getSoggettoRegistro(), (org.openspcoop2.core.registry.Soggetto)old);
                    if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                        throw new Exception("Il soggetto non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                    }
                    this.importerEngine.updateSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                } else {
                    this.importerEngine.createSoggettoRegistro(archiveSoggetto.getSoggettoRegistro());
                    create = true;
                }
            }
            if (archiveSoggetto.getSoggettoConfigurazione() != null) {
                if (!this.updateAbilitato && this.importerEngine.existsSoggettoConfigurazione(idSoggetto) && !create) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    return;
                }
                archiveSoggetto.getSoggettoConfigurazione().setSuperUser(this.userLogin);
                if (archiveSoggetto.getSoggettoConfigurazione().getIdentificativoPorta() == null) {
                    if (protocolFactory == null) {
                        protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idSoggetto.getTipo());
                    }
                    ITraduttore traduttore = protocolFactory.createTraduttore();
                    if (archiveSoggetto.getSoggettoConfigurazione().getIdentificativoPorta() == null) {
                        archiveSoggetto.getSoggettoConfigurazione().setIdentificativoPorta(traduttore.getIdentificativoPortaDefault(idSoggetto));
                    }
                }
                archiveSoggetto.getSoggettoConfigurazione().setOraRegistrazione(DateManager.getDate());
                if (this.importerEngine.existsSoggettoConfigurazione(idSoggetto)) {
                    Soggetto old = this.importerEngine.getSoggettoConfigurazione(idSoggetto);
                    archiveSoggetto.getSoggettoConfigurazione().setId(old.getId());
                    IDSoggetto oldIDSoggettoForUpdate = new IDSoggetto(old.getTipo(), old.getNome());
                    archiveSoggetto.getSoggettoRegistro().setOldIDSoggettoForUpdate(oldIDSoggettoForUpdate);
                    if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                        throw new Exception("Il soggetto non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                    }
                    this.importerEngine.updateSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                } else {
                    this.importerEngine.createSoggettoConfigurazione(archiveSoggetto.getSoggettoConfigurazione());
                    create = true;
                }
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del soggetto [" + idSoggetto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importServizioApplicativo(ArchiveServizioApplicativo archiveServizioApplicativo, ArchiveEsitoImportDetail detail, boolean isSoggettiApplicativiCredenzialiBasicPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiSslPermitSameCredentials, boolean isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials) {
        IDServizioApplicativo idServizioApplicativo = archiveServizioApplicativo.getIdServizioApplicativo();
        IDSoggetto idSoggettoProprietario = archiveServizioApplicativo.getIdSoggettoProprietario();
        try {
            String policy;
            if (!this.updateAbilitato && this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            if (archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getRuoli() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                for (int i = 0; i < archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getRuoli().sizeRuoloList(); ++i) {
                    IDRuolo idRuolo = new IDRuolo(archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getRuoli().getRuolo(i).getNome());
                    if (this.importerEngine.existsRuolo(idRuolo)) continue;
                    throw new Exception("Ruolo [" + idRuolo.getNome() + "] associato non esiste");
                }
            }
            if (archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getCredenzialiList() != null && !archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getCredenzialiList().isEmpty()) {
                for (Credenziali credenziali : archiveServizioApplicativo.getServizioApplicativo().getInvocazionePorta().getCredenzialiList()) {
                    org.openspcoop2.core.config.constants.CredenzialeTipo tipo = credenziali.getTipo();
                    if (tipo == null) continue;
                    ServizioApplicativo saFound = null;
                    org.openspcoop2.core.registry.Soggetto soggettoFound = null;
                    String c = null;
                    switch (tipo) {
                        case BASIC: {
                            saFound = this.importerEngine.getServizioApplicativoCredenzialiBasic(credenziali.getUser());
                            c = credenziali.getUser();
                            if (isSoggettiApplicativiCredenzialiBasicPermitSameCredentials) break;
                            soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiBasic(credenziali.getUser());
                            break;
                        }
                        case APIKEY: {
                            saFound = this.importerEngine.getServizioApplicativoCredenzialiApiKey(credenziali.getUser(), credenziali.isAppId());
                            c = credenziali.getUser();
                            break;
                        }
                        case SSL: {
                            boolean tokenWithHttpsEnabled = false;
                            ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                            String protocollo = protocolFactoryManager.getProtocolByOrganizationType(idSoggettoProprietario.getTipo());
                            tokenWithHttpsEnabled = protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken();
                            if (tokenWithHttpsEnabled && credenziali.getTokenPolicy() != null && StringUtils.isNotEmpty((String)credenziali.getTokenPolicy())) {
                                saFound = this.importerEngine.getServizioApplicativoCredenzialiToken(credenziali.getTokenPolicy(), credenziali.getUser());
                                c = credenziali.getUser();
                                tipo = org.openspcoop2.core.config.constants.CredenzialeTipo.TOKEN;
                                break;
                            }
                            boolean dominioEsternoModI = false;
                            if ("modipa".equals(protocollo)) {
                                org.openspcoop2.core.registry.Soggetto s = null;
                                try {
                                    s = this.importerEngine.getSoggettoRegistro(idSoggettoProprietario);
                                }
                                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                    // empty catch block
                                }
                                List<String> listPdDoperative = null;
                                if (s != null && s.getPortaDominio() != null && !s.getPortaDominio().equals("") && !s.getPortaDominio().equals("-")) {
                                    FiltroRicerca filtroPdDoperative = new FiltroRicerca();
                                    filtroPdDoperative.setTipo(PddTipologia.OPERATIVO.toString());
                                    try {
                                        listPdDoperative = this.importerEngine.getAllIdPorteDominio(filtroPdDoperative);
                                    }
                                    catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                                        // empty catch block
                                    }
                                    if (listPdDoperative == null) {
                                        listPdDoperative = new ArrayList<String>();
                                    }
                                }
                                boolean pddEsterna = false;
                                if (listPdDoperative == null || !listPdDoperative.contains(s.getPortaDominio())) {
                                    pddEsterna = true;
                                }
                                dominioEsternoModI = pddEsterna;
                            }
                            if (credenziali.getCertificate() != null && credenziali.getCertificate().length > 0) {
                                saFound = this.importerEngine.getServizioApplicativoCredenzialiSsl(credenziali.getCertificate(), credenziali.isCertificateStrictVerification(), dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                                c = "X.509";
                                if (isSoggettiApplicativiCredenzialiSslPermitSameCredentials) break;
                                soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiSsl(credenziali.getCertificate(), credenziali.isCertificateStrictVerification());
                                break;
                            }
                            saFound = this.importerEngine.getServizioApplicativoCredenzialiSsl(credenziali.getSubject(), credenziali.getIssuer(), dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                            c = credenziali.getSubject();
                            if (isSoggettiApplicativiCredenzialiSslPermitSameCredentials) break;
                            soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiSsl(credenziali.getSubject(), credenziali.getIssuer());
                            break;
                        }
                        case PRINCIPAL: {
                            saFound = this.importerEngine.getServizioApplicativoCredenzialiPrincipal(credenziali.getUser());
                            c = credenziali.getUser();
                            if (isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials) break;
                            soggettoFound = this.importerEngine.getSoggettoRegistroCredenzialiPrincipal(credenziali.getUser());
                            break;
                        }
                        case TOKEN: {
                            saFound = this.importerEngine.getServizioApplicativoCredenzialiToken(credenziali.getTokenPolicy(), credenziali.getUser());
                            c = credenziali.getUser();
                        }
                    }
                    if (saFound != null) {
                        boolean equalsForUpdate;
                        IDSoggetto idSoggettoProprietarioFound = new IDSoggetto(saFound.getTipoSoggettoProprietario(), saFound.getNomeSoggettoProprietario());
                        boolean bl = equalsForUpdate = idSoggettoProprietario.equals((Object)idSoggettoProprietarioFound) && idServizioApplicativo.getNome().contentEquals(saFound.getNome());
                        if (!equalsForUpdate) {
                            throw new Exception("Le credenziali '" + tipo + "' (" + c + ") risultano gi\u00e0 associate all'applicativo '" + saFound.getNome() + "' appartenente al soggetto '" + idSoggettoProprietarioFound + "'");
                        }
                    }
                    if (soggettoFound == null) continue;
                    IDSoggetto idSoggettoFound = new IDSoggetto(soggettoFound.getTipo(), soggettoFound.getNome());
                    throw new Exception("Le credenziali '" + tipo + "' (" + c + ") risultano gi\u00e0 associate al soggetto '" + idSoggettoFound + "'");
                }
            }
            if (archiveServizioApplicativo.getServizioApplicativo() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getProperties() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getProperties().containsKey("tokenPolicy") && !this.importerEngine.existsGenericProperties_retrieve(policy = (String)archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getProperties().get("tokenPolicy"))) {
                throw new Exception("Token Policy Negoziazione [" + policy + "] indicato nel connettore non esistente");
            }
            if (archiveServizioApplicativo.getServizioApplicativo() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getProperties() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getProperties().containsKey("tokenPolicy") && !this.importerEngine.existsGenericProperties_retrieve(policy = (String)archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getProperties().get("tokenPolicy"))) {
                throw new Exception("Token Policy Negoziazione [" + policy + "] indicato nel connettore non esistente");
            }
            if (this.checkExistsPluginConfigurazione) {
                TipiConnettore tipo;
                if (archiveServizioApplicativo.getServizioApplicativo() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getCustom() != null && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getCustom().booleanValue() && archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getTipo())) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getTipo())) {
                    throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + archiveServizioApplicativo.getServizioApplicativo().getInvocazioneServizio().getConnettore().getTipo() + "] non esistente nel registro");
                }
                if (archiveServizioApplicativo.getServizioApplicativo() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getCustom() != null && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getCustom().booleanValue() && archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getTipo())) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getTipo())) {
                    throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + archiveServizioApplicativo.getServizioApplicativo().getRispostaAsincrona().getConnettore().getTipo() + "] non esistente nel registro");
                }
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo((ServizioApplicativo)archiveServizioApplicativo.getServizioApplicativo(), (Soggetto)soggetto, (String)"", (Logger)this.log, (String)"db");
            archiveServizioApplicativo.getServizioApplicativo().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsServizioApplicativo(idServizioApplicativo)) {
                ServizioApplicativo old = this.importerEngine.getServizioApplicativo(idServizioApplicativo);
                archiveServizioApplicativo.getServizioApplicativo().setId(old.getId());
                IDServizioApplicativo oldIDServizioApplicativoForUpdate = new IDServizioApplicativo();
                oldIDServizioApplicativoForUpdate.setNome(old.getNome());
                oldIDServizioApplicativoForUpdate.setIdSoggettoProprietario(new IDSoggetto(old.getTipoSoggettoProprietario(), old.getNomeSoggettoProprietario()));
                archiveServizioApplicativo.getServizioApplicativo().setOldIDServizioApplicativoForUpdate(oldIDServizioApplicativoForUpdate);
                org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_ServizioApplicativo_update((ServizioApplicativo)archiveServizioApplicativo.getServizioApplicativo(), (ServizioApplicativo)old);
                this.importerEngine.updateServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createServizioApplicativo(archiveServizioApplicativo.getServizioApplicativo());
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del servizio applicativo [" + idServizioApplicativo + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importAccordoCooperazione(ArchiveAccordoCooperazione archiveAccordoCooperazione, ArchiveEsitoImportDetail detail) {
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoCooperazione.getIdAccordoCooperazione();
        IDSoggetto idSoggettoReferente = archiveAccordoCooperazione.getIdSoggettoReferente();
        List idSoggettiPartecipanti = archiveAccordoCooperazione.getIdSoggettiPartecipanti();
        try {
            int i;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            if (idSoggettiPartecipanti != null) {
                for (Object idSoggettoPartecipante : idSoggettiPartecipanti) {
                    if (this.importerEngine.existsSoggettoRegistro((IDSoggetto)idSoggettoPartecipante)) continue;
                    throw new Exception("Soggetto partecipante [" + (IDSoggetto)idSoggettoPartecipante + "] non esistente");
                }
            }
            String protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoReferente.getTipo());
            if (idSoggettiPartecipanti != null) {
                for (Object idSoggettoPartecipante : idSoggettiPartecipanti) {
                    String protocolloAssociatoSoggettoPartecipante = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoPartecipante.getTipo());
                    if (protocolloAssociatoAccordo.equals(protocolloAssociatoSoggettoPartecipante)) continue;
                    throw new Exception("Soggetto partecipante [" + (IDSoggetto)idSoggettoPartecipante + "] (protocollo:" + protocolloAssociatoSoggettoPartecipante + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
                }
            }
            org.openspcoop2.core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (idSoggettiPartecipanti != null) {
                for (IDSoggetto idSoggettoPartecipante : idSoggettiPartecipanti) {
                    org.openspcoop2.core.registry.Soggetto soggettoPartecipante = this.importerEngine.getSoggettoRegistro(idSoggettoPartecipante);
                    if (this.importerEngine.isVisioneOggettiGlobale(this.userLogin) || this.userLogin.equals(soggettoPartecipante.getSuperUser())) continue;
                    throw new Exception("Il soggetto partecipante [" + idSoggettoPartecipante + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            archiveAccordoCooperazione.getAccordoCooperazione().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoCooperazione.getAccordoCooperazione().sizeAllegatoList(); ++i) {
                archiveAccordoCooperazione.getAccordoCooperazione().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoCooperazione.getAccordoCooperazione().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
            }
            for (i = 0; i < archiveAccordoCooperazione.getAccordoCooperazione().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoCooperazione.getAccordoCooperazione().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoCooperazione.getAccordoCooperazione().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoCooperazione.toString());
            }
            StringBuilder warningInfoStatoFinale = new StringBuilder("");
            if (archiveAccordoCooperazione.getAccordoCooperazione().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("'\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoCooperazione.getAccordoCooperazione().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveAccordoCooperazione.getAccordoCooperazione().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                AccordoCooperazione old = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
                archiveAccordoCooperazione.getAccordoCooperazione().setId(old.getId());
                archiveAccordoCooperazione.getAccordoCooperazione().setOldIDAccordoForUpdate(this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            } else {
                this.importerEngine.createAccordoCooperazione(archiveAccordoCooperazione.getAccordoCooperazione());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'accordo di cooperazione [" + idAccordoCooperazione + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private void modifyUriAccordoCorrelato(AccordoServizioParteComune aspc, IDSoggetto soggettoDefaultProtocollo) {
        if (aspc != null) {
            if (aspc.sizeProtocolPropertyList() > 0) {
                for (ProtocolProperty pp : aspc.getProtocolPropertyList()) {
                    if (!"modipaInteractionAsyncApiRequest".equals(pp.getName()) || pp.getValue() == null || !StringUtils.isNotEmpty((String)pp.getValue())) continue;
                    this.modifyUriAccordo(pp, soggettoDefaultProtocollo);
                }
            }
            if (aspc.sizeResourceList() > 0) {
                for (Resource r : aspc.getResourceList()) {
                    if (r.sizeProtocolPropertyList() <= 0) continue;
                    for (ProtocolProperty pp : r.getProtocolPropertyList()) {
                        if (!"modipaInteractionAsyncApiRequest".equals(pp.getName()) || pp.getValue() == null || !StringUtils.isNotEmpty((String)pp.getValue())) continue;
                        this.modifyUriAccordo(pp, soggettoDefaultProtocollo);
                    }
                }
            }
            if (aspc.sizePortTypeList() > 0) {
                for (org.openspcoop2.core.registry.PortType pt : aspc.getPortTypeList()) {
                    if (pt.sizeProtocolPropertyList() > 0) {
                        for (ProtocolProperty pp : pt.getProtocolPropertyList()) {
                            if (!"modipaInteractionAsyncApiRequest".equals(pp.getName()) || pp.getValue() == null || !StringUtils.isNotEmpty((String)pp.getValue())) continue;
                            this.modifyUriAccordo(pp, soggettoDefaultProtocollo);
                        }
                    }
                    if (pt.sizeAzioneList() <= 0) continue;
                    for (org.openspcoop2.core.registry.Operation op : pt.getAzioneList()) {
                        if (op.sizeProtocolPropertyList() <= 0) continue;
                        for (ProtocolProperty pp : op.getProtocolPropertyList()) {
                            if (!"modipaInteractionAsyncApiRequest".equals(pp.getName()) || pp.getValue() == null || !StringUtils.isNotEmpty((String)pp.getValue())) continue;
                            this.modifyUriAccordo(pp, soggettoDefaultProtocollo);
                        }
                    }
                }
            }
        }
    }

    private void modifyUriAccordo(ProtocolProperty pp, IDSoggetto soggettoDefaultProtocollo) {
        if (pp != null && "modipaInteractionAsyncApiRequest".equals(pp.getName()) && pp.getValue() != null && StringUtils.isNotEmpty((String)pp.getValue())) {
            String uri = pp.getValue();
            try {
                IDAccordo idUri = this.idAccordoFactory.getIDAccordoFromUri(uri);
                if (idUri != null && idUri.getSoggettoReferente() != null && !idUri.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                    idUri.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idUri.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    String newUri = this.idAccordoFactory.getUriFromIDAccordo(idUri);
                    pp.setValue(newUri);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void importAccordoServizioParteComune(ArchiveAccordoServizioParteComune archiveAccordoServizioParteComune, boolean utilizzoAzioniDiretteInAccordoAbilitato, ArchiveEsitoImportDetail detail, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteComune.getIdAccordoServizioParteComune();
        IDSoggetto idSoggettoReferente = archiveAccordoServizioParteComune.getIdSoggettoReferente();
        try {
            int i;
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idSoggettoReferente.getTipo());
            boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idSoggettoReferente.equals((Object)soggettoDefaultProtocollo)) {
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    idSoggettoReferente.setTipo(soggettoDefaultProtocollo.getTipo());
                    idSoggettoReferente.setNome(soggettoDefaultProtocollo.getNome());
                    idAccordoServizioParteComune.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioParteComune.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                }
                if ("modipa".equals(protocolFactory.getProtocol())) {
                    this.modifyUriAccordoCorrelato(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), soggettoDefaultProtocollo);
                }
            }
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (APIconReferente && !this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            if (archiveAccordoServizioParteComune.getAccordoServizioParteComune().getGruppi() != null && archiveAccordoServizioParteComune.getAccordoServizioParteComune().getGruppi().sizeGruppoList() > 0) {
                for (int i2 = 0; i2 < archiveAccordoServizioParteComune.getAccordoServizioParteComune().getGruppi().sizeGruppoList(); ++i2) {
                    IDGruppo idGruppo = new IDGruppo(archiveAccordoServizioParteComune.getAccordoServizioParteComune().getGruppi().getGruppo(i2).getNome());
                    if (this.importerEngine.existsGruppo(idGruppo)) continue;
                    throw new Exception("Tag [" + idGruppo.getNome() + "] associato non esiste");
                }
            }
            if (APIconReferente) {
                org.openspcoop2.core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                    throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune((AccordoServizioParteComune)archiveAccordoServizioParteComune.getAccordoServizioParteComune());
            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioParteComune.getAccordoServizioParteComune().sizeAllegatoList(); ++i) {
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteComune.getAccordoServizioParteComune().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            StringBuilder warningInfoStatoFinale = new StringBuilder("");
            if (archiveAccordoServizioParteComune.getAccordoServizioParteComune().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioParteComune.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            StringBuilder warningAderenzaWSDL = new StringBuilder("");
            if (ServiceBinding.SOAP.equals((Object)archiveAccordoServizioParteComune.getAccordoServizioParteComune().getServiceBinding())) {
                this.informazioniServizioAderentiWSDL(archiveAccordoServizioParteComune.getAccordoServizioParteComune(), warningAderenzaWSDL);
            }
            archiveAccordoServizioParteComune.getAccordoServizioParteComune().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                AccordoServizioParteComune old = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().setId(old.getId());
                archiveAccordoServizioParteComune.getAccordoServizioParteComune().setOldIDAccordoForUpdate(this.idAccordoFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            } else {
                this.importerEngine.createAccordoServizioParteComune(archiveAccordoServizioParteComune.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'accordo di servizio parte comune [" + idAccordoServizioParteComune + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importAccordoServizioComposto(ArchiveAccordoServizioComposto archiveAccordoServizioComposto, boolean utilizzoAzioniDiretteInAccordoAbilitato, ArchiveEsitoImportDetail detail, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) {
        IDAccordo idAccordoServizioComposto = archiveAccordoServizioComposto.getIdAccordoServizioParteComune();
        IDSoggetto idSoggettoReferente = archiveAccordoServizioComposto.getIdSoggettoReferente();
        IDAccordoCooperazione idAccordoCooperazione = archiveAccordoServizioComposto.getIdAccordoCooperazione();
        List idServiziComponenti = archiveAccordoServizioComposto.getIdServiziComponenti();
        try {
            int i;
            AccordoCooperazione ac;
            String protocolloAssociatoAccordoCooperazione;
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idSoggettoReferente.getTipo());
            boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idSoggettoReferente.equals((Object)soggettoDefaultProtocollo)) {
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    idSoggettoReferente.setTipo(soggettoDefaultProtocollo.getTipo());
                    idSoggettoReferente.setNome(soggettoDefaultProtocollo.getNome());
                    idAccordoServizioComposto.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioComposto.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                }
                if ("modipa".equals(protocolFactory.getProtocol())) {
                    this.modifyUriAccordoCorrelato(archiveAccordoServizioComposto.getAccordoServizioParteComune(), soggettoDefaultProtocollo);
                }
            }
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (APIconReferente && !this.importerEngine.existsSoggettoRegistro(idSoggettoReferente)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoReferente + "] non esistente");
            }
            if (!this.importerEngine.existsAccordoCooperazione(idAccordoCooperazione)) {
                throw new Exception("Accordo di Cooperazione [" + idAccordoCooperazione + "] riferito non esistente");
            }
            for (IDServizio idServizioComponente : idServiziComponenti) {
                if (this.importerEngine.existsAccordoServizioParteSpecifica(idServizioComponente)) continue;
                throw new Exception("ServizioComponente [" + idServizioComponente + "] riferito non esistente");
            }
            String protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoReferente.getTipo());
            if (!protocolloAssociatoAccordo.equals(protocolloAssociatoAccordoCooperazione = this.protocolFactoryManager.getProtocolByOrganizationType((ac = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione)).getSoggettoReferente().getTipo()))) {
                throw new Exception("Soggetto referente (" + ac.getSoggettoReferente().getTipo() + "/" + ac.getSoggettoReferente().getNome() + ") dell'accordo di cooperazione [" + idAccordoCooperazione + "] (protocollo:" + protocolloAssociatoAccordoCooperazione + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            for (IDServizio idServizioComponente : idServiziComponenti) {
                String protocolloAssociatoServizioComponente = this.protocolFactoryManager.getProtocolByServiceType(idServizioComponente.getTipo());
                if (!protocolloAssociatoAccordo.equals(protocolloAssociatoServizioComponente)) {
                    throw new Exception("ServizioComponente [" + idServizioComponente + "] (protocollo:" + (String)protocolloAssociatoServizioComponente + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
                }
                String protocolloAssociatoSoggettoServizioComponente = this.protocolFactoryManager.getProtocolByOrganizationType(idServizioComponente.getSoggettoErogatore().getTipo());
                if (protocolloAssociatoAccordo.equals(protocolloAssociatoSoggettoServizioComponente)) continue;
                throw new Exception("ServizioComponente [" + idServizioComponente + "] (protocollo:" + protocolloAssociatoSoggettoServizioComponente + ") non utilizzabile in un accordo con soggetto referente [" + idSoggettoReferente + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            if (APIconReferente) {
                org.openspcoop2.core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoReferente);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                    throw new Exception("Il soggetto referente [" + idSoggettoReferente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            AccordoCooperazione accordoCooperazione = this.importerEngine.getAccordoCooperazione(idAccordoCooperazione);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoCooperazione.getSuperUser())) {
                throw new Exception("L'accordo di cooperazione [" + idAccordoCooperazione + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            HashMap<String, AccordoServizioParteSpecifica> serviziComponenti = new HashMap<String, AccordoServizioParteSpecifica>();
            for (IDServizio idServizioComponente : idServiziComponenti) {
                AccordoServizioParteSpecifica asps = this.importerEngine.getAccordoServizioParteSpecifica(idServizioComponente);
                serviziComponenti.put(idServizioComponente.toString(), asps);
                if (this.importerEngine.isVisioneOggettiGlobale(this.userLogin)) continue;
                if (!this.userLogin.equals(asps.getSuperUser())) {
                    throw new Exception("Il servizio componente [" + idServizioComponente + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ").");
                }
                org.openspcoop2.core.registry.Soggetto soggettoErogatoreServizioComponente = this.importerEngine.getSoggettoRegistro(new IDSoggetto(idServizioComponente.getSoggettoErogatore().getTipo(), idServizioComponente.getSoggettoErogatore().getNome()));
                if (this.userLogin.equals(soggettoErogatoreServizioComponente.getSuperUser())) continue;
                throw new Exception("Il servizio componente [" + idServizioComponente + "] (il soggetto erogatore in particolar modo) non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ").");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteComune((AccordoServizioParteComune)archiveAccordoServizioComposto.getAccordoServizioParteComune());
            archiveAccordoServizioComposto.getAccordoServizioParteComune().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().sizeAllegatoList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().sizeSpecificaCoordinamentoList(); ++i) {
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.accordoServizio.toString());
            }
            archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().setIdAccordoCooperazione(accordoCooperazione.getId());
            for (i = 0; i < archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().sizeServizioComponenteList(); ++i) {
                AccordoServizioParteComuneServizioCompostoServizioComponente componente = archiveAccordoServizioComposto.getAccordoServizioParteComune().getServizioComposto().getServizioComponente(i);
                IDServizio idServizioComponente = IDServizioFactory.getInstance().getIDServizioFromValues(componente.getTipo(), componente.getNome(), componente.getTipoSoggetto(), componente.getNomeSoggetto(), componente.getVersione().intValue());
                idServizioComponente.setAzione(componente.getAzione());
                AccordoServizioParteSpecifica asps = (AccordoServizioParteSpecifica)serviziComponenti.get(idServizioComponente.toString());
                if (asps == null) {
                    StringBuilder bfException = new StringBuilder();
                    for (String idS : serviziComponenti.keySet()) {
                        if (bfException.length() > 0) {
                            bfException.append(",");
                        }
                        bfException.append(idS);
                    }
                    throw new Exception("ServizioComponente [" + idServizioComponente + "] riferito non esistente?? Dovrebbe essere stato recuperato? ListaKeys: " + bfException.toString());
                }
                componente.setIdServizioComponente(asps.getId());
            }
            StringBuilder warningInfoStatoFinale = new StringBuilder("");
            if (archiveAccordoServizioComposto.getAccordoServizioParteComune().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune(), utilizzoAzioniDiretteInAccordoAbilitato);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioComposto.getAccordoServizioParteComune().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            StringBuilder warningAderenzaWSDL = new StringBuilder("");
            if (ServiceBinding.SOAP.equals((Object)archiveAccordoServizioComposto.getAccordoServizioParteComune().getServiceBinding())) {
                this.informazioniServizioAderentiWSDL(archiveAccordoServizioComposto.getAccordoServizioParteComune(), warningAderenzaWSDL);
            }
            archiveAccordoServizioComposto.getAccordoServizioParteComune().setOraRegistrazione(DateManager.getDate());
            if (this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioComposto)) {
                AccordoServizioParteComune old = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioComposto);
                archiveAccordoServizioComposto.getAccordoServizioParteComune().setId(old.getId());
                archiveAccordoServizioComposto.getAccordoServizioParteComune().setOldIDAccordoForUpdate(this.idAccordoFactory.getIDAccordoFromAccordo(old));
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            } else {
                this.importerEngine.createAccordoServizioParteComune(archiveAccordoServizioComposto.getAccordoServizioParteComune());
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString() + warningAderenzaWSDL.toString());
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'accordo di servizio parte comune [" + idAccordoServizioComposto + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private void informazioniServizioAderentiWSDL(AccordoServizioParteComune accordoServizioParteComune, StringBuilder anomalieRiscontrate) throws Exception {
        try {
            org.openspcoop2.core.registry.Operation opOpenSPCoop;
            org.openspcoop2.core.registry.PortType ptOpenSPCoop;
            ArrayList<String> listOperationName;
            ArrayList<String> listPortTypesName;
            String indent = "\t\t";
            StringBuilder strutturaWSDL = new StringBuilder("Struttura WSDL:\n");
            byte[] wsdl = accordoServizioParteComune.getByteWsdlConcettuale();
            if (wsdl == null) {
                throw new Exception("WSDLConcettuale non fornito");
            }
            OpenSPCoop2MessageFactory defaultFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
            RegistroOpenSPCoopUtilities wsdlUtility = new RegistroOpenSPCoopUtilities(defaultFactory, this.log);
            wsdl = wsdlUtility.eliminaImportASParteComune(wsdl);
            DefinitionWrapper wsdlObject = new DefinitionWrapper(wsdl, (AbstractXMLUtils)MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)defaultFactory));
            HashMap mapPortTypeOperations = new HashMap();
            Map pts = wsdlObject.getAllPortTypes();
            if (pts == null || pts.size() <= 0) {
                this.log.warn("Non sono stati definiti port types nel wsdl concettuale");
            } else {
                Iterator ptsIterator = pts.values().iterator();
                listPortTypesName = new ArrayList<String>();
                while (ptsIterator.hasNext()) {
                    PortType pt = (PortType)ptsIterator.next();
                    String ptName = pt.getQName().getLocalPart();
                    listPortTypesName.add(ptName);
                    List ops = pt.getOperations();
                    Iterator opIt = ops.iterator();
                    listOperationName = new ArrayList<String>();
                    while (opIt.hasNext()) {
                        Operation op = (Operation)opIt.next();
                        String nomeOperazione = op.getName();
                        listOperationName.add(nomeOperazione);
                    }
                    Collections.sort(listOperationName);
                    mapPortTypeOperations.put(ptName, listOperationName);
                }
                Collections.sort(listPortTypesName);
                for (String ptName : listPortTypesName) {
                    strutturaWSDL.append(indent + ". " + ptName + "\n");
                    List opList = (List)mapPortTypeOperations.get(ptName);
                    for (String opName : opList) {
                        strutturaWSDL.append(indent + "\t- " + opName + "\n");
                    }
                }
            }
            StringBuilder strutturaAccordoOpenSPCoop = new StringBuilder("Servizi/Azioni associati all'accordo:\n");
            listPortTypesName = new ArrayList();
            HashMap<String, org.openspcoop2.core.registry.PortType> mapPtNameToObject = new HashMap<String, org.openspcoop2.core.registry.PortType>();
            for (int i = 0; i < accordoServizioParteComune.sizePortTypeList(); ++i) {
                org.openspcoop2.core.registry.PortType ptOpenSPCoop2 = accordoServizioParteComune.getPortType(i);
                listPortTypesName.add(ptOpenSPCoop2.getNome());
                mapPtNameToObject.put(ptOpenSPCoop2.getNome(), ptOpenSPCoop2);
            }
            Collections.sort(listPortTypesName);
            for (String ptName : listPortTypesName) {
                ptOpenSPCoop = (org.openspcoop2.core.registry.PortType)mapPtNameToObject.get(ptName);
                strutturaAccordoOpenSPCoop.append(indent + ". " + ptOpenSPCoop.getNome() + "\n");
                listOperationName = new ArrayList();
                for (int j = 0; j < ptOpenSPCoop.sizeAzioneList(); ++j) {
                    opOpenSPCoop = ptOpenSPCoop.getAzione(j);
                    listOperationName.add(opOpenSPCoop.getNome());
                }
                Collections.sort(listOperationName);
                for (String opName : listOperationName) {
                    strutturaAccordoOpenSPCoop.append(indent + "\t- " + opName + "\n");
                }
            }
            boolean aderenzaWSDL = true;
            for (int i = 0; i < accordoServizioParteComune.sizePortTypeList(); ++i) {
                ptOpenSPCoop = accordoServizioParteComune.getPortType(i);
                if (mapPortTypeOperations.containsKey(ptOpenSPCoop.getNome())) {
                    List opWSDL = (List)mapPortTypeOperations.remove(ptOpenSPCoop.getNome());
                    for (int j = 0; j < ptOpenSPCoop.sizeAzioneList(); ++j) {
                        opOpenSPCoop = ptOpenSPCoop.getAzione(j);
                        if (!opWSDL.contains(opOpenSPCoop.getNome())) {
                            aderenzaWSDL = false;
                            break;
                        }
                        opWSDL.remove(opOpenSPCoop.getNome());
                    }
                    if (opWSDL.size() <= 0) continue;
                    aderenzaWSDL = false;
                    break;
                }
                aderenzaWSDL = false;
                break;
            }
            if (aderenzaWSDL && mapPortTypeOperations.size() > 0) {
                aderenzaWSDL = false;
            }
            if (!aderenzaWSDL) {
                anomalieRiscontrate.append("\n" + indent + "(WARNING) accordo importato contiene una struttura (servizi e azioni) non aderente all'interfaccia WSDL");
                anomalieRiscontrate.append("\n" + indent + "Alcuni servizi o alcune azioni associate all'accordo importato");
                anomalieRiscontrate.append("\n" + indent + "non corrispondono ai port types e alle operations definite");
                anomalieRiscontrate.append("\n" + indent);
                anomalieRiscontrate.append((CharSequence)strutturaWSDL);
                anomalieRiscontrate.append(indent);
                anomalieRiscontrate.append((CharSequence)strutturaAccordoOpenSPCoop);
            }
        }
        catch (Exception e) {
            this.log.debug("Check informazioniServizioAderentiWSDL non riuscito: " + e.getMessage());
        }
    }

    public void importAccordoServizioParteSpecifica(ArchiveAccordoServizioParteSpecifica archiveAccordoServizioParteSpecifica, boolean servizioComposto, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto, ArchiveEsitoImportDetail detail, List<MappingErogazionePortaApplicativa> listMappingErogazionePA, Map<String, IDSoggetto> mapIdSoggettoDefault, Map<String, Boolean> mapAPIconReferente) {
        IDAccordo idAccordoServizioParteComune = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteComune();
        IDServizio idAccordoServizioParteSpecifica = archiveAccordoServizioParteSpecifica.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoErogatore = archiveAccordoServizioParteSpecifica.getIdSoggettoErogatore();
        String labelAccordoParteComune = "Accordo di Servizio Parte Comune";
        if (servizioComposto) {
            labelAccordoParteComune = "Accordo di Servizio Composto";
        }
        try {
            int i;
            String protocolloAssociatoAccordoParteComune;
            String protocolloAssociatoAccordo;
            if (!this.updateAbilitato && this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                List<IDPortaApplicativa> idPACheck = this.importerEngine.getIDPorteApplicativeAssociateErogazione(idAccordoServizioParteSpecifica);
                if (archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate() != null && archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate().size() > 0) {
                    for (MappingErogazionePortaApplicativa mappingPortaApplicativaAssociata : archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate()) {
                        if (idPACheck != null && idPACheck.size() > 0 && idPACheck.contains(mappingPortaApplicativaAssociata.getIdPortaApplicativa())) continue;
                        listMappingErogazionePA.add(mappingPortaApplicativaAssociata);
                    }
                }
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore [" + idSoggettoErogatore + "] non esistente");
            }
            IProtocolFactory<?> protocolFactory = this.protocolFactoryManager.getProtocolFactoryByOrganizationType(idSoggettoErogatore.getTipo());
            boolean APIconReferente = mapAPIconReferente.get(protocolFactory.getProtocol());
            if (!APIconReferente) {
                IDSoggetto soggettoDefaultProtocollo = mapIdSoggettoDefault.get(protocolFactory.getProtocol());
                if (!idAccordoServizioParteComune.getSoggettoReferente().equals((Object)soggettoDefaultProtocollo)) {
                    idAccordoServizioParteComune.getSoggettoReferente().setTipo(soggettoDefaultProtocollo.getTipo());
                    idAccordoServizioParteComune.getSoggettoReferente().setNome(soggettoDefaultProtocollo.getNome());
                    archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setAccordoServizioParteComune(this.idAccordoFactory.getUriFromIDAccordo(idAccordoServizioParteComune));
                }
            }
            if (!this.importerEngine.existsAccordoServizioParteComune(idAccordoServizioParteComune)) {
                throw new Exception(labelAccordoParteComune + " [" + idAccordoServizioParteComune + "] non esistente");
            }
            org.openspcoop2.core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
            AccordoServizioParteComune accordoServizioParteComune = this.importerEngine.getAccordoServizioParteComune(idAccordoServizioParteComune);
            AccordoServizioParteSpecifica old = null;
            long idAccordoServizioParteSpecificaLong = -1L;
            boolean isUpdate = false;
            boolean servizioCorrelato = TipologiaServizio.CORRELATO.equals((Object)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getTipologiaServizio());
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                old = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                idAccordoServizioParteSpecificaLong = old.getId();
                isUpdate = true;
            }
            String uriAccordo = null;
            try {
                uriAccordo = IDServizioFactory.getInstance().getUriFromIDServizio(idAccordoServizioParteSpecifica);
            }
            catch (Exception e) {
                uriAccordo = idAccordoServizioParteSpecifica.toString(false);
            }
            this.importerEngine.controlloUnicitaImplementazioneAccordoPerSoggetto(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getPortType(), idSoggettoErogatore, soggetto.getId(), idAccordoServizioParteComune, accordoServizioParteComune.getId(), idAccordoServizioParteSpecifica, idAccordoServizioParteSpecificaLong, isUpdate, servizioCorrelato, isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto);
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                if (!isUpdate) {
                    AccordoServizioParteSpecifica aspsCheck = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                    throw new Exception("Servizio [" + uriAccordo + "] gi\u00e0 esistente definito all'interno dell'accordo di servizio parte specifica [" + IDServizioFactory.getInstance().getUriFromAccordo(aspsCheck) + "]");
                }
                AccordoServizioParteSpecifica aspsCheck = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                IDServizio idAccordoASPSCheck = IDServizioFactory.getInstance().getIDServizioFromAccordo(aspsCheck);
                if (!idAccordoASPSCheck.equals((Object)idAccordoServizioParteSpecifica)) {
                    throw new Exception("Servizio [" + uriAccordo + "] gi\u00e0 esistente definito all'interno dell'accordo di servizio parte specifica [" + IDServizioFactory.getInstance().getUriFromAccordo(aspsCheck) + "]");
                }
            }
            if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica() != null && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio() != null) {
                Object policy;
                if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore() != null && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getProperties() != null && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getProperties().containsKey("tokenPolicy") && !this.importerEngine.existsGenericProperties_retrieve((String)(policy = (String)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getProperties().get("tokenPolicy")))) {
                    throw new Exception("Token Policy Negoziazione [" + (String)policy + "] indicato nel connettore non esistente");
                }
                if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().sizeConfigurazioneAzioneList() > 0) {
                    for (ConfigurazioneServizioAzione confAzione : archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConfigurazioneAzioneList()) {
                        String policy2;
                        if (confAzione.getConnettore() == null || confAzione.getConnettore().getProperties() == null || !confAzione.getConnettore().getProperties().containsKey("tokenPolicy") || this.importerEngine.existsGenericProperties_retrieve(policy2 = (String)confAzione.getConnettore().getProperties().get("tokenPolicy"))) continue;
                        throw new Exception("Token Policy Negoziazione [" + policy2 + "] indicato nel connettore non esistente");
                    }
                }
            }
            if (this.checkExistsPluginConfigurazione) {
                TipiConnettore tipo;
                if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore() != null && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getCustom() != null && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getCustom().booleanValue() && archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getTipo())) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getTipo())) {
                    throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConnettore().getTipo() + "] non esistente nel registro");
                }
                if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().sizeConfigurazioneAzioneList() > 0) {
                    for (ConfigurazioneServizioAzione confAzione : archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getConfigurazioneServizio().getConfigurazioneAzioneList()) {
                        TipiConnettore tipo2;
                        if (confAzione.getConnettore() == null || confAzione.getConnettore().getCustom() == null || !confAzione.getConnettore().getCustom().booleanValue() || confAzione.getConnettore().getTipo() == null || (tipo2 = TipiConnettore.toEnumFromName((String)confAzione.getConnettore().getTipo())) != null || this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), confAzione.getConnettore().getTipo())) continue;
                        throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + confAzione.getConnettore().getTipo() + "] non esistente nel registro");
                    }
                }
            }
            if (!(protocolloAssociatoAccordo = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoErogatore.getTipo())).equals(protocolloAssociatoAccordoParteComune = this.protocolFactoryManager.getProtocolByOrganizationType(idAccordoServizioParteComune.getSoggettoReferente().getTipo()))) {
                throw new Exception("AccordoServizioParteComune [" + idAccordoServizioParteComune + "] (protocollo:" + protocolloAssociatoAccordoParteComune + ") non utilizzabile in un accordo con soggetto erogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoAccordo + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto erogatore [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteComune.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte comune [" + idAccordoServizioParteComune + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setSuperUser(this.userLogin);
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeAllegatoList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getAllegato(i).setRuolo(RuoliDocumento.allegato.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getAllegato(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaSemiformaleList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSemiformale(i).setRuolo(RuoliDocumento.specificaSemiformale.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSemiformale(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaLivelloServizioList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaLivelloServizio(i).setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaLivelloServizio(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            for (i = 0; i < archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().sizeSpecificaSicurezzaList(); ++i) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSicurezza(i).setRuolo(RuoliDocumento.specificaSicurezza.toString());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getSpecificaSicurezza(i).setTipoProprietarioDocumento(ProprietariDocumento.servizio.toString());
            }
            StringBuilder warningInfoStatoFinale = new StringBuilder("");
            if (archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getStatoPackage() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    boolean gestioneWsdlImplementativo = false;
                    try {
                        IProtocolFactory<?> protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByServiceType(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getTipo());
                        gestioneWsdlImplementativo = protocol.createProtocolConfiguration().isSupportoPortiAccessoAccordiParteSpecifica(this.toMessageServiceBinding(accordoServizioParteComune.getServiceBinding()), this.formatoSpecifica2InterfaceType(accordoServizioParteComune.getFormatoSpecifica()));
                        archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), gestioneWsdlImplementativo, false);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), gestioneWsdlImplementativo, false);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Accordo salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setOraRegistrazione(DateManager.getDate());
            XMLDataConverter.aggiornatoStatoFruitori((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), (StatiAccordo)StatiAccordo.valueOf((String)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().getStatoPackage()));
            List<IDPortaApplicativa> idPACheck = null;
            ArchiveStatoImport statoImport = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setId(old.getId());
                IDServizio oldIDServizioForUpdate = IDServizioFactory.getInstance().getIDServizioFromValues(old.getTipo(), old.getNome(), old.getTipoSoggettoErogatore(), old.getNomeSoggettoErogatore(), old.getVersione().intValue());
                archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica().setOldIDServizioForUpdate(oldIDServizioForUpdate);
                boolean mantieniFruitoriEsistenti = true;
                XMLDataConverter.impostaInformazioniRegistro_AccordoServizioParteSpecifica_update((AccordoServizioParteSpecifica)archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica(), (AccordoServizioParteSpecifica)old, (boolean)mantieniFruitoriEsistenti);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(old.getSuperUser())) {
                    throw new Exception("L'accordo non \u00e8 visibile/aggiornabile dall'utente collegato (" + this.userLogin + ")");
                }
                this.importerEngine.updateAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                statoImport = ArchiveStatoImport.UPDATED;
                idPACheck = this.importerEngine.getIDPorteApplicativeAssociateErogazione(idAccordoServizioParteSpecifica);
            } else {
                this.importerEngine.createAccordoServizioParteSpecifica(archiveAccordoServizioParteSpecifica.getAccordoServizioParteSpecifica());
                statoImport = ArchiveStatoImport.CREATED;
            }
            if (archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate() != null && archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate().size() > 0) {
                for (MappingErogazionePortaApplicativa mappingPortaApplicativaAssociata : archiveAccordoServizioParteSpecifica.getMappingPorteApplicativeAssociate()) {
                    if (idPACheck != null && idPACheck.size() > 0 && idPACheck.contains(mappingPortaApplicativaAssociata.getIdPortaApplicativa())) continue;
                    listMappingErogazionePA.add(mappingPortaApplicativaAssociata);
                }
            }
            detail.setState(statoImport);
            detail.setStateDetail(warningInfoStatoFinale.toString());
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private org.openspcoop2.message.constants.ServiceBinding toMessageServiceBinding(ServiceBinding serviceBinding) {
        if (serviceBinding == null) {
            return null;
        }
        switch (serviceBinding) {
            case REST: {
                return org.openspcoop2.message.constants.ServiceBinding.REST;
            }
        }
        return org.openspcoop2.message.constants.ServiceBinding.SOAP;
    }

    private InterfaceType formatoSpecifica2InterfaceType(FormatoSpecifica formatoSpecifica) {
        if (formatoSpecifica == null) {
            return null;
        }
        switch (formatoSpecifica) {
            case SWAGGER_2: {
                return InterfaceType.SWAGGER_2;
            }
            case OPEN_API_3: {
                return InterfaceType.OPEN_API_3;
            }
            case WADL: {
                return InterfaceType.WADL;
            }
        }
        return InterfaceType.WSDL_11;
    }

    public void importFruitore(ArchiveFruitore archiveFruitore, ArchiveEsitoImportDetail detail, List<MappingFruizionePortaDelegata> listMappingFruizionePD) {
        IDServizio idAccordoServizioParteSpecifica = archiveFruitore.getIdAccordoServizioParteSpecifica();
        IDSoggetto idSoggettoFruitore = archiveFruitore.getIdSoggettoFruitore();
        try {
            String protocolloAssociatoAccordoParteSpecifica;
            String protocolloAssociatoFruitore;
            String policy;
            AccordoServizioParteSpecifica oldAccordo = null;
            Fruitore old = null;
            if (this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                oldAccordo = this.importerEngine.getAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica);
                for (int i = 0; i < oldAccordo.sizeFruitoreList(); ++i) {
                    Fruitore check = oldAccordo.getFruitore(i);
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    old = oldAccordo.removeFruitore(i);
                    break;
                }
            }
            if (!this.updateAbilitato && old != null) {
                if (archiveFruitore.getMappingPorteDelegateAssociate() != null && archiveFruitore.getMappingPorteDelegateAssociate().size() > 0) {
                    List<IDPortaDelegata> idPDCheck = this.importerEngine.getIDPorteDelegateAssociateFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                    for (MappingFruizionePortaDelegata mappingPortaDelegataAssociata : archiveFruitore.getMappingPorteDelegateAssociate()) {
                        if (idPDCheck != null && idPDCheck.size() > 0 && idPDCheck.contains(mappingPortaDelegataAssociata.getIdPortaDelegata())) continue;
                        listMappingFruizionePD.add(mappingPortaDelegataAssociata);
                    }
                }
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsSoggettoRegistro(idSoggettoFruitore)) {
                throw new Exception("Soggetto fruitore [" + idSoggettoFruitore + "] non esistente");
            }
            if (!this.importerEngine.existsAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica)) {
                throw new Exception("Accordo di Servizio Parte Specifica non esistente");
            }
            if (archiveFruitore.getFruitore().getConnettore() != null && archiveFruitore.getFruitore().getConnettore().getProperties() != null && archiveFruitore.getFruitore().getConnettore().getProperties().containsKey("tokenPolicy") && !this.importerEngine.existsGenericProperties_retrieve(policy = (String)archiveFruitore.getFruitore().getConnettore().getProperties().get("tokenPolicy"))) {
                throw new Exception("Token Policy Negoziazione [" + policy + "] indicato nel connettore non esistente");
            }
            if (archiveFruitore.getFruitore().sizeConfigurazioneAzioneList() > 0) {
                for (ConfigurazioneServizioAzione confAzione : archiveFruitore.getFruitore().getConfigurazioneAzioneList()) {
                    String policy2;
                    if (confAzione.getConnettore() == null || confAzione.getConnettore().getProperties() == null || !confAzione.getConnettore().getProperties().containsKey("tokenPolicy") || this.importerEngine.existsGenericProperties_retrieve(policy2 = (String)confAzione.getConnettore().getProperties().get("tokenPolicy"))) continue;
                    throw new Exception("Token Policy Negoziazione [" + policy2 + "] indicato nel connettore non esistente");
                }
            }
            if (this.checkExistsPluginConfigurazione) {
                TipiConnettore tipo;
                if (archiveFruitore.getFruitore().getConnettore() != null && archiveFruitore.getFruitore().getConnettore().getCustom() != null && archiveFruitore.getFruitore().getConnettore().getCustom().booleanValue() && archiveFruitore.getFruitore().getConnettore().getTipo() != null && (tipo = TipiConnettore.toEnumFromName((String)archiveFruitore.getFruitore().getConnettore().getTipo())) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), archiveFruitore.getFruitore().getConnettore().getTipo())) {
                    throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + archiveFruitore.getFruitore().getConnettore().getTipo() + "] non esistente nel registro");
                }
                if (archiveFruitore.getFruitore().sizeConfigurazioneAzioneList() > 0) {
                    for (ConfigurazioneServizioAzione confAzione : archiveFruitore.getFruitore().getConfigurazioneAzioneList()) {
                        TipiConnettore tipo2;
                        if (confAzione.getConnettore() == null || confAzione.getConnettore().getCustom() == null || !confAzione.getConnettore().getCustom().booleanValue() || confAzione.getConnettore().getTipo() == null || (tipo2 = TipiConnettore.toEnumFromName((String)confAzione.getConnettore().getTipo())) != null || this.importerEngine.existsPluginClasse(TipoPlugin.CONNETTORE.getValue(), confAzione.getConnettore().getTipo())) continue;
                        throw new Exception("Plugin '" + TipoPlugin.CONNETTORE.getValue() + "' [" + confAzione.getConnettore().getTipo() + "] non esistente nel registro");
                    }
                }
            }
            if (!(protocolloAssociatoFruitore = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoFruitore.getTipo())).equals(protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByOrganizationType(idAccordoServizioParteSpecifica.getSoggettoErogatore().getTipo()))) {
                throw new Exception("AccordoServizioParteSpecifica [" + idAccordoServizioParteSpecifica + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") non utilizzabile in un fruitore [" + idSoggettoFruitore + "] (protocollo:" + protocolloAssociatoFruitore + ")");
            }
            org.openspcoop2.core.registry.Soggetto soggetto = this.importerEngine.getSoggettoRegistro(idSoggettoFruitore);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto fruitore [" + idSoggettoFruitore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(oldAccordo.getSuperUser())) {
                throw new Exception("L'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            XMLDataConverter.impostaInformazioniRegistroDB_AccordoServizioParteSpecifica_Fruitore((Fruitore)archiveFruitore.getFruitore());
            StringBuilder warningInfoStatoFinale = new StringBuilder("");
            if (archiveFruitore.getFruitore() == null) {
                if (this.gestioneWorkflowStatiAccordi) {
                    try {
                        archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.finale.toString());
                        this.importerEngine.validaStatoFruitoreServizio(archiveFruitore.getFruitore(), oldAccordo);
                    }
                    catch (ValidazioneStatoPackageException validazioneException) {
                        try {
                            archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.operativo.toString());
                            this.importerEngine.validaStatoFruitoreServizio(archiveFruitore.getFruitore(), oldAccordo);
                        }
                        catch (ValidazioneStatoPackageException validazioneExceptionLevelOperativo) {
                            warningInfoStatoFinale.append("\n\t\t(WARNING) Fruitore salvato con stato '").append(StatiAccordo.bozza.toString()).append("':\n\t\t\t");
                            warningInfoStatoFinale.append(validazioneException.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            warningInfoStatoFinale.append("\n\t\t\t" + validazioneExceptionLevelOperativo.toString("\n\t\t\t - ", "\n\t\t\t - "));
                            archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.bozza.toString());
                        }
                    }
                } else {
                    archiveFruitore.getFruitore().setStatoPackage(StatiAccordo.finale.toString());
                }
            }
            archiveFruitore.getFruitore().setOraRegistrazione(DateManager.getDate());
            if (old != null) {
                archiveFruitore.getFruitore().setId(old.getId());
            }
            oldAccordo.addFruitore(archiveFruitore.getFruitore());
            IDServizio oldIDServizioForUpdate = IDServizioFactory.getInstance().getIDServizioFromValues(oldAccordo.getTipo(), oldAccordo.getNome(), oldAccordo.getTipoSoggettoErogatore(), oldAccordo.getNomeSoggettoErogatore(), oldAccordo.getVersione().intValue());
            oldAccordo.setOldIDServizioForUpdate(oldIDServizioForUpdate);
            this.importerEngine.updateAccordoServizioParteSpecifica(oldAccordo);
            if (archiveFruitore.getMappingPorteDelegateAssociate() != null && archiveFruitore.getMappingPorteDelegateAssociate().size() > 0) {
                List<IDPortaDelegata> idPDCheck = this.importerEngine.getIDPorteDelegateAssociateFruizione(archiveFruitore.getIdAccordoServizioParteSpecifica(), archiveFruitore.getIdSoggettoFruitore());
                for (MappingFruizionePortaDelegata mappingPortaDelegataAssociata : archiveFruitore.getMappingPorteDelegateAssociate()) {
                    if (idPDCheck != null && idPDCheck.size() > 0 && idPDCheck.contains(mappingPortaDelegataAssociata.getIdPortaDelegata())) continue;
                    listMappingFruizionePD.add(mappingPortaDelegataAssociata);
                }
            }
            if (old != null) {
                detail.setState(ArchiveStatoImport.UPDATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            } else {
                detail.setState(ArchiveStatoImport.CREATED);
                detail.setStateDetail(warningInfoStatoFinale.toString());
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del fruitore[" + idSoggettoFruitore + "] dell'accordo di servizio parte specifica [" + idAccordoServizioParteSpecifica + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPortaDelegata(ArchivePortaDelegata archivePortaDelegata, ArchiveEsitoImportDetail detail) {
        IDPortaDelegata idPortaDelegata = archivePortaDelegata.getIdPortaDelegata();
        IDSoggetto idSoggettoProprietario = archivePortaDelegata.getIdSoggettoProprietario();
        try {
            String protocolloAssociatoSoggettoErogatore;
            int i;
            if (!this.updateAbilitato && this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            PortaDelegata pd = archivePortaDelegata.getPortaDelegata();
            IDSoggetto idSoggettoErogatore = null;
            IDServizio idServizio = null;
            if (pd.getSoggettoErogatore() != null && pd.getSoggettoErogatore().getTipo() != null && pd.getSoggettoErogatore().getNome() != null) {
                idSoggettoErogatore = new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome());
            }
            if (idSoggettoErogatore != null && pd.getServizio() != null && pd.getServizio().getTipo() != null && pd.getServizio().getNome() != null && pd.getServizio().getVersione() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), idSoggettoErogatore, pd.getServizio().getVersione().intValue());
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            if (idSoggettoErogatore != null && !this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore riferito nella PD [" + idSoggettoErogatore + "] non esistente");
            }
            if (idServizio != null && !this.importerEngine.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new Exception("Servizio riferito nella PD [" + idServizio + "] non esistente");
            }
            if (archivePortaDelegata.getPortaDelegata().getRuoli() != null && archivePortaDelegata.getPortaDelegata().getRuoli().sizeRuoloList() > 0) {
                for (i = 0; i < archivePortaDelegata.getPortaDelegata().getRuoli().sizeRuoloList(); ++i) {
                    IDRuolo idRuolo = new IDRuolo(archivePortaDelegata.getPortaDelegata().getRuoli().getRuolo(i).getNome());
                    if (this.importerEngine.existsRuolo(idRuolo)) continue;
                    throw new Exception("Ruolo [" + idRuolo.getNome() + "] associato non esiste");
                }
            }
            if (archivePortaDelegata.getPortaDelegata().getScope() != null && archivePortaDelegata.getPortaDelegata().getScope().sizeScopeList() > 0) {
                for (i = 0; i < archivePortaDelegata.getPortaDelegata().getScope().sizeScopeList(); ++i) {
                    IDScope idScope = new IDScope(archivePortaDelegata.getPortaDelegata().getScope().getScope(i).getNome());
                    if (this.importerEngine.existsScope(idScope)) continue;
                    throw new Exception("Scope [" + idScope.getNome() + "] associato non esiste");
                }
            }
            if (archivePortaDelegata.getPortaDelegata().getServizioApplicativoList() != null && archivePortaDelegata.getPortaDelegata().sizeServizioApplicativoList() > 0) {
                for (i = 0; i < archivePortaDelegata.getPortaDelegata().sizeServizioApplicativoList(); ++i) {
                    IDServizioApplicativo idSaAuth = new IDServizioApplicativo();
                    idSaAuth.setIdSoggettoProprietario(idSoggettoProprietario);
                    idSaAuth.setNome(archivePortaDelegata.getPortaDelegata().getServizioApplicativo(i).getNome());
                    if (this.importerEngine.existsServizioApplicativo(idSaAuth)) continue;
                    throw new Exception("Applicativo [" + idSaAuth + "] indicato nel controllo degli accessi non esistente");
                }
            }
            if (archivePortaDelegata.getPortaDelegata().getGestioneToken() != null && archivePortaDelegata.getPortaDelegata().getGestioneToken().getPolicy() != null && !"".equals(archivePortaDelegata.getPortaDelegata().getGestioneToken().getPolicy()) && !this.importerEngine.existsGenericProperties_validation(archivePortaDelegata.getPortaDelegata().getGestioneToken().getPolicy())) {
                throw new Exception("Token Policy Validazione [" + archivePortaDelegata.getPortaDelegata().getGestioneToken().getPolicy() + "] indicato nel controllo degli accessi non esistente");
            }
            if (this.checkExistsPluginConfigurazione) {
                TipoAutenticazione tipo;
                if (archivePortaDelegata.getPortaDelegata() != null && StringUtils.isNotEmpty((String)archivePortaDelegata.getPortaDelegata().getAutenticazione()) && (tipo = TipoAutenticazione.toEnumConstant((String)archivePortaDelegata.getPortaDelegata().getAutenticazione(), (boolean)false)) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTENTICAZIONE.getValue(), archivePortaDelegata.getPortaDelegata().getAutenticazione())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTENTICAZIONE.getValue() + "' [" + archivePortaDelegata.getPortaDelegata().getAutenticazione() + "] non esistente nel registro");
                }
                if (archivePortaDelegata.getPortaDelegata() != null && StringUtils.isNotEmpty((String)archivePortaDelegata.getPortaDelegata().getAutorizzazione()) && (tipo = TipoAutorizzazione.toEnumConstant((String)archivePortaDelegata.getPortaDelegata().getAutorizzazione(), (boolean)false)) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTORIZZAZIONE.getValue(), archivePortaDelegata.getPortaDelegata().getAutorizzazione())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTORIZZAZIONE.getValue() + "' [" + archivePortaDelegata.getPortaDelegata().getAutorizzazione() + "] non esistente nel registro");
                }
                if (archivePortaDelegata.getPortaDelegata() != null && StringUtils.isNotEmpty((String)archivePortaDelegata.getPortaDelegata().getAutorizzazioneContenuto()) && !"builtIn".equals(archivePortaDelegata.getPortaDelegata().getAutorizzazioneContenuto()) && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue(), archivePortaDelegata.getPortaDelegata().getAutorizzazioneContenuto())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue() + "' [" + archivePortaDelegata.getPortaDelegata().getAutorizzazioneContenuto() + "] non esistente nel registro");
                }
            }
            String protocolloAssociatoSoggettoProprietario = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoProprietario.getTipo());
            if (idSoggettoErogatore != null && !protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoErogatore = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoErogatore.getTipo()))) {
                throw new Exception("SoggettoErogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoSoggettoErogatore + ") non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            if (idServizio != null) {
                String protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByServiceType(idServizio.getTipo());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") con servizio non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
                String protocolloAssociatoSoggettoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByOrganizationType(idServizio.getSoggettoErogatore().getTipo());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoSoggettoAccordoParteSpecifica + ") con soggetto non utilizzabile in una porta delegata appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            org.openspcoop2.core.registry.Soggetto soggettoErogatore = null;
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
            if (idSoggettoErogatore != null) {
                soggettoErogatore = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggettoErogatore.getSuperUser())) {
                    throw new Exception("Il soggetto erogatore riferito nella PD [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idServizio != null) {
                accordoServizioParteSpecifica = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteSpecifica.getSuperUser())) {
                    throw new Exception("Il servizio riferito nella PD [" + idServizio + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idSoggettoErogatore != null) {
                pd.getSoggettoErogatore().setId(soggettoErogatore.getId());
            }
            if (idServizio != null) {
                pd.getServizio().setId(accordoServizioParteSpecifica.getId());
            }
            pd.setOraRegistrazione(DateManager.getDate());
            org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_PortaDelegata((PortaDelegata)pd);
            MerlinProvider.correctProviderName((MessageSecurity)pd.getMessageSecurity());
            if (this.importerEngine.existsPortaDelegata(idPortaDelegata)) {
                PortaDelegata old = this.importerEngine.getPortaDelegata(idPortaDelegata);
                pd.setId(old.getId());
                IDPortaDelegata oldIDPortaDelegataForUpdate = new IDPortaDelegata();
                oldIDPortaDelegataForUpdate.setNome(old.getNome());
                pd.setOldIDPortaDelegataForUpdate(oldIDPortaDelegataForUpdate);
                this.importerEngine.updatePortaDelegata(pd);
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createPortaDelegata(pd);
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della porta delegata [" + idPortaDelegata + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPortaApplicativa(ArchivePortaApplicativa archivePortaApplicativa, ArchiveEsitoImportDetail detail) {
        IDPortaApplicativa idPortaApplicativa = archivePortaApplicativa.getIdPortaApplicativa();
        IDSoggetto idSoggettoProprietario = archivePortaApplicativa.getIdSoggettoProprietario();
        try {
            String protocolloAssociatoSoggettoErogatore;
            String protocolloAssociatoSoggettoProprietario;
            IDSoggetto idSoggettoAuth;
            int i;
            if (!this.updateAbilitato && this.importerEngine.existsPortaApplicativa(idPortaApplicativa)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (idSoggettoProprietario == null) {
                throw new Exception("Soggetto proprietario non definito");
            }
            PortaApplicativa pa = archivePortaApplicativa.getPortaApplicativa();
            IDServizio idServizio = null;
            IDSoggetto idSoggettoErogatore = idSoggettoProprietario;
            if (pa.getSoggettoVirtuale() != null && pa.getSoggettoVirtuale().getTipo() != null && pa.getSoggettoVirtuale().getNome() != null) {
                idSoggettoErogatore = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
            }
            if (idSoggettoErogatore != null && pa.getServizio() != null && pa.getServizio().getTipo() != null && pa.getServizio().getNome() != null && pa.getServizio().getVersione() != null) {
                idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), idSoggettoErogatore, pa.getServizio().getVersione().intValue());
            }
            if (!this.importerEngine.existsSoggettoConfigurazione(idSoggettoProprietario)) {
                throw new Exception("Soggetto proprietario [" + idSoggettoProprietario + "] non esistente");
            }
            if (idSoggettoErogatore != null && !this.importerEngine.existsSoggettoRegistro(idSoggettoErogatore)) {
                throw new Exception("Soggetto erogatore riferito nella PA [" + idSoggettoErogatore + "] non esistente");
            }
            if (idServizio != null && !this.importerEngine.existsAccordoServizioParteSpecifica(idServizio)) {
                throw new Exception("Servizio riferito nella PA [" + idServizio + "] non esistente");
            }
            if (archivePortaApplicativa.getPortaApplicativa().getRuoli() != null && archivePortaApplicativa.getPortaApplicativa().getRuoli().sizeRuoloList() > 0) {
                for (i = 0; i < archivePortaApplicativa.getPortaApplicativa().getRuoli().sizeRuoloList(); ++i) {
                    IDRuolo idRuolo = new IDRuolo(archivePortaApplicativa.getPortaApplicativa().getRuoli().getRuolo(i).getNome());
                    if (this.importerEngine.existsRuolo(idRuolo)) continue;
                    throw new Exception("Ruolo [" + idRuolo.getNome() + "] associato non esiste");
                }
            }
            if (archivePortaApplicativa.getPortaApplicativa().getScope() != null && archivePortaApplicativa.getPortaApplicativa().getScope().sizeScopeList() > 0) {
                for (i = 0; i < archivePortaApplicativa.getPortaApplicativa().getScope().sizeScopeList(); ++i) {
                    IDScope idScope = new IDScope(archivePortaApplicativa.getPortaApplicativa().getScope().getScope(i).getNome());
                    if (this.importerEngine.existsScope(idScope)) continue;
                    throw new Exception("Scope [" + idScope.getNome() + "] associato non esiste");
                }
            }
            if (archivePortaApplicativa.getPortaApplicativa().getSoggetti() != null && archivePortaApplicativa.getPortaApplicativa().getSoggetti().sizeSoggettoList() > 0) {
                for (i = 0; i < archivePortaApplicativa.getPortaApplicativa().getSoggetti().sizeSoggettoList(); ++i) {
                    idSoggettoAuth = new IDSoggetto(archivePortaApplicativa.getPortaApplicativa().getSoggetti().getSoggetto(i).getTipo(), archivePortaApplicativa.getPortaApplicativa().getSoggetti().getSoggetto(i).getNome());
                    if (this.importerEngine.existsSoggettoRegistro(idSoggettoAuth)) continue;
                    throw new Exception("Soggetto [" + idSoggettoAuth + "] indicato nel controllo degli accessi non esistente");
                }
            }
            if (archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati() != null && archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                for (i = 0; i < archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++i) {
                    idSoggettoAuth = new IDSoggetto(archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati().getServizioApplicativo(i).getTipoSoggettoProprietario(), archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati().getServizioApplicativo(i).getNomeSoggettoProprietario());
                    IDServizioApplicativo idSaAuth = new IDServizioApplicativo();
                    idSaAuth.setIdSoggettoProprietario(idSoggettoAuth);
                    idSaAuth.setNome(archivePortaApplicativa.getPortaApplicativa().getServiziApplicativiAutorizzati().getServizioApplicativo(i).getNome());
                    if (this.importerEngine.existsServizioApplicativo(idSaAuth)) continue;
                    throw new Exception("Applicativo [" + idSaAuth + "] indicato nel controllo degli accessi non esistente");
                }
            }
            if (archivePortaApplicativa.getPortaApplicativa().getServizioApplicativoList() != null && archivePortaApplicativa.getPortaApplicativa().sizeServizioApplicativoList() > 0) {
                for (i = 0; i < archivePortaApplicativa.getPortaApplicativa().sizeServizioApplicativoList(); ++i) {
                    IDServizioApplicativo idSaErogatore = new IDServizioApplicativo();
                    idSaErogatore.setIdSoggettoProprietario(idSoggettoErogatore);
                    idSaErogatore.setNome(archivePortaApplicativa.getPortaApplicativa().getServizioApplicativo(i).getNome());
                    if (this.importerEngine.existsServizioApplicativo(idSaErogatore)) continue;
                    throw new Exception("Servizio Applicativo [" + idSaErogatore + "] (erogatore) non esistente");
                }
            }
            if (archivePortaApplicativa.getPortaApplicativa().getGestioneToken() != null && archivePortaApplicativa.getPortaApplicativa().getGestioneToken().getPolicy() != null && !"".equals(archivePortaApplicativa.getPortaApplicativa().getGestioneToken().getPolicy()) && !this.importerEngine.existsGenericProperties_validation(archivePortaApplicativa.getPortaApplicativa().getGestioneToken().getPolicy())) {
                throw new Exception("Token Policy Validazione [" + archivePortaApplicativa.getPortaApplicativa().getGestioneToken().getPolicy() + "] indicato nel controllo degli accessi non esistente");
            }
            if (this.checkExistsPluginConfigurazione) {
                TipoBehaviour behaviourType;
                TipoAutenticazione tipo;
                if (archivePortaApplicativa.getPortaApplicativa() != null && StringUtils.isNotEmpty((String)archivePortaApplicativa.getPortaApplicativa().getAutenticazione()) && (tipo = TipoAutenticazione.toEnumConstant((String)archivePortaApplicativa.getPortaApplicativa().getAutenticazione(), (boolean)false)) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTENTICAZIONE.getValue(), archivePortaApplicativa.getPortaApplicativa().getAutenticazione())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTENTICAZIONE.getValue() + "' [" + archivePortaApplicativa.getPortaApplicativa().getAutenticazione() + "] non esistente nel registro");
                }
                if (archivePortaApplicativa.getPortaApplicativa() != null && StringUtils.isNotEmpty((String)archivePortaApplicativa.getPortaApplicativa().getAutorizzazione()) && (tipo = TipoAutorizzazione.toEnumConstant((String)archivePortaApplicativa.getPortaApplicativa().getAutorizzazione(), (boolean)false)) == null && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTORIZZAZIONE.getValue(), archivePortaApplicativa.getPortaApplicativa().getAutorizzazione())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTORIZZAZIONE.getValue() + "' [" + archivePortaApplicativa.getPortaApplicativa().getAutorizzazione() + "] non esistente nel registro");
                }
                if (archivePortaApplicativa.getPortaApplicativa() != null && StringUtils.isNotEmpty((String)archivePortaApplicativa.getPortaApplicativa().getAutorizzazioneContenuto()) && !"builtIn".equals(archivePortaApplicativa.getPortaApplicativa().getAutorizzazioneContenuto()) && !this.importerEngine.existsPluginClasse(TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue(), archivePortaApplicativa.getPortaApplicativa().getAutorizzazioneContenuto())) {
                    throw new Exception("Plugin '" + TipoPlugin.AUTORIZZAZIONE_CONTENUTI.getValue() + "' [" + archivePortaApplicativa.getPortaApplicativa().getAutorizzazioneContenuto() + "] non esistente nel registro");
                }
                if (archivePortaApplicativa.getPortaApplicativa() != null && archivePortaApplicativa.getPortaApplicativa().getBehaviour() != null && archivePortaApplicativa.getPortaApplicativa().getBehaviour().getNome() != null && TipoBehaviour.CUSTOM.equals((Object)(behaviourType = TipoBehaviour.toEnumConstant((String)archivePortaApplicativa.getPortaApplicativa().getBehaviour().getNome()))) && !this.importerEngine.existsPluginClasse(TipoPlugin.BEHAVIOUR.getValue(), archivePortaApplicativa.getPortaApplicativa().getBehaviour().getNome())) {
                    throw new Exception("Plugin '" + TipoPlugin.BEHAVIOUR.getValue() + "' [" + archivePortaApplicativa.getPortaApplicativa().getBehaviour().getNome() + "] non esistente nel registro");
                }
            }
            if (!(protocolloAssociatoSoggettoProprietario = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoProprietario.getTipo())).equals(protocolloAssociatoSoggettoErogatore = this.protocolFactoryManager.getProtocolByOrganizationType(idSoggettoErogatore.getTipo()))) {
                throw new Exception("SoggettoErogatore [" + idSoggettoErogatore + "] (protocollo:" + protocolloAssociatoSoggettoErogatore + ") non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
            }
            if (idServizio != null) {
                String protocolloAssociatoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByServiceType(idServizio.getTipo());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoAccordoParteSpecifica + ") con servizio non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
                String protocolloAssociatoSoggettoAccordoParteSpecifica = this.protocolFactoryManager.getProtocolByOrganizationType(idServizio.getSoggettoErogatore().getTipo());
                if (!protocolloAssociatoSoggettoProprietario.equals(protocolloAssociatoSoggettoAccordoParteSpecifica)) {
                    throw new Exception("AccordoServizioParteSpecifica [" + idServizio + "] (protocollo:" + protocolloAssociatoSoggettoAccordoParteSpecifica + ") con soggetto non utilizzabile in una porta applicativa appartenete al soggetto [" + idSoggettoProprietario + "] (protocollo:" + protocolloAssociatoSoggettoProprietario + ")");
                }
            }
            Soggetto soggetto = this.importerEngine.getSoggettoConfigurazione(idSoggettoProprietario);
            if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggetto.getSuperUser())) {
                throw new Exception("Il soggetto proprietario [" + idSoggettoProprietario + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
            }
            org.openspcoop2.core.registry.Soggetto soggettoErogatore = null;
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = null;
            if (idSoggettoErogatore != null) {
                soggettoErogatore = this.importerEngine.getSoggettoRegistro(idSoggettoErogatore);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(soggettoErogatore.getSuperUser())) {
                    throw new Exception("Il soggetto erogatore riferito nella PA [" + idSoggettoErogatore + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (idServizio != null) {
                accordoServizioParteSpecifica = this.importerEngine.getAccordoServizioParteSpecifica(idServizio);
                if (!this.importerEngine.isVisioneOggettiGlobale(this.userLogin) && !this.userLogin.equals(accordoServizioParteSpecifica.getSuperUser())) {
                    throw new Exception("Il servizio riferito nella PA [" + idServizio + "] non \u00e8 visibile/utilizzabile dall'utente collegato (" + this.userLogin + ")");
                }
            }
            if (pa.getSoggettoVirtuale() != null) {
                pa.getSoggettoVirtuale().setId(soggettoErogatore.getId());
            }
            if (idServizio != null) {
                pa.getServizio().setId(accordoServizioParteSpecifica.getId());
            }
            pa.setOraRegistrazione(DateManager.getDate());
            org.openspcoop2.core.config.driver.utils.XMLDataConverter.impostaInformazioniConfigurazione_PortaApplicativa((PortaApplicativa)pa);
            MerlinProvider.correctProviderName((MessageSecurity)pa.getMessageSecurity());
            if (this.importerEngine.existsPortaApplicativa(idPortaApplicativa)) {
                PortaApplicativa old = this.importerEngine.getPortaApplicativa(idPortaApplicativa);
                pa.setId(old.getId());
                IDPortaApplicativa oldIDPortaApplicativaForUpdate = new IDPortaApplicativa();
                oldIDPortaApplicativaForUpdate.setNome(old.getNome());
                pa.setOldIDPortaApplicativaForUpdate(oldIDPortaApplicativaForUpdate);
                this.importerEngine.updatePortaApplicativa(pa);
                detail.setState(ArchiveStatoImport.UPDATED);
            } else {
                this.importerEngine.createPortaApplicativa(pa);
                detail.setState(ArchiveStatoImport.CREATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della porta applicativa [" + idPortaApplicativa + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importControlloTraffico_configurazione(ConfigurazioneGenerale configurazione, ArchiveEsitoImportDetailConfigurazione<ConfigurazioneGenerale> detail) {
        try {
            if (!this.importConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_CONFIG_NOT_ENABLED);
                return;
            }
            this.importerEngine.updateControlloTraffico_configurazione(configurazione);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione di controllo del traffico: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importControlloTraffico_configurationPolicy(ArchiveConfigurationPolicy archivePolicy, ArchiveEsitoImportDetail detail) {
        String nomePolicy = archivePolicy.getNomePolicy();
        try {
            if (!this.importPolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsControlloTraffico_configurationPolicy(nomePolicy)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            boolean create = false;
            if (this.importerEngine.existsControlloTraffico_configurationPolicy(nomePolicy)) {
                ConfigurazionePolicy old = this.importerEngine.getControlloTraffico_configurationPolicy(nomePolicy);
                archivePolicy.getPolicy().setId(old.getId());
                this.importerEngine.updateControlloTraffico_configurationPolicy(archivePolicy.getPolicy());
                create = false;
            } else {
                this.importerEngine.createControlloTraffico_configurationPolicy(archivePolicy.getPolicy());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione della policy [" + nomePolicy + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importControlloTraffico_activePolicy(ArchiveActivePolicy archivePolicy, ArchiveEsitoImportDetail detail, HashMap<String, String> instanceSerialIdsForPolicy) {
        AttivazionePolicy attivazionePolicy = archivePolicy.getPolicy();
        String aliasPolicy = archivePolicy.getAliasPolicy();
        RuoloPolicy ruoloPorta = archivePolicy.getRuoloPorta();
        String nomePorta = archivePolicy.getNomePorta();
        Object tipoPolicy = "configurazione";
        if (ruoloPorta != null && nomePorta != null) {
            tipoPolicy = ruoloPorta.toString() + " " + nomePorta;
        }
        try {
            boolean policyGlobale = archivePolicy.isPolicyGlobale();
            if (policyGlobale && !this.importPolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsControlloTraffico_activePolicy(ruoloPorta, nomePorta, aliasPolicy)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (attivazionePolicy == null) {
                throw new Exception("Configurazione della policy non definita");
            }
            if (!this.importerEngine.existsControlloTraffico_configurationPolicy(attivazionePolicy.getIdPolicy())) {
                throw new Exception("Configurazione della policy [" + attivazionePolicy.getIdPolicy() + "] non esistente nel registro");
            }
            if (this.checkExistsPluginConfigurazione) {
                TipoFiltroApplicativo tipoFiltro;
                if (attivazionePolicy != null && attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().isEnabled() && attivazionePolicy.getFiltro().isInformazioneApplicativaEnabled() && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getInformazioneApplicativaTipo()) && TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)attivazionePolicy.getFiltro().getInformazioneApplicativaTipo(), (boolean)false))) && !this.importerEngine.existsPluginClasse(TipoPlugin.RATE_LIMITING.getValue(), attivazionePolicy.getFiltro().getInformazioneApplicativaNome())) {
                    throw new Exception("Plugin '" + TipoPlugin.RATE_LIMITING.getValue() + "' [" + attivazionePolicy.getFiltro().getInformazioneApplicativaNome() + "] non esistente nel registro");
                }
                if (attivazionePolicy != null && attivazionePolicy.getGroupBy() != null && attivazionePolicy.getGroupBy().isEnabled() && attivazionePolicy.getGroupBy().isInformazioneApplicativaEnabled() && StringUtils.isNotEmpty((String)attivazionePolicy.getGroupBy().getInformazioneApplicativaTipo()) && TipoFiltroApplicativo.PLUGIN_BASED.equals((Object)(tipoFiltro = TipoFiltroApplicativo.toEnumConstant((String)attivazionePolicy.getGroupBy().getInformazioneApplicativaTipo(), (boolean)false))) && !this.importerEngine.existsPluginClasse(TipoPlugin.RATE_LIMITING.getValue(), attivazionePolicy.getGroupBy().getInformazioneApplicativaNome())) {
                    throw new Exception("Plugin '" + TipoPlugin.RATE_LIMITING.getValue() + "' [" + attivazionePolicy.getGroupBy().getInformazioneApplicativaNome() + "] non esistente nel registro");
                }
            }
            boolean create = false;
            if (this.importerEngine.existsControlloTraffico_activePolicy(ruoloPorta, nomePorta, aliasPolicy)) {
                AttivazionePolicy old = this.importerEngine.getControlloTraffico_activePolicy(ruoloPorta, nomePorta, aliasPolicy);
                attivazionePolicy.setId(old.getId());
                attivazionePolicy.setOldIdActivePolicy(new IdActivePolicy());
                attivazionePolicy.getOldIdActivePolicy().setNome(old.getIdActivePolicy());
                if (old.getIdPolicy().equals(attivazionePolicy.getIdPolicy())) {
                    attivazionePolicy.setIdActivePolicy(old.getIdActivePolicy());
                } else {
                    attivazionePolicy.setIdActivePolicy(this.buildIdActivePolicy(instanceSerialIdsForPolicy, attivazionePolicy.getIdPolicy()));
                }
                attivazionePolicy.setPosizione(old.getPosizione());
                this.importerEngine.updateControlloTraffico_activePolicy(attivazionePolicy);
                create = false;
            } else {
                attivazionePolicy.setIdActivePolicy(this.buildIdActivePolicy(instanceSerialIdsForPolicy, attivazionePolicy.getIdPolicy()));
                this.importerEngine.createControlloTraffico_activePolicy(attivazionePolicy, this.log);
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'attivazione della policy [" + aliasPolicy + "] (" + (String)tipoPolicy + "): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private String buildIdActivePolicy(HashMap<String, String> instanceSerialIdsForPolicy, String idPolicy) throws RegistryException {
        String serialId = null;
        if (instanceSerialIdsForPolicy.containsKey(idPolicy)) {
            serialId = instanceSerialIdsForPolicy.remove(idPolicy);
            serialId = ControlloTrafficoDriverUtils.incrementPolicyInstanceSerialId((String)serialId);
            instanceSerialIdsForPolicy.put(idPolicy, serialId);
        } else {
            serialId = this.importerEngine.getNextPolicyInstanceSerialId(idPolicy, this.log);
            instanceSerialIdsForPolicy.put(idPolicy, serialId);
        }
        String idActive = ControlloTrafficoDriverUtils.buildIdActivePolicy((String)idPolicy, (String)serialId);
        return idActive;
    }

    public void importAllarme(ArchiveAllarme archiveAllarme, ArchiveEsitoImportDetail detail, HashMap<String, String> instanceSerialIdsForAlarm) {
        Allarme allarme = archiveAllarme.getAllarme();
        String aliasAllarme = archiveAllarme.getAlias();
        RuoloPorta ruoloPorta = archiveAllarme.getRuoloPorta();
        String nomePorta = archiveAllarme.getNomePorta();
        Object tipoAllarme = "configurazione";
        if (ruoloPorta != null && nomePorta != null) {
            tipoAllarme = ruoloPorta.toString() + " " + nomePorta;
        }
        try {
            boolean allarmeGlobale = archiveAllarme.isAllarmeGlobale();
            if (allarmeGlobale && !this.importPolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsAllarme(ruoloPorta, nomePorta, aliasAllarme)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (!this.importerEngine.existsPluginClasse(TipoPlugin.ALLARME.getValue(), allarme.getTipo())) {
                throw new Exception("Plugin '" + TipoPlugin.ALLARME.getValue() + "' [" + allarme.getTipo() + "] non esistente nel registro");
            }
            boolean create = false;
            if (this.importerEngine.existsAllarme(ruoloPorta, nomePorta, aliasAllarme)) {
                Allarme old = this.importerEngine.getAllarme(ruoloPorta, nomePorta, aliasAllarme);
                allarme.setId(old.getId());
                allarme.setNome(old.getNome());
                if (allarme.sizeAllarmeParametroList() > 0 && old.sizeAllarmeParametroList() > 0) {
                    block2: for (AllarmeParametro param : allarme.getAllarmeParametroList()) {
                        for (AllarmeParametro oldParam : old.getAllarmeParametroList()) {
                            if (!oldParam.getIdParametro().equals(param.getIdParametro())) continue;
                            param.setId(oldParam.getId());
                            continue block2;
                        }
                    }
                }
                this.importerEngine.updateAllarme(allarme, this.log);
                create = false;
            } else {
                allarme.setNome(this.buildIdAllarme(instanceSerialIdsForAlarm, allarme.getTipo()));
                this.importerEngine.createAllarme(allarme, this.log);
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'allarme [" + aliasAllarme + "] (" + (String)tipoAllarme + "): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    private String buildIdAllarme(HashMap<String, String> instanceSerialIdsForAlarm, String tipoPlugin) throws RegistryException {
        String serialId = null;
        if (instanceSerialIdsForAlarm.containsKey(tipoPlugin)) {
            serialId = instanceSerialIdsForAlarm.remove(tipoPlugin);
            serialId = AllarmiDriverUtils.incrementAlarmInstanceSerialId((String)serialId);
            instanceSerialIdsForAlarm.put(tipoPlugin, serialId);
        } else {
            serialId = this.importerEngine.getNextAlarmInstanceSerialId(tipoPlugin, this.log);
            instanceSerialIdsForAlarm.put(tipoPlugin, serialId);
        }
        String idActive = AllarmiDriverUtils.buildIdAlarm((String)tipoPlugin, (String)serialId);
        return idActive;
    }

    public void importTokenPolicy(ArchiveTokenPolicy archivePolicy, ArchiveEsitoImportDetail detail) {
        this._importGenericProperties("Token Policy", (AbstractArchiveGenericProperties)archivePolicy, detail);
    }

    public void importAttributeAuthority(ArchiveAttributeAuthority archiveAA, ArchiveEsitoImportDetail detail) {
        this._importGenericProperties("Attribute Authority", (AbstractArchiveGenericProperties)archiveAA, detail);
    }

    public void _importGenericProperties(String oggetto, AbstractArchiveGenericProperties archiveGenericProperties, ArchiveEsitoImportDetail detail) {
        if (archiveGenericProperties == null) {
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)new Exception("archiveGenericProperties is null"));
            return;
        }
        String nomePolicy = archiveGenericProperties.getNomePolicy();
        String tipologiaPolicy = archiveGenericProperties.getTipologiaPolicy();
        try {
            if (!this.importPolicyConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_POLICY_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsGenericProperties(tipologiaPolicy, nomePolicy)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            if (this.checkExistsPluginConfigurazione) {
                String gpName;
                Property p;
                int i;
                boolean tokenValidazione = "gestionePolicyToken".equals(archiveGenericProperties.getTipologiaPolicy());
                boolean tokenNegoziazione = "retrievePolicyToken".equals(archiveGenericProperties.getTipologiaPolicy());
                boolean attributeAuthority = "attributeAuthority".equals(archiveGenericProperties.getTipologiaPolicy());
                ArrayList<String> tokenName = new ArrayList<String>();
                TipoPlugin tipoPlugin = null;
                if (tokenValidazione) {
                    tokenName.add("policy.validazioneJWT.claimsParser.pluginType");
                    tokenName.add("policy.introspection.claimsParser.pluginType");
                    tokenName.add("policy.userInfo.claimsParser.pluginType");
                    tipoPlugin = TipoPlugin.TOKEN_VALIDAZIONE;
                } else if (tokenNegoziazione) {
                    tokenName.add("policy.retrieveToken.claimsParser.pluginType");
                    tipoPlugin = TipoPlugin.TOKEN_NEGOZIAZIONE;
                } else if (attributeAuthority) {
                    tokenName.add("policy.attributeAuthority.claimsParser.pluginType");
                    tipoPlugin = TipoPlugin.ATTRIBUTE_AUTHORITY;
                }
                if (!tokenName.isEmpty() && archiveGenericProperties != null && archiveGenericProperties.getPolicy() != null && archiveGenericProperties.getPolicy().sizePropertyList() > 0) {
                    for (i = 0; i < archiveGenericProperties.getPolicy().sizePropertyList(); ++i) {
                        p = archiveGenericProperties.getPolicy().getProperty(i);
                        if (!tokenName.contains(p.getNome()) || (gpName = p.getValore()) == null || !StringUtils.isNotEmpty((String)gpName) || "-".equals(gpName) || this.importerEngine.existsPluginClasse(tipoPlugin.getValue(), gpName)) continue;
                        throw new Exception("Plugin '" + tipoPlugin.getValue() + "' [" + p.getValore() + "] non esistente nel registro");
                    }
                }
                tokenName.clear();
                if (tokenValidazione) {
                    tokenName.add("policy.discovery.claimsParser.pluginType");
                    tipoPlugin = TipoPlugin.TOKEN_DYNAMIC_DISCOVERY;
                }
                if (!tokenName.isEmpty() && archiveGenericProperties != null && archiveGenericProperties.getPolicy() != null && archiveGenericProperties.getPolicy().sizePropertyList() > 0) {
                    for (i = 0; i < archiveGenericProperties.getPolicy().sizePropertyList(); ++i) {
                        p = archiveGenericProperties.getPolicy().getProperty(i);
                        if (!tokenName.contains(p.getNome()) || (gpName = p.getValore()) == null || !StringUtils.isNotEmpty((String)gpName) || "-".equals(gpName) || this.importerEngine.existsPluginClasse(tipoPlugin.getValue(), gpName)) continue;
                        throw new Exception("Plugin '" + tipoPlugin.getValue() + "' [" + p.getValore() + "] non esistente nel registro");
                    }
                }
            }
            boolean create = false;
            if (this.importerEngine.existsGenericProperties(tipologiaPolicy, nomePolicy)) {
                GenericProperties old = this.importerEngine.getGenericProperties(tipologiaPolicy, nomePolicy);
                archiveGenericProperties.getPolicy().setId(old.getId());
                this.importerEngine.updateGenericProperties(archiveGenericProperties.getPolicy());
                create = false;
            } else {
                this.importerEngine.createGenericProperties(archiveGenericProperties.getPolicy());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione '" + oggetto + "' [" + nomePolicy + "] (tipo: '" + tipologiaPolicy + "'): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPluginArchivio(ArchivePluginArchivio archivePlugin, ArchiveEsitoImportDetail detail) {
        String nome = archivePlugin.getNome();
        try {
            if (!this.importPluginConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_PLUGIN_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsPluginArchivio(nome)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            boolean create = false;
            if (this.importerEngine.existsPluginArchivio(nome)) {
                RegistroPlugin old = this.importerEngine.getPluginArchivio(nome);
                archivePlugin.getPlugin().setId(old.getId());
                archivePlugin.getPlugin().setOldNome(old.getNome());
                archivePlugin.getPlugin().setPosizione(old.getPosizione());
                this.importerEngine.updatePluginArchivio(archivePlugin.getPlugin());
                create = false;
            } else {
                this.importerEngine.createPluginArchivio(archivePlugin.getPlugin());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import dell'archivio dei plugin [" + nome + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importPluginClasse(ArchivePluginClasse archivePluginClasse, ArchiveEsitoImportDetail detail) {
        String tipoPlugin = archivePluginClasse.getTipoPlugin();
        String tipo = archivePluginClasse.getTipo();
        String className = archivePluginClasse.getClassName();
        String label = archivePluginClasse.getLabel();
        try {
            if (!this.importPluginConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_PLUGIN_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato) {
                if (this.importerEngine.existsPluginClasse(tipoPlugin, tipo)) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    return;
                }
                if (this.importerEngine.existsPluginClasseByClassName(tipoPlugin, className)) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    detail.setStateDetail(" plugin '" + tipoPlugin + "' definito con la stessa classe '" + className + "'");
                    return;
                }
                if (this.importerEngine.existsPluginClasseByLabel(tipoPlugin, label)) {
                    detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                    detail.setStateDetail(" plugin '" + tipoPlugin + "' definito con la stessa label '" + label + "'");
                    return;
                }
            }
            boolean create = false;
            if (this.importerEngine.existsPluginClasse(tipoPlugin, tipo)) {
                Plugin old = this.importerEngine.getPluginClasse(tipoPlugin, tipo);
                archivePluginClasse.getPlugin().setId(old.getId());
                IdPlugin oldIdPlugin = new IdPlugin();
                oldIdPlugin.setClassName(old.getClassName());
                oldIdPlugin.setLabel(old.getLabel());
                oldIdPlugin.setTipo(old.getTipo());
                oldIdPlugin.setTipoPlugin(old.getTipoPlugin());
                archivePluginClasse.getPlugin().setOldIdPlugin(oldIdPlugin);
                this.importerEngine.updatePluginClasse(archivePluginClasse.getPlugin());
                create = false;
            } else {
                this.importerEngine.createPluginClasse(archivePluginClasse.getPlugin());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import del plugin [" + tipo + "] (tipo-plugin: '" + tipoPlugin + "'): " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importConfigurazione_UrlInvocazioneRegola(ArchiveUrlInvocazioneRegola archiveRegola, ArchiveEsitoImportDetail detail) {
        String nome = archiveRegola.getNome();
        try {
            if (!this.importConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_CONFIG_NOT_ENABLED);
                return;
            }
            if (!this.updateAbilitato && this.importerEngine.existsUrlInvocazioneRegola(nome)) {
                detail.setState(ArchiveStatoImport.UPDATE_NOT_ENABLED);
                return;
            }
            boolean create = false;
            if (this.importerEngine.existsUrlInvocazioneRegola(nome)) {
                ConfigurazioneUrlInvocazioneRegola old = this.importerEngine.getUrlInvocazioneRegola(nome);
                archiveRegola.getRegola().setId(old.getId());
                archiveRegola.getRegola().setOldNome(old.getNome());
                archiveRegola.getRegola().setPosizione(old.getPosizione());
                this.importerEngine.updateUrlInvocazioneRegola(archiveRegola.getRegola());
                create = false;
            } else {
                this.importerEngine.createUrlInvocazioneRegola(archiveRegola.getRegola());
                create = true;
            }
            if (create) {
                detail.setState(ArchiveStatoImport.CREATED);
            } else {
                detail.setState(ArchiveStatoImport.UPDATED);
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della regola di proxy pass [" + nome + "]: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importConfigurazione_UrlInvocazione(ConfigurazioneUrlInvocazione configurazionePdD, ArchiveEsitoImportDetailConfigurazione<ConfigurazioneUrlInvocazione> detail) {
        try {
            if (!this.importConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_CONFIG_NOT_ENABLED);
                return;
            }
            this.importerEngine.updateConfigurazione_UrlInvocazione(configurazionePdD);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione dell'url di invocazione: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }

    public void importConfigurazione(Configurazione configurazionePdD, ArchiveEsitoImportDetailConfigurazione<Configurazione> detail) {
        try {
            if (!this.importConfigurazione) {
                detail.setState(ArchiveStatoImport.IMPORT_CONFIG_NOT_ENABLED);
                return;
            }
            this.importerEngine.updateConfigurazione(configurazionePdD);
            detail.setState(ArchiveStatoImport.UPDATED);
        }
        catch (Exception e) {
            this.log.error("Errore durante l'import della configurazione: " + e.getMessage(), (Throwable)e);
            detail.setState(ArchiveStatoImport.ERROR);
            detail.setException((Throwable)e);
        }
    }
}

