/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.archive;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.GruppiAccordo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.utils.CleanerOpenSPCoop2Extensions;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class WizardAPIUtilities {
    private static final String EMPTY = "Empty?";
    private static final String SUFFIX_NON_ESISTENTE = " non esistente";
    private static final String SUFFIX_NON_LEGGIBILE = " non leggibile";
    private static final String USE = "Usage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]";
    private static final Logger log = LoggerWrapperFactory.getLogger(WizardAPIUtilities.class);
    private static final String PROPERTIES_NAME = "name";
    private static final String PROPERTIES_VERSION = "version";
    private static final String PROPERTIES_DESCRIPTION = "description";
    private static final String PROPERTIES_SERVICE_BINDING = "serviceBinding";
    private static final String PROPERTIES_INTERFACE_TYPE = "interfaceType";
    private static final String PROPERTIES_TAG = "tag";
    private static final String PROPERTIES_CANALE = "canale";
    private static final String CAST_BOOLEAN = "(boolean) ";
    private static final String CAST_NUMBER = "(number) ";
    private static final String CAST_INT = "(int) ";
    private static final String CAST_LONG = "(long) ";
    private static final String CAST_FILE = "(file) ";

    public static void main(String[] args) throws ProtocolException {
        if (args == null || args.length < 4) {
            throw new ProtocolException("ERROR: argomenti non forniti\nUsage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]");
        }
        String pathOutputFile = WizardAPIUtilities.readPathOutpuFile(args, 0);
        String profile = WizardAPIUtilities.readProfile(args, 1);
        byte[] bytesInterface = WizardAPIUtilities.readInterface(args, 2);
        Properties properties = WizardAPIUtilities.readProperties(args, 3);
        Properties profileProperties = WizardAPIUtilities.readProfileProperties(args, 4);
        IProtocolFactory<?> protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(profile);
        AccordoServizioParteComune as = WizardAPIUtilities.buildAccordo(properties, bytesInterface, protocol);
        WizardAPIUtilities.addProfileProperties(as, profileProperties);
        protocol.createArchive().setProtocolInfo(as);
        CleanerOpenSPCoop2Extensions cleaner = new CleanerOpenSPCoop2Extensions();
        cleaner.clean(as);
        try (FileOutputStream fout = new FileOutputStream(pathOutputFile);){
            as.writeTo((OutputStream)fout, WriteToSerializerType.XML_JAXB);
        }
        catch (Exception e) {
            throw new ProtocolException("Serializzazione in '" + pathOutputFile + "' non riuscita: " + e.getMessage(), (Throwable)e);
        }
        log.info("Serializzazione completata");
    }

    private static String readPathOutpuFile(String[] args, int position) throws ProtocolException {
        String pathOutputFile = args[position];
        if (pathOutputFile == null || StringUtils.isEmpty((String)pathOutputFile)) {
            throw new ProtocolException("ERROR: argomento 'pathOutputFile' non fornito\nUsage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]");
        }
        File fPathOutputFile = new File(pathOutputFile);
        if (fPathOutputFile.exists()) {
            throw new ProtocolException("ERROR: argomento 'pathOutputFile' contiene il riferimento ad un file " + fPathOutputFile.getAbsolutePath() + " gi\u00e0 esistente");
        }
        return pathOutputFile;
    }

    private static String readProfile(String[] args, int position) throws ProtocolException {
        String profile = args[position];
        if (profile == null || StringUtils.isEmpty((String)profile)) {
            throw new ProtocolException("ERROR: argomento 'profile' non fornito\nUsage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]");
        }
        try {
            ConfigurazionePdD configPdD = new ConfigurazionePdD();
            configPdD.setLoader(new Loader());
            configPdD.setLog(log);
            ProtocolFactoryManager.initialize(log, configPdD, profile);
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: argomento 'profile=" + profile + "' non valido:" + e.getMessage(), (Throwable)e);
        }
        return profile;
    }

    private static byte[] readInterface(String[] args, int position) throws ProtocolException {
        String pathInterface = args[position];
        if (pathInterface == null || StringUtils.isEmpty((String)pathInterface)) {
            throw new ProtocolException("ERROR: argomento 'pathInterface' non fornito\nUsage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]");
        }
        File fPathInterface = new File(pathInterface);
        WizardAPIUtilities.checkExists(fPathInterface, "pathInterface");
        byte[] bytesInterface = null;
        try {
            bytesInterface = FileSystemUtilities.readBytesFromFile((File)fPathInterface);
            if (bytesInterface == null || bytesInterface.length <= 0) {
                throw new ProtocolException(EMPTY);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: argomento 'pathInterface=" + pathInterface + "' non valido:" + e.getMessage(), (Throwable)e);
        }
        return bytesInterface;
    }

    private static Properties readProperties(String[] args, int position) throws ProtocolException {
        String pathProperties = args[position];
        if (pathProperties == null || StringUtils.isEmpty((String)pathProperties)) {
            throw new ProtocolException("ERROR: argomento 'pathProperties' non fornito\nUsage: java WizardAPIUtilities pathOutputFile profile pathInterface pathProperties [pathProfileProperties]");
        }
        File fPathProperties = new File(pathProperties);
        WizardAPIUtilities.checkExists(fPathProperties, "pathProperties");
        byte[] bytesProperties = null;
        try {
            bytesProperties = FileSystemUtilities.readBytesFromFile((File)fPathProperties);
            if (bytesProperties == null || bytesProperties.length <= 0) {
                throw new ProtocolException(EMPTY);
            }
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: argomento 'pathProperties=" + pathProperties + "' non \u00e8 un file di propriet\u00e0 corretto:" + e.getMessage(), (Throwable)e);
        }
        return WizardAPIUtilities.convertToProperties("pathProperties=" + pathProperties, bytesProperties);
    }

    private static Properties readProfileProperties(String[] args, int position) throws ProtocolException {
        String pathProfileProperties;
        Properties profileProperties = null;
        if (args.length >= position + 1 && (pathProfileProperties = args[position]) != null && !StringUtils.isEmpty((String)pathProfileProperties)) {
            File fPathProfileProperties = new File(pathProfileProperties);
            WizardAPIUtilities.checkExists(fPathProfileProperties, "pathProfileProperties");
            byte[] bytesProfileProperties = null;
            try {
                bytesProfileProperties = FileSystemUtilities.readBytesFromFile((File)fPathProfileProperties);
                if (bytesProfileProperties == null || bytesProfileProperties.length <= 0) {
                    throw new ProtocolException(EMPTY);
                }
            }
            catch (Exception e) {
                throw new ProtocolException("ERROR: argomento 'pathProfileProperties=" + pathProfileProperties + "' non \u00e8 un file di propriet\u00e0 corretto:" + e.getMessage(), (Throwable)e);
            }
            profileProperties = WizardAPIUtilities.convertToProperties("pathProfileProperties=" + pathProfileProperties, bytesProfileProperties);
        }
        return profileProperties;
    }

    private static void checkExists(File f, String name) throws ProtocolException {
        if (!f.exists()) {
            throw new ProtocolException("ERROR: argomento '" + name + "' contiene il riferimento ad un file " + f.getAbsolutePath() + SUFFIX_NON_ESISTENTE);
        }
        if (!f.canRead()) {
            throw new ProtocolException("ERROR: argomento '" + name + "' contiene il riferimento ad un file " + f.getAbsolutePath() + SUFFIX_NON_LEGGIBILE);
        }
    }

    private static Properties convertToProperties(String name, byte[] b) throws ProtocolException {
        Properties tmp = new Properties();
        try (ByteArrayInputStream bin = new ByteArrayInputStream(b);){
            tmp.load(bin);
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: conversione non  riuscita, argomento '" + name + "' non corretto:" + e.getMessage(), (Throwable)e);
        }
        return tmp;
    }

    private static AccordoServizioParteComune buildAccordo(Properties properties, byte[] bytesInterface, IProtocolFactory<?> protocol) throws ProtocolException {
        String canale;
        AccordoServizioParteComune as = new AccordoServizioParteComune();
        as.setNome(WizardAPIUtilities.readProperty(properties, PROPERTIES_NAME, true));
        as.setDescrizione(WizardAPIUtilities.readProperty(properties, PROPERTIES_DESCRIPTION, false));
        as.setByteWsdlConcettuale(bytesInterface);
        as.setProfiloCollaborazione(ProfiloCollaborazione.SINCRONO);
        String serviceBinding = null;
        try {
            serviceBinding = WizardAPIUtilities.readProperty(properties, PROPERTIES_SERVICE_BINDING, true);
            as.setServiceBinding(ServiceBinding.toEnumConstant((String)serviceBinding, (boolean)true));
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: 'pathProperties' contiene una propriet\u00e0 'serviceBinding' valorizzata con un valore '" + serviceBinding + "' non supportato:" + e.getMessage(), (Throwable)e);
        }
        if (ServiceBinding.SOAP.equals((Object)as.getServiceBinding())) {
            as.setByteWsdlLogicoErogatore(bytesInterface);
        }
        String formatoSpecifica = null;
        try {
            formatoSpecifica = WizardAPIUtilities.readProperty(properties, PROPERTIES_INTERFACE_TYPE, true);
            as.setFormatoSpecifica(FormatoSpecifica.toEnumConstant((String)formatoSpecifica, (boolean)true));
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: 'pathProperties' contiene una propriet\u00e0 'interfaceType' valorizzata con un valore '" + formatoSpecifica + "' non supportato:" + e.getMessage(), (Throwable)e);
        }
        String tipoSoggettoDefault = protocol.getManifest().getRegistry().getOrganization().getTypes().getType(0).getName();
        IdSoggetto assr = new IdSoggetto();
        assr.setTipo(tipoSoggettoDefault);
        assr.setNome("@OPENSPCOOP2_NOME_SOGGETTO_DEFAULT@");
        as.setSoggettoReferente(assr);
        String versioneApi = null;
        try {
            versioneApi = WizardAPIUtilities.readProperty(properties, PROPERTIES_VERSION, true);
            as.setVersione(Integer.valueOf(Integer.parseInt(versioneApi)));
        }
        catch (Exception e) {
            throw new ProtocolException("ERROR: argomento 'pathProperties' contiene una propriet\u00e0 'version' valorizzata con un numero '" + versioneApi + "' che non rappresenta un intero:" + e.getMessage(), (Throwable)e);
        }
        String gruppi = WizardAPIUtilities.readProperty(properties, PROPERTIES_TAG, false);
        if (gruppi != null && StringUtils.isNotEmpty((String)gruppi)) {
            List<String> nomiGruppi = Arrays.asList(gruppi.split(","));
            for (String nomeGruppo : nomiGruppi) {
                nomeGruppo = nomeGruppo.trim();
                GruppoAccordo gruppoAccordo = new GruppoAccordo();
                gruppoAccordo.setNome(nomeGruppo);
                if (as.getGruppi() == null) {
                    as.setGruppi(new GruppiAccordo());
                }
                as.getGruppi().addGruppo(gruppoAccordo);
            }
        }
        if ((canale = WizardAPIUtilities.readProperty(properties, PROPERTIES_CANALE, false)) != null && StringUtils.isNotEmpty((String)canale)) {
            as.setCanale(canale);
        }
        return as;
    }

    private static String readProperty(Properties properties, String property, boolean required) throws ProtocolException {
        String v = properties.getProperty(property);
        if (v != null) {
            v = v.trim();
        }
        if (required && (v == null || StringUtils.isEmpty((String)v))) {
            throw new ProtocolException("Property '" + property + "' not found");
        }
        return v;
    }

    private static void addProfileProperties(AccordoServizioParteComune as, Properties profileProperties) throws ProtocolException {
        if (profileProperties != null && !profileProperties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : profileProperties.entrySet()) {
                WizardAPIUtilities.addProfileProperty(as, entry);
            }
        }
    }

    private static void addProfileProperty(AccordoServizioParteComune as, Map.Entry<Object, Object> entry) throws ProtocolException {
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        ProtocolProperty pp = new ProtocolProperty();
        pp.setName(key);
        if (value.startsWith(CAST_BOOLEAN)) {
            pp.setBooleanValue(Boolean.valueOf(Boolean.parseBoolean(value.substring(CAST_BOOLEAN.length()))));
        } else if (value.startsWith(CAST_NUMBER)) {
            pp.setNumberValue(Long.valueOf(Long.parseLong(value.substring(CAST_NUMBER.length()))));
        } else if (value.startsWith(CAST_INT)) {
            pp.setNumberValue(Long.valueOf(Long.parseLong(value.substring(CAST_INT.length()))));
        } else if (value.startsWith(CAST_LONG)) {
            pp.setNumberValue(Long.valueOf(Long.parseLong(value.substring(CAST_LONG.length()))));
        } else if (value.startsWith(CAST_FILE)) {
            String file = value.substring(CAST_FILE.length());
            pp.setFile(file);
            try {
                pp.setByteFile(FileSystemUtilities.readBytesFromFile((String)file));
            }
            catch (Exception e) {
                throw new ProtocolException("ERROR: argomento 'pathProfileProperties' contiene una propriet\u00e0 '" + key + "' valorizzata con un file '" + file + "' non accessibile:" + e.getMessage(), (Throwable)e);
            }
        } else {
            pp.setValue(value);
        }
        as.addProtocolProperty(pp);
    }
}

