/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.builder;

import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.eccezione.details.DettaglioEccezione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.config.ConfigurationRFC7807;
import org.openspcoop2.message.config.IntegrationErrorReturnConfiguration;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.engine.builder.DettaglioEccezioneOpenSPCoop2Builder;
import org.openspcoop2.protocol.sdk.AbstractEccezioneBuilderParameter;
import org.openspcoop2.protocol.sdk.Context;
import org.openspcoop2.protocol.sdk.Eccezione;
import org.openspcoop2.protocol.sdk.EccezioneIntegrazioneBuilderParameters;
import org.openspcoop2.protocol.sdk.EccezioneProtocolloBuilderParameters;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.builder.ProprietaErroreApplicativo;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.IntegrationFunctionError;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ErroreApplicativoBuilder {
    protected Logger log = null;
    protected OpenSPCoop2MessageFactory errorFactory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
    private IProtocolFactory<?> protocolFactory;
    private IProtocolManager protocolManager;
    private IErroreApplicativoBuilder erroreApplicativoBuilder;
    private MessageXMLUtils xmlUtils;
    private IDSoggetto dominio;
    private IDSoggetto mittente;
    private IDServizio servizio;
    private String idFunzione;
    private ProprietaErroreApplicativo proprietaErroreApplicato;
    private MessageType messageType;
    private ConfigurationRFC7807 rfc7807;
    private boolean useProblemRFC7807;
    private IntegrationErrorReturnConfiguration returnConfig;
    private IntegrationFunctionError functionError;
    private String nomePorta;
    private DettaglioEccezioneOpenSPCoop2Builder dettaglioEccezioneOpenSPCoop2Builder;
    private String servizioApplicativo;
    private TipoPdD tipoPdD = null;
    private String idTransazione;
    private Context context;

    public void setDominio(IDSoggetto dominio) {
        this.dominio = dominio;
    }

    public void setMittente(IDSoggetto mittente) {
        this.mittente = mittente;
    }

    public void setServizio(IDServizio servizio) {
        this.servizio = servizio;
    }

    public void setProprietaErroreApplicato(ProprietaErroreApplicativo proprietaErroreApplicato) {
        this.proprietaErroreApplicato = proprietaErroreApplicato;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setServizioApplicativo(String servizioApplicativo) {
        this.servizioApplicativo = servizioApplicativo;
    }

    public void setTipoPdD(TipoPdD tipoPdD) {
        this.tipoPdD = tipoPdD;
    }

    public ErroreApplicativoBuilder(Logger aLog, IProtocolFactory<?> protocolFactory, IDSoggetto dominio, IDSoggetto mittente, IDServizio servizio, String idFunzione, ProprietaErroreApplicativo proprietaErroreApplicativo, MessageType messageType, ConfigurationRFC7807 rfc7807, IntegrationErrorReturnConfiguration returnConfig, IntegrationFunctionError functionError, String nomePorta, TipoPdD tipoPdD, String servizioApplicativo, String idTransazione, Context context) throws ProtocolException {
        this.log = aLog != null ? aLog : LoggerWrapperFactory.getLogger(ErroreApplicativoBuilder.class);
        this.protocolFactory = protocolFactory;
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.errorFactory);
        this.protocolManager = this.protocolFactory.createProtocolManager();
        this.erroreApplicativoBuilder = this.protocolFactory.createErroreApplicativoBuilder();
        this.dominio = dominio;
        this.mittente = mittente;
        this.servizio = servizio;
        this.idFunzione = idFunzione;
        this.proprietaErroreApplicato = proprietaErroreApplicativo;
        this.messageType = messageType;
        this.rfc7807 = rfc7807;
        this.useProblemRFC7807 = this.rfc7807 != null;
        this.returnConfig = returnConfig;
        this.functionError = functionError;
        this.nomePorta = nomePorta;
        this.dettaglioEccezioneOpenSPCoop2Builder = new DettaglioEccezioneOpenSPCoop2Builder(aLog, protocolFactory);
        this.tipoPdD = tipoPdD;
        this.servizioApplicativo = servizioApplicativo;
        this.idTransazione = idTransazione;
        this.context = context;
    }

    public IProtocolFactory<?> getProtocolFactory() {
        return this.protocolFactory;
    }

    private void setEccezioneBuilderParameter(AbstractEccezioneBuilderParameter parameters, DettaglioEccezione dettaglio, ParseException parseException) {
        RequestInfo requestInfo;
        Object o;
        parameters.setDettaglioEccezionePdD(dettaglio);
        parameters.setDominioPorta(this.dominio);
        parameters.setMittente(this.mittente);
        parameters.setServizio(this.servizio);
        parameters.setIdFunzione(this.idFunzione);
        parameters.setProprieta(this.proprietaErroreApplicato);
        parameters.setMessageType(this.messageType);
        parameters.setRfc7807(this.rfc7807);
        parameters.setReturnConfig(this.returnConfig);
        parameters.setFunctionError(this.functionError);
        parameters.setNomePorta(this.nomePorta);
        if (this.nomePorta == null && this.context != null && this.context.containsKey(Costanti.REQUEST_INFO) && (o = this.context.getObject(Costanti.REQUEST_INFO)) != null && o instanceof RequestInfo && (requestInfo = (RequestInfo)o).getProtocolContext() != null) {
            this.nomePorta = requestInfo.getProtocolContext().getInterfaceName();
        }
        parameters.setTransactionId(this.idTransazione);
        parameters.setContext(this.context);
        parameters.setTipoPorta(this.tipoPdD);
        parameters.setServizioApplicativo(this.servizioApplicativo);
        parameters.setParseException(parseException);
    }

    private EccezioneProtocolloBuilderParameters getEccezioneProtocolloBuilderParameters(Eccezione eccezioneProtocollo, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglio, ParseException parseException) {
        EccezioneProtocolloBuilderParameters parameters = new EccezioneProtocolloBuilderParameters();
        this.setEccezioneBuilderParameter((AbstractEccezioneBuilderParameter)parameters, dettaglio, parseException);
        parameters.setEccezioneProtocollo(eccezioneProtocollo);
        parameters.setSoggettoProduceEccezione(soggettoProduceEccezione);
        return parameters;
    }

    private EccezioneIntegrazioneBuilderParameters getEccezioneIntegrazioneBuilderParameters(ErroreIntegrazione erroreIntegrazione, DettaglioEccezione dettaglio, ParseException parseException) {
        EccezioneIntegrazioneBuilderParameters parameters = new EccezioneIntegrazioneBuilderParameters();
        this.setEccezioneBuilderParameter((AbstractEccezioneBuilderParameter)parameters, dettaglio, parseException);
        parameters.setErroreIntegrazione(erroreIntegrazione);
        return parameters;
    }

    public Element toElement(ErroreIntegrazione errore) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        return this.erroreApplicativoBuilder.toElement(parameters);
    }

    public byte[] toByteArray(ErroreIntegrazione errore) throws ProtocolException {
        Element eccezione = this.toElement(errore);
        if (eccezione == null) {
            throw new ProtocolException("Elemento non generato");
        }
        try {
            return this.xmlUtils.toByteArray(eccezione, true);
        }
        catch (Exception e) {
            this.log.error("XMLBuilder.buildBytes_Eccezione error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("toByte failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public void insertInSOAPFault(ErroreIntegrazione errore, OpenSPCoop2Message msg) throws ProtocolException {
        EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, null, null);
        this.erroreApplicativoBuilder.insertInSOAPFault(parameters, msg);
    }

    public void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg) throws ProtocolException {
        this.erroreApplicativoBuilder.insertRoutingErrorInSOAPFault(identitaRouter, idFunzione, msgErrore, msg);
    }

    public OpenSPCoop2Message toMessage(ErroreIntegrazione errore, Throwable eProcessamento, ParseException parseException) {
        try {
            boolean produciDettaglioEccezione = false;
            produciDettaglioEccezione = errore.getCodiceErrore().getCodice() < 500 && CodiceErroreIntegrazione.CODICE_5XX_CUSTOM.getCodice() != errore.getCodiceErrore().getCodice() ? this.protocolManager.isGenerazioneDetailsFaultIntegratione_erroreClient() : this.protocolManager.isGenerazioneDetailsFaultIntegratione_erroreServer();
            String msgErroreTrasformato = this.proprietaErroreApplicato.transformFaultMsg(errore, this.protocolFactory);
            String codErroreTrasformato = this.protocolFactory.createTraduttore().toCodiceErroreIntegrazioneAsString(errore, this.proprietaErroreApplicato.getFaultPrefixCode(), this.proprietaErroreApplicato.isFaultAsGenericCode());
            DettaglioEccezione dettaglioEccezione = null;
            if (produciDettaglioEccezione) {
                dettaglioEccezione = this.dettaglioEccezioneOpenSPCoop2Builder.buildDettaglioEccezione(this.dominio, this.tipoPdD, this.idFunzione, codErroreTrasformato, msgErroreTrasformato, false, this.returnConfig, this.functionError);
                if (eProcessamento != null) {
                    boolean informazioniGeneriche = this.proprietaErroreApplicato.isInformazioniGenericheDetailsOpenSPCoop();
                    this.dettaglioEccezioneOpenSPCoop2Builder.gestioneDettaglioEccezioneIntegrazione(eProcessamento, dettaglioEccezione, informazioniGeneriche);
                }
            }
            EccezioneIntegrazioneBuilderParameters parameters = this.getEccezioneIntegrazioneBuilderParameters(errore, dettaglioEccezione, parseException);
            OpenSPCoop2Message msg = this.erroreApplicativoBuilder.toMessage(parameters);
            return msg;
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di eccezione integrazione", (Throwable)e);
            return this.errorFactory.createFaultMessage(this.messageType, this.useProblemRFC7807, "ErroreDiProcessamento");
        }
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, ParseException parseException) {
        return this.toMessage(eccezione, soggettoProduceEccezione, null, parseException);
    }

    public OpenSPCoop2Message toMessage(Eccezione eccezione, IDSoggetto soggettoProduceEccezione, DettaglioEccezione dettaglioEccezione, ParseException parseException) {
        try {
            EccezioneProtocolloBuilderParameters parameters = this.getEccezioneProtocolloBuilderParameters(eccezione, soggettoProduceEccezione, dettaglioEccezione, parseException);
            return this.erroreApplicativoBuilder.toMessage(parameters);
        }
        catch (Exception e) {
            this.log.error("Errore durante la costruzione del messaggio di eccezione busta", (Throwable)e);
            return this.errorFactory.createFaultMessage(this.messageType, this.useProblemRFC7807, "ErroreDiProcessamento");
        }
    }
}

