/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.registry;

import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.registry.IRegistryReaderInUso;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.slf4j.Logger;

public class RegistryReaderInUso
implements IRegistryReaderInUso {
    private IDriverRegistroServiziGet driverRegistroServiziGET;
    private Logger log;

    public void init(IDriverRegistroServiziGet driverRegistroServizi, Logger log) {
        this.driverRegistroServiziGET = driverRegistroServizi;
        this.log = log;
    }

    public boolean inUso(IDSoggetto idSoggetto, boolean verificaRuoli) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDSoggetto)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isSoggettoRegistryInUso(connection, driverDB.getTipoDB(), idSoggetto, true, whereIsInUso, normalizeObjectIds, verificaRuoli);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDSoggetto idSoggetto, boolean verificaRuoli) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDSoggetto)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isSoggettoRegistryInUso(connection, driverDB.getTipoDB(), idSoggetto, true, whereIsInUso, normalizeObjectIds, verificaRuoli);
                if (inUso) {
                    String string = DBOggettiInUsoUtils.toString(idSoggetto, whereIsInUso, false, "\n", normalizeObjectIds);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public boolean inUso(IDAccordo idAccordo) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDAccordo)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso(connection, driverDB.getTipoDB(), idAccordo, whereIsInUso, normalizeObjectIds);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDAccordo idAccordo) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDAccordo)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso(connection, driverDB.getTipoDB(), idAccordo, whereIsInUso, normalizeObjectIds);
                if (inUso) {
                    String string = DBOggettiInUsoUtils.toString(idAccordo, whereIsInUso, false, "\n", normalizeObjectIds);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public boolean inUso(IDPortType id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDPortType)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isPortTypeInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDPortType id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDPortType)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isPortTypeInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                if (inUso) {
                    String string = DBOggettiInUsoUtils.toString(id, whereIsInUso, false, "\n", "");
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public boolean inUso(IDPortTypeAzione id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDPortTypeAzione)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isOperazioneInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDPortTypeAzione id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDPortTypeAzione)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isOperazioneInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                if (inUso) {
                    String string = DBOggettiInUsoUtils.toString(id, whereIsInUso, false, "\n", "");
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public boolean inUso(IDResource id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("inUso(IDResource)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean bl = DBOggettiInUsoUtils.isRisorsaInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                return bl;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }

    public String getDettagliInUso(IDResource id) throws RegistryException {
        if (this.driverRegistroServiziGET instanceof DriverRegistroServiziDB) {
            DriverRegistroServiziDB driverDB = (DriverRegistroServiziDB)this.driverRegistroServiziGET;
            Connection connection = null;
            try {
                connection = driverDB.getConnection("getDettagliInUso(IDResource)");
                HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                boolean normalizeObjectIds = true;
                boolean inUso = DBOggettiInUsoUtils.isRisorsaInUso(connection, driverDB.getTipoDB(), id, whereIsInUso, normalizeObjectIds);
                if (inUso) {
                    String methodPath = null;
                    String string = DBOggettiInUsoUtils.toString(id, methodPath, whereIsInUso, false, "\n", "");
                    return string;
                }
                String string = null;
                return string;
            }
            catch (Exception e) {
                throw new RegistryException(e.getMessage(), (Throwable)e);
            }
            finally {
                driverDB.releaseConnection(connection);
            }
        }
        throw new RuntimeException("Not Implemented");
    }
}

