/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.AzioneSintetica;
import org.openspcoop2.core.registry.beans.OperationSintetica;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.slf4j.Logger;

public class AzioniUtils {
    private AzioniUtils() {
    }

    public static List<String> getAzioni(AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico aspc, boolean addTrattinoSelezioneNonEffettuata, boolean throwException, List<String> filtraAzioniUtilizzate, String defaultValueAzioneRisorsaNonSelezionata, Logger log) throws DriverConfigurazioneException {
        String nomeMetodo = "getAzioni";
        try {
            ArrayList<String> azioniList;
            block19: {
                azioniList = null;
                try {
                    if (aspc == null) break block19;
                    ServiceBinding sb = aspc.getServiceBinding();
                    switch (sb) {
                        case SOAP: {
                            if (asps == null) break;
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
                            if (asps.getPortType() != null) {
                                int i;
                                PortTypeSintetico pt = null;
                                for (i = 0; i < aspc.getPortType().size(); ++i) {
                                    if (!((PortTypeSintetico)aspc.getPortType().get(i)).getNome().equals(asps.getPortType())) continue;
                                    pt = (PortTypeSintetico)aspc.getPortType().get(i);
                                    break;
                                }
                                if (pt == null) {
                                    throw new CoreException("Servizio [" + idServizio.toString() + "] possiede il port type [" + asps.getPortType() + "] che non risulta essere registrato nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "]");
                                }
                                if (!pt.getAzione().isEmpty()) {
                                    azioniList = new ArrayList();
                                    for (i = 0; i < pt.getAzione().size(); ++i) {
                                        if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((OperationSintetica)pt.getAzione().get(i)).getNome())) continue;
                                        azioniList.add(((OperationSintetica)pt.getAzione().get(i)).getNome());
                                    }
                                }
                            } else if (!aspc.getAzione().isEmpty()) {
                                azioniList = new ArrayList();
                                for (int i = 0; i < aspc.getAzione().size(); ++i) {
                                    if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((AzioneSintetica)aspc.getAzione().get(i)).getNome())) continue;
                                    azioniList.add(((AzioneSintetica)aspc.getAzione().get(i)).getNome());
                                }
                            }
                            break;
                        }
                        case REST: {
                            if (aspc.getResource().isEmpty()) break;
                            azioniList = new ArrayList<String>();
                            for (int i = 0; i < aspc.getResource().size(); ++i) {
                                if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((ResourceSintetica)aspc.getResource().get(i)).getNome())) continue;
                                azioniList.add(((ResourceSintetica)aspc.getResource().get(i)).getNome());
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (!throwException) break block19;
                    throw e;
                }
            }
            ArrayList<String> azioniListReturn = null;
            if (azioniList != null && !azioniList.isEmpty()) {
                Collections.sort(azioniList);
                azioniListReturn = new ArrayList<String>();
                if (addTrattinoSelezioneNonEffettuata) {
                    azioniListReturn.add(defaultValueAzioneRisorsaNonSelezionata);
                }
                azioniListReturn.addAll(azioniList);
            }
            return azioniListReturn;
        }
        catch (Exception e) {
            log.error("[" + nomeMetodo + "] Exception :" + e.getMessage(), (Throwable)e);
            throw new DriverConfigurazioneException("[" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getMapAzioni(AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico aspc, boolean addTrattinoSelezioneNonEffettuata, boolean throwException, List<String> filtraAzioniUtilizzate, boolean sortByLabel, boolean sortFirstByPath, String defaultValueAzioneRisorsaNonSelezionata, String defaultLabelAzioneRisorsaNonSelezionata, Logger log) throws DriverConfigurazioneException {
        String nomeMetodo = "getAzioni";
        try {
            HashMap<String, String> sortMap;
            ArrayList<String> sortList;
            HashMap<String, String> azioniMap;
            block28: {
                azioniMap = null;
                sortList = null;
                sortMap = null;
                try {
                    if (aspc == null) break block28;
                    ServiceBinding sb = aspc.getServiceBinding();
                    switch (sb) {
                        case SOAP: {
                            if (asps == null) break;
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
                            if (asps.getPortType() != null) {
                                int i;
                                PortTypeSintetico pt = null;
                                for (i = 0; i < aspc.getPortType().size(); ++i) {
                                    if (!((PortTypeSintetico)aspc.getPortType().get(i)).getNome().equals(asps.getPortType())) continue;
                                    pt = (PortTypeSintetico)aspc.getPortType().get(i);
                                    break;
                                }
                                if (pt == null) {
                                    throw new CoreException("Servizio [" + idServizio.toString() + "] possiede il port type [" + asps.getPortType() + "] che non risulta essere registrato nell'accordo di servizio [" + asps.getAccordoServizioParteComune() + "]");
                                }
                                if (!pt.getAzione().isEmpty()) {
                                    azioniMap = new HashMap();
                                    sortList = new ArrayList();
                                    for (i = 0; i < pt.getAzione().size(); ++i) {
                                        if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((OperationSintetica)pt.getAzione().get(i)).getNome())) continue;
                                        sortList.add(((OperationSintetica)pt.getAzione().get(i)).getNome());
                                        azioniMap.put(((OperationSintetica)pt.getAzione().get(i)).getNome(), ((OperationSintetica)pt.getAzione().get(i)).getNome());
                                    }
                                }
                            } else if (!aspc.getAzione().isEmpty()) {
                                azioniMap = new HashMap();
                                sortList = new ArrayList();
                                for (int i = 0; i < aspc.getAzione().size(); ++i) {
                                    if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((AzioneSintetica)aspc.getAzione().get(i)).getNome())) continue;
                                    sortList.add(((AzioneSintetica)aspc.getAzione().get(i)).getNome());
                                    azioniMap.put(((AzioneSintetica)aspc.getAzione().get(i)).getNome(), ((AzioneSintetica)aspc.getAzione().get(i)).getNome());
                                }
                            }
                            break;
                        }
                        case REST: {
                            if (aspc.getResource().isEmpty()) break;
                            azioniMap = new HashMap<String, String>();
                            sortList = new ArrayList<String>();
                            if (sortByLabel) {
                                sortMap = new HashMap<String, String>();
                            }
                            for (int i = 0; i < aspc.getResource().size(); ++i) {
                                if (filtraAzioniUtilizzate != null && filtraAzioniUtilizzate.contains(((ResourceSintetica)aspc.getResource().get(i)).getNome())) continue;
                                if (sortByLabel) {
                                    Object sortLabelId = null;
                                    if (!sortFirstByPath) {
                                        sortLabelId = NamingUtils.getLabelResource((ResourceSintetica)aspc.getResource().get(i));
                                    } else {
                                        String path = ((ResourceSintetica)aspc.getResource().get(i)).getPath() != null ? ((ResourceSintetica)aspc.getResource().get(i)).getPath() : "*";
                                        String method = ((ResourceSintetica)aspc.getResource().get(i)).getMethod() != null ? ((ResourceSintetica)aspc.getResource().get(i)).getMethod().getValue() : "ALL";
                                        sortLabelId = path + " " + method;
                                    }
                                    sortList.add((String)sortLabelId);
                                    sortMap.put((String)sortLabelId, ((ResourceSintetica)aspc.getResource().get(i)).getNome());
                                } else {
                                    sortList.add(((ResourceSintetica)aspc.getResource().get(i)).getNome());
                                }
                                azioniMap.put(((ResourceSintetica)aspc.getResource().get(i)).getNome(), NamingUtils.getLabelResource((ResourceSintetica)aspc.getResource().get(i)));
                            }
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    if (!throwException) break block28;
                    throw e;
                }
            }
            LinkedHashMap<String, String> mapAzioniReturn = new LinkedHashMap<String, String>();
            if (sortList != null && !sortList.isEmpty()) {
                Collections.sort(sortList);
                if (addTrattinoSelezioneNonEffettuata) {
                    mapAzioniReturn.put(defaultValueAzioneRisorsaNonSelezionata, defaultLabelAzioneRisorsaNonSelezionata);
                }
                if (sortMap != null) {
                    for (String idSort : sortList) {
                        String id = (String)sortMap.get(idSort);
                        mapAzioniReturn.put(id, (String)azioniMap.get(id));
                    }
                } else {
                    for (String id : sortList) {
                        mapAzioniReturn.put(id, (String)azioniMap.get(id));
                    }
                }
            }
            return mapAzioniReturn;
        }
        catch (Exception e) {
            log.error("[ControlStationCore::" + nomeMetodo + "] Exception :" + e.getMessage(), (Throwable)e);
            throw new DriverConfigurazioneException("[ControlStationCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getAzioniConLabel(AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico aspc, boolean addTrattinoSelezioneNonEffettuata, boolean throwException, List<String> filtraAzioniUtilizzate, String defaultValueAzioneRisorsaNonSelezionata, String defaultLabelAzioneRisorsaNonSelezionata, Logger log) throws DriverConfigurazioneException {
        return AzioniUtils.getMapAzioni(asps, aspc, addTrattinoSelezioneNonEffettuata, throwException, filtraAzioniUtilizzate, true, true, defaultValueAzioneRisorsaNonSelezionata, defaultLabelAzioneRisorsaNonSelezionata, log);
    }

    public static String getProtocolPropertyStringValue(AccordoServizioParteComune aspc, String idPortType, String idAzione, String propertyName) {
        block7: {
            if (idPortType != null) {
                for (PortType pt : aspc.getPortTypeList()) {
                    if (!pt.getNome().equals(idPortType)) continue;
                    for (Operation op : pt.getAzioneList()) {
                        if (!op.getNome().equals(idAzione)) continue;
                        for (ProtocolProperty pp : op.getProtocolPropertyList()) {
                            if (!pp.getName().equals(propertyName)) continue;
                            return pp.getValue();
                        }
                        break block7;
                    }
                    break;
                }
            } else {
                for (Resource resource : aspc.getResourceList()) {
                    if (!resource.getNome().equals(idAzione)) continue;
                    for (ProtocolProperty pp : resource.getProtocolPropertyList()) {
                        if (!pp.getName().equals(propertyName)) continue;
                        return pp.getValue();
                    }
                    break;
                }
            }
        }
        return null;
    }
}

