/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.constants.ModalitaIdentificazioneAzione;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_accordi;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_accordiCooperazione;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_accordiParteSpecifica;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_accordiRest;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_accordiSoap;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_canali;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_genericProperties;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_gruppi;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_pdd;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_plugins;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_rateLimiting;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_ruoli;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_scope;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_serviziApplicativi;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils_soggetti;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils {
    protected static String getProtocolPrefix(String protocollo) throws UtilsException {
        try {
            return "[" + NamingUtils.getLabelProtocollo(protocollo) + "] ";
        }
        catch (Exception se) {
            throw new UtilsException(se.getMessage(), (Throwable)se);
        }
    }

    protected static String getSubjectSuffix(String protocollo, IDSoggetto idSoggetto) throws UtilsException {
        try {
            return " (" + NamingUtils.getLabelSoggetto(protocollo, idSoggetto) + ")";
        }
        catch (Exception se) {
            throw new UtilsException(se.getMessage(), (Throwable)se);
        }
    }

    public static String formatList(List<String> whereIsInUso, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String v : whereIsInUso) {
            sb.append(separator);
            sb.append("- ");
            sb.append(v);
        }
        return sb.toString();
    }

    protected static ResultPorta formatPortaDelegata(String nomePorta, String tipoDB, Connection con, boolean normalizeObjectIds) throws Exception {
        block9: {
            String nome;
            String nome_soggetto;
            String tipo_soggetto;
            ResultSet risultato;
            PreparedStatement stmt;
            block10: {
                String protocollo;
                IDSoggetto idSoggetto;
                block11: {
                    ResultPorta resultPorta;
                    stmt = null;
                    risultato = null;
                    try {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("porte_delegate");
                        sqlQueryObject.addFromTable("soggetti");
                        sqlQueryObject.addSelectField("tipo_soggetto");
                        sqlQueryObject.addSelectField("nome_soggetto");
                        sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                        sqlQueryObject.addSelectField("porte_delegate.tipo_soggetto_erogatore");
                        sqlQueryObject.addSelectField("porte_delegate.nome_soggetto_erogatore");
                        sqlQueryObject.addSelectField("porte_delegate.tipo_servizio");
                        sqlQueryObject.addSelectField("porte_delegate.nome_servizio");
                        sqlQueryObject.addSelectField("porte_delegate.versione_servizio");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.setSelectDistinct(true);
                        sqlQueryObject.addWhereCondition("porte_delegate.nome_porta = ?");
                        sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                        String queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setString(1, nomePorta);
                        risultato = stmt.executeQuery();
                        if (!risultato.next()) break block9;
                        tipo_soggetto = risultato.getString("tipo_soggetto");
                        nome_soggetto = risultato.getString("nome_soggetto");
                        nome = risultato.getString("nome_porta");
                        idSoggetto = new IDSoggetto(tipo_soggetto, nome_soggetto);
                        if (!normalizeObjectIds) break block10;
                        String tipoSoggettoErogatore = risultato.getString("tipo_soggetto_erogatore");
                        String nomeSoggettoErogatore = risultato.getString("nome_soggetto_erogatore");
                        IDSoggetto idSoggettoErogatore = null;
                        if (tipoSoggettoErogatore != null && !"".equals(tipoSoggettoErogatore) && nomeSoggettoErogatore != null && !"".equals(nomeSoggettoErogatore)) {
                            idSoggettoErogatore = new IDSoggetto(tipoSoggettoErogatore, nomeSoggettoErogatore);
                        }
                        String tipoServizio = risultato.getString("tipo_servizio");
                        String nomeServizio = risultato.getString("nome_servizio");
                        Integer versioneServizio = risultato.getInt("versione_servizio");
                        protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                        MappingFruizionePortaDelegata mappingPD = null;
                        if (tipoServizio != null && !"".equals(tipoServizio) && nomeServizio != null && !"".equals(nomeServizio) && versioneServizio != null && versioneServizio > 0) {
                            IDPortaDelegata idPD = new IDPortaDelegata();
                            idPD.setNome(nome);
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, idSoggettoErogatore, versioneServizio.intValue());
                            boolean existsMapping = DBMappingUtils.existsMappingFruizione((IDServizio)idServizio, (IDSoggetto)idSoggetto, (IDPortaDelegata)idPD, (Connection)con, (String)tipoDB);
                            if (existsMapping) {
                                mappingPD = DBMappingUtils.getMappingFruizione((IDServizio)idServizio, (IDSoggetto)idSoggetto, (IDPortaDelegata)idPD, (Connection)con, (String)tipoDB);
                            }
                        }
                        if (mappingPD == null) break block11;
                        Object suffixGruppo = "";
                        if (!mappingPD.isDefault()) {
                            suffixGruppo = " (Gruppo: " + mappingPD.getDescrizione() + ")";
                        }
                        ResultPorta result = new ResultPorta();
                        result.label = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, mappingPD.getIdServizio()) + " (Fruitore:" + NamingUtils.getLabelSoggetto(protocollo, idSoggetto) + ")" + (String)suffixGruppo;
                        result.mapping = true;
                        resultPorta = result;
                    }
                    catch (Throwable throwable) {
                        JDBCUtilities.closeResources(risultato, stmt);
                        throw throwable;
                    }
                    JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
                    return resultPorta;
                }
                ResultPorta result = new ResultPorta();
                result.label = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idSoggetto);
                ResultPorta resultPorta = result;
                JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
                return resultPorta;
            }
            ResultPorta result = new ResultPorta();
            result.label = tipo_soggetto + "/" + nome_soggetto + "_" + nome;
            ResultPorta resultPorta = result;
            JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
            return resultPorta;
        }
        throw new Exception("Porta Delegata '" + nomePorta + "' not found");
    }

    protected static ResultPorta formatPortaApplicativa(String nomePorta, String tipoDB, Connection con, boolean normalizeObjectIds) throws Exception {
        block9: {
            String nome;
            String nome_soggetto;
            String tipo_soggetto;
            ResultSet risultato;
            PreparedStatement stmt;
            block10: {
                String protocollo;
                IDSoggetto idSoggetto;
                block11: {
                    ResultPorta resultPorta;
                    stmt = null;
                    risultato = null;
                    try {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("porte_applicative");
                        sqlQueryObject.addFromTable("soggetti");
                        sqlQueryObject.addSelectField("tipo_soggetto");
                        sqlQueryObject.addSelectField("nome_soggetto");
                        sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                        sqlQueryObject.addSelectField("porte_applicative.tipo_servizio");
                        sqlQueryObject.addSelectField("porte_applicative.servizio");
                        sqlQueryObject.addSelectField("porte_applicative.versione_servizio");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.setSelectDistinct(true);
                        sqlQueryObject.addWhereCondition("porte_applicative.nome_porta = ?");
                        sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                        String queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setString(1, nomePorta);
                        risultato = stmt.executeQuery();
                        if (!risultato.next()) break block9;
                        tipo_soggetto = risultato.getString("tipo_soggetto");
                        nome_soggetto = risultato.getString("nome_soggetto");
                        nome = risultato.getString("nome_porta");
                        idSoggetto = new IDSoggetto(tipo_soggetto, nome_soggetto);
                        if (!normalizeObjectIds) break block10;
                        String tipoServizio = risultato.getString("tipo_servizio");
                        String nomeServizio = risultato.getString("servizio");
                        Integer versioneServizio = risultato.getInt("versione_servizio");
                        protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                        MappingErogazionePortaApplicativa mappingPA = null;
                        if (tipoServizio != null && !"".equals(tipoServizio) && nomeServizio != null && !"".equals(nomeServizio) && versioneServizio != null && versioneServizio > 0) {
                            IDPortaApplicativa idPA = new IDPortaApplicativa();
                            idPA.setNome(nome);
                            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, idSoggetto, versioneServizio.intValue());
                            boolean existsMapping = DBMappingUtils.existsMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPA, (Connection)con, (String)tipoDB);
                            if (existsMapping) {
                                mappingPA = DBMappingUtils.getMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPA, (Connection)con, (String)tipoDB);
                            }
                        }
                        if (mappingPA == null) break block11;
                        Object suffixGruppo = "";
                        if (!mappingPA.isDefault()) {
                            suffixGruppo = " (Gruppo: " + mappingPA.getDescrizione() + ")";
                        }
                        ResultPorta result = new ResultPorta();
                        result.label = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, mappingPA.getIdServizio()) + (String)suffixGruppo;
                        result.mapping = true;
                        result.erogazioneModi = "modipa".equals(protocollo);
                        resultPorta = result;
                    }
                    catch (Throwable throwable) {
                        JDBCUtilities.closeResources(risultato, stmt);
                        throw throwable;
                    }
                    JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
                    return resultPorta;
                }
                ResultPorta result = new ResultPorta();
                result.label = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idSoggetto);
                result.erogazioneModi = "modipa".equals(protocollo);
                ResultPorta resultPorta = result;
                JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
                return resultPorta;
            }
            ResultPorta result = new ResultPorta();
            result.label = tipo_soggetto + "/" + nome_soggetto + "_" + nome;
            if (tipo_soggetto != null) {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                result.erogazioneModi = "modipa".equals(protocollo);
            }
            ResultPorta resultPorta = result;
            JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
            return resultPorta;
        }
        throw new Exception("Porta Delegata '" + nomePorta + "' not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatConnettori(List<Long> idConnettori, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, Connection con, boolean normalizeObjectIds, String tipoDB) throws Exception {
        if (idConnettori != null && !idConnettori.isEmpty()) {
            List<String> connettorePA_list = whereIsInUso.get(ErrorsHandlerCostant.CONNETTORE_PA);
            List<String> connettorePD_list = whereIsInUso.get(ErrorsHandlerCostant.CONNETTORE_PD);
            List<String> mapping_connettorePA_list = whereIsInUso.get(ErrorsHandlerCostant.CONNETTORE_MAPPING_PA);
            List<String> mapping_connettorePD_list = whereIsInUso.get(ErrorsHandlerCostant.CONNETTORE_MAPPING_PD);
            if (connettorePA_list == null) {
                connettorePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONNETTORE_PA, connettorePA_list);
            }
            if (connettorePD_list == null) {
                connettorePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONNETTORE_PD, connettorePD_list);
            }
            if (mapping_connettorePA_list == null) {
                mapping_connettorePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONNETTORE_MAPPING_PA, mapping_connettorePA_list);
            }
            if (mapping_connettorePD_list == null) {
                mapping_connettorePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONNETTORE_MAPPING_PD, mapping_connettorePD_list);
            }
            ArrayList<Long> idFruizioniDefault = new ArrayList<Long>();
            ArrayList<Long> idFruizioniGruppi_idFruizione = new ArrayList<Long>();
            ArrayList<Long> idFruizioniGruppi_id = new ArrayList<Long>();
            HashMap idFruizioniGruppi_azioni = new HashMap();
            ArrayList<Long> idServiziApplicativi = new ArrayList<Long>();
            ArrayList<String> idServiziApplicativi_server = new ArrayList<String>();
            ArrayList<String> idServiziApplicativi_nome = new ArrayList<String>();
            PreparedStatement stmt = null;
            ResultSet risultato = null;
            try {
                String nomePorta;
                String queryString;
                ISQLQueryObject sqlQueryObject;
                for (Long idConnettore : idConnettori) {
                    Long id;
                    Long id2;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addSelectField("tipo");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_connettore_inv=?");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idConnettore);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        id2 = risultato.getLong("id");
                        String tipo = risultato.getString("tipo");
                        String nome = risultato.getString("nome");
                        idServiziApplicativi.add(id2);
                        idServiziApplicativi_server.add(tipo);
                        idServiziApplicativi_nome.add(nome);
                    }
                    risultato.close();
                    stmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_connettore=?");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idConnettore);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        id2 = risultato.getLong("id");
                        idFruizioniDefault.add(id2);
                    }
                    risultato.close();
                    stmt.close();
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi_fruitori_azioni");
                    sqlQueryObject.addSelectField("id_fruizione");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addWhereCondition("servizi_fruitori_azioni.id_connettore=?");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setLong(1, idConnettore);
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        Long idF = risultato.getLong("id_fruizione");
                        idFruizioniGruppi_idFruizione.add(idF);
                        id = risultato.getLong("id");
                        idFruizioniGruppi_id.add(id);
                    }
                    risultato.close();
                    stmt.close();
                    if (idFruizioniGruppi_id.isEmpty()) continue;
                    for (int i = 0; i < idFruizioniGruppi_id.size(); ++i) {
                        id = (Long)idFruizioniGruppi_id.get(0);
                        Long idF = (Long)idFruizioniGruppi_idFruizione.get(0);
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("servizi_fruitori_azione");
                        sqlQueryObject.addFromTable("servizi_fruitori_azioni");
                        sqlQueryObject.addSelectField("nome_azione");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("servizi_fruitori_azioni.id=?");
                        sqlQueryObject.addWhereCondition("servizi_fruitori_azione.id_fruizione_azioni=servizi_fruitori_azioni.id");
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setLong(1, id);
                        risultato = stmt.executeQuery();
                        ArrayList<String> azioni = new ArrayList<String>();
                        while (risultato.next()) {
                            String nomeAzione = risultato.getString("nome_azione");
                            azioni.add(nomeAzione);
                        }
                        risultato.close();
                        stmt.close();
                        idFruizioniGruppi_azioni.put(idF, azioni);
                    }
                }
                if (idServiziApplicativi != null && !idServiziApplicativi.isEmpty()) {
                    for (int i = 0; i < idServiziApplicativi.size(); ++i) {
                        Long idServiziApplicativo = (Long)idServiziApplicativi.get(i);
                        Object suffix = "";
                        String tipoApplicativo = (String)idServiziApplicativi_server.get(i);
                        if ("server".equals(tipoApplicativo)) {
                            suffix = " (Applicativo Server: " + (String)idServiziApplicativi_nome.get(i) + ")";
                        }
                        ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject2.addFromTable("porte_applicative_sa");
                        sqlQueryObject2.addFromTable("porte_applicative");
                        sqlQueryObject2.setSelectDistinct(true);
                        sqlQueryObject2.addSelectField("nome_porta");
                        sqlQueryObject2.addSelectField("connettore_nome");
                        sqlQueryObject2.setANDLogicOperator(true);
                        sqlQueryObject2.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=?");
                        sqlQueryObject2.addWhereCondition("porte_applicative.id=porte_applicative_sa.id_porta");
                        queryString = sqlQueryObject2.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setLong(1, idServiziApplicativo);
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            nomePorta = risultato.getString("nome_porta");
                            String nomeConnettore = risultato.getString("connettore_nome");
                            Object labelNomeConnettore = "";
                            if (nomeConnettore != null && !"".equals(nomeConnettore)) {
                                labelNomeConnettore = " (Connettore: " + nomeConnettore + ")";
                            }
                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                mapping_connettorePA_list.add(resultPorta.label + (String)labelNomeConnettore + (String)suffix);
                                continue;
                            }
                            connettorePA_list.add(resultPorta.label + (String)labelNomeConnettore + (String)suffix);
                        }
                        risultato.close();
                        stmt.close();
                    }
                }
                if (idFruizioniDefault != null && !idFruizioniDefault.isEmpty()) {
                    for (Long idFruizione : idFruizioniDefault) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("mapping_fruizione_pd");
                        sqlQueryObject.addFromTable("porte_delegate");
                        sqlQueryObject.setSelectDistinct(true);
                        sqlQueryObject.addSelectField("nome_porta");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione=?");
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.is_default=?");
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        stmt.setLong(1, idFruizione);
                        stmt.setInt(2, 1);
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            String nomePorta2 = risultato.getString("nome_porta");
                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta2, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                mapping_connettorePD_list.add(resultPorta.label);
                                continue;
                            }
                            connettorePD_list.add(resultPorta.label);
                        }
                        risultato.close();
                        stmt.close();
                    }
                }
                if (idFruizioniGruppi_idFruizione != null && !idFruizioniGruppi_idFruizione.isEmpty()) {
                    for (Long idFruizione : idFruizioniGruppi_idFruizione) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObject.addFromTable("mapping_fruizione_pd");
                        sqlQueryObject.addFromTable("porte_delegate");
                        sqlQueryObject.setSelectDistinct(true);
                        sqlQueryObject.addSelectField("nome_porta");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_fruizione=?");
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.id_porta=porte_delegate.id");
                        sqlQueryObject.addWhereCondition("mapping_fruizione_pd.is_default=?");
                        sqlQueryObject.addWhereCondition("porte_delegate.mode_azione=?");
                        List azioni = (List)idFruizioniGruppi_azioni.get(idFruizione);
                        if (azioni != null && !azioni.isEmpty()) {
                            for (Object azione : azioni) {
                                ISQLQueryObject sqlQueryObjectAzione = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                                sqlQueryObjectAzione.addFromTable("pd_azioni");
                                sqlQueryObjectAzione.addSelectField("pd_azioni.azione");
                                sqlQueryObjectAzione.setANDLogicOperator(true);
                                sqlQueryObjectAzione.addWhereCondition("pd_azioni.id_porta=porte_delegate.id");
                                sqlQueryObjectAzione.addWhereCondition("pd_azioni.azione=?");
                                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAzione);
                            }
                        }
                        queryString = sqlQueryObject.createSQLQuery();
                        stmt = con.prepareStatement(queryString);
                        int index = 1;
                        stmt.setLong(index++, idFruizione);
                        stmt.setInt(index++, 0);
                        stmt.setString(index++, ModalitaIdentificazioneAzione.DELEGATED_BY.getValue());
                        if (azioni != null && !azioni.isEmpty()) {
                            for (String azione : azioni) {
                                stmt.setString(index++, azione);
                            }
                        }
                        risultato = stmt.executeQuery();
                        while (risultato.next()) {
                            nomePorta = risultato.getString("nome_porta");
                            ResultPorta resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                mapping_connettorePD_list.add(resultPorta.label);
                                continue;
                            }
                            connettorePD_list.add(resultPorta.label);
                        }
                        risultato.close();
                        stmt.close();
                    }
                }
            }
            finally {
                JDBCUtilities.closeResources(risultato, stmt);
            }
        }
    }

    public static String formatGenericProperties(String tipologia, String nome) {
        return nome;
    }

    public static boolean isPddInUso(Connection con, String tipoDB, String nomePdd, List<String> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_pdd.isPddInUso(con, tipoDB, nomePdd, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(String nomePdd, List<String> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_pdd.toString(nomePdd, whereIsInUso, prefix, separator);
    }

    public static boolean isGruppoConfigInUso(Connection con, String tipoDB, IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_gruppi.isGruppoConfigInUso(con, tipoDB, idGruppo, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isGruppoRegistryInUso(Connection con, String tipoDB, IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_gruppi.isGruppoRegistryInUso(con, tipoDB, idGruppo, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isGruppoInUso(Connection con, String tipoDB, IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_gruppi.isGruppoInUso(con, tipoDB, idGruppo, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_gruppi.toString(idGruppo, whereIsInUso, prefix, separator);
    }

    public static String toString(IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_gruppi.toString(idGruppo, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isRuoloConfigInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloConfigInUso(con, tipoDB, idRuolo, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isRuoloRegistryInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloRegistryInUso(con, tipoDB, idRuolo, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isRuoloInUso(Connection con, String tipoDB, IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_ruoli.isRuoloInUso(con, tipoDB, idRuolo, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_ruoli.toString(idRuolo, whereIsInUso, prefix, separator);
    }

    public static String toString(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_ruoli.toString(idRuolo, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isScopeConfigInUso(Connection con, String tipoDB, IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_scope.isScopeConfigInUso(con, tipoDB, idScope, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isScopeInUso(Connection con, String tipoDB, IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_scope.isScopeInUso(con, tipoDB, idScope, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_scope.toString(idScope, whereIsInUso, prefix, separator);
    }

    public static String toString(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_scope.toString(idScope, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isSoggettoConfigInUso(Connection con, String tipoDB, IDSoggetto idSoggettoConfig, boolean checkControlloTraffico, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        return DBOggettiInUsoUtils_soggetti.isSoggettoConfigInUso(con, tipoDB, idSoggettoConfig, checkControlloTraffico, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    public static boolean isSoggettoRegistryInUso(Connection con, String tipoDB, IDSoggetto idSoggettoRegistro, boolean checkControlloTraffico, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        return DBOggettiInUsoUtils_soggetti.isSoggettoRegistryInUso(con, tipoDB, idSoggettoRegistro, checkControlloTraffico, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    public static String toString(IDSoggetto idSoggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        return DBOggettiInUsoUtils_soggetti.toString(idSoggetto, whereIsInUso, prefix, separator, normalizeObjectIds);
    }

    public static boolean isAccordoCooperazioneInUso(Connection con, String tipoDB, IDAccordoCooperazione idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiCooperazione.isAccordoCooperazioneInUso(con, tipoDB, idAccordo, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDAccordoCooperazione idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        return DBOggettiInUsoUtils_accordiCooperazione.toString(idAccordo, whereIsInUso, prefix, separator, normalizeObjectIds);
    }

    public static boolean isAccordoServizioParteComuneInUso(Connection con, String tipoDB, IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordi.isAccordoServizioParteComuneInUso(con, tipoDB, idAccordo, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        return DBOggettiInUsoUtils_accordi.toString(idAccordo, whereIsInUso, prefix, separator, normalizeObjectIds);
    }

    public static boolean isRisorsaConfigInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaConfigInUso(con, tipoDB, idRisorsa, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isRisorsaRegistryInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaRegistryInUso(con, tipoDB, idRisorsa, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isRisorsaInUso(Connection con, String tipoDB, IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiRest.isRisorsaInUso(con, tipoDB, idRisorsa, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDResource idRisorsa, String methodPath, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_accordiRest.toString(idRisorsa, methodPath, whereIsInUso, prefix, separator);
    }

    public static String toString(IDResource idRisorsa, String methodPath, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_accordiRest.toString(idRisorsa, methodPath, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isPortTypeConfigInUso(Connection con, String tipoDB, IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isPortTypeConfigInUso(con, tipoDB, idPT, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isPortTypeRegistryInUso(Connection con, String tipoDB, IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isPortTypeRegistryInUso(con, tipoDB, idPT, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isPortTypeInUso(Connection con, String tipoDB, IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isPortTypeInUso(con, tipoDB, idPT, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_accordiSoap.toString(idPT, whereIsInUso, prefix, separator);
    }

    public static String toString(IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_accordiSoap.toString(idPT, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isOperazioneConfigInUso(Connection con, String tipoDB, IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isOperazioneConfigInUso(con, tipoDB, idOperazione, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isOperazioneRegistryInUso(Connection con, String tipoDB, IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isOperazioneRegistryInUso(con, tipoDB, idOperazione, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isOperazioneInUso(Connection con, String tipoDB, IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiSoap.isOperazioneInUso(con, tipoDB, idOperazione, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_accordiSoap.toString(idOperazione, whereIsInUso, prefix, separator);
    }

    public static String toString(IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_accordiSoap.toString(idOperazione, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isAccordoServizioParteSpecificaInUso(Connection con, String tipoDB, IDServizio idServizio, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, List<IDPortaDelegata> nomePDGenerateAutomaticamente, List<IDPortaApplicativa> nomePAGenerateAutomaticamente, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_accordiParteSpecifica.isAccordoServizioParteSpecificaInUso(con, tipoDB, idServizio, whereIsInUso, nomePDGenerateAutomaticamente, nomePAGenerateAutomaticamente, normalizeObjectIds);
    }

    public static String toString(IDServizio idServizio, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds, String oggetto) {
        return DBOggettiInUsoUtils_accordiParteSpecifica.toString(idServizio, whereIsInUso, prefix, separator, normalizeObjectIds, oggetto);
    }

    public static boolean isServizioApplicativoInUso(Connection con, String tipoDB, IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean isRegistroServiziLocale, boolean normalizeObjectIds, boolean verificaRuoli) throws UtilsException {
        return DBOggettiInUsoUtils_serviziApplicativi.isServizioApplicativoInUso(con, tipoDB, idServizioApplicativo, whereIsInUso, isRegistroServiziLocale, normalizeObjectIds, verificaRuoli);
    }

    public static String toString(IDServizioApplicativo idServizioApplicativo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        return DBOggettiInUsoUtils_serviziApplicativi.toString(idServizioApplicativo, whereIsInUso, prefix, separator, normalizeObjectIds);
    }

    public static boolean isGenericPropertiesInUso(Connection con, String tipoDB, IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_genericProperties.isGenericPropertiesInUso(con, tipoDB, idGP, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_genericProperties.toString(idGP, whereIsInUso, prefix, separator);
    }

    public static String toString(IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_genericProperties.toString(idGP, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isCanaleInUsoRegistro(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_canali.isCanaleInUsoRegistro(con, tipoDB, canale, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isCanaleInUso(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_canali.isCanaleInUso(con, tipoDB, canale, whereIsInUso, normalizeObjectIds);
    }

    public static boolean isCanaleInUso(Connection con, String tipoDB, CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean registry, boolean config, boolean nodi) throws UtilsException {
        return DBOggettiInUsoUtils_canali.isCanaleInUso(con, tipoDB, canale, whereIsInUso, normalizeObjectIds, registry, config, nodi);
    }

    public static String toString(CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_canali.toString(canale, whereIsInUso, prefix, separator);
    }

    public static String toString(CanaleConfigurazione canale, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        return DBOggettiInUsoUtils_canali.toString(canale, whereIsInUso, prefix, separator, intestazione);
    }

    public static boolean isRateLimitingPolicyInUso(Connection con, String tipoDB, IdPolicy idPolicy, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_rateLimiting.isRateLimitingPolicyInUso(con, tipoDB, idPolicy, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(IdPolicy idPolicy, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_rateLimiting.toString(idPolicy, whereIsInUso, prefix, separator);
    }

    public static boolean isPluginInUso(Connection con, String tipoDB, String className, String label, String tipoPlugin, String tipo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_plugins.isPluginInUso(con, tipoDB, className, label, tipoPlugin, tipo, whereIsInUso, normalizeObjectIds);
    }

    public static String toString(String className, String label, String tipoPlugin, String tipo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_plugins.toString(className, label, tipoPlugin, tipo, whereIsInUso, prefix, separator);
    }
}

