/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_accordi {
    protected static boolean isAccordoServizioParteComuneInUso(Connection con, String tipoDB, IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "isAccordoServizioParteComuneInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            boolean isInUso = false;
            long idAccordoServizioParteComune = DBUtils.getIdAccordoServizioParteComune((IDAccordo)idAccordo, (Connection)con, (String)tipoDB);
            if (idAccordoServizioParteComune <= 0L) {
                throw new UtilsException("Accordi di Servizio Parte Comune con id [" + idAccordo.toString() + "] non trovato");
            }
            List<String> servizi_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_SERVIZI);
            List<String> mappingErogazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePD_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            List<String> correlazione_list = whereIsInUso.get(ErrorsHandlerCostant.IS_CORRELATA);
            if (servizi_list == null) {
                servizi_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_SERVIZI, servizi_list);
            }
            if (mappingErogazionePA_list == null) {
                mappingErogazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePA_list);
            }
            if (mappingFruizionePD_list == null) {
                mappingFruizionePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePD_list);
            }
            if (correlazione_list == null) {
                correlazione_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IS_CORRELATA, correlazione_list);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoServizioParteComune);
            risultato = stmt.executeQuery();
            ArrayList<IDServizio> listIDServizio = new ArrayList<IDServizio>();
            while (risultato.next()) {
                isInUso = true;
                String tipoSoggettoErogatore = risultato.getString("tipo_soggetto");
                String nomeSoggettoErogatore = risultato.getString("nome_soggetto");
                String tipoServizio = risultato.getString("tipo_servizio");
                String nomeServizio = risultato.getString("nome_servizio");
                int versioneServizio = risultato.getInt("versione_servizio");
                IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromValues(tipoServizio, nomeServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, versioneServizio);
                listIDServizio.add(idServizio2);
            }
            risultato.close();
            stmt.close();
            if (!listIDServizio.isEmpty()) {
                for (IDServizio idServizio : listIDServizio) {
                    String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idServizio.getSoggettoErogatore().getTipo());
                    boolean found = false;
                    List listPA = null;
                    try {
                        listPA = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)tipoDB, (IDServizio)idServizio, (boolean)true);
                    }
                    catch (Exception idServizio2) {
                        // empty catch block
                    }
                    if (listPA != null && !listPA.isEmpty()) {
                        found = true;
                        for (MappingErogazionePortaApplicativa mappingPA : listPA) {
                            Object suffixGruppo = "";
                            if (!mappingPA.isDefault()) {
                                suffixGruppo = " (Gruppo: " + mappingPA.getDescrizione() + ")";
                            }
                            String servizio = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, mappingPA.getIdServizio()) + (String)suffixGruppo;
                            mappingErogazionePA_list.add(servizio);
                        }
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("servizi");
                    sqlQueryObject.addFromTable("servizi_fruitori");
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("tipo_soggetto");
                    sqlQueryObject.addSelectField("nome_soggetto");
                    sqlQueryObject.addWhereCondition("tipo_servizio = ?");
                    sqlQueryObject.addWhereCondition("nome_servizio = ?");
                    sqlQueryObject.addWhereCondition("versione_servizio = ?");
                    sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
                    sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    stmt.setString(1, idServizio.getTipo());
                    stmt.setString(2, idServizio.getNome());
                    stmt.setInt(3, idServizio.getVersione());
                    stmt.setLong(4, DBUtils.getIdSoggetto((String)idServizio.getSoggettoErogatore().getNome(), (String)idServizio.getSoggettoErogatore().getTipo(), (Connection)con, (String)tipoDB));
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        String tipoSoggettoFruitore = risultato.getString("tipo_soggetto");
                        String nomeSoggettoFruitore = risultato.getString("nome_soggetto");
                        IDSoggetto idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
                        List listPD = null;
                        try {
                            listPD = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)tipoDB, (IDSoggetto)idSoggettoFruitore, (IDServizio)idServizio, (boolean)true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (listPD == null || listPD.isEmpty()) continue;
                        found = true;
                        for (MappingFruizionePortaDelegata mappingPD : listPD) {
                            Object suffixGruppo = "";
                            if (!mappingPD.isDefault()) {
                                suffixGruppo = " (Gruppo: " + mappingPD.getDescrizione() + ")";
                            }
                            String servizio = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteSpecifica(protocollo, mappingPD.getIdServizio()) + " (Fruitore:" + NamingUtils.getLabelSoggetto(protocollo, idSoggettoFruitore) + ")" + (String)suffixGruppo;
                            mappingFruizionePD_list.add(servizio);
                        }
                    }
                    risultato.close();
                    stmt.close();
                    if (found) continue;
                    servizi_list.add(idServizio.toString());
                }
            }
            if ("modipa".equals(idAccordo.getSoggettoReferente().getTipo())) {
                ISQLQueryObject sqlQueryObjectApiExists;
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("accordi");
                sqlQueryObject.addSelectField("service_binding");
                sqlQueryObject.addWhereCondition("id = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idAccordoServizioParteComune);
                risultato = stmt.executeQuery();
                ServiceBinding tipoAccordo = null;
                if (risultato.next()) {
                    tipoAccordo = ServiceBinding.toEnumConstant((String)risultato.getString("service_binding"), (boolean)false);
                }
                risultato.close();
                stmt.close();
                if (ServiceBinding.REST.equals((Object)tipoAccordo)) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addFromTable("api_resources");
                    sqlQueryObject.addSelectAliasField("api_resources", "nome", "nomeRisorsa");
                    sqlQueryObject.addSelectAliasField("api_resources", "http_method", "httpMethodRisorsa");
                    sqlQueryObject.addSelectAliasField("api_resources", "path", "pathRisorsa");
                    sqlQueryObject.addWhereCondition("accordi.id = ?");
                    sqlQueryObject.addWhereCondition("api_resources.id_accordo = accordi.id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("pathRisorsa");
                    sqlQueryObject.addOrderBy("httpMethodRisorsa");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    int index = 1;
                    stmt.setLong(index++, idAccordoServizioParteComune);
                    risultato = stmt.executeQuery();
                    ArrayList<String> risorse = new ArrayList<String>();
                    while (risultato.next()) {
                        String nomeRisorsa = risultato.getString("nomeRisorsa");
                        risorse.add(nomeRisorsa);
                    }
                    risultato.close();
                    stmt.close();
                    if (!risorse.isEmpty()) {
                        for (String nomeRisorsa : risorse) {
                            sqlQueryObjectApiExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectApiExists.setANDLogicOperator(true);
                            sqlQueryObjectApiExists.addFromTable("protocol_properties");
                            sqlQueryObjectApiExists.addSelectField("protocol_properties", "name");
                            sqlQueryObjectApiExists.addWhereCondition("api_resources.id = protocol_properties.id_proprietario");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.name=?");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.value_string=?");
                            ISQLQueryObject sqlQueryObjectOperationExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectOperationExists.setANDLogicOperator(true);
                            sqlQueryObjectOperationExists.addFromTable("protocol_properties");
                            sqlQueryObjectOperationExists.addSelectField("protocol_properties", "name");
                            sqlQueryObjectOperationExists.addWhereCondition("api_resources.id = protocol_properties.id_proprietario");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.name=?");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.value_string=?");
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addFromTable("accordi");
                            sqlQueryObject.addFromTable("soggetti");
                            sqlQueryObject.addFromTable("api_resources");
                            sqlQueryObject.addSelectAliasField("api_resources", "nome", "nomeRisorsaCorrelata");
                            sqlQueryObject.addSelectAliasField("api_resources", "http_method", "httpMethodRisorsaCorrelata");
                            sqlQueryObject.addSelectAliasField("api_resources", "path", "pathRisorsaCorrelata");
                            sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeApi");
                            sqlQueryObject.addSelectAliasField("accordi", "versione", "versioneApi");
                            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoReferenteApi");
                            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeReferenteApi");
                            sqlQueryObject.addWhereCondition("api_resources.id_accordo = accordi.id");
                            sqlQueryObject.addWhereCondition("soggetti.id = accordi.id_referente");
                            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectApiExists);
                            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectOperationExists);
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQueryObject.addOrderBy("nomeApi");
                            sqlQueryObject.addOrderBy("versioneApi");
                            sqlQueryObject.addOrderBy("nomeReferenteApi");
                            sqlQueryObject.addOrderBy("tipoReferenteApi");
                            sqlQueryObject.addOrderBy("pathRisorsaCorrelata");
                            sqlQueryObject.addOrderBy("httpMethodRisorsaCorrelata");
                            sqlQueryObject.setSortType(true);
                            queryString = sqlQueryObject.createSQLQuery();
                            stmt = con.prepareStatement(queryString);
                            index = 1;
                            stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                            stmt.setString(index++, "modipaInteractionAsyncApiRequest");
                            stmt.setString(index++, IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordo));
                            stmt.setString(index++, ProprietariProtocolProperty.RESOURCE.name());
                            stmt.setString(index++, "modipaInteractionAsyncActionRequest");
                            stmt.setString(index++, nomeRisorsa);
                            risultato = stmt.executeQuery();
                            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
                            while (risultato.next()) {
                                String nomeReferenteApi;
                                String nomeApi = risultato.getString("nomeApi");
                                int versioneApi = risultato.getInt("versioneApi");
                                String tipoReferenteApi = risultato.getString("tipoReferenteApi");
                                IDAccordo idAPI = idAccordoFactory.getIDAccordoFromValues(nomeApi, tipoReferenteApi, nomeReferenteApi = risultato.getString("nomeReferenteApi"), Integer.valueOf(versioneApi));
                                if (idAPI.equals((Object)idAccordo)) continue;
                                String nomeRisorsaCorrelata = risultato.getString("nomeRisorsaCorrelata");
                                String httpMethodRisorsaCorrelata = risultato.getString("httpMethodRisorsaCorrelata");
                                String pathRisorsaCorrelata = risultato.getString("pathRisorsaCorrelata");
                                String path = null;
                                path = pathRisorsaCorrelata == null || "".equals(pathRisorsaCorrelata) ? "*" : pathRisorsaCorrelata;
                                String method = null;
                                method = httpMethodRisorsaCorrelata == null || "".equals(httpMethodRisorsaCorrelata) ? "Qualsiasi" : httpMethodRisorsaCorrelata;
                                correlazione_list.add("Risorsa " + method + " " + path + " dell'API '" + idAccordoFactory.getUriFromIDAccordo(idAPI) + "' (interazione: NonBloccante-Push)");
                                isInUso = true;
                            }
                            risultato.close();
                            stmt.close();
                        }
                    }
                } else {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("accordi");
                    sqlQueryObject.addFromTable("port_type");
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomeAzione");
                    sqlQueryObject.addSelectAliasField("port_type", "nome", "nomePT");
                    sqlQueryObject.addWhereCondition("accordi.id = ?");
                    sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("nomePT");
                    sqlQueryObject.addOrderBy("nomeAzione");
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    int index = 1;
                    stmt.setLong(index++, idAccordoServizioParteComune);
                    risultato = stmt.executeQuery();
                    ArrayList<IDPortTypeAzione> azioni = new ArrayList<IDPortTypeAzione>();
                    while (risultato.next()) {
                        IDPortType idPT = new IDPortType();
                        idPT.setIdAccordo(idAccordo);
                        idPT.setNome(risultato.getString("nomePT"));
                        IDPortTypeAzione id = new IDPortTypeAzione();
                        id.setIdPortType(idPT);
                        id.setNome(risultato.getString("nomeAzione"));
                        azioni.add(id);
                    }
                    risultato.close();
                    stmt.close();
                    if (!azioni.isEmpty()) {
                        for (IDPortTypeAzione idAzione : azioni) {
                            sqlQueryObjectApiExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectApiExists.setANDLogicOperator(true);
                            sqlQueryObjectApiExists.addFromTable("protocol_properties");
                            sqlQueryObjectApiExists.addSelectField("protocol_properties", "name");
                            sqlQueryObjectApiExists.addWhereCondition("port_type_azioni.id = protocol_properties.id_proprietario");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.name=?");
                            sqlQueryObjectApiExists.addWhereCondition("protocol_properties.value_string=?");
                            ISQLQueryObject sqlQueryObjectPortTypeExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectPortTypeExists.setANDLogicOperator(true);
                            sqlQueryObjectPortTypeExists.addFromTable("protocol_properties");
                            sqlQueryObjectPortTypeExists.addSelectField("protocol_properties", "name");
                            sqlQueryObjectPortTypeExists.addWhereCondition("port_type_azioni.id = protocol_properties.id_proprietario");
                            sqlQueryObjectPortTypeExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                            sqlQueryObjectPortTypeExists.addWhereCondition("protocol_properties.name=?");
                            sqlQueryObjectPortTypeExists.addWhereCondition("protocol_properties.value_string=?");
                            ISQLQueryObject sqlQueryObjectOperationExists = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObjectOperationExists.setANDLogicOperator(true);
                            sqlQueryObjectOperationExists.addFromTable("protocol_properties");
                            sqlQueryObjectOperationExists.addSelectField("protocol_properties", "name");
                            sqlQueryObjectOperationExists.addWhereCondition("port_type_azioni.id = protocol_properties.id_proprietario");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.tipo_proprietario=?");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.name=?");
                            sqlQueryObjectOperationExists.addWhereCondition("protocol_properties.value_string=?");
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                            sqlQueryObject.addFromTable("accordi");
                            sqlQueryObject.addFromTable("soggetti");
                            sqlQueryObject.addFromTable("port_type");
                            sqlQueryObject.addFromTable("port_type_azioni");
                            sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomeAzioneCorrelata");
                            sqlQueryObject.addSelectAliasField("port_type", "nome", "nomePTCorrelato");
                            sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeApi");
                            sqlQueryObject.addSelectAliasField("accordi", "versione", "versioneApi");
                            sqlQueryObject.addSelectAliasField("soggetti", "tipo_soggetto", "tipoReferenteApi");
                            sqlQueryObject.addSelectAliasField("soggetti", "nome_soggetto", "nomeReferenteApi");
                            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
                            sqlQueryObject.addWhereCondition("soggetti.id = accordi.id_referente");
                            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
                            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectApiExists);
                            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectPortTypeExists);
                            sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectOperationExists);
                            sqlQueryObject.setANDLogicOperator(true);
                            sqlQueryObject.addOrderBy("nomeApi");
                            sqlQueryObject.addOrderBy("versioneApi");
                            sqlQueryObject.addOrderBy("nomeReferenteApi");
                            sqlQueryObject.addOrderBy("tipoReferenteApi");
                            sqlQueryObject.addOrderBy("nomePTCorrelato");
                            sqlQueryObject.addOrderBy("nomeAzioneCorrelata");
                            sqlQueryObject.setSortType(true);
                            queryString = sqlQueryObject.createSQLQuery();
                            stmt = con.prepareStatement(queryString);
                            index = 1;
                            stmt.setString(index++, ProprietariProtocolProperty.OPERATION.name());
                            stmt.setString(index++, "modipaInteractionAsyncApiRequest");
                            stmt.setString(index++, IDAccordoFactory.getInstance().getUriFromIDAccordo(idAzione.getIdPortType().getIdAccordo()));
                            stmt.setString(index++, ProprietariProtocolProperty.OPERATION.name());
                            stmt.setString(index++, "modipaInteractionAsyncServiceRequest");
                            stmt.setString(index++, idAzione.getIdPortType().getNome());
                            stmt.setString(index++, ProprietariProtocolProperty.OPERATION.name());
                            stmt.setString(index++, "modipaInteractionAsyncActionRequest");
                            stmt.setString(index++, idAzione.getNome());
                            risultato = stmt.executeQuery();
                            IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
                            while (risultato.next()) {
                                String nomeReferenteApi;
                                String nomeAzioneCorrelata = risultato.getString("nomeAzioneCorrelata");
                                String nomePTCorrelato = risultato.getString("nomePTCorrelato");
                                String nomeApi = risultato.getString("nomeApi");
                                int versioneApi = risultato.getInt("versioneApi");
                                String tipoReferenteApi = risultato.getString("tipoReferenteApi");
                                IDAccordo idAPI = idAccordoFactory.getIDAccordoFromValues(nomeApi, tipoReferenteApi, nomeReferenteApi = risultato.getString("nomeReferenteApi"), Integer.valueOf(versioneApi));
                                if (idAPI.equals((Object)idAccordo)) continue;
                                correlazione_list.add("Azione " + nomeAzioneCorrelata + " del Servizio " + nomePTCorrelato + " dell'API '" + idAccordoFactory.getUriFromIDAccordo(idAPI) + "' (interazione: NonBloccante-Push)");
                                isInUso = true;
                            }
                            risultato.close();
                            stmt.close();
                        }
                    }
                }
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, boolean normalizeObjectIds) {
        StringBuilder bf = new StringBuilder();
        if (normalizeObjectIds && idAccordo.getSoggettoReferente() != null) {
            try {
                String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(idAccordo.getSoggettoReferente().getTipo());
                String labelAccordo = DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + NamingUtils.getLabelAccordoServizioParteComune(protocollo, idAccordo);
                bf.append(labelAccordo);
            }
            catch (Exception e) {
                bf.append(idAccordo.toString());
            }
        } else {
            bf.append(idAccordo.toString());
        }
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = "API '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block8: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IN_USO_IN_SERVIZI: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "implementata dai Servizi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "implementata nelle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "implementata nelle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
                case IS_CORRELATA: {
                    if (messages == null || messages.size() <= 0) continue block8;
                    msg = (String)msg + "correlata ad operazioni di altre API: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block8;
                }
            }
            msg = (String)msg + "utilizzata in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

