/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_genericProperties {
    protected static boolean isGenericPropertiesInUso(Connection con, String tipoDB, IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        String nomeMetodo = "isGenericPropertiesInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            String queryString;
            boolean isInUso = false;
            if ("gestionePolicyToken".equals(idGP.getTipologia())) {
                ResultPorta resultPorta;
                String nome;
                List<String> tokenPA_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_PA);
                List<String> tokenPD_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_PD);
                List<String> mapping_tokenPA_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_MAPPING_PA);
                List<String> mapping_tokenPD_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_MAPPING_PD);
                List<String> tokenSA_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_SA);
                List<String> tokenSA_MODI_list = whereIsInUso.get(ErrorsHandlerCostant.TOKEN_SA_MODI);
                if (tokenPA_list == null) {
                    tokenPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_PA, tokenPA_list);
                }
                if (tokenPD_list == null) {
                    tokenPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_PD, tokenPD_list);
                }
                if (mapping_tokenPA_list == null) {
                    mapping_tokenPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_MAPPING_PA, mapping_tokenPA_list);
                }
                if (mapping_tokenPD_list == null) {
                    mapping_tokenPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_MAPPING_PD, mapping_tokenPD_list);
                }
                if (tokenSA_list == null) {
                    tokenSA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_SA, tokenSA_list);
                }
                if (tokenSA_MODI_list == null) {
                    tokenSA_MODI_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_SA_MODI, tokenSA_MODI_list);
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("porte_applicative.token_policy = ?");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mapping_tokenPA_list.add(resultPorta.label);
                    } else {
                        tokenPA_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("porte_delegate.token_policy = ?");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mapping_tokenPD_list.add(resultPorta.label);
                    } else {
                        tokenPD_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("servizi_applicativi.nome");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String tipo_soggetto = risultato.getString("tipo_soggetto");
                    String nome_soggetto = risultato.getString("nome_soggetto");
                    String nome2 = risultato.getString("nome");
                    IDSoggetto idSoggetto = new IDSoggetto(tipo_soggetto, nome_soggetto);
                    if (normalizeObjectIds) {
                        String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                        tokenSA_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome2 + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idSoggetto));
                    } else {
                        tokenSA_list.add(tipo_soggetto + "/" + nome_soggetto + "_" + nome2);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("protocol_properties");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("servizi_applicativi.nome");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("protocol_properties.tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition("protocol_properties.id_proprietario = servizi_applicativi.id");
                sqlQueryObject.addWhereCondition("protocol_properties.name = ?");
                sqlQueryObject.addWhereCondition("protocol_properties.value_string = ?");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                stmt.setString(index++, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO.name());
                stmt.setString(index++, "modipaSecurityTokenPolicy");
                stmt.setString(index++, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String tipo_soggetto = risultato.getString("tipo_soggetto");
                    String nome_soggetto = risultato.getString("nome_soggetto");
                    String nome3 = risultato.getString("nome");
                    IDSoggetto idSoggetto = new IDSoggetto(tipo_soggetto, nome_soggetto);
                    if (normalizeObjectIds) {
                        String protocollo = ProtocolFactoryManager.getInstance().getProtocolByOrganizationType(tipo_soggetto);
                        tokenSA_MODI_list.add(DBOggettiInUsoUtils.getProtocolPrefix(protocollo) + nome3 + DBOggettiInUsoUtils.getSubjectSuffix(protocollo, idSoggetto));
                    } else {
                        tokenSA_MODI_list.add(tipo_soggetto + "/" + nome_soggetto + "_" + nome3);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if ("retrievePolicyToken".equals(idGP.getTipologia())) {
                ArrayList<Long> idConnettori = new ArrayList<Long>();
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addSelectField("connettori.id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("connettori.token_policy = ?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    Long id = risultato.getLong("id");
                    idConnettori.add(id);
                }
                risultato.close();
                stmt.close();
                if (idConnettori != null && !idConnettori.isEmpty()) {
                    isInUso = true;
                }
                DBOggettiInUsoUtils.formatConnettori(idConnettori, whereIsInUso, con, normalizeObjectIds, tipoDB);
            }
            if ("attributeAuthority".equals(idGP.getTipologia())) {
                ResultPorta resultPorta;
                String nome;
                List<String> aaPA_list = whereIsInUso.get(ErrorsHandlerCostant.ATTRIBUTE_AUTHORITY_PA);
                List<String> aaPD_list = whereIsInUso.get(ErrorsHandlerCostant.ATTRIBUTE_AUTHORITY_PD);
                List<String> mapping_aaPA_list = whereIsInUso.get(ErrorsHandlerCostant.ATTRIBUTE_AUTHORITY_MAPPING_PA);
                List<String> mapping_aaPD_list = whereIsInUso.get(ErrorsHandlerCostant.ATTRIBUTE_AUTHORITY_MAPPING_PD);
                if (aaPA_list == null) {
                    aaPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_PA, aaPA_list);
                }
                if (aaPD_list == null) {
                    aaPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_PD, aaPD_list);
                }
                if (mapping_aaPA_list == null) {
                    mapping_aaPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_MAPPING_PA, mapping_aaPA_list);
                }
                if (mapping_aaPD_list == null) {
                    mapping_aaPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.TOKEN_MAPPING_PD, mapping_aaPD_list);
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("pa_aa");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pa_aa.nome = ?");
                sqlQueryObject.addWhereCondition("pa_aa.id_porta = porte_applicative.id");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mapping_aaPA_list.add(resultPorta.label);
                    } else {
                        aaPA_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_aa");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pd_aa.nome = ?");
                sqlQueryObject.addWhereCondition("pd_aa.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idGP.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mapping_aaPD_list.add(resultPorta.label);
                    } else {
                        aaPD_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            JDBCUtilities.closeResources(risultato2, stmt2);
            JDBCUtilities.closeResources(risultato, stmt);
        }
    }

    protected static String toString(IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_genericProperties.toString(idGP, whereIsInUso, prefix, separator, " non eliminabile perch&egrave; :");
    }

    protected static String toString(IDGenericProperties idGP, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        String object = "Token Policy";
        if (idGP != null && "attributeAuthority".equals(idGP.getTipologia())) {
            object = "Attribute Authority";
        }
        Object msg = object + " '" + (idGP != null ? idGP.getNome() : "?") + "'" + intestazione + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block16: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case TOKEN_MAPPING_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzata nel controllo degli accessi per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case TOKEN_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Outbound (Controllo degli Accessi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case TOKEN_MAPPING_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nel controllo degli accessi per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case TOKEN_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Controllo degli Accessi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case TOKEN_SA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato negli Applicativi: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case TOKEN_SA_MODI: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato negli Applicativi (ModI Authorization OAuth): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case CONNETTORE_MAPPING_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzata nel connettore per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case CONNETTORE_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Outbound (Connettore): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case CONNETTORE_MAPPING_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nel connettore per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case CONNETTORE_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Connettore): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case ATTRIBUTE_AUTHORITY_MAPPING_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzata nel controllo degli accessi per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case ATTRIBUTE_AUTHORITY_PD: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Outbound (Controllo degli Accessi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case ATTRIBUTE_AUTHORITY_MAPPING_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nel controllo degli accessi per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
                case ATTRIBUTE_AUTHORITY_PA: {
                    if (messages == null || messages.size() <= 0) continue block16;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Controllo degli Accessi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block16;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

