/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.controllo_traffico.constants.TipoFiltroApplicativo;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCParameterUtilities;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_plugins {
    protected static boolean isPluginInUso(Connection con, String tipoDB, String className, String label, String tipoPlugin, String tipo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "isPluginInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            boolean isInUso = false;
            long idPluginLong = DBUtils.getIdPlugin((String)className, (String)label, (String)tipoPlugin, (String)tipo, (Connection)con, (String)tipoDB);
            if (idPluginLong <= 0L) {
                throw new UtilsException("Plugin con Label [" + label + "] non trovato");
            }
            if ("CONNETTORE".equals(tipoPlugin)) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("endpointtype=?");
                sqlQueryObject.addWhereCondition("custom=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                stmt.setInt(2, 1);
                risultato = stmt.executeQuery();
                ArrayList<Long> idConnettori = new ArrayList<Long>();
                while (risultato.next()) {
                    long idConnettore = risultato.getLong("id");
                    idConnettori.add(idConnettore);
                }
                risultato.close();
                stmt.close();
                if (idConnettori != null && !idConnettori.isEmpty()) {
                    isInUso = true;
                }
                DBOggettiInUsoUtils.formatConnettori(idConnettori, whereIsInUso, con, normalizeObjectIds, tipoDB);
            } else if ("AUTENTICAZIONE".equals(tipoPlugin) || "AUTORIZZAZIONE".equals(tipoPlugin) || "AUTORIZZAZIONE_CONTENUTI".equals(tipoPlugin) || "INTEGRAZIONE".equals(tipoPlugin) || "BEHAVIOUR".equals(tipoPlugin)) {
                boolean autenticazione = "AUTENTICAZIONE".equals(tipoPlugin);
                boolean autorizzazione = "AUTORIZZAZIONE".equals(tipoPlugin);
                boolean autorizzazione_contenuti = "AUTORIZZAZIONE_CONTENUTI".equals(tipoPlugin);
                boolean integrazione = "INTEGRAZIONE".equals(tipoPlugin);
                boolean behaviour = "BEHAVIOUR".equals(tipoPlugin);
                ErrorsHandlerCostant PD_tipoControllo_mapping = null;
                ErrorsHandlerCostant PD_tipoControllo = null;
                ErrorsHandlerCostant PA_tipoControllo_mapping = null;
                ErrorsHandlerCostant PA_tipoControllo = null;
                String colonna = "";
                if (autenticazione) {
                    PD_tipoControllo_mapping = ErrorsHandlerCostant.AUTENTICAZIONE_MAPPING_PD;
                    PD_tipoControllo = ErrorsHandlerCostant.AUTENTICAZIONE_PD;
                    PA_tipoControllo_mapping = ErrorsHandlerCostant.AUTENTICAZIONE_MAPPING_PA;
                    PA_tipoControllo = ErrorsHandlerCostant.AUTENTICAZIONE_PA;
                    colonna = "autenticazione";
                } else if (autorizzazione) {
                    PD_tipoControllo_mapping = ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PD;
                    PD_tipoControllo = ErrorsHandlerCostant.AUTORIZZAZIONE_PD;
                    PA_tipoControllo_mapping = ErrorsHandlerCostant.AUTORIZZAZIONE_MAPPING_PA;
                    PA_tipoControllo = ErrorsHandlerCostant.AUTORIZZAZIONE_PA;
                    colonna = "autorizzazione";
                } else if (autorizzazione_contenuti) {
                    PD_tipoControllo_mapping = ErrorsHandlerCostant.AUTORIZZAZIONE_CONTENUTI_MAPPING_PD;
                    PD_tipoControllo = ErrorsHandlerCostant.AUTORIZZAZIONE_CONTENUTI_PD;
                    PA_tipoControllo_mapping = ErrorsHandlerCostant.AUTORIZZAZIONE_CONTENUTI_MAPPING_PA;
                    PA_tipoControllo = ErrorsHandlerCostant.AUTORIZZAZIONE_CONTENUTI_PA;
                    colonna = "autorizzazione_contenuto";
                } else if (integrazione) {
                    PD_tipoControllo_mapping = ErrorsHandlerCostant.INTEGRAZIONE_MAPPING_PD;
                    PD_tipoControllo = ErrorsHandlerCostant.INTEGRAZIONE_PD;
                    PA_tipoControllo_mapping = ErrorsHandlerCostant.INTEGRAZIONE_MAPPING_PA;
                    PA_tipoControllo = ErrorsHandlerCostant.INTEGRAZIONE_PA;
                    colonna = "integrazione";
                } else if (behaviour) {
                    PA_tipoControllo_mapping = ErrorsHandlerCostant.BEHAVIOUR_MAPPING_PA;
                    PA_tipoControllo = ErrorsHandlerCostant.BEHAVIOUR_PA;
                    colonna = "behaviour";
                }
                List<String> PD_mapping_list = null;
                List<String> PD_list = null;
                if (!behaviour) {
                    PD_mapping_list = whereIsInUso.get(PD_tipoControllo_mapping);
                    PD_list = whereIsInUso.get(PD_tipoControllo);
                }
                List<String> PA_mapping_list = whereIsInUso.get(PA_tipoControllo_mapping);
                List<String> PA_list = whereIsInUso.get(PA_tipoControllo);
                if (!behaviour) {
                    if (PD_mapping_list == null) {
                        PD_mapping_list = new ArrayList<String>();
                        whereIsInUso.put(PD_tipoControllo_mapping, PD_mapping_list);
                    }
                    if (PD_list == null) {
                        PD_list = new ArrayList<String>();
                        whereIsInUso.put(PD_tipoControllo, PD_list);
                    }
                }
                if (PA_mapping_list == null) {
                    PA_mapping_list = new ArrayList<String>();
                    whereIsInUso.put(PA_tipoControllo_mapping, PA_mapping_list);
                }
                if (PA_list == null) {
                    PA_list = new ArrayList<String>();
                    whereIsInUso.put(PA_tipoControllo, PA_list);
                }
                int i = 0;
                if (behaviour) {
                    i = 1;
                }
                while (i < 2) {
                    String table = "porte_delegate";
                    if (i == 1) {
                        table = "porte_applicative";
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable(table);
                    sqlQueryObject.addSelectField("nome_porta");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (integrazione) {
                        ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                        sqlQueryObjectOr.setANDLogicOperator(false);
                        sqlQueryObjectOr.addWhereLikeCondition(colonna, tipo, false, false);
                        sqlQueryObjectOr.addWhereLikeCondition(colonna, tipo + ",", LikeConfig.startsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition(colonna, "," + tipo, LikeConfig.endsWith((boolean)false));
                        sqlQueryObjectOr.addWhereLikeCondition(colonna, "," + tipo + ",", true, false);
                        sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
                    } else {
                        sqlQueryObject.addWhereCondition(colonna + "=?");
                    }
                    String queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    if (!integrazione) {
                        stmt.setString(1, tipo);
                    }
                    risultato = stmt.executeQuery();
                    while (risultato.next()) {
                        ResultPorta resultPorta;
                        String nome = risultato.getString("nome_porta");
                        if ("porte_delegate".equals(table)) {
                            resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                PD_mapping_list.add(resultPorta.label);
                            } else {
                                PD_list.add(resultPorta.label);
                            }
                        } else {
                            resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                PA_mapping_list.add(resultPorta.label);
                            } else {
                                PA_list.add(resultPorta.label);
                            }
                        }
                        isInUso = true;
                    }
                    risultato.close();
                    stmt.close();
                    ++i;
                }
            } else if ("RATE_LIMITING".equals(tipoPlugin)) {
                List<String> ct_list = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
                if (ct_list == null) {
                    ct_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ct_list);
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("ct_active_policy");
                sqlQueryObject.addSelectField("active_policy_id");
                sqlQueryObject.addSelectField("policy_alias");
                sqlQueryObject.addSelectField("filtro_ruolo");
                sqlQueryObject.addSelectField("filtro_porta");
                sqlQueryObject.setANDLogicOperator(false);
                sqlQueryObject.addWhereCondition(true, new String[]{"ct_active_policy.filtro_key_enabled = ?", "ct_active_policy.filtro_key_type = ?", sqlQueryObject.getWhereLikeCondition("ct_active_policy.filtro_key_name", tipo, false, false)});
                sqlQueryObject.addWhereCondition(true, new String[]{"ct_active_policy.group_key_enabled = ?", "ct_active_policy.group_key_type = ?", sqlQueryObject.getWhereLikeCondition("ct_active_policy.group_key_name", tipo, false, false)});
                sqlQueryObject.addOrderBy("filtro_ruolo");
                sqlQueryObject.addOrderBy("filtro_porta");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                JDBCParameterUtilities utils = new JDBCParameterUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2());
                utils.setParameter(stmt, index++, (Object)true, Boolean.TYPE);
                stmt.setString(index++, TipoFiltroApplicativo.PLUGIN_BASED.getValue());
                utils.setParameter(stmt, index++, (Object)true, Boolean.TYPE);
                stmt.setString(index++, TipoFiltroApplicativo.PLUGIN_BASED.getValue());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String alias = risultato.getString("policy_alias");
                    if (alias == null || "".equals(alias)) {
                        alias = risultato.getString("active_policy_id");
                    }
                    String nomePorta = risultato.getString("filtro_porta");
                    String filtro_ruolo = risultato.getString("filtro_ruolo");
                    if (nomePorta != null) {
                        ResultPorta resultPorta;
                        String tipoPorta = null;
                        String labelPorta = null;
                        if ("delegata".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    labelPorta = "Fruizione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipoPorta = "Outbound";
                            }
                        } else if ("applicativa".equals(filtro_ruolo)) {
                            try {
                                resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                                if (resultPorta.mapping) {
                                    labelPorta = "Erogazione di Servizio " + resultPorta.label;
                                }
                            }
                            catch (Exception e) {
                                tipoPorta = "Inbound";
                            }
                        } else {
                            tipoPorta = filtro_ruolo;
                        }
                        if (labelPorta == null) {
                            ct_list.add("Policy '" + alias + "' attiva nella porta '" + tipoPorta + "' '" + nomePorta + "' ");
                        } else {
                            ct_list.add("Policy '" + alias + "' attiva nella " + labelPorta);
                        }
                    } else {
                        ct_list.add("Policy '" + alias + "'");
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            } else if ("ALLARME".equals(tipoPlugin)) {
                ResultPorta resultPorta;
                String nome;
                List<String> allarmiPD_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI_MAPPING_PD);
                List<String> allarmiPD_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI_PD);
                List<String> allarmiPA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI_MAPPING_PA);
                List<String> allarmiPA_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI_PA);
                List<String> allarmi_list = whereIsInUso.get(ErrorsHandlerCostant.ALLARMI);
                if (allarmiPD_mapping_list == null) {
                    allarmiPD_mapping_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.ALLARMI_MAPPING_PD, allarmiPD_mapping_list);
                }
                if (allarmiPD_list == null) {
                    allarmiPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.ALLARMI_PD, allarmiPD_list);
                }
                if (allarmiPA_mapping_list == null) {
                    allarmiPA_mapping_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.ALLARMI_MAPPING_PA, allarmiPA_mapping_list);
                }
                if (allarmiPA_list == null) {
                    allarmiPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.ALLARMI_PA, allarmiPA_list);
                }
                if (allarmi_list == null) {
                    allarmi_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.ALLARMI, allarmi_list);
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("allarmi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("tipo=?");
                sqlQueryObject.addWhereIsNullCondition("filtro_porta");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome");
                    allarmi_list.add(nome);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("allarmi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("filtro_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("tipo=?");
                sqlQueryObject.addWhereCondition("filtro_ruolo=?");
                sqlQueryObject.addWhereIsNotNullCondition("filtro_porta");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                stmt.setString(2, RuoloPorta.APPLICATIVA.getValue());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("filtro_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        allarmiPA_mapping_list.add(resultPorta.label);
                    } else {
                        allarmiPA_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("allarmi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("filtro_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("tipo=?");
                sqlQueryObject.addWhereCondition("filtro_ruolo=?");
                sqlQueryObject.addWhereIsNotNullCondition("filtro_porta");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                stmt.setString(2, RuoloPorta.DELEGATA.getValue());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("filtro_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        allarmiPD_mapping_list.add(resultPorta.label);
                    } else {
                        allarmiPD_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            } else if ("MESSAGE_HANDLER".equals(tipoPlugin)) {
                ResultPorta resultPorta;
                String labelMessaggio;
                String nome;
                String tipologia;
                List<String> messageHandlerPD_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.MESSAGE_HANDLER_MAPPING_PD);
                List<String> messageHandlerPD_list = whereIsInUso.get(ErrorsHandlerCostant.MESSAGE_HANDLER_PD);
                List<String> messageHandlerPA_mapping_list = whereIsInUso.get(ErrorsHandlerCostant.MESSAGE_HANDLER_MAPPING_PA);
                List<String> messageHandlerPA_list = whereIsInUso.get(ErrorsHandlerCostant.MESSAGE_HANDLER_PA);
                List<String> messageHandler_list = whereIsInUso.get(ErrorsHandlerCostant.MESSAGE_HANDLER);
                if (messageHandlerPD_mapping_list == null) {
                    messageHandlerPD_mapping_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.MESSAGE_HANDLER_MAPPING_PD, messageHandlerPD_mapping_list);
                }
                if (messageHandlerPD_list == null) {
                    messageHandlerPD_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.MESSAGE_HANDLER_PD, messageHandlerPD_list);
                }
                if (messageHandlerPA_mapping_list == null) {
                    messageHandlerPA_mapping_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.MESSAGE_HANDLER_MAPPING_PA, messageHandlerPA_mapping_list);
                }
                if (messageHandlerPA_list == null) {
                    messageHandlerPA_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.MESSAGE_HANDLER_PA, messageHandlerPA_list);
                }
                if (messageHandler_list == null) {
                    messageHandler_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.MESSAGE_HANDLER, messageHandler_list);
                }
                String tabella = "config_handlers";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField(tabella + ".tipologia");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(tabella + ".tipo=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipologia = risultato.getString("tipologia");
                    String labelMessaggio2 = DBOggettiInUsoUtils_plugins.formatMessageHandlerFromTipologia(tipologia);
                    messageHandler_list.add(labelMessaggio2);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                tabella = "pa_handlers";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addSelectField(tabella + ".tipologia");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=porte_applicative.id");
                sqlQueryObject.addWhereCondition(tabella + ".tipo=?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipologia = risultato.getString("tipologia");
                    nome = risultato.getString("nome_porta");
                    labelMessaggio = DBOggettiInUsoUtils_plugins.formatMessageHandlerFromTipologia(tipologia);
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        messageHandlerPA_mapping_list.add(resultPorta.label + ": " + labelMessaggio);
                    } else {
                        messageHandlerPA_list.add(resultPorta.label + ": " + labelMessaggio);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
                tabella = "pd_handlers";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField(tabella + ".tipologia");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(tabella + ".id_porta=porte_delegate.id");
                sqlQueryObject.addWhereCondition(tabella + ".tipo=?");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    tipologia = risultato.getString("tipologia");
                    nome = risultato.getString("nome_porta");
                    labelMessaggio = DBOggettiInUsoUtils_plugins.formatMessageHandlerFromTipologia(tipologia);
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        messageHandlerPD_mapping_list.add(resultPorta.label + ": " + labelMessaggio);
                    } else {
                        messageHandlerPD_list.add(resultPorta.label + ": " + labelMessaggio);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            } else if ("SERVICE_HANDLER".equals(tipoPlugin)) {
                List<String> serviceHandler_list = whereIsInUso.get(ErrorsHandlerCostant.SERVICE_HANDLER);
                if (serviceHandler_list == null) {
                    serviceHandler_list = new ArrayList<String>();
                    whereIsInUso.put(ErrorsHandlerCostant.SERVICE_HANDLER, serviceHandler_list);
                }
                String tabella = "config_handlers";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable(tabella);
                sqlQueryObject.addSelectField(tabella + ".tipologia");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition(tabella + ".tipo=?");
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, tipo);
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String tipologia = risultato.getString("tipologia");
                    String labelMessaggio = DBOggettiInUsoUtils_plugins.formatServiceHandlerFromTipologia(tipologia);
                    serviceHandler_list.add(labelMessaggio);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            } else if ("TOKEN_DYNAMIC_DISCOVERY".equals(tipoPlugin) || "TOKEN_VALIDAZIONE".equals(tipoPlugin) || "TOKEN_NEGOZIAZIONE".equals(tipoPlugin) || "ATTRIBUTE_AUTHORITY".equals(tipoPlugin)) {
                boolean tokenDynamicDiscovery = "TOKEN_DYNAMIC_DISCOVERY".equals(tipoPlugin);
                boolean tokenValidazione = "TOKEN_VALIDAZIONE".equals(tipoPlugin);
                boolean tokenNegoziazione = "TOKEN_NEGOZIAZIONE".equals(tipoPlugin);
                boolean attributeAuthority = "ATTRIBUTE_AUTHORITY".equals(tipoPlugin);
                ErrorsHandlerCostant constants = null;
                String tipologia = null;
                if (tokenDynamicDiscovery) {
                    constants = ErrorsHandlerCostant.TOKEN_DYNAMIC_DISCOVERY_PA;
                    tipologia = "gestionePolicyToken";
                } else if (tokenValidazione) {
                    constants = ErrorsHandlerCostant.TOKEN_PA;
                    tipologia = "gestionePolicyToken";
                } else if (tokenNegoziazione) {
                    constants = ErrorsHandlerCostant.TOKEN_NEGOZIAZIONE_PA;
                    tipologia = "retrievePolicyToken";
                } else {
                    constants = ErrorsHandlerCostant.ATTRIBUTE_AUTHORITY_PA;
                    tipologia = "attributeAuthority";
                }
                List<String> gpList = whereIsInUso.get(constants);
                if (gpList == null) {
                    gpList = new ArrayList<String>();
                    whereIsInUso.put(constants, gpList);
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("generic_properties", "gps");
                sqlQueryObject.addFromTable("generic_property", "gp");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addSelectAliasField("gps", "nome", "nomeGP");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("gps.id=gp.id_props");
                sqlQueryObject.addWhereCondition("gps.tipologia=?");
                String campoGpNome = "gp.nome=?";
                String campoGpValore = "gp.valore";
                if (tokenValidazione) {
                    sqlQueryObject.addWhereCondition(false, new String[]{campoGpNome, campoGpNome, campoGpNome});
                    sqlQueryObject.addWhereLikeCondition(campoGpValore, tipo, false, false, false);
                } else if (tokenDynamicDiscovery || tokenNegoziazione || attributeAuthority) {
                    sqlQueryObject.addWhereCondition(campoGpNome);
                    sqlQueryObject.addWhereLikeCondition(campoGpValore, tipo, false, false, false);
                }
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                int index = 1;
                JDBCParameterUtilities utils = new JDBCParameterUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2());
                utils.setParameter(stmt, index++, (Object)tipologia, String.class);
                if (tokenValidazione) {
                    utils.setParameter(stmt, index++, (Object)"policy.validazioneJWT.claimsParser.pluginType", String.class);
                    utils.setParameter(stmt, index++, (Object)"policy.introspection.claimsParser.pluginType", String.class);
                    utils.setParameter(stmt, index++, (Object)"policy.userInfo.claimsParser.pluginType", String.class);
                } else if (tokenDynamicDiscovery) {
                    utils.setParameter(stmt, index++, (Object)"policy.discovery.claimsParser.pluginType", String.class);
                } else if (tokenNegoziazione) {
                    utils.setParameter(stmt, index++, (Object)"policy.retrieveToken.claimsParser.pluginType", String.class);
                } else if (attributeAuthority) {
                    utils.setParameter(stmt, index++, (Object)"policy.attributeAuthority.claimsParser.pluginType", String.class);
                }
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String nome = risultato.getString("nomeGP");
                    String labelMessaggio = DBOggettiInUsoUtils.formatGenericProperties(tipologia, nome);
                    gpList.add(labelMessaggio);
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato2, stmt2);
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(risultato2, stmt2);
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(String className, String label, String tipoPlugin, String tipo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        if (className == null || tipoPlugin == null || tipo != null) {
            // empty if block
        }
        StringBuilder bf = new StringBuilder();
        bf.append(label);
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        StringBuilder msg = new StringBuilder();
        msg.append("Plugin '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator);
        if (!prefix) {
            msg = new StringBuilder();
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block40: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && !messages.isEmpty()) {
                msg.append(separatorCategorie);
            }
            switch (key) {
                case CONNETTORE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzata nel connettore per le Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case CONNETTORE_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Connettore): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case CONNETTORE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nel connettore per le Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case CONNETTORE_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Connettore): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTENTICAZIONE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autenticazione nel Controllo degli Accessi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTENTICAZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Controllo degli Accessi - Autenticazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTENTICAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autenticazione nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTENTICAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autenticazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autorizzazione nel Controllo degli Accessi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Controllo degli Accessi - Autorizzazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autorizzazione nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autorizzazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_CONTENUTI_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autorizzazione dei contenuti nel Controllo degli Accessi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_CONTENUTI_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Controllo degli Accessi - Autorizzazione dei Contenuti): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_CONTENUTI_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato come processo di autorizzazione dei contenuti nel Controllo degli Accessi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case AUTORIZZAZIONE_CONTENUTI_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Controllo degli Accessi - Autorizzazione dei Contenuti): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato in Policy di Rate Limiting: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case INTEGRAZIONE_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato per generare i metadati di integrazione nelle Opzioni Avanzate delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case INTEGRAZIONE_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Opzioni Avanzate - Metadata di Integrazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case INTEGRAZIONE_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato per generare i metadati di integrazione nelle Opzioni Avanzate delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case INTEGRAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Opzioni Avanzate - Metadata di Integrazione): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case BEHAVIOUR_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nella configurazione dei connettori multipli come consegna personalizzata delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case BEHAVIOUR_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Connettori Multipli - Consegna Personalizzata): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ALLARMI_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato negli Allarmi delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ALLARMI_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Allarmi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ALLARMI_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato negli Allarmi delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ALLARMI_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Allarmi): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ALLARMI: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato negli Allarmi definiti nella configurazione generale: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case MESSAGE_HANDLER_MAPPING_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nei Message Handlers delle Erogazioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case MESSAGE_HANDLER_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Inbound (Message Handlers): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case MESSAGE_HANDLER: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nei Message Handlers: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case MESSAGE_HANDLER_MAPPING_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nei Message Handlers delle Fruizioni: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case MESSAGE_HANDLER_PD: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Porte Outbound (Message Handlers): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case SERVICE_HANDLER: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nei Service Handlers: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case TOKEN_DYNAMIC_DISCOVERY_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Token Policy di Validazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case TOKEN_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Token Policy di Validazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case TOKEN_NEGOZIAZIONE_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato nelle Token Policy di Negoziazione: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
                case ATTRIBUTE_AUTHORITY_PA: {
                    if (messages == null || messages.isEmpty()) continue block40;
                    msg.append("utilizzato negli Attribute Authority: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator);
                    continue block40;
                }
            }
            msg.append("utilizzato in oggetto non codificato (" + key + ")" + separator);
        }
        return msg.toString();
    }

    private static String formatMessageHandlerFromTipologia(String tipologia) {
        if (tipologia.endsWith("Request")) {
            String tipologiaWS = tipologia.substring(0, tipologia.indexOf("Request"));
            String template = "Fase [{0}] degli Handler di Richiesta";
            return MessageFormat.format(template, tipologiaWS);
        }
        String tipologiaWS = tipologia.substring(0, tipologia.indexOf("Response"));
        String template = "Fase [{0}] degli Handler di Risposta";
        return MessageFormat.format(template, tipologiaWS);
    }

    private static String formatServiceHandlerFromTipologia(String tipologia) {
        return MessageFormat.format("Fase [{0}]", tipologia);
    }
}

