/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_rateLimiting {
    protected static boolean isRateLimitingPolicyInUso(Connection con, String tipoDB, IdPolicy idPolicy, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        boolean bl;
        String nomeMetodo = "isRateLimitingPolicyInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        PreparedStatement stmt2 = null;
        ResultSet risultato2 = null;
        try {
            boolean isInUso = false;
            List<String> ct_list = whereIsInUso.get(ErrorsHandlerCostant.CONTROLLO_TRAFFICO);
            if (ct_list == null) {
                ct_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.CONTROLLO_TRAFFICO, ct_list);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
            sqlQueryObject.addFromTable("ct_active_policy");
            sqlQueryObject.addSelectField("active_policy_id");
            sqlQueryObject.addSelectField("policy_alias");
            sqlQueryObject.addSelectField("filtro_ruolo");
            sqlQueryObject.addSelectField("filtro_porta");
            sqlQueryObject.setANDLogicOperator(false);
            sqlQueryObject.addWhereCondition("ct_active_policy.policy_id = ?");
            sqlQueryObject.addOrderBy("filtro_ruolo");
            sqlQueryObject.addOrderBy("filtro_porta");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, idPolicy.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                String alias = risultato.getString("policy_alias");
                if (alias == null || "".equals(alias)) {
                    alias = risultato.getString("active_policy_id");
                }
                String nomePorta = risultato.getString("filtro_porta");
                String filtro_ruolo = risultato.getString("filtro_ruolo");
                if (nomePorta != null) {
                    ResultPorta resultPorta;
                    String tipoPorta = null;
                    String labelPorta = null;
                    if ("delegata".equals(filtro_ruolo)) {
                        try {
                            resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nomePorta, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                labelPorta = "Fruizione di Servizio " + resultPorta.label;
                            }
                        }
                        catch (Exception e) {
                            tipoPorta = "Outbound";
                        }
                    } else if ("applicativa".equals(filtro_ruolo)) {
                        try {
                            resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nomePorta, tipoDB, con, normalizeObjectIds);
                            if (resultPorta.mapping) {
                                labelPorta = "Erogazione di Servizio " + resultPorta.label;
                            }
                        }
                        catch (Exception e) {
                            tipoPorta = "Inbound";
                        }
                    } else {
                        tipoPorta = filtro_ruolo;
                    }
                    if (labelPorta == null) {
                        ct_list.add("Policy '" + alias + "' attiva nella porta '" + tipoPorta + "' '" + nomePorta + "' ");
                    } else {
                        ct_list.add("Policy '" + alias + "' attiva nella " + labelPorta);
                    }
                } else {
                    ct_list.add("Policy '" + alias + "'");
                }
                isInUso = true;
            }
            risultato.close();
            stmt.close();
            bl = isInUso;
        }
        catch (Exception se) {
            try {
                throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato2, stmt2);
                JDBCUtilities.closeResources(risultato, stmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(risultato2, stmt2);
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        return bl;
    }

    protected static String toString(IdPolicy idPolicy, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        StringBuilder bf = new StringBuilder();
        bf.append(idPolicy.getNome());
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = "Policy '" + bf.toString() + "' non eliminabile perch&egrave; :" + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block3: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case CONTROLLO_TRAFFICO: {
                    if (messages == null || messages.size() <= 0) continue block3;
                    msg = (String)msg + "utilizzato in: " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block3;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

