/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.engine.utils.ResultPorta;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DBOggettiInUsoUtils_scope {
    protected static boolean isScopeConfigInUso(Connection con, String tipoDB, IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_scope._isScopeInUso(con, tipoDB, idScope, false, true, whereIsInUso, normalizeObjectIds);
    }

    protected static boolean isScopeInUso(Connection con, String tipoDB, IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        return DBOggettiInUsoUtils_scope._isScopeInUso(con, tipoDB, idScope, true, true, whereIsInUso, normalizeObjectIds);
    }

    private static boolean _isScopeInUso(Connection con, String tipoDB, IDScope idScope, boolean registry, boolean config, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws UtilsException {
        String nomeMetodo = "_isScopeInUso";
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            ResultPorta resultPorta;
            String nome;
            String queryString;
            ISQLQueryObject sqlQueryObject;
            boolean isInUso = false;
            List<String> porte_applicative_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE);
            List<String> porte_delegate_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE);
            List<String> mappingErogazionePA_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA);
            List<String> mappingFruizionePD_list = whereIsInUso.get(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD);
            if (porte_applicative_list == null) {
                porte_applicative_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, porte_applicative_list);
            }
            if (porte_delegate_list == null) {
                porte_delegate_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_DELEGATE, porte_delegate_list);
            }
            if (mappingErogazionePA_list == null) {
                mappingErogazionePA_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_EROGAZIONE_PA, mappingErogazionePA_list);
            }
            if (mappingFruizionePD_list == null) {
                mappingFruizionePD_list = new ArrayList<String>();
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_MAPPING_FRUIZIONE_PD, mappingFruizionePD_list);
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pa_scope");
                sqlQueryObject.addFromTable("porte_applicative");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_applicative.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pa_scope.scope = ?");
                sqlQueryObject.addWhereCondition("pa_scope.id_porta = porte_applicative.id");
                sqlQueryObject.addWhereCondition("porte_applicative.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idScope.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaApplicativa(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingErogazionePA_list.add(resultPorta.label);
                    } else {
                        porte_applicative_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            if (config) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.nome_porta");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.addWhereCondition("pd_scope.scope = ?");
                sqlQueryObject.addWhereCondition("pd_scope.id_porta = porte_delegate.id");
                sqlQueryObject.addWhereCondition("porte_delegate.id_soggetto = soggetti.id");
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, idScope.getNome());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    nome = risultato.getString("nome_porta");
                    resultPorta = DBOggettiInUsoUtils.formatPortaDelegata(nome, tipoDB, con, normalizeObjectIds);
                    if (resultPorta.mapping) {
                        mappingFruizionePD_list.add(resultPorta.label);
                    } else {
                        porte_delegate_list.add(resultPorta.label);
                    }
                    isInUso = true;
                }
                risultato.close();
                stmt.close();
            }
            boolean bl = isInUso;
            return bl;
        }
        catch (Exception se) {
            throw new UtilsException("[DBOggettiInUsoUtils::" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
        }
    }

    protected static String toString(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator) {
        return DBOggettiInUsoUtils_scope.toString(idScope, whereIsInUso, prefix, separator, " non eliminabile perch&egrave; :");
    }

    protected static String toString(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean prefix, String separator, String intestazione) {
        Set<ErrorsHandlerCostant> keys = whereIsInUso.keySet();
        Object msg = "Scope '" + idScope.getNome() + "'" + intestazione + separator;
        if (!prefix) {
            msg = "";
        }
        String separatorCategorie = "";
        if (whereIsInUso.size() > 1) {
            separatorCategorie = separator;
        }
        block6: for (ErrorsHandlerCostant key : keys) {
            List<String> messages = whereIsInUso.get(key);
            if (messages != null && messages.size() > 0) {
                msg = (String)msg + separatorCategorie;
            }
            switch (key) {
                case IN_USO_IN_PORTE_APPLICATIVE: {
                    if (messages == null || messages.size() <= 0) continue block6;
                    msg = (String)msg + "utilizzato nelle Porte Inbound (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block6;
                }
                case IN_USO_IN_PORTE_DELEGATE: {
                    if (messages == null || messages.size() <= 0) continue block6;
                    msg = (String)msg + "utilizzato nelle Porte Outbound (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block6;
                }
                case IN_USO_IN_MAPPING_EROGAZIONE_PA: {
                    if (messages == null || messages.size() <= 0) continue block6;
                    msg = (String)msg + "utilizzato nelle Erogazioni (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block6;
                }
                case IN_USO_IN_MAPPING_FRUIZIONE_PD: {
                    if (messages == null || messages.size() <= 0) continue block6;
                    msg = (String)msg + "utilizzato nelle Fruizioni (Controllo Accessi - Autorizzazione Token): " + DBOggettiInUsoUtils.formatList(messages, separator) + separator;
                    continue block6;
                }
            }
            msg = (String)msg + "utilizzato in oggetto non codificato (" + key + ")" + separator;
        }
        return msg;
    }
}

