/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.engine.utils;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.ModIPDNDClientConfig;
import org.openspcoop2.protocol.sdk.ModIPDNDOrganizationConfig;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.slf4j.Logger;

public class ModITestUtils {
    public static void main(String[] args) throws ProtocolException {
        ModITestUtils.verify();
    }

    public static void verify() throws ProtocolException {
        Logger log = LoggerWrapperFactory.getLogger(ModITestUtils.class);
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration((Level)Level.ALL);
        ConfigurazionePdD configPdD = new ConfigurazionePdD();
        configPdD.setLog(log);
        ProtocolFactoryManager.initializeSingleProtocol(log, configPdD, "modipa");
        ModITestUtils.testModIProperties(log);
        ModITestUtils.getHeaderModI(log);
        ModITestUtils.isTokenOAuthUseJtiIntegrityAsMessageId(log);
        ModITestUtils.getAPIPDNDClientConfig(log);
        ModITestUtils.getAPIPDNDOrganizationConfig(log);
        ModITestUtils.buildSignalHubPushIdAPI(log);
        ModITestUtils.isSignalHubEnabled(log);
        ModITestUtils.isTracingPDNDEnabled(log);
        ModITestUtils.getRemoteStoreConfig(log);
        ModITestUtils.getRemoteKeyType(log);
        ModITestUtils.getSicurezzaMessaggioCertificatiTrustStore(log);
        ModITestUtils.getSicurezzaMessaggioSslTrustStore(log);
        ModITestUtils.getSicurezzaMessaggioCertificatiKeyStore(log);
    }

    private static void testModIProperties(Logger log) throws ProtocolException {
        log.info("test ModIProperties ...");
        Object o = ModIUtils.getModiProperties();
        if (o == null) {
            throw new ProtocolException("ModiIProperties undefined");
        }
        if (!o.getClass().getName().equals("org.openspcoop2.protocol.modipa.config.ModIProperties")) {
            throw new ProtocolException("ModiIProperties class wrong, expected [org.openspcoop2.protocol.modipa.config.ModIProperties] found [" + o.getClass().getName() + "]");
        }
        log.info("test ModIProperties ok");
    }

    private static void getHeaderModI(Logger log) throws ProtocolException {
        log.info("test getHeaderModI ...");
        String hdr = ModIUtils.getHeaderModI();
        if (hdr == null) {
            throw new ProtocolException("ModiIProperties.getHeaderModI is null");
        }
        log.info("test getHeaderModI ok");
    }

    private static void isTokenOAuthUseJtiIntegrityAsMessageId(Logger log) throws ProtocolException {
        log.info("test isTokenOAuthUseJtiIntegrityAsMessageId ...");
        ModIUtils.isTokenOAuthUseJtiIntegrityAsMessageId();
        log.info("test isTokenOAuthUseJtiIntegrityAsMessageId ok");
    }

    private static void getAPIPDNDClientConfig(Logger log) throws ProtocolException {
        log.info("test getAPIPDNDClientConfig ...");
        ModIPDNDClientConfig c = ModIUtils.getAPIPDNDClientConfig();
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig is null");
        }
        c = ModIUtils.getAPIPDNDClientConfig((Logger)log);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig(log) is null");
        }
        String details = "{\"id\":\"1\"}";
        c = ModIUtils.getAPIPDNDClientConfig((String)details);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig is null");
        }
        if (!details.equals(c.getDetails())) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig.details different");
        }
        c = ModIUtils.getAPIPDNDClientConfig((String)details, (Logger)log);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig(log) is null");
        }
        if (!details.equals(c.getDetails())) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDClientConfig(log).details different");
        }
        log.info("test getAPIPDNDClientConfig ok");
    }

    private static void getAPIPDNDOrganizationConfig(Logger log) throws ProtocolException {
        log.info("test getAPIPDNDOrganizationConfig ...");
        ModIPDNDOrganizationConfig c = ModIUtils.getAPIPDNDOrganizationConfig();
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig is null");
        }
        c = ModIUtils.getAPIPDNDOrganizationConfig((Logger)log);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig(log) is null");
        }
        String details = "{\"id\":\"1\"}";
        c = ModIUtils.getAPIPDNDOrganizationConfig((String)details);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig is null");
        }
        if (!details.equals(c.getDetails())) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig.details different");
        }
        c = ModIUtils.getAPIPDNDOrganizationConfig((String)details, (Logger)log);
        if (c == null) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig(log) is null");
        }
        if (!details.equals(c.getDetails())) {
            throw new ProtocolException("ModiIProperties.getAPIPDNDOrganizationConfig(log).details different");
        }
        log.info("test getAPIPDNDOrganizationConfig ok");
    }

    private static void buildSignalHubPushIdAPI(Logger log) throws ProtocolException {
        log.info("test buildSignalHubPushIdAPI ...");
        IDAccordo idAccordo = ModIUtils.buildSignalHubPushIdAPI((IDSoggetto)new IDSoggetto("modipa", "Test"));
        if (idAccordo == null) {
            throw new ProtocolException("ModiIProperties.buildSignalHubPushIdAPI is null");
        }
        log.info("test buildSignalHubPushIdAPI ok");
    }

    private static void isSignalHubEnabled(Logger log) throws ProtocolException {
        log.info("test isSignalHubEnabled ...");
        ModIUtils.isSignalHubEnabled();
        log.info("test isSignalHubEnabled ok");
    }

    private static void isTracingPDNDEnabled(Logger log) throws ProtocolException {
        log.info("test isTracingPDNDEnabled ...");
        ModIUtils.isTracingPDNDEnabled();
        log.info("test isTracingPDNDEnabled ok");
    }

    private static void getRemoteStoreConfig(Logger log) throws ProtocolException {
        log.info("test getRemoteStoreConfig ...");
        List l = ModIUtils.getRemoteStoreConfig();
        if (l == null) {
            throw new ProtocolException("ModiIProperties.getRemoteStoreConfig is null");
        }
        log.info("test getRemoteStoreConfig ok");
    }

    private static void getRemoteKeyType(Logger log) throws ProtocolException {
        log.info("test getRemoteKeyType ...");
        ModIUtils.getRemoteKeyType((String)"notExists");
        log.info("test getRemoteKeyType ok");
    }

    private static void getSicurezzaMessaggioCertificatiTrustStore(Logger log) throws ProtocolException {
        log.info("test getSicurezzaMessaggioCertificatiTrustStore ...");
        KeystoreParams kp = ModIUtils.getSicurezzaMessaggioCertificatiTrustStore();
        if (kp == null) {
            throw new ProtocolException("ModiIProperties.getSicurezzaMessaggioCertificatiTrustStore is null");
        }
        log.info("test getSicurezzaMessaggioCertificatiTrustStore ok");
    }

    private static void getSicurezzaMessaggioSslTrustStore(Logger log) throws ProtocolException {
        log.info("test getSicurezzaMessaggioSslTrustStore ...");
        ModIUtils.getSicurezzaMessaggioSslTrustStore();
        log.info("test getSicurezzaMessaggioSslTrustStore ok");
    }

    private static void getSicurezzaMessaggioCertificatiKeyStore(Logger log) throws ProtocolException {
        log.info("test getSicurezzaMessaggioCertificatiKeyStore ...");
        KeystoreParams kp = ModIUtils.getSicurezzaMessaggioCertificatiKeyStore();
        if (kp == null) {
            throw new ProtocolException("ModiIProperties.getSicurezzaMessaggioCertificatiKeyStore is null");
        }
        log.info("test getSicurezzaMessaggioCertificatiKeyStore ok");
    }
}

