/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.rule;

import org.herasaf.xacml.core.ProcessingException;
import org.herasaf.xacml.core.SyntaxException;
import org.herasaf.xacml.core.combiningAlgorithm.AbstractCombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.rule.RuleCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.MissingAttributeException;
import org.herasaf.xacml.core.policy.impl.ConditionType;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.ExpressionType;
import org.herasaf.xacml.core.policy.impl.RuleType;
import org.herasaf.xacml.core.targetMatcher.TargetMatchingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleCombiningAlgorithm
extends AbstractCombiningAlgorithm
implements RuleCombiningAlgorithm {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRuleCombiningAlgorithm.class);
    protected static final String MDC_RULE_ID = "org:herasaf:xacml:evaluation:ruleid";

    @Override
    public DecisionType evaluateRule(RequestType request, RuleType rule, EvaluationContext evaluationContext) {
        TargetMatchingResult targetDecision = this.matchTarget(request, rule.getTarget(), evaluationContext);
        if (targetDecision == TargetMatchingResult.NO_MATCH) {
            return DecisionType.NOT_APPLICABLE;
        }
        if (targetDecision == TargetMatchingResult.INDETERMINATE) {
            return DecisionType.INDETERMINATE;
        }
        ConditionType condition = rule.getCondition();
        Boolean decision = null;
        if (condition == null) {
            if (rule.getEffect() == EffectType.PERMIT) {
                return DecisionType.PERMIT;
            }
            return DecisionType.DENY;
        }
        try {
            decision = (Boolean)((ExpressionType)condition.getExpression().getValue()).handle(request, evaluationContext);
        }
        catch (ProcessingException e) {
            LOGGER.warn("A processing error occurred.", (Throwable)e);
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.PROCESSING_ERROR);
            return DecisionType.INDETERMINATE;
        }
        catch (MissingAttributeException e) {
            MissingAttributeDetailType missingAttribute = e.getMissingAttribute();
            LOGGER.warn("The required attribute [" + missingAttribute + "] was missing in the request.", (Throwable)e);
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.MISSING_ATTRIBUTE);
            evaluationContext.addMissingAttributes(missingAttribute);
            return DecisionType.INDETERMINATE;
        }
        catch (SyntaxException e) {
            LOGGER.warn("A syntax error occurred during evaluation.", (Throwable)e);
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        catch (Exception e) {
            LOGGER.error("An unexpected error occurred during evaluation.", (Throwable)e);
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.PROCESSING_ERROR);
            return DecisionType.INDETERMINATE;
        }
        if (decision.booleanValue()) {
            if (rule.getEffect() == EffectType.PERMIT) {
                return DecisionType.PERMIT;
            }
            return DecisionType.DENY;
        }
        return DecisionType.NOT_APPLICABLE;
    }
}

