/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.combiningAlgorithm.rule.RuleCombiningAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleCombiningAlgorithmJAXBTypeAdapter
extends XmlAdapter<String, RuleCombiningAlgorithm> {
    private static final Logger logger = LoggerFactory.getLogger(RuleCombiningAlgorithmJAXBTypeAdapter.class);
    private static Map<String, RuleCombiningAlgorithm> combiningAlgorithms = new HashMap<String, RuleCombiningAlgorithm>();

    public static void addCombiningAlgorithms(Map<String, RuleCombiningAlgorithm> algorithms) {
        combiningAlgorithms.putAll(algorithms);
    }

    public String marshal(RuleCombiningAlgorithm combAlg) {
        String combAlgString;
        try {
            combAlgString = combAlg.toString();
        }
        catch (NullPointerException e) {
            logger.error("Argument combAlg must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return combAlgString;
    }

    public RuleCombiningAlgorithm unmarshal(String combAlgId) {
        RuleCombiningAlgorithm combAlg;
        try {
            combAlg = combiningAlgorithms.get(combAlgId);
        }
        catch (NullPointerException e) {
            logger.error("RuleCombiningAlgorithmJAXBTypeAdapter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (combAlg != null) {
            return combAlg;
        }
        throw new IllegalArgumentException("Combining Algorithm " + combAlgId + " unknown.");
    }
}

